/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MiriamEditDialog;
import jp.sbi.celldesigner.MiriamMainDialog;
import jp.sbi.celldesigner.MiriamMainPanel;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.miriam.MIRIAM;
import jp.sbi.sbml.MiriamDefinition;

public class MiriamEditPanel1
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel jLabelRelation = null;
    private JComboBox jComboBoxRelation = null;
    private JButton jButtonUpdate = null;
    private JButton jButtonNext = null;
    private JButton jButtonCancel = null;
    private MiriamEditDialog jdialog = null;

    public MiriamEditPanel1() {
        this.initialize();
    }

    public void initialize() {
        this.jLabelRelation = new JLabel();
        this.jLabelRelation.setBounds(new Rectangle(15, 10, 70, 20));
        this.jLabelRelation.setText("Relation");
        this.setSize(335, 85);
        this.setLayout(null);
        this.add((Component)this.jLabelRelation, null);
        this.add((Component)this.getJComboBoxRelation(), null);
        this.add((Component)this.getJButtonUpdate(), null);
        this.add((Component)this.getJButtonNext(), null);
        this.add((Component)this.getJButtonCancel(), null);
        this.initComboBoxRelation();
    }

    public void setDialogData() {
        MiriamEditDialog dialog = this.getJDialog();
        if (dialog != null) {
            MiriamDefinition miriamDefinition = dialog.getObject();
            if (miriamDefinition == null) {
                return;
            }
            String strRelation = miriamDefinition.getRelation();
            if (strRelation == null) {
                return;
            }
            if (strRelation.equals("")) {
                this.jComboBoxRelation.setSelectedIndex(0);
            } else {
                this.jComboBoxRelation.setSelectedItem(strRelation);
                if (this.jComboBoxRelation.getSelectedIndex() == -1) {
                    this.jComboBoxRelation.setSelectedIndex(0);
                }
            }
        }
    }

    private JComboBox getJComboBoxRelation() {
        if (this.jComboBoxRelation == null) {
            this.jComboBoxRelation = new JComboBox();
            this.jComboBoxRelation.setBounds(new Rectangle(90, 10, 220, 20));
        }
        return this.jComboBoxRelation;
    }

    private JButton getJButtonUpdate() {
        if (this.jButtonUpdate == null) {
            this.jButtonUpdate = new JButton();
            this.jButtonUpdate.setBounds(new Rectangle(40, 45, 120, 30));
            this.jButtonUpdate.setText("Update");
            this.jButtonUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MiriamEditPanel1.this.updatebtn_actionPerformed();
                }
            });
        }
        return this.jButtonUpdate;
    }

    private JButton getJButtonNext() {
        if (this.jButtonNext == null) {
            this.jButtonNext = new JButton();
            this.jButtonNext.setBounds(new Rectangle(80, 45, 80, 30));
            this.jButtonNext.setText("Next");
            this.jButtonNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MiriamEditPanel1.this.nextbtn_actionPerformed();
                }
            });
        }
        return this.jButtonNext;
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setBounds(new Rectangle(180, 45, 120, 30));
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MiriamEditPanel1.this.closebtn_actionPerformed();
                }
            });
        }
        return this.jButtonCancel;
    }

    private void closebtn_actionPerformed() {
        MiriamEditDialog dialog = this.getJDialog();
        if (dialog != null) {
            dialog.setVisible(false);
        }
    }

    private void updatebtn_actionPerformed() {
        MiriamEditDialog dialog = this.getJDialog();
        if (dialog != null) {
            MiriamDefinition miriam = dialog.getObject();
            if (miriam == null) {
                return;
            }
            String strOldRelation = miriam.getRelation();
            if (strOldRelation == null) {
                return;
            }
            Object relation = this.jComboBoxRelation.getSelectedItem();
            if (relation != null && !strOldRelation.equals(relation.toString())) {
                miriam.setRelation(relation.toString());
                MiriamMainPanel miriamMainPanel = null;
                if (dialog.getParent() instanceof MainWindow) {
                    miriamMainPanel = MainWindow.getMiriamMainPanel();
                } else if (dialog.getParent() instanceof MiriamMainDialog) {
                    MiriamMainDialog miriamMainDialog = (MiriamMainDialog)dialog.getParent();
                    miriamMainPanel = miriamMainDialog.getMiriamMainPanel();
                }
                if (miriamMainPanel != null) {
                    miriamMainPanel.setSubObject(null);
                    MiriamMainPanel.updateSBaseAnnotation(miriamMainPanel.getSBase(), miriamMainPanel.getMainObject());
                    miriamMainPanel.repaintPanelForMain();
                }
                dialog.setShowFlag(false, false, false, false, false);
                dialog.setVisible(false);
                try {
                    SBModelFrame sbmfrm = MainWindow.getLastInstance().getCurrentModel();
                    sbmfrm.setHasAnySBaseChangedFlg(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void nextbtn_actionPerformed() {
        MiriamEditDialog dialog = this.getJDialog();
        if (dialog != null) {
            MiriamDefinition miriam = dialog.getObject();
            if (miriam == null) {
                return;
            }
            Object relation = this.jComboBoxRelation.getSelectedItem();
            if (relation != null) {
                miriam.setRelation(relation.toString());
                dialog.setShowFlag(false, true, false, false, false);
                dialog.updateDialog();
            }
        }
    }

    public void setJButtonNextVisable(boolean showflag) {
        this.jButtonNext.setVisible(showflag);
    }

    public void setJButtonUpdateVisable(boolean showflag) {
        this.jButtonUpdate.setVisible(showflag);
    }

    public void setButtonVisable(boolean newbtnflag, boolean updatebtnflag) {
        this.setJButtonNextVisable(newbtnflag);
        this.setJButtonUpdateVisable(updatebtnflag);
    }

    public void setJDialog(MiriamEditDialog jdialog) {
        this.jdialog = jdialog;
    }

    public MiriamEditDialog getJDialog() {
        return this.jdialog;
    }

    public void initComboBoxRelation() {
        Vector<String> relation = MIRIAM.vectEnumerationRelationOfMIRIAM;
        if (relation != null) {
            this.jComboBoxRelation.removeAllItems();
            int i = 0;
            while (i < relation.size()) {
                String strrelation = relation.get(i).toString();
                this.jComboBoxRelation.addItem(strrelation);
                ++i;
            }
            if (this.jComboBoxRelation.getSelectedIndex() == -1) {
                this.jComboBoxRelation.setSelectedIndex(0);
            }
        }
    }

    public void resetDialog() {
        this.jdialog = null;
    }
}

