/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModelFrame;

public class LoupeDialog2
extends JDialog {
    private MainWindow mainWindow = null;
    private static final Dimension CANVAS_SIZE = new Dimension(220, 170);
    private static final Insets OFFSET = new Insets(10, 10, 10, 10);
    private static final Color symbolDefaultColor = new Color(0, 0, 0, 127);
    private static final RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private static final BasicStroke stroke = new BasicStroke(1.0f);
    private double ratioval = 0.0;
    private Dimension model_size = null;
    private Rectangle modelCanvas = new Rectangle();
    private Rectangle viewFrame = new Rectangle();
    private AffineTransform transform = new AffineTransform();
    private AffineTransform inverseTransform = new AffineTransform();
    private JPanel canvas = new MyCanvas();
    private SBModelFrame modelframe = null;

    public LoupeDialog2(MainWindow frame) {
        super((Frame)frame, false);
        this.mainWindow = frame;
        try {
            this.createUI();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createUI() throws Exception {
        this.setTitle("Bird's Eye View");
        this.canvas.setPreferredSize(CANVAS_SIZE);
        this.setResizable(false);
        this.setContentPane(this.canvas);
        this.pack();
        Insets dInsets = this.getInsets();
        this.setSize(LoupeDialog2.CANVAS_SIZE.width + dInsets.left + dInsets.right, LoupeDialog2.CANVAS_SIZE.height + dInsets.top + dInsets.bottom);
    }

    public void clearSBModelFrame() {
        this.modelframe = null;
    }

    public void updateCurrentSBModelFrame() {
        this.modelframe = this.mainWindow.getCurrentModel();
        if (this.modelframe != null) {
            this.model_size = this.modelframe.getModelSize();
            double wratio = (double)(LoupeDialog2.CANVAS_SIZE.width - LoupeDialog2.OFFSET.left - LoupeDialog2.OFFSET.right) / (double)this.model_size.width;
            double hratio = (double)(LoupeDialog2.CANVAS_SIZE.height - LoupeDialog2.OFFSET.top - LoupeDialog2.OFFSET.bottom) / (double)this.model_size.height;
            this.ratioval = wratio < hratio ? wratio : hratio;
            this.modelCanvas.width = (int)((double)this.model_size.width * this.ratioval);
            this.modelCanvas.height = (int)((double)this.model_size.height * this.ratioval);
            this.modelCanvas.x = (LoupeDialog2.CANVAS_SIZE.width - this.modelCanvas.width) / 2;
            this.modelCanvas.y = (LoupeDialog2.CANVAS_SIZE.height - this.modelCanvas.height) / 2;
            this.transform.setToTranslation(this.modelCanvas.x, this.modelCanvas.y);
            this.transform.scale(this.ratioval, this.ratioval);
            double rinv = 1.0 / this.ratioval;
            this.inverseTransform.setToScale(rinv, rinv);
            this.inverseTransform.translate(-this.modelCanvas.x, -this.modelCanvas.y);
        }
    }

    private void updateViewFrame() {
        if (this.modelframe != null) {
            Rectangle rect = this.modelframe.getCurrentLogicalViewArea();
            double zoom = this.modelframe.getZoomScale();
            zoom = 1.0 / zoom;
            this.viewFrame.width = (int)((double)rect.width * this.ratioval * zoom);
            this.viewFrame.height = (int)((double)rect.height * this.ratioval * zoom);
            this.viewFrame.x = this.modelCanvas.x + (int)((double)rect.x * this.ratioval * zoom);
            this.viewFrame.y = this.modelCanvas.y + (int)((double)rect.y * this.ratioval * zoom);
        }
    }

    private class MyCanvas
    extends JPanel {
        private Image backGrp = null;
        private final Rectangle canvasRect = new Rectangle(new Point(0, 0), LoupeDialog2.access$0());

        public MyCanvas() {
            MouseAdapter ma = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    MyCanvas.this.mouseClicked(e);
                }
            };
            this.addMouseListener(ma);
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    MyCanvas.this.mouseClicked(e);
                }
            });
            this.setOpaque(true);
        }

        @Override
        public void paint(Graphics g) {
            if (this.backGrp == null) {
                this.backGrp = this.createImage(CANVAS_SIZE.width, CANVAS_SIZE.height);
            }
            Graphics2D g2 = (Graphics2D)this.backGrp.getGraphics();
            g2.addRenderingHints(hints);
            g2.setStroke(stroke);
            if (LoupeDialog2.this.modelCanvas != null) {
                g2.setColor(Color.GRAY);
                g2.fill(this.canvasRect);
                g2.setColor(Color.WHITE);
                g2.fill(LoupeDialog2.this.modelCanvas);
                g2.setColor(symbolDefaultColor);
                LoupeDialog2.this.modelframe.paintSymbol(g2, LoupeDialog2.this.transform);
                LoupeDialog2.this.updateViewFrame();
            }
            g2.dispose();
            g.drawImage(this.backGrp, this.getInsets().left, this.getInsets().top, this);
            Graphics2D gg = (Graphics2D)g;
            gg.setStroke(stroke);
            gg.setColor(Color.RED);
            gg.draw(LoupeDialog2.this.viewFrame);
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        private void mouseClicked(MouseEvent e) {
            Point clickedPoint = e.getPoint();
            Point2D.Double point = new Point2D.Double((double)clickedPoint.x - (double)((LoupeDialog2)LoupeDialog2.this).viewFrame.width / 2.0, (double)clickedPoint.y - (double)((LoupeDialog2)LoupeDialog2.this).viewFrame.height / 2.0);
            LoupeDialog2.this.inverseTransform.transform(point, point);
            LoupeDialog2.this.modelframe.scrollView(point.x, point.y);
            this.repaint();
        }
    }
}

