/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class JPEGBytes
implements Serializable {
    public static final String[] SUFFIX = new String[]{"jpg", "jpeg", "JPG", "JPEG"};
    private byte[] jpegStream;
    private String filename = "";
    private int w = 0;
    private int h = 0;
    private float quality = 0.75f;

    public void setFilename(String fname) {
        this.filename = fname;
    }

    public void setQuality(float quality) {
        this.quality = quality;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getWidth() {
        if (this.w == 0) {
            this.makeSize();
        }
        return this.w;
    }

    public int getHeight() {
        if (this.h == 0) {
            this.makeSize();
        }
        return this.h;
    }

    private void makeSize() {
        BufferedImage tmpImg = this.createImage();
        if (tmpImg != null) {
            this.w = tmpImg.getWidth();
            this.h = tmpImg.getHeight();
        }
    }

    public void setImage(BufferedImage image) {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)baout);
        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(image);
        param.setQuality(this.quality, false);
        encoder.setJPEGEncodeParam(param);
        try {
            encoder.encode(image);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jpegStream = baout.toByteArray();
        this.w = image.getWidth();
        this.h = image.getHeight();
    }

    public BufferedImage createImage() {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.jpegStream);
        JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)bais);
        try {
            BufferedImage image = decoder.decodeAsBufferedImage();
            return image;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void readFile(String filepath) throws Exception {
        if (filepath == null) {
            throw new IOException("No Image path");
        }
        FileInputStream fin = new FileInputStream(filepath);
        this.readStream(fin);
        fin.close();
    }

    public void readStream(InputStream in) throws Exception {
        int c;
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((c = bis.read()) != -1) {
            baos.write(c);
        }
        this.jpegStream = baos.toByteArray();
        this.makeSize();
    }

    public void writeFile(String filepath) throws Exception {
        if (this.jpegStream.length == 0) {
            return;
        }
        File file = new File(filepath);
        FileOutputStream fos = new FileOutputStream(file);
        this.writeStream(fos);
        fos.close();
    }

    public void writeStream(OutputStream out) throws Exception {
        int c;
        BufferedOutputStream bos = new BufferedOutputStream(out);
        ByteArrayInputStream bais = new ByteArrayInputStream(this.jpegStream);
        while ((c = bais.read()) != -1) {
            bos.write(c);
        }
        bais.close();
        bos.close();
    }
}

