/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import jp.fric.graphics.draw.GElement;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.CompartmentSymbol;
import jp.sbi.celldesigner.InformationBox;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SpeciesAlias;
import org.sbml.libsbml.Compartment;

public class InformationBoxDialog
extends JDialog {
    private JButton okButton;
    private JButton cancelButton;
    private boolean isFirstShowing = true;
    private Object showingObject = null;
    private int selectedObjectKubun;
    private JFrame frame;
    protected JComboBox infoboxStateCombo;
    protected JComboBox label1Combo;
    protected JComboBox label2Combo;
    protected JTextField label2TextField;
    private SBModel sbmodel;
    private String state = new String();
    private String label1 = new String();
    private String label2 = new String();

    public InformationBoxDialog(JFrame frame, SBModel sbmodel, String title) {
        super(frame);
        this.frame = frame;
        this.sbmodel = sbmodel;
        this.setResizable(false);
        this.setModal(true);
        final JRootPane rootPane = this.getRootPane();
        FocusAdapter applyButtonFocuser = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(InformationBoxDialog.this.okButton);
            }
        };
        int leftOffset = 10;
        JPanel panel = new JPanel();
        panel.setLayout(null);
        int inputX = leftOffset + 60;
        int panelWidth = 330;
        panel.setBounds(0, 0, panelWidth, 130);
        int dy = 10;
        JLabel structuralStateLabel = new JLabel("state");
        structuralStateLabel.setBounds(new Rectangle(leftOffset, panel.getY() + 20, 70, 20));
        panel.add((Component)structuralStateLabel, null);
        this.infoboxStateCombo = new JComboBox();
        this.infoboxStateCombo.setBounds(new Rectangle(inputX, structuralStateLabel.getY(), 240, 20));
        this.initInfoboxStateCombo();
        this.infoboxStateCombo.setSelectedIndex(0);
        this.infoboxStateCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InformationBoxDialog.this.state = (String)InformationBoxDialog.this.infoboxStateCombo.getSelectedItem();
                InformationBoxDialog.this.label2TextField.setText("");
                if (InformationBoxDialog.this.state != null && InformationBoxDialog.this.state.equals(InformationBox.InformationBoxtateStrSystemVect[0])) {
                    InformationBoxDialog.this.label1Combo.setVisible(true);
                    InformationBoxDialog.this.label1Combo.setEnabled(false);
                    if (InformationBoxDialog.this.label2Combo.isVisible()) {
                        InformationBoxDialog.this.label2Combo.setEnabled(false);
                    } else if (InformationBoxDialog.this.label2TextField.isVisible()) {
                        InformationBoxDialog.this.label2TextField.setEnabled(false);
                    } else {
                        InformationBoxDialog.this.label2Combo.setVisible(true);
                        InformationBoxDialog.this.label2Combo.setEnabled(false);
                    }
                } else {
                    InformationBoxDialog.this.label1Combo.setEnabled(true);
                    InformationBoxDialog.this.label1Combo.setVisible(true);
                    String strlabel1 = (String)InformationBoxDialog.this.label1Combo.getSelectedItem();
                    if (InformationBox.isCanFreeInput(strlabel1)) {
                        InformationBoxDialog.this.label2TextField.setEnabled(true);
                        InformationBoxDialog.this.label2TextField.setVisible(true);
                        InformationBoxDialog.this.label2Combo.setVisible(false);
                    } else {
                        InformationBoxDialog.this.label2Combo.setEnabled(true);
                        InformationBoxDialog.this.label2Combo.setVisible(true);
                        InformationBoxDialog.this.label2TextField.setVisible(false);
                    }
                }
                InformationBoxDialog.this.label1 = (String)InformationBoxDialog.this.label1Combo.getSelectedItem();
                if (InformationBox.isCanFreeInput(InformationBoxDialog.this.label1)) {
                    return;
                }
                if (InformationBoxDialog.this.label2Combo.isVisible()) {
                    InformationBoxDialog.this.label2 = (String)InformationBoxDialog.this.label2Combo.getSelectedItem();
                } else if (InformationBoxDialog.this.label2TextField.isVisible()) {
                    InformationBoxDialog.this.label2 = InformationBoxDialog.this.label2TextField.getText();
                }
                InformationBoxDialog.this.repaint();
            }
        });
        panel.add((Component)this.infoboxStateCombo, null);
        JLabel Label1 = new JLabel("prefix");
        Label1.setBounds(new Rectangle(leftOffset, structuralStateLabel.getY() + structuralStateLabel.getHeight() + dy, 70, 20));
        panel.add((Component)Label1, null);
        this.label1Combo = new JComboBox();
        this.label1Combo.setBounds(new Rectangle(inputX, Label1.getY(), 240, 20));
        this.initLabel1Combo();
        this.label1Combo.setSelectedIndex(0);
        this.label1Combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String strlabel1 = (String)InformationBoxDialog.this.label1Combo.getSelectedItem();
                InformationBoxDialog.this.label2TextField.setText("");
                if (InformationBox.isCanFreeInput(strlabel1)) {
                    InformationBoxDialog.this.label2TextField.setEnabled(true);
                    InformationBoxDialog.this.label2TextField.setVisible(true);
                    InformationBoxDialog.this.label2Combo.setVisible(false);
                } else {
                    InformationBoxDialog.this.label2Combo.setEnabled(true);
                    InformationBoxDialog.this.label2Combo.setVisible(true);
                    InformationBoxDialog.this.label2Combo.removeAllItems();
                    if ("pc".equals(strlabel1)) {
                        int i = 0;
                        while (i < InformationBox.InformationBoxLabel2ForPcStrSystemVect.length) {
                            InformationBoxDialog.this.label2Combo.addItem(InformationBox.InformationBoxLabel2ForPcStrSystemVect[i]);
                            ++i;
                        }
                        InformationBoxDialog.this.label2Combo.setSelectedIndex(0);
                        InformationBoxDialog.this.label2Combo.setEnabled(true);
                        InformationBoxDialog.this.label2Combo.setVisible(true);
                    } else if ("mt".equals(strlabel1)) {
                        int i = 0;
                        while (i < InformationBox.InformationBoxLabel2ForMtStrSystemVect.length) {
                            InformationBoxDialog.this.label2Combo.addItem(InformationBox.InformationBoxLabel2ForMtStrSystemVect[i]);
                            ++i;
                        }
                        InformationBoxDialog.this.label2Combo.setSelectedIndex(0);
                        InformationBoxDialog.this.label2Combo.setEnabled(true);
                        InformationBoxDialog.this.label2Combo.setVisible(true);
                    } else if ("ct".equals(strlabel1)) {
                        int i = 0;
                        while (i < InformationBox.InformationBoxLabel2ForCtStrSystemVect.length) {
                            InformationBoxDialog.this.label2Combo.addItem(InformationBox.InformationBoxLabel2ForCtStrSystemVect[i]);
                            ++i;
                        }
                        InformationBoxDialog.this.label2Combo.setSelectedIndex(0);
                        InformationBoxDialog.this.label2Combo.setEnabled(true);
                        InformationBoxDialog.this.label2Combo.setVisible(true);
                    }
                    InformationBoxDialog.this.label2TextField.setVisible(false);
                }
                InformationBoxDialog.this.state = (String)InformationBoxDialog.this.infoboxStateCombo.getSelectedItem();
                if (strlabel1 != null) {
                    InformationBoxDialog.this.label1 = new String(strlabel1);
                }
                if (InformationBoxDialog.this.label2Combo.isVisible()) {
                    InformationBoxDialog.this.label2 = (String)InformationBoxDialog.this.label2Combo.getSelectedItem();
                } else if (InformationBoxDialog.this.label2TextField.isVisible()) {
                    InformationBoxDialog.this.label2 = InformationBoxDialog.this.label2TextField.getText();
                }
                InformationBoxDialog.this.repaint();
            }
        });
        panel.add((Component)this.label1Combo, null);
        JLabel Label2 = new JLabel("label");
        Label2.setBounds(new Rectangle(leftOffset, Label1.getY() + Label1.getHeight() + dy, 70, this.infoboxStateCombo.getHeight()));
        panel.add((Component)Label2, null);
        this.label2Combo = new JComboBox();
        this.label2Combo.setBounds(new Rectangle(inputX, Label2.getY(), 240, 20));
        this.initLabel2Combo();
        this.label2Combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InformationBoxDialog.this.state = (String)InformationBoxDialog.this.infoboxStateCombo.getSelectedItem();
                InformationBoxDialog.this.label1 = (String)InformationBoxDialog.this.label1Combo.getSelectedItem();
                if (InformationBox.isCanFreeInput(InformationBoxDialog.this.label1)) {
                    return;
                }
                InformationBoxDialog.this.label2 = (String)InformationBoxDialog.this.label2Combo.getSelectedItem();
                InformationBoxDialog.this.repaint();
            }
        });
        panel.add((Component)this.label2Combo, null);
        this.label2TextField = new JTextField();
        this.label2TextField.setBounds(new Rectangle(inputX, Label2.getY(), this.infoboxStateCombo.getWidth(), this.infoboxStateCombo.getHeight()));
        this.label2TextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                InformationBoxDialog.this.state = (String)InformationBoxDialog.this.infoboxStateCombo.getSelectedItem();
                InformationBoxDialog.this.label1 = (String)InformationBoxDialog.this.label1Combo.getSelectedItem();
                if (!InformationBox.isCanFreeInput(InformationBoxDialog.this.label1)) {
                    return;
                }
                InformationBoxDialog.this.label2 = InformationBoxDialog.this.label2TextField.getText();
                InformationBoxDialog.this.repaint();
            }
        });
        this.label2TextField.addFocusListener(applyButtonFocuser);
        panel.add((Component)this.label2TextField, null);
        this.okButton = new JButton("OK");
        this.okButton.setMnemonic(83);
        this.okButton.setBounds(new Rectangle(this.label2TextField.getX(), Label2.getY() + Label2.getHeight() + 10, 80, 25));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InformationBoxDialog.this.okButton_actionPerformed(e);
            }
        });
        this.okButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(InformationBoxDialog.this.okButton);
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic(67);
        this.cancelButton.setBounds(new Rectangle(this.label2TextField.getX() + this.okButton.getWidth() + 10, this.okButton.getY(), 120, this.okButton.getHeight()));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InformationBoxDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.getContentPane().add(panel);
        panel.add((Component)this.okButton, null);
        panel.add((Component)this.cancelButton, null);
        this.setTitle(title);
        this.setSize(panelWidth, this.okButton.getY() + this.okButton.getHeight() + 40);
    }

    private void setComponentsEnabled() {
        this.okButton.setEnabled(false);
    }

    public void releaseFrame() {
        this.showingObject = null;
    }

    @Override
    public void show() {
        if (this.isFirstShowing) {
            Point p = this.frame.getLocation();
            Dimension he = this.frame.getSize();
            Dimension me = this.getSize();
            int x = p.x + (he.width - me.width) / 2;
            int y = p.y + (he.height - me.height) / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.setLocation(x, y);
            this.isFirstShowing = false;
        }
        this.rootPane.setDefaultButton(this.okButton);
        super.show();
    }

    public void showAliasProperty(Object alias, int selected) {
        this.showingObject = alias;
        this.selectedObjectKubun = selected;
        InformationBox informationBox = null;
        if (this.selectedObjectKubun == 0) {
            informationBox = ((CompartmentAlias)this.showingObject).getInfoBox();
        } else if (this.selectedObjectKubun == 1) {
            informationBox = ((SpeciesAlias)this.showingObject).getInfoBox();
        } else {
            return;
        }
        try {
            if (informationBox != null && !InformationBox.isEmptyState(informationBox.getStateString()) && InformationBox.isValidForInfo(informationBox)) {
                this.state = informationBox.getStateString();
                int i = 0;
                i = 0;
                while (i < InformationBox.InformationBoxtateStrSystemVect.length) {
                    if (InformationBox.InformationBoxtateStrSystemVect[i].equals(this.state)) {
                        this.infoboxStateCombo.setSelectedIndex(i);
                        break;
                    }
                    ++i;
                }
                String strLabel1 = informationBox.getLabel1String();
                String strLabel2 = informationBox.getLabel2String();
                if (strLabel1 != null) {
                    this.label1Combo.setSelectedItem(strLabel1);
                    if (strLabel1.equals("free input")) {
                        this.label1 = "free input";
                        this.label2TextField.setEditable(true);
                        this.label2TextField.setVisible(true);
                        this.label2TextField.setText(strLabel2);
                        this.label2 = new String(strLabel2);
                        this.label2Combo.setVisible(false);
                    } else {
                        this.label1 = strLabel1;
                        if ("N".equals(strLabel1)) {
                            this.label2TextField.setEditable(true);
                            this.label2TextField.setVisible(true);
                            this.label2TextField.setText(strLabel2);
                            this.label2 = new String(strLabel2);
                            this.label2Combo.setVisible(false);
                        } else {
                            this.label2TextField.setVisible(false);
                            this.label2Combo.setVisible(true);
                            this.label2Combo.setEnabled(true);
                            this.label2Combo.setSelectedItem(strLabel2);
                        }
                    }
                }
            } else {
                this.resetDialog();
            }
        }
        catch (Exception ex) {
            this.resetDialog();
        }
        this.show();
    }

    private void okButton_actionPerformed(ActionEvent e) {
        if (this.showingObject != null) {
            Compartment sbase = null;
            InformationBox informationBox = null;
            double defaultangle = 0.0;
            if (this.selectedObjectKubun == 0) {
                CompartmentAlias compartmentAlias = (CompartmentAlias)this.showingObject;
                sbase = compartmentAlias.getOriginalCompartment();
                informationBox = compartmentAlias.getInfoBox();
                if (compartmentAlias.getSymbol() != null) {
                    defaultangle = ((CompartmentSymbol)((Object)compartmentAlias.getSymbol())).getDefaultAngle();
                }
            } else if (this.selectedObjectKubun == 1) {
                SpeciesAlias elementSpeciesAlias = (SpeciesAlias)this.showingObject;
                sbase = elementSpeciesAlias.getOriginalSpecies();
                informationBox = elementSpeciesAlias.getInfoBox();
                if (elementSpeciesAlias.getSpeciesSymbol() != null) {
                    defaultangle = elementSpeciesAlias.getSpeciesSymbol().getDefaultAngle();
                }
            } else {
                return;
            }
            if (sbase == null) {
                return;
            }
            boolean isChanged = false;
            InformationBox newInformationBox = null;
            this.label1 = this.label1.trim();
            this.label2 = this.label2.trim();
            try {
                InformationBox.isValidForInfo(this.state, this.label1, this.label2);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
                return;
            }
            boolean oldIsEmpty = informationBox == null || InformationBox.isEmptyState(informationBox.getStateString());
            boolean newIsEmpty = InformationBox.isEmptyState(this.state);
            if (oldIsEmpty && !newIsEmpty) {
                isChanged = true;
                newInformationBox = new InformationBox(this.state, this.label1, this.label2, (GElement)this.showingObject);
                newInformationBox.setAngle(defaultangle);
            } else if (!oldIsEmpty && newIsEmpty) {
                isChanged = true;
            } else if (!oldIsEmpty && !newIsEmpty) {
                String oldState = informationBox.getStateString();
                String oldLabel1 = informationBox.getLabel1String();
                String oldLabel2 = informationBox.getLabel2String();
                double angle = informationBox.getAngle();
                if (!(this.state.equals(oldState) && this.label1.equals(oldLabel1) && this.label2.equals(oldLabel2))) {
                    isChanged = true;
                    newInformationBox = (InformationBox)informationBox.createCopy();
                    newInformationBox.setInfoAll(this.state, this.label1, this.label2);
                    newInformationBox.setAngle(angle);
                }
            }
            if (isChanged) {
                int flag = 2;
                this.sbmodel.changeInfo(this.showingObject, newInformationBox, flag);
            }
        }
        this.dispose();
        this.showingObject = null;
    }

    private void cancelButton_actionPerformed(ActionEvent e) {
        this.dispose();
        this.showingObject = null;
    }

    public void resetDialog() {
        this.initInfoboxStateCombo();
        this.initLabel1Combo();
        this.initLabel2Combo();
        this.infoboxStateCombo.setSelectedIndex(0);
        this.label1Combo.setSelectedIndex(0);
        this.label1Combo.setVisible(true);
        this.label1Combo.setEnabled(false);
        this.label2Combo.setSelectedIndex(0);
        this.label2Combo.setVisible(true);
        this.label2Combo.setEnabled(false);
        this.label2TextField.setText("");
        this.label2TextField.setVisible(false);
    }

    private void initInfoboxStateCombo() {
        if (this.infoboxStateCombo != null) {
            this.infoboxStateCombo.removeAllItems();
            int i = 0;
            while (i < InformationBox.InformationBoxtateStrSystemVect.length) {
                this.infoboxStateCombo.addItem(InformationBox.InformationBoxtateStrSystemVect[i]);
                ++i;
            }
        }
    }

    private void initLabel1Combo() {
        if (this.label1Combo != null) {
            this.label1Combo.removeAllItems();
            int i = 0;
            while (i < InformationBox.InformationBoxLabel1StrSystemVect.length) {
                this.label1Combo.addItem(InformationBox.InformationBoxLabel1StrSystemVect[i]);
                ++i;
            }
        }
    }

    private void initLabel2Combo() {
        if (this.label2Combo != null && this.label1Combo != null && this.label1Combo.isVisible() && this.label1Combo.getSelectedItem() != null) {
            this.label2Combo.removeAllItems();
            String selectedLabel1 = (String)this.label1Combo.getSelectedItem();
            if ("pc".equals(selectedLabel1)) {
                int i = 0;
                while (i < InformationBox.InformationBoxLabel2ForPcStrSystemVect.length) {
                    this.label2Combo.addItem(InformationBox.InformationBoxLabel2ForPcStrSystemVect[i]);
                    ++i;
                }
                this.label2Combo.setSelectedIndex(0);
            } else if ("mt".equals(selectedLabel1)) {
                int i = 0;
                while (i < InformationBox.InformationBoxLabel2ForMtStrSystemVect.length) {
                    this.label2Combo.addItem(InformationBox.InformationBoxLabel2ForMtStrSystemVect[i]);
                    ++i;
                }
                this.label2Combo.setSelectedIndex(0);
            } else if ("ct".equals(selectedLabel1)) {
                int i = 0;
                while (i < InformationBox.InformationBoxLabel2ForCtStrSystemVect.length) {
                    this.label2Combo.addItem(InformationBox.InformationBoxLabel2ForCtStrSystemVect[i]);
                    ++i;
                }
                this.label2Combo.setSelectedIndex(0);
            }
        }
    }
}

