/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import jp.fric.graphics.draw.GColor;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GFramed;
import jp.fric.graphics.draw.GResizeHandle;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.CompartmentSymbol;
import jp.sbi.celldesigner.NameExpression;
import jp.sbi.celldesigner.NameExpressionDictionary;
import jp.sbi.celldesigner.NameTranslator;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;
import jp.sbi.sbml.util.LibSBMLUtil;

public class InformationBox
implements GElement,
GFramed {
    public static final String strpcInputKey = "pc";
    public static final String strmtInputKey = "mt";
    public static final String strctInputKey = "ct";
    public static final String strNInputKey = "N";
    public static final String strFreeInputKey = "free input";
    public static final String strConnect = ":";
    public static final String buffer = "... ";
    public static final int maxLength = 70;
    public static final String message = "[label] value should be a positive integer.";
    public static final String[] InformationBoxtateStrSystemVect = new String[]{"empty", "open"};
    public static final String[] InformationBoxLabel1StrSystemVect = new String[]{"pc", "mt", "ct", "N", "free input"};
    public static final String[] InformationBoxLabel2ForPcStrSystemVect = new String[]{"T", "V", "pH"};
    public static final String[] InformationBoxLabel2ForMtStrSystemVect = new String[]{"ion", "rad", "rna", "dna", "prot", "psac"};
    public static final String[] InformationBoxLabel2ForCtStrSystemVect = new String[]{"gene", "tss", "coding", "grr", "mRNA"};
    public static final boolean[] InformationBoxCanFreeInputSystemVect;
    public static String defaultstateStr;
    public static String emptystateStr;
    public static final double H = 16.0;
    public static final double dDefaultAngle = -1.5707963267948966;
    private String strSTATE = "";
    private String strLabel1 = "";
    private String strLabel2 = "";
    private double angle = -1.5707963267948966;
    private Rectangle2D.Double oldBound = null;
    private Rectangle2D.Double oldNameBound = null;
    private Point2D.Double centerpos = null;
    private GElement parent = null;
    private Graphics2D labelGraphics2d = null;
    protected boolean isHighlighted = false;
    private String strShowLabel = "";
    boolean changeflag = false;
    private double backupAngleWhenBeforeChangeInfo = 0.0;
    public static final Color infoColor;
    public static final Stroke infoStroke;
    private Point2D.Double deltaPoint2DUsingOnlyByMoving = null;

    static {
        boolean[] blArray = new boolean[5];
        blArray[3] = true;
        blArray[4] = true;
        InformationBoxCanFreeInputSystemVect = blArray;
        defaultstateStr = InformationBoxtateStrSystemVect[0];
        emptystateStr = InformationBoxtateStrSystemVect[0];
        infoColor = Color.BLACK;
        infoStroke = new BasicStroke(1.0f, 0, 2);
    }

    public InformationBox(GElement parent) {
        this.resetStateString();
        this.parent = parent;
    }

    public InformationBox(String strstate, String labelstr1, String labelstr2, GElement parent) {
        this.setInfoAll(strstate, labelstr1, labelstr2);
        this.parent = parent;
    }

    public static final boolean isEmptyState(String state) {
        if (state == null) {
            return true;
        }
        return state.equals(emptystateStr);
    }

    public static final boolean isCanFreeInput(String state) {
        if (!InformationBox.isValidLabel1Str(state)) {
            return false;
        }
        int i = 0;
        while (i < InformationBoxLabel1StrSystemVect.length) {
            if (state.equals(InformationBoxLabel1StrSystemVect[i])) {
                return InformationBoxCanFreeInputSystemVect[i];
            }
            ++i;
        }
        return false;
    }

    public static final boolean isValidForInfo(InformationBox informationBox) throws Exception {
        if (informationBox == null) {
            return false;
        }
        return InformationBox.isValidForInfo(informationBox.getStateString(), informationBox.getLabel1String(), informationBox.getLabel2String());
    }

    public static final boolean isValidForInfo(String state, String label1, String label2) throws Exception {
        if (state == null || label1 == null) {
            return false;
        }
        if (InformationBox.isEmptyState(state)) {
            return true;
        }
        if (!InformationBox.isValidStateStr(state)) {
            return false;
        }
        if (!InformationBox.isValidLabel1Str(label1)) {
            return false;
        }
        return InformationBox.isValidLabel2Str(label1, label2);
    }

    private static final boolean isValidStateStr(String state) {
        if (state == null) {
            return false;
        }
        int i = 0;
        while (i < InformationBoxtateStrSystemVect.length) {
            if (state.equals(InformationBoxtateStrSystemVect[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final boolean isValidLabel1Str(String label1) {
        if (label1 == null) {
            return false;
        }
        int i = 0;
        while (i < InformationBoxLabel1StrSystemVect.length) {
            if (label1.equals(InformationBoxLabel1StrSystemVect[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final boolean isValidLabel2Str(String label1, String label2) throws Exception {
        if (label1 == null || label1.equals("") || label2 == null) {
            return false;
        }
        if (label1.equals(strpcInputKey)) {
            int i = 0;
            while (i < InformationBoxLabel2ForPcStrSystemVect.length) {
                if (label2.equals(InformationBoxLabel2ForPcStrSystemVect[i])) {
                    return true;
                }
                ++i;
            }
        } else if (label1.equals(strmtInputKey)) {
            int i = 0;
            while (i < InformationBoxLabel2ForMtStrSystemVect.length) {
                if (label2.equals(InformationBoxLabel2ForMtStrSystemVect[i])) {
                    return true;
                }
                ++i;
            }
        } else if (label1.equals(strctInputKey)) {
            int i = 0;
            while (i < InformationBoxLabel2ForCtStrSystemVect.length) {
                if (label2.equals(InformationBoxLabel2ForCtStrSystemVect[i])) {
                    return true;
                }
                ++i;
            }
        } else {
            if (label1.equals(strNInputKey)) {
                InformationBox.checkInput(label1, label2);
                return true;
            }
            if (label1.equals(strFreeInputKey)) {
                return true;
            }
        }
        return false;
    }

    private static final void checkInput(String strLabel1, String strLabel2) throws Exception {
        block5: {
            if (strNInputKey.equals(strLabel1)) {
                if (strLabel2 == null || strLabel2.equals("")) {
                    throw new Exception(message);
                }
                try {
                    Integer lba2 = new Integer(strLabel2);
                    if (lba2 < 1) {
                        throw new Exception(message);
                    }
                    break block5;
                }
                catch (Exception ex) {
                    throw new Exception(message);
                }
            }
            strFreeInputKey.equals(strLabel1);
        }
    }

    public void resetStateString() {
        this.setInfoAll(defaultstateStr, "", "");
    }

    private void setStateString(String str) {
        this.strSTATE = str;
    }

    public String getStateString() {
        return this.strSTATE;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setInfoAll(String strState, String strLabel1, String strLabel2) {
        try {
            if (!InformationBox.isValidForInfo(strState, strLabel1, strLabel2)) {
                this.resetStateString();
            }
        }
        catch (Exception ex) {
            this.resetStateString();
        }
        this.setStateString(strState);
        if (InformationBox.isEmptyState(strState)) {
            this.setLabelString("", "");
        } else {
            this.setLabelString(strLabel1, strLabel2);
        }
        this.getShowLabelStr(InformationBox.getLabel(this));
    }

    private void setLabelString(String str1, String str2) {
        this.setLabel1String(str1);
        this.setLabel2String(str2);
    }

    private void setLabel1String(String str) {
        this.strLabel1 = str;
    }

    public String getLabel1String() {
        return this.strLabel1;
    }

    private void setLabel2String(String str) {
        this.strLabel2 = str;
    }

    public String getLabel2String() {
        return this.strLabel2;
    }

    @Override
    public GElement createCopy() {
        InformationBox informationBox = new InformationBox(this.strSTATE, this.strLabel1, this.strLabel2, this.parent);
        informationBox.setAngle(this.angle);
        return informationBox;
    }

    @Override
    public void draw(Graphics2D graphics2d) {
        if (InformationBox.isEmptyState(this.strSTATE)) {
            return;
        }
        if (this.parent == null) {
            return;
        }
        if (this.centerpos == null) {
            return;
        }
        RenderingHints backup = graphics2d.getRenderingHints();
        graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontMetrics fm = graphics2d.getFontMetrics();
        boolean isHigh = false;
        boolean isLow = false;
        boolean isGreek = false;
        int y_base = fm.getAscent() + 4;
        int y_upper = y_base - 4;
        int y_lower = y_base + 4;
        int x = 0;
        int w = 0;
        int h = 0;
        double xpos = this.centerpos.x;
        double ypos = this.centerpos.y;
        String label = InformationBox.getShowStrOfInformationBox(this);
        label = this.getLabelStr(fm);
        char[] array = label.toCharArray();
        Color originalcolor = graphics2d.getColor();
        graphics2d.setColor(infoColor);
        Stroke originalStroke = graphics2d.getStroke();
        graphics2d.setStroke(infoStroke);
        Point2D.Double size = this.getFrameSize();
        Rectangle2D.Double rectangle2D = this.getInfoRectangle2DBounds();
        if (rectangle2D != null) {
            if (this.isHighlighted) {
                graphics2d.setColor(Color.LIGHT_GRAY);
            } else {
                graphics2d.setColor(Color.WHITE);
            }
            graphics2d.fill(rectangle2D);
            if (this.isHighlighted) {
                graphics2d.setColor(GColor.HIGHLIGHTED_COLOR);
            } else {
                graphics2d.setColor(Color.BLACK);
            }
            graphics2d.draw(rectangle2D);
        }
        xpos = this.centerpos.x - size.x / 2.0;
        ypos = this.centerpos.y - size.y / 2.0;
        int iCharacterCounter = 0;
        int i = 0;
        while (i < array.length) {
            char c = array[i];
            if (c == '~') {
                x = 0;
                h += y_base;
            } else if (c == '^') {
                isHigh = !isHigh;
            } else if (c == '%') {
                isLow = !isLow;
            } else if (c == '$') {
                isGreek = true;
            } else {
                String str = "";
                if (isGreek) {
                    NameExpression exp = NameExpressionDictionary.getEntry(c);
                    if (exp != null) {
                        str = exp.printExp;
                    }
                } else {
                    str = String.valueOf(c);
                }
                if (isHigh) {
                    graphics2d.drawString(str, (int)(xpos + (double)x), (int)(ypos + (double)h + (double)y_upper));
                } else if (isLow) {
                    graphics2d.drawString(str, (int)(xpos + (double)x), (int)(ypos + (double)h + (double)y_lower));
                } else {
                    graphics2d.drawString(str, (int)(xpos + (double)x), (int)(ypos + (double)h + (double)y_base));
                }
                if (this.labelGraphics2d == null) {
                    this.labelGraphics2d = this.getGraphics2D();
                    this.labelGraphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    this.labelGraphics2d.setFont(graphics2d.getFont());
                }
                ++iCharacterCounter;
                isGreek = false;
                if ((x += fm.charWidth(c)) > w) {
                    w = x;
                }
            }
            ++i;
        }
        Rectangle2D.Double rectangle2D2 = this.getInfoRectangle2DBounds();
        if (rectangle2D2 != null) {
            this.oldBound = (Rectangle2D.Double)rectangle2D2.getBounds2D().clone();
            if (this.getNameBounds() != null) {
                this.oldNameBound = (Rectangle2D.Double)this.getNameBounds().clone();
            }
        } else {
            this.oldBound = null;
            this.oldNameBound = null;
        }
        graphics2d.setStroke(originalStroke);
        graphics2d.setColor(originalcolor);
        graphics2d.setRenderingHints(backup);
    }

    public Point2D.Double resetCenterPointByAngle() {
        return this.setCenterPointByAngle(this.angle);
    }

    public Point2D.Double setCenterPointByAngle(double agl) {
        if (this.parent == null) {
            this.centerpos = null;
        } else if (this.parent instanceof CompartmentAlias) {
            this.centerpos = ((CompartmentAlias)((Object)this.parent)).getInfoBoxCenterPointByAngle(agl);
        } else if (this.parent instanceof SpeciesAlias) {
            this.centerpos = ((SpeciesAlias)this.parent).getInfoBoxCenterPointByAngle(agl);
        }
        return this.centerpos;
    }

    public Rectangle2D.Double getInfoRectangle2DBounds() {
        if (this.centerpos == null) {
            return null;
        }
        if (this.parent == null) {
            return null;
        }
        if (InformationBox.isEmptyState(this.strSTATE)) {
            return null;
        }
        return InformationBox.getOutterRectangle2DSize(this.parent, this.centerpos);
    }

    public static final String getShowStrOfInformationBox(InformationBox ib) {
        String label = "";
        if (!InformationBox.isEmptyState(ib.strSTATE)) {
            label = InformationBox.getLabel(ib);
        }
        if (label == null) {
            label = "";
        }
        return label;
    }

    public static final Rectangle2D.Double getOutterRectangle2DSize(GElement parentGelm, Point2D.Double pntCenterPntOfBounds) {
        try {
            if (pntCenterPntOfBounds == null) {
                pntCenterPntOfBounds = new Point2D.Double(0.0, 0.0);
            }
            Rectangle2D.Double rectangle2D = new Rectangle2D.Double();
            Rectangle2D.Double rectParentBounds = null;
            double w2 = 70.0;
            rectParentBounds = parentGelm instanceof CompartmentAlias ? (Rectangle2D.Double)((CompartmentSymbol)((Object)((CompartmentAlias)((Object)parentGelm)).getSymbol())).getOutterShape().getBounds2D() : parentGelm.getBounds();
            if (w2 > rectParentBounds.getWidth()) {
                w2 = rectParentBounds.getWidth();
            }
            double xpos = pntCenterPntOfBounds.x;
            double ypos = pntCenterPntOfBounds.y;
            rectangle2D.setFrame(xpos - w2 / 2.0, ypos - 8.0, w2, 16.0);
            return rectangle2D;
        }
        catch (Exception myErr) {
            return null;
        }
    }

    private Graphics2D getGraphics2D() {
        BufferedImage img = new BufferedImage(1, 1, 1);
        Graphics2D g2 = img.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setFont(ModificationShape.getOutterLableFont_Size10(g2));
        return g2;
    }

    public Rectangle2D.Double getNameBounds() {
        Rectangle2D.Double rectangle2D;
        if (this.labelGraphics2d == null) {
            this.labelGraphics2d = this.getGraphics2D();
        }
        FontMetrics fmOutside = this.labelGraphics2d.getFontMetrics();
        String name = new String();
        if (!InformationBox.isEmptyState(this.strSTATE)) {
            name = InformationBox.getShowStrOfInformationBox(this);
            name = this.getLabelStr(fmOutside);
        }
        if ((rectangle2D = this.getInfoRectangle2DBounds()) != null && !name.equals("")) {
            int w = fmOutside.stringWidth(name);
            int h = fmOutside.getAscent() - fmOutside.getDescent();
            int x = (int)(rectangle2D.getX() + (rectangle2D.getWidth() - (double)w) / 2.0);
            int y = (int)(rectangle2D.getY() + (rectangle2D.getHeight() - (double)h) / 2.0);
            return new Rectangle2D.Double(x, y - h, w, h);
        }
        return null;
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return this.getRepaintBounds();
    }

    @Override
    public Rectangle2D.Double getRepaintBounds() {
        Rectangle2D.Double newBound = null;
        Rectangle2D.Double rectangle2D = this.getInfoRectangle2DBounds();
        if (rectangle2D != null) {
            newBound = (Rectangle2D.Double)rectangle2D.getBounds2D().clone();
        }
        Rectangle2D.Double paintBound = GUtil.union(this.oldBound, newBound);
        paintBound = GUtil.union(paintBound, this.oldNameBound);
        paintBound = GUtil.union(paintBound, this.getNameBounds());
        if (newBound != null) {
            this.oldBound = newBound;
        }
        if (this.getNameBounds() != null) {
            this.oldNameBound = (Rectangle2D.Double)this.getNameBounds().clone();
        }
        return paintBound;
    }

    @Override
    public boolean inShape(double x, double y) {
        Rectangle2D.Double rectangle2D = this.getInfoRectangle2DBounds();
        if (rectangle2D != null) {
            return rectangle2D.contains(x, y);
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D.Double selectArea) {
        Rectangle2D.Double rectangle2D = this.getInfoRectangle2DBounds();
        if (rectangle2D != null) {
            return rectangle2D.intersects(selectArea);
        }
        return false;
    }

    @Override
    public boolean onEdge(double x, double y) {
        return false;
    }

    @Override
    public boolean popupAvailable() {
        return false;
    }

    @Override
    public void setHighlighted(boolean highlight) {
        if (this.parent != null && (this.parent instanceof CompartmentAlias || this.parent instanceof SpeciesAlias)) {
            this.isHighlighted = highlight;
            return;
        }
        this.isHighlighted = false;
    }

    @Override
    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void showPopup(MouseEvent e, double x, double y, GStructure structure) {
    }

    @Override
    public Rectangle2D update() {
        return this.getRepaintBounds();
    }

    @Override
    public Rectangle2D.Double getFrameBounds() {
        return this.getRepaintBounds();
    }

    @Override
    public Point2D.Double getFramePosition() {
        Rectangle2D.Double rectangle2D = this.getInfoRectangle2DBounds();
        if (rectangle2D != null) {
            return new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
        }
        return null;
    }

    @Override
    public Point2D.Double getFrameSize() {
        Point2D.Double size = new Point2D.Double(0.0, 0.0);
        BufferedImage img = new BufferedImage(1, 1, 1);
        Graphics2D g2 = img.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontMetrics fm = g2.getFontMetrics();
        int y_base = fm.getAscent() + 4;
        int y_lower = y_base + 4;
        int x = 0;
        int w = 0;
        int h = 0;
        String label = InformationBox.getShowStrOfInformationBox(this);
        label = this.getLabelStr(fm);
        char[] array = label.toCharArray();
        int iCharacterCounter = 0;
        int i = 0;
        while (i < array.length) {
            char c = array[i];
            if (c == '~') {
                x = 0;
                h += y_base;
            } else if (c != '^' && c != '%' && c != '$') {
                ++iCharacterCounter;
                if ((x += fm.charWidth(c)) > w) {
                    w = x;
                }
            }
            ++i;
        }
        size.setLocation(w + 2, h + y_lower + fm.getDescent());
        return size;
    }

    @Override
    public void setFramePosition(double x, double y) {
        if (this.parent instanceof CompartmentAlias) {
            CompartmentAlias p = (CompartmentAlias)((Object)this.parent);
            this.centerpos = p.recalInfoBoxDisplayPostion(new Point2D.Double(x, y));
            this.angle = LibSBMLUtil.getAngleByInfoCenterPoint(p, this.centerpos, this.angle);
        } else if (this.parent instanceof SpeciesAlias) {
            SpeciesAlias sp = (SpeciesAlias)this.parent;
            this.centerpos = sp.recalInfoBoxDisplayPostion(new Point2D.Double(x, y));
            this.angle = LibSBMLUtil.getAngleByInfoCenterPoint(sp, this.centerpos, this.angle);
        }
    }

    @Override
    public void setFrameSize(double width, double height) {
    }

    @Override
    public void activateHandle(boolean active) {
    }

    @Override
    public GResizeHandle getHandle(double x, double y) {
        return null;
    }

    public void setInfoParent(GElement gElement) {
        this.parent = gElement;
    }

    public Object getInfoParent() {
        return this.parent;
    }

    public void backupAngleBeforeChangeInfo() {
        this.backupAngleWhenBeforeChangeInfo = this.angle;
    }

    public Rectangle2D restoreAngleAfterChangeInfoCancled() {
        this.angle = this.backupAngleWhenBeforeChangeInfo;
        this.setCenterPointByAngle(this.backupAngleWhenBeforeChangeInfo);
        return this.update();
    }

    public double getBackupAngleBeforeChangeInfo() {
        return this.backupAngleWhenBeforeChangeInfo;
    }

    public Point2D.Double getCenterPoint() {
        if (this.centerpos == null) {
            return null;
        }
        return (Point2D.Double)this.centerpos.clone();
    }

    public void setDeltaPoint2DUsingOnlyByMoving(double x, double y) {
        this.deltaPoint2DUsingOnlyByMoving = new Point2D.Double(x, y);
    }

    public void clearDeltaPoint2DUsingOnlyByMoving() {
        this.deltaPoint2DUsingOnlyByMoving = null;
    }

    public Point2D.Double getDeltaPoint2DUsingOnlyByMoving() {
        if (this.deltaPoint2DUsingOnlyByMoving == null) {
            return null;
        }
        return (Point2D.Double)this.deltaPoint2DUsingOnlyByMoving.clone();
    }

    @Override
    public String getName() {
        return "";
    }

    public static final String getLabel(InformationBox informationBox) {
        if (informationBox == null) {
            return "";
        }
        String strLabel1 = informationBox.getLabel1String();
        String strLabel2 = informationBox.getLabel2String();
        String strState = informationBox.getStateString();
        if (InformationBox.isEmptyState(strState)) {
            return "";
        }
        if (strLabel1.equals(strFreeInputKey)) {
            return strLabel2;
        }
        return String.valueOf(strLabel1) + strConnect + strLabel2;
    }

    private String getShowLabelStr(String strLabel) {
        if (strLabel == null) {
            return strLabel;
        }
        if ((strLabel = NameTranslator.translate(strLabel, 2, 1)) == null) {
            strLabel = "";
        }
        if (strLabel.contains("~")) {
            this.changeflag = true;
            strLabel = strLabel.substring(0, strLabel.indexOf("~"));
        }
        if (strLabel.contains("$")) {
            NameExpression exp = NameExpressionDictionary.getEntry("$");
            String strReplace = "";
            if (exp != null) {
                strReplace = exp.printExp;
            }
            strLabel = strLabel.replace("$", strReplace);
        }
        this.strShowLabel = new String(strLabel);
        return this.strShowLabel;
    }

    private String getLabelStr(FontMetrics fm) {
        if (fm == null) {
            return "";
        }
        if (this.strShowLabel == null) {
            return "";
        }
        String tempShow = this.changeflag ? new String(new StringBuffer(" ").append(this.strShowLabel).append(buffer)) : new String(new StringBuffer(" ").append(this.strShowLabel).append(" "));
        StringBuffer strShow = new StringBuffer("");
        String temp = new String(tempShow);
        if (temp.contains("^")) {
            temp = temp.replace("^", "");
        }
        if (temp.contains("%")) {
            temp = temp.replace("%", "");
        }
        int stringWidth = fm.stringWidth(temp);
        int Length = 70;
        Object obparent = this.getInfoParent();
        if (obparent != null) {
            int wid;
            Rectangle2D.Double rectParentBounds = null;
            if (obparent instanceof CompartmentAlias) {
                try {
                    rectParentBounds = (Rectangle2D.Double)((CompartmentSymbol)((Object)((CompartmentAlias)obparent).getSymbol())).getOutterShape().getBounds2D();
                }
                catch (Exception ex) {
                    rectParentBounds = new Rectangle2D.Double();
                }
            } else if (obparent instanceof GElement) {
                rectParentBounds = ((GElement)obparent).getBounds();
            }
            if ((wid = (int)rectParentBounds.getWidth()) < 70) {
                Length = wid;
            }
        }
        if (stringWidth < Length) {
            return tempShow;
        }
        int maxLengthTemp = Length - fm.stringWidth(buffer);
        char[] array = tempShow.toCharArray();
        int x = 0;
        int i = 0;
        while (i < array.length) {
            char c = array[i];
            if (c == '^' || c == '%') {
                strShow.append(c);
            } else {
                if ((x += fm.charWidth(c)) > maxLengthTemp) break;
                strShow.append(c);
            }
            ++i;
        }
        strShow = new StringBuffer(strShow).append(buffer);
        return strShow.toString();
    }
}

