/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import jp.sbi.celldesigner.NameExpression;
import jp.sbi.celldesigner.NameExpressionDictionary;

public class HelpDialog
extends JDialog {
    private String helpString = "";
    private JButton closeButton;
    private JTextComponent textComponent;
    private JScrollPane scrollPane;
    private static final int DEFAULT_HEIGHT = 480;
    private static final int DEFAULT_WIDTH = 480;

    public HelpDialog(JFrame owner, String title) {
        super(owner);
        this.initializeDialog(owner, title, new NoFocusTraversalJTextArea());
    }

    public HelpDialog(JFrame owner, String title, JTextComponent textComponent) {
        super(owner);
        this.initializeDialog(owner, title, textComponent);
    }

    private void initializeDialog(JFrame owner, String title, JTextComponent textComponent) {
        this.setModal(false);
        this.setResizable(false);
        JRootPane rootPane = this.getRootPane();
        this.textComponent = textComponent;
        this.textComponent.setEditable(false);
        this.scrollPane = new JScrollPane(textComponent);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.closeButton = new JButton("Close");
        this.closeButton.setMnemonic(67);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpDialog.this.dispose();
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.add((Component)this.closeButton, null);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)buttonPane, "South");
        contentPane.add((Component)this.scrollPane, "Center");
        rootPane.setDefaultButton(this.closeButton);
        this.setTitle(title);
        this.setSize(480, 480);
    }

    @Override
    public void show() {
        this.getRootPane().setDefaultButton(this.closeButton);
        this.textComponent.setCaretPosition(0);
        super.show();
    }

    public void setNameExpressionHelpString() {
        this.makeHelpStringCellDesigner2();
        if (this.textComponent instanceof JEditorPane && ((JEditorPane)this.textComponent).getContentType().equals("text/html")) {
            this.helpString = this.helpString.replaceAll("\n", "<br>");
            this.helpString = this.helpString.replaceAll("\t", "&nbsp;&nbsp;");
        }
        this.textComponent.setText("");
        this.textComponent.setText(this.helpString);
    }

    public void setTextString(String textString) {
        this.textComponent.setText("");
        this.textComponent.setText(textString);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(((int)screenSize.getWidth() - width) / 2, ((int)screenSize.getHeight() - height) / 2);
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    private void makeHelpString() {
        this.helpString = String.valueOf(this.helpString) + "\tDISPLAY SPECIAL CHARACTERS\n\n";
        this.helpString = String.valueOf(this.helpString) + " In SBML Level 1, all names of components in a model must be \"SName\" \n";
        this.helpString = String.valueOf(this.helpString) + "strings: the definition of \"SName\" is\n\n";
        this.helpString = String.valueOf(this.helpString) + "\tletter ::= 'a'..'z','A'..'Z',\n";
        this.helpString = String.valueOf(this.helpString) + "\tdigit ::= '0'..'9',\n";
        this.helpString = String.valueOf(this.helpString) + "\tSName ::= { '_' } letter { letter | '_' | digit },\n\n";
        this.helpString = String.valueOf(this.helpString) + "which means that a \"letter,\" preceded by zero or more '_'s, and\n";
        this.helpString = String.valueOf(this.helpString) + "followed by zero or more combinations of \"letter,\" '_', or \"digit.\"\n\n";
        this.helpString = String.valueOf(this.helpString) + " If you want to display special characters not allowed to use in the names, \n";
        this.helpString = String.valueOf(this.helpString) + "type them in accordance with the following description.\n\n";
        this.helpString = String.valueOf(this.helpString) + "EXAMPLES:\n";
        this.helpString = String.valueOf(this.helpString) + " A special character is expressed by a sequence of characters with \n";
        this.helpString = String.valueOf(this.helpString) + "precedent and followup '_'s. Here are three examples. \n\n";
        this.helpString = String.valueOf(this.helpString) + " (1) Ca2+(\"Ca\" with \"2+\" superscript)\n";
        this.helpString = String.valueOf(this.helpString) + "\tCa_super_2_plus__endsuper_\n\n";
        this.helpString = String.valueOf(this.helpString) + " (2) G alpha beta gamma (\"G\" with Greek \"alpha beta gamma\" subscripts)\n";
        this.helpString = String.valueOf(this.helpString) + "\tG_sub__alpha__beta__gamma__endsub_\n\n";
        this.helpString = String.valueOf(this.helpString) + " (3) Complex of Cdc2 and CyclinB (\"Cdc2\" followed by \"+CyclinB\" \n";
        this.helpString = String.valueOf(this.helpString) + " in the new line).\n";
        this.helpString = String.valueOf(this.helpString) + "\tCdc2_br__plus_CyclinB\n\n";
        this.helpString = String.valueOf(this.helpString) + " These kinds of typing rules are specific to CellDesigner1.0, \n";
        this.helpString = String.valueOf(this.helpString) + "while not defined in SBML level 1.\n\n";
        this.helpString = String.valueOf(this.helpString) + "RULES:\n";
        this.helpString = String.valueOf(this.helpString) + " The followings are the whole typing rules defined in CellDesigner1.0.\n";
        this.helpString = String.valueOf(this.helpString) + "You can copy these strings from this area with Ctrl-C,\n";
        this.helpString = String.valueOf(this.helpString) + "and can paste to any input area with Ctrl-V.\n\n";
        Vector entries = NameExpressionDictionary.getAllEntries();
        int i = 0;
        while (i < entries.size()) {
            NameExpression exp = (NameExpression)entries.elementAt(i);
            this.helpString = String.valueOf(this.helpString) + "\t" + exp.desc + "    " + "_" + exp.snameExp + "_" + "\n";
            ++i;
        }
        this.helpString = String.valueOf(this.helpString) + "\n";
        this.helpString = String.valueOf(this.helpString) + "INTERPRETATION RULES:\n";
        this.helpString = String.valueOf(this.helpString) + " Here are described rules used by CellDesigner1.0 to interpret \"SName\" \n";
        this.helpString = String.valueOf(this.helpString) + "strings including \"_\"s.\n\n";
        this.helpString = String.valueOf(this.helpString) + " 1. The order of interpretation\n";
        this.helpString = String.valueOf(this.helpString) + " A defined sequence with its precedent and followup '_'s is replaced by \n";
        this.helpString = String.valueOf(this.helpString) + "a corresponding special character.\n";
        this.helpString = String.valueOf(this.helpString) + " This interpretation is done from left to right in an \"SName\" string.\n";
        this.helpString = String.valueOf(this.helpString) + " Ex.) _alpha_beta_gamma_ is tokenized as _alpha_, beta, and _gamma_,\n";
        this.helpString = String.valueOf(this.helpString) + "in order, to be displayed [alpha]beta[gamma] with a Greek character \n";
        this.helpString = String.valueOf(this.helpString) + "in each [ ].\n\n";
        this.helpString = String.valueOf(this.helpString) + " 2. Undefined sequences between '_'s\n";
        this.helpString = String.valueOf(this.helpString) + " An undefined sequence with its precedent '_' is displayed as it is.\n";
        this.helpString = String.valueOf(this.helpString) + " Ex.) a_foo_bar is tokenized as a, _foo, and _bar, in order.\n\n";
        this.helpString = String.valueOf(this.helpString) + " 3. The terminal '_'\n";
        this.helpString = String.valueOf(this.helpString) + " A terminal '_' following a defined sequence is omissible.\n";
        this.helpString = String.valueOf(this.helpString) + "One following an undefined sequence is displayed as it is.\n";
        this.helpString = String.valueOf(this.helpString) + " Ex.) G_alpha is equal to G_alpha_. foo_bar_ is displayed as it is.\n\n";
        this.helpString = String.valueOf(this.helpString) + " 4. Sequences used in pair form\n";
        this.helpString = String.valueOf(this.helpString) + " For sequences indicating superscripts and subscripts, _endsuper_ and\n";
        this.helpString = String.valueOf(this.helpString) + "_endsub_ are omissible at the end of Sname strings.\n\n";
        this.helpString = String.valueOf(this.helpString) + " 5. No interpretation of a defined sequence\n";
        this.helpString = String.valueOf(this.helpString) + " For a defined sequence between '_' to be displayed as it is, use \n";
        this.helpString = String.valueOf(this.helpString) + "\"_underscore_\".\n";
        this.helpString = String.valueOf(this.helpString) + " Ex.)_underscore_alpha_ is tokenized, '_underscore_', alpha, and '_', \n";
        this.helpString = String.valueOf(this.helpString) + "in order, to be displayed \"_alpha_\".\n\n";
        this.helpString = String.valueOf(this.helpString) + "CAUTION:\n";
        this.helpString = String.valueOf(this.helpString) + " As for a current version, displaying Greek characters\n";
        this.helpString = String.valueOf(this.helpString) + "has been confirmed on English and Japanese platforms.\n";
        this.helpString = String.valueOf(this.helpString) + "However, displays may not be good. It is caused by difference in font \n";
        this.helpString = String.valueOf(this.helpString) + "metrics.\n";
    }

    private void makeHelpStringCellDesigner2() {
        this.helpString = "";
        this.addComment();
        this.addExample();
        this.addRule();
    }

    private void addComment_old() {
        this.helpString = String.valueOf(this.helpString) + "\tDISPLAY SPECIAL CHARACTERS\n\n In this help dialog the way for CellDesigner 2.0 to render speciel characters used in Species and Compartment names is described.\n\n CellDesigner is able to handle SBML level 2 version 1 documents and hence \"name\" attributes of SBML components. (SBML level 1 components also have \"name\" attribute, which has the same role with \"id\" attribute of level 2 components.) The component names input by users are directly stored to the \"name\" attributes, where it is allowed to use UTF-8 characters. Therefore, any character that can be mapped to UTF-8 encoding can be used for component names.\n\n Rule, described below, to render special characters is mainly designed for SBML level 1 documents where there is restriction on available characters (letters, digits, and '_') of \"name\" attributes. While almost characters in the rule can now be input directly, rules to control rendering super/subscripts and line breaks still provide the only ways to do so. Moreover, keeping the rule may still be useful for situation with restricted character usage, such as, limited input methods and compatibility with other tools.\n\n There is a point to be paid attention. CellDesigner uses the \"name\" attributes as an information to distinguish a Species from another. Therefore, even if the rendered name results seem to be the same, different \"name\" attributes, for example, 'G\u03b1' and 'G_alpha_', mean different Species.\n\n";
    }

    private void addComment() {
        this.helpString = String.valueOf(this.helpString) + "\tDISPLAY SPECIAL CHARACTERS\n\n CellDesigner is able to handle SBML Level 2 version 1 documents, and stores the component names in \"name\" attributes of SBML Level 2 Version 1 documents. Any character that can be mapped to UTF-8 encoding can be used for the component names. Check the following RULES when you want to input the special characters.\n\nCaution: CellDesigner uses the \"name\" attributes as information to distinguish Species.  Therefore, even if the rendered names look the same, the different \"name\" attributes, for example, \"G\u03b1\" and \"G_alpha_\", mean different Species.\n\nNote: CellDesginer 1.x and SBML Level 1\n The previous version of CellDesigner 1.x only support SBML Level-1, therefore, there are much strict restrictions were needed in handling the characters (letters, digits, and '_') used for components names. The Rules to render special characters is mainly designed for SBML Level 1 documents. Even though CellDesigner 2.0 supports SBML Level 2, most of the characters in the rules can now be input as they are, these rules are still useful, especially for maintaining the compatibility with other tools, which only supports SBML Level 1.\n\n";
    }

    private void addExample() {
        this.helpString = String.valueOf(this.helpString) + "EXAMPLES:\n A special character is expressed by a sequence of characters with precedent and followup '_'s. Here are three examples. \n\n (1) Ca2+(\"Ca\" with \"2+\" superscript)\n\tCa_super_2_plus__endsuper_  or  Ca_super_2+_endsuper_\n\n (2) G alpha beta gamma (\"G\" with Greek \"\u03b1\u03b2\u03b3\" subscripts)\n\tG_sub__alpha__beta__gamma__endsub_  or  G_sub_\u03b1\u03b2\u03b3_endsub_\n\n (3) Complex of Cdc2 and CyclinB (\"Cdc2\" followed by \"+CyclinB\" in the new line).\n\tCdc2_br__plus_CyclinB  or  Cdc2_br_+CyclinB\n\n";
    }

    private void addRule() {
        NameExpression exp;
        this.helpString = String.valueOf(this.helpString) + "RULES:\n The followings are the whole typing rules defined in CellDesigner 2.0. You can copy these strings from this area with CTRL-C, and can paste to any input area with CTRL-V.\n\n";
        Vector entries = NameExpressionDictionary.getAllEntries();
        int i = 5;
        while (i < 10) {
            exp = (NameExpression)entries.elementAt(i);
            this.helpString = String.valueOf(this.helpString) + "\t" + exp.desc + "    " + "_" + exp.snameExp + "_" + "\n";
            ++i;
        }
        this.helpString = String.valueOf(this.helpString) + "\n*The following characters can be input directly without specifying the following rules in CellDesginer 2.0 (in SBML Level2 Version1): However, the rules are still useful, especially for maintaining the compatibility with other tools, which only supports SBML Level 1.\n\n";
        i = 0;
        while (i < entries.size()) {
            if (4 >= i || i >= 10) {
                exp = (NameExpression)entries.elementAt(i);
                this.helpString = String.valueOf(this.helpString) + "\t" + exp.desc + "    " + "_" + exp.snameExp + "_" + "\n";
            }
            ++i;
        }
        this.helpString = String.valueOf(this.helpString) + "\nINTERPRETATION RULES:\n Here are described rules used by CellDesigner to interpret \"name\" strings including \"_\"s to render.\n\n 1. The order of interpretation\n A defined sequence with its precedent and followup '_'s is replaced by a corresponding special character. This interpretation is done from left to right in a \"name\" string.\n Ex.) '_alpha_beta_gamma_' is tokenized as '_alpha_', 'beta', and '_gamma_' in order, to be displayed '\u03b1beta\u03b3'.\n\n 2. Undefined sequences between '_'s\n An undefined sequence with its precedent '_' is displayed as it is.\n Ex.) 'a_foo_bar' is tokenized as 'a', '_foo', and '_bar' in order.\n\n 3. The terminal '_'\n A terminal '_' following a defined sequence is omissible. One following an undefined sequence is displayed as it is.\n Ex.) 'G_alpha' is equal to 'G_alpha_'. 'foo_bar_' is displayed as it is.\n\n 4. Sequences used in pair form\n For sequences indicating superscripts and subscripts, '_endsuper_' and '_endsub_' are omissible at the end of \"name\" strings.\n\n 5. No interpretation of a defined sequence\n For a defined sequence between '_' to be displayed as it is, use '_underscore_'.\n Ex.)'_underscore_alpha_' is tokenized, '_underscore_', 'alpha', and '_' in order, to be displayed '_alpha_'.\n\n";
    }

    private class NoFocusTraversalJTextArea
    extends JTextArea {
        public NoFocusTraversalJTextArea() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }

        @Override
        public boolean isManagingFocus() {
            return false;
        }
    }
}

