/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import jp.fric.graphics.draw.GElement;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.SpeciesAlias;

public class FindSpecieDialog
extends JDialog {
    private static final String strSearchingFor = "search";
    private SBModelFrame sbframe;
    private Vector matched = new Vector();
    private int index = 0;
    private int max = 0;
    private JPanel jMainPanel = null;
    private JPanel jSearchPanel = null;
    private JLabel jPatternLabel = null;
    private JLabel jSearchLabel = null;
    private JRadioButton jRadioButtonId = null;
    private JRadioButton jRadioButtonName = null;
    private JTextField jTextFieldSearch = null;
    private JCheckBox jCheckBoxCaseSensitive = null;
    private JComboBox jComboBoxPattern = null;
    private JButton jButtonClose = null;
    private JButton jButtonFindAll = null;
    private JButton jButtonNext = null;
    private JButton jButtonPrev = null;
    private JButton jButtonFind = null;
    private FocusListener findButtonFocuser;

    public FindSpecieDialog(SBModelFrame sbframe, String title) {
        super(sbframe.getMyFrame());
        this.sbframe = sbframe;
        this.setTitle(title);
        this.initialize();
    }

    private void initialize() {
        final JRootPane rootPane = this.getRootPane();
        this.findButtonFocuser = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(FindSpecieDialog.this.jButtonFind);
            }
        };
        this.setLocation(30, 60);
        this.setResizable(false);
        this.setSize(new Dimension(410, 270));
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.getJMainPanel());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FindSpecieDialog.this.close_actionPerformed();
            }
        });
        this.getJTextFieldSearch().requestFocus();
    }

    private JPanel getJMainPanel() {
        if (this.jMainPanel == null) {
            this.jMainPanel = new JPanel();
            this.jMainPanel.setLayout(null);
            this.jMainPanel.add((Component)this.getJSearchPanel(), null);
        }
        return this.jMainPanel;
    }

    private JPanel getJSearchPanel() {
        if (this.jSearchPanel == null) {
            this.jPatternLabel = new JLabel();
            this.jPatternLabel.setBounds(new Rectangle(5, 95, 80, 25));
            this.jPatternLabel.setText("pattern");
            this.jSearchLabel = new JLabel();
            this.jSearchLabel.setText(strSearchingFor);
            this.jSearchLabel.setBounds(new Rectangle(5, 5, 80, 25));
            this.jSearchPanel = new JPanel();
            this.jSearchPanel.setLayout(null);
            this.jSearchPanel.setBounds(new Rectangle(0, 0, 420, 260));
            this.jSearchPanel.add((Component)this.jSearchLabel, null);
            this.jSearchPanel.add((Component)this.jPatternLabel, null);
            this.jSearchPanel.add((Component)this.getJTextFieldSearch(), null);
            this.jSearchPanel.add((Component)this.getJComboBoxPattern(), null);
            this.jSearchPanel.add((Component)this.getJButtonPrev(), null);
            this.jSearchPanel.add((Component)this.getJButtonNext(), null);
            this.jSearchPanel.add((Component)this.getJRadioButtonId(), null);
            this.jSearchPanel.add((Component)this.getJRadioButtonName(), null);
            ButtonGroup jBtnGrp = new ButtonGroup();
            jBtnGrp.add(this.getJRadioButtonId());
            jBtnGrp.add(this.getJRadioButtonName());
            this.jSearchPanel.add((Component)this.getJCheckBoxCaseSensitive(), null);
            this.jSearchPanel.add((Component)this.getJButtonFind(), null);
            this.jSearchPanel.add((Component)this.getJButtonFindAll(), null);
            this.jSearchPanel.add((Component)this.getJButtonClose(), null);
        }
        return this.jSearchPanel;
    }

    private JTextField getJTextFieldSearch() {
        if (this.jTextFieldSearch == null) {
            this.jTextFieldSearch = new JTextField();
            this.jTextFieldSearch.setBounds(new Rectangle(90, 5, 300, 25));
            this.jTextFieldSearch.addFocusListener(this.findButtonFocuser);
        }
        return this.jTextFieldSearch;
    }

    private JComboBox getJComboBoxPattern() {
        if (this.jComboBoxPattern == null) {
            this.jComboBoxPattern = new JComboBox();
            this.jComboBoxPattern.setBounds(new Rectangle(90, 95, 300, 25));
            this.jComboBoxPattern.addItem("include");
            this.jComboBoxPattern.addItem("equal");
            this.jComboBoxPattern.addItem("begin with");
            this.jComboBoxPattern.addItem("end with");
            this.jComboBoxPattern.setSelectedIndex(0);
        }
        return this.jComboBoxPattern;
    }

    private JButton getJButtonPrev() {
        if (this.jButtonPrev == null) {
            this.jButtonPrev = new JButton();
            this.jButtonPrev.setBounds(new Rectangle(225, 140, 80, 30));
            this.jButtonPrev.setText("Prev");
            this.jButtonPrev.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindSpecieDialog.this.prev();
                }
            });
        }
        return this.jButtonPrev;
    }

    private JButton getJButtonNext() {
        if (this.jButtonNext == null) {
            this.jButtonNext = new JButton();
            this.jButtonNext.setBounds(new Rectangle(310, 140, 80, 30));
            this.jButtonNext.setText("Next");
            this.jButtonNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindSpecieDialog.this.next();
                }
            });
        }
        return this.jButtonNext;
    }

    private JRadioButton getJRadioButtonId() {
        if (this.jRadioButtonId == null) {
            this.jRadioButtonId = new JRadioButton();
            this.jRadioButtonId.setBounds(new Rectangle(90, 35, 50, 25));
            this.jRadioButtonId.setText("ID");
        }
        return this.jRadioButtonId;
    }

    private JRadioButton getJRadioButtonName() {
        if (this.jRadioButtonName == null) {
            this.jRadioButtonName = new JRadioButton();
            this.jRadioButtonName.setBounds(new Rectangle(145, 35, 80, 25));
            this.jRadioButtonName.setText("name");
            this.jRadioButtonName.setSelected(true);
        }
        return this.jRadioButtonName;
    }

    private JCheckBox getJCheckBoxCaseSensitive() {
        if (this.jCheckBoxCaseSensitive == null) {
            this.jCheckBoxCaseSensitive = new JCheckBox();
            this.jCheckBoxCaseSensitive.setBounds(new Rectangle(90, 65, 220, 25));
            this.jCheckBoxCaseSensitive.setText("case sensitive");
        }
        return this.jCheckBoxCaseSensitive;
    }

    private JButton getJButtonFind() {
        if (this.jButtonFind == null) {
            this.jButtonFind = new JButton();
            this.jButtonFind.setBounds(new Rectangle(10, 140, 80, 30));
            this.jButtonFind.setText("Find");
            this.jButtonFind.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindSpecieDialog.this.find_actionPerformed(e);
                }
            });
        }
        return this.jButtonFind;
    }

    private JButton getJButtonFindAll() {
        if (this.jButtonFindAll == null) {
            this.jButtonFindAll = new JButton();
            this.jButtonFindAll.setBounds(new Rectangle(100, 140, 110, 30));
            this.jButtonFindAll.setText(" Show All");
            this.jButtonFindAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindSpecieDialog.this.findall_actionPerformed(e);
                }
            });
        }
        return this.jButtonFindAll;
    }

    private JButton getJButtonClose() {
        if (this.jButtonClose == null) {
            this.jButtonClose = new JButton();
            this.jButtonClose.setBounds(new Rectangle(310, 190, 80, 30));
            this.jButtonClose.setText("Close");
            this.jButtonClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindSpecieDialog.this.close_actionPerformed();
                }
            });
        }
        return this.jButtonClose;
    }

    public void releaseFrame() {
        this.matched.clear();
        this.sbframe = null;
    }

    private void find_actionPerformed(ActionEvent e) {
        if (!this.inputcheck()) {
            return;
        }
        this.findSpecies(true);
    }

    private void findall_actionPerformed(ActionEvent e) {
        if (!this.inputcheck()) {
            return;
        }
        this.findSpecies(false);
    }

    private void close_actionPerformed() {
        this.resetMatched();
        this.resetDialog();
        this.setVisible(false);
    }

    private boolean inputcheck() {
        if (this.getJTextFieldSearch().getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Please input [search]", "Confirmation", 2);
            return false;
        }
        return true;
    }

    public void resetMatched() {
        this.matched = new Vector();
        this.index = 0;
        this.max = 0;
        this.getJButtonPrev().setEnabled(false);
        this.getJButtonNext().setEnabled(false);
    }

    private void resetDialog() {
        this.getJTextFieldSearch().setText("");
        this.getJRadioButtonId().setSelected(true);
        this.getJComboBoxPattern().setSelectedIndex(0);
        this.getJCheckBoxCaseSensitive().setSelected(false);
        this.getJTextFieldSearch().requestFocus();
    }

    private void findSpecies(boolean OneByOne) {
        String searchfor = this.getJTextFieldSearch().getText();
        String pattern = this.getJComboBoxPattern().getSelectedItem().toString();
        boolean casesensitive = this.getJCheckBoxCaseSensitive().isSelected();
        boolean bID = this.getJRadioButtonId().isSelected();
        Vector matched = this.sbframe.findSpecies(searchfor, bID, casesensitive, pattern, OneByOne);
        if (matched.size() > 0) {
            GElement any;
            Vector<GElement> temp = new Vector<GElement>();
            int i = 0;
            while (i < matched.size()) {
                any = (GElement)matched.get(i);
                GElement ge = this.sbframe.getSBModel().getGStructure().getEventAvailableNeastNodeFrom(any);
                if (!ge.equals(any)) {
                    temp.add(any);
                }
                ++i;
            }
            i = 0;
            while (i < temp.size()) {
                any = (SpeciesAlias)temp.get(i);
                if (matched != null && matched.size() >= 1) {
                    matched.remove(any);
                }
                ++i;
            }
        }
        if (matched.size() <= 0) {
            this.showNotMatched();
        } else {
            if (OneByOne) {
                this.setMatched(matched);
            } else {
                this.showAllMatched(matched);
            }
            this.sbframe.repaintOffScreenPanel();
        }
    }

    private void showNotMatched() {
        JOptionPane.showMessageDialog(this, "No matched", "Result", 1);
        this.resetMatched();
    }

    private void setMatched(Vector matchedVector) {
        this.matched = matchedVector;
        this.max = this.matched.size();
        this.index = -1;
        this.next();
    }

    private void showAllMatched(Vector matchedVector) {
        GElement elem;
        this.matched = matchedVector;
        this.max = this.matched.size();
        this.index = 1;
        while (this.index < this.max) {
            elem = (GElement)this.matched.elementAt(this.index);
            this.sbframe.getSBModel().getGStructure().select(elem, false, false);
            ++this.index;
        }
        this.index = 0;
        elem = (GElement)this.matched.elementAt(this.index);
        this.sbframe.scrollToShow(elem, false);
        this.getJButtonPrev().setEnabled(false);
        this.getJButtonNext().setEnabled(false);
    }

    private void next() {
        ++this.index;
        if (this.index < this.max) {
            GElement elem = (GElement)this.matched.elementAt(this.index);
            this.sbframe.scrollToShow(elem, true);
        } else {
            this.index = this.max - 1;
        }
        this.setButtons();
    }

    private void prev() {
        --this.index;
        if (this.index >= 0) {
            GElement elem = (GElement)this.matched.elementAt(this.index);
            this.sbframe.scrollToShow(elem, true);
        } else {
            this.index = 0;
        }
        this.setButtons();
    }

    private void setButtons() {
        boolean prevEnabled = false;
        boolean nextEnabled = false;
        if (this.index > 0) {
            prevEnabled = true;
        }
        if (this.index < this.max - 1) {
            nextEnabled = true;
        }
        this.getJButtonPrev().setEnabled(prevEnabled);
        this.getJButtonNext().setEnabled(nextEnabled);
    }
}

