/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import jp.fric.graphics.draw.GLinkedLine;

public class EditReactionsDialog
extends JDialog
implements ActionListener {
    private JSpinner defaultCreasePointsNumberSpinner;
    private static ImageIcon iconDirect;
    private static ImageIcon iconSquare;
    private JLabel iconLabel;
    private int connectPolicy;

    static {
        Toolkit tk = Toolkit.getDefaultToolkit();
        try {
            iconDirect = new ImageIcon(tk.getImage(EditReactionsDialog.class.getResource("icons/directconnect.png")));
            iconSquare = new ImageIcon(tk.getImage(EditReactionsDialog.class.getResource("icons/squareconnect.png")));
        }
        catch (Exception e) {
            System.out.println("cannnot load directconnect/squareconnect icon.");
        }
    }

    public EditReactionsDialog(Frame frame, String title, Action buttonAction, boolean modal) {
        super(frame, title, modal);
        this.enableEvents(64L);
        try {
            this.myInit();
            this.pack();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    void cancel() {
        this.dispose();
    }

    private void myInit() {
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        GridBagConstraints c = new GridBagConstraints();
        contentPane.setLayout(new GridBagLayout());
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Anchor Points"));
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        contentPane.add((Component)p, c);
        c.fill = 0;
        JLabel label1 = new JLabel("default number:");
        p.add((Component)label1, c);
        Integer initial = new Integer(GLinkedLine.getDefaultCreasePointNumber());
        Integer minimum = new Integer(0);
        Comparable<?> maximum = null;
        Integer stepSize = new Integer(1);
        this.defaultCreasePointsNumberSpinner = new JSpinner(new SpinnerNumberModel(initial, minimum, maximum, stepSize));
        this.defaultCreasePointsNumberSpinner.setPreferredSize(new Dimension(50, 20));
        label1.setLabelFor(this.defaultCreasePointsNumberSpinner);
        c.gridx = 1;
        c.gridy = 0;
        p.add((Component)this.defaultCreasePointsNumberSpinner, c);
        p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Connection Drawing"));
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        contentPane.add((Component)p, c);
        c.fill = 0;
        ButtonGroup bg = new ButtonGroup();
        this.connectPolicy = GLinkedLine.getDefaultConnectPolicy();
        JRadioButton b = new JRadioButton("Polyline");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditReactionsDialog.this.directButton_actionPerformed(e);
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        p.add((Component)b, c);
        if (this.connectPolicy == 0) {
            b.setSelected(true);
        }
        bg.add(b);
        b = new JRadioButton("Orthogonal");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditReactionsDialog.this.squareButton_actionPerformed(e);
            }
        });
        c.gridx = 0;
        c.gridy = 1;
        p.add((Component)b, c);
        c.anchor = 10;
        if (this.connectPolicy == 1) {
            b.setSelected(true);
        }
        bg.add(b);
        this.iconLabel = new JLabel();
        if (this.connectPolicy == 1) {
            this.iconLabel.setIcon(iconSquare);
        } else {
            this.iconLabel.setIcon(iconDirect);
        }
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 2;
        p.add((Component)this.iconLabel, c);
        c.gridheight = 1;
        p = new JPanel();
        p.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 2;
        contentPane.add((Component)p, c);
        c.insets = new Insets(4, 4, 4, 4);
        JButton b1 = new JButton("Apply");
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)b1, c);
        b1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditReactionsDialog.this.applyButton_actionPerformed(e);
            }
        });
        JButton b2 = new JButton("Close");
        c.gridx = 1;
        p.add((Component)b2, c);
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditReactionsDialog.this.closeButton_actionPerformed(e);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private void directButton_actionPerformed(ActionEvent e) {
        this.iconLabel.setIcon(iconDirect);
        this.connectPolicy = 0;
    }

    private void squareButton_actionPerformed(ActionEvent e) {
        this.iconLabel.setIcon(iconSquare);
        this.connectPolicy = 1;
    }

    void applyButton_actionPerformed(ActionEvent e) {
        Integer value = (Integer)this.defaultCreasePointsNumberSpinner.getValue();
        GLinkedLine.setDefaultCreasePointNumber(value);
        GLinkedLine.setDefaultConnectPolicy(this.connectPolicy);
    }

    void closeButton_actionPerformed(ActionEvent e) {
        this.dispose();
    }
}

