/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import jp.fric.graphics.draw.GLinkConnectSchemeOwner;
import jp.fric.graphics.draw.GLinkedCreaseLine;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineComplex3;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SBSymbolPaletteDialog;
import jp.sbi.celldesigner.util.SpringUtilities;

public class EditComponentsDialog2
extends JDialog
implements ActionListener {
    private MainWindow mainwindow = null;
    private JButton applyAllButton = null;
    private Action buttonAction = null;
    private JButton jClose = new JButton();
    private SBSymbolPaletteDialog paletteDlg;
    private Vector buttons = new Vector();
    private Vector symbols = new Vector();
    private JPanel proteinPanel = new JPanel();
    private JPanel speciesPanel = new JPanel();
    private JPanel compartmentPanel = new JPanel();
    private JPanel reactionPanel = new JPanel();
    private JPanel mixedNotationPanel = new JPanel();
    private JPanel closeButtonPanel = new JPanel();
    private Insets insets = new Insets(4, 4, 4, 4);
    private static final String[] proteinLabel = new String[]{"Generic", "Receptor", "Ion Channel", "Truncated"};
    private static final String[] speciesLabel = new String[]{"Gene", "RNA", "Antisense RNA", "Phenotype", "Ion", "Simple Molecule", "Drug", "Unknown", "Complex", "Complex Packed", "Degraded"};
    private static final String[] compartmentLabel = new String[]{"Square", "Oval", "Closeup NW", "Closeup NE", "Closeup SW", "Closeup SE", "Closeup N", "Closeup E", "Closeup W", "Closeup S"};
    private static final String[] reactionLabel = new String[]{"State Transition", "Known Transition Omitted", "Unknown Transition", "Transcription", "Translation", "Transport", "Heterodimer Association", "Dissociation", "Truncation", "Add Reactant", "Add Product", "Catalysis", "Unknown Catalysis", "Inhibition", "Unknown Inhibition", "PhisicalStimulation", "Modulation", "Trigger"};
    private static final String[] mixedNotationLabel = new String[]{"Positive Influence", "Negative Influence", "Reduced PhysicalStimulation", "Reduced Modulation", "Reduced Trigger", "Unknown Positive Influence", "Unknown Negative Influence", "Unknown Reduced PhysicalStimulation", "Unknown Reduced Modulation", "Unknown Reduced Trigger"};
    private ButtonGroup bgroup = new ButtonGroup();

    public EditComponentsDialog2(Frame frame, String title, Action buttonAction, boolean modal) {
        super(frame, title, modal);
        if (frame instanceof MainWindow) {
            this.mainwindow = (MainWindow)frame;
        }
        this.buttonAction = buttonAction;
        this.enableEvents(64L);
        try {
            this.myInit();
            this.pack();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    void cancel() {
        this.dispose();
    }

    private void myInit() {
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        SpringLayout layout = new SpringLayout();
        int gridLayoutRows = 0;
        int gridLayoutCols = 4;
        int gridLayoutHgap = 5;
        int gridLayoutVgap = 5;
        int emptyBorderTop = 4;
        int emptyBorderLeft = 7;
        int emptyBorderBottom = 4;
        int emptyBorderRight = 13;
        contentPane.setLayout(layout);
        contentPane.add(this.proteinPanel);
        this.proteinPanel.setRequestFocusEnabled(false);
        this.proteinPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Protein"));
        this.proteinPanel.setLayout(new GridLayout(gridLayoutRows, gridLayoutCols, gridLayoutHgap, gridLayoutVgap));
        Vector proteinCodes = SBFactory.getProteinCodes();
        Border buttonBorder = BorderFactory.createEmptyBorder(emptyBorderTop, emptyBorderLeft, emptyBorderBottom, emptyBorderRight);
        int i = 0;
        while (i < proteinLabel.length) {
            JToggleButton b = new JToggleButton();
            b.setIconTextGap(10);
            b.setHorizontalAlignment(2);
            b.setRolloverEnabled(true);
            b.setBorder(buttonBorder);
            String code = (String)proteinCodes.elementAt(i);
            String normalName = "icons/" + code + ".png";
            try {
                Toolkit tk = Toolkit.getDefaultToolkit();
                ImageIcon image = new ImageIcon(tk.getImage(this.getClass().getResource(normalName)));
                b.setIcon(image);
            }
            catch (Exception e) {
                System.out.println("cannnot load icon: " + code);
            }
            b.setText(proteinLabel[i]);
            b.addActionListener(this);
            this.proteinPanel.add(b);
            this.bgroup.add(b);
            this.buttons.addElement(b);
            this.symbols.add(SBFactory.createSymbol(code));
            ++i;
        }
        contentPane.add(this.speciesPanel);
        this.speciesPanel.setRequestFocusEnabled(false);
        this.speciesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "The Other Species"));
        this.speciesPanel.setLayout(new GridLayout(gridLayoutRows, gridLayoutCols, gridLayoutHgap, gridLayoutVgap));
        Vector speciesCodes = SBFactory.getSpeciesCodesExceptProtein();
        int i2 = 0;
        while (i2 < speciesLabel.length) {
            JToggleButton b = new JToggleButton();
            b.setIconTextGap(10);
            b.setHorizontalAlignment(2);
            b.setRolloverEnabled(true);
            b.setBorder(buttonBorder);
            String code = (String)speciesCodes.elementAt(i2);
            String normalName = "icons/" + code + ".png";
            try {
                Toolkit tk = Toolkit.getDefaultToolkit();
                ImageIcon image = new ImageIcon(tk.getImage(this.getClass().getResource(normalName)));
                b.setIcon(image);
            }
            catch (Exception e) {
                System.out.println("cannnot load icon: " + code);
            }
            b.setText(speciesLabel[i2]);
            b.addActionListener(this);
            this.speciesPanel.add(b);
            this.bgroup.add(b);
            this.buttons.addElement(b);
            this.symbols.add(SBFactory.createSymbol(code));
            ++i2;
        }
        contentPane.add(this.compartmentPanel);
        this.compartmentPanel.setRequestFocusEnabled(false);
        this.compartmentPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Compartment"));
        this.compartmentPanel.setLayout(new GridLayout(gridLayoutRows, gridLayoutCols, gridLayoutHgap, gridLayoutVgap));
        Vector compartmentCodes = SBFactory.getCompartmentCodes();
        int i3 = 0;
        while (i3 < compartmentLabel.length) {
            JToggleButton b = new JToggleButton();
            b.setIconTextGap(10);
            b.setHorizontalAlignment(2);
            b.setRolloverEnabled(true);
            b.setBorder(buttonBorder);
            String code = (String)compartmentCodes.elementAt(i3);
            String normalName = "icons2/" + code + ".png";
            try {
                Toolkit tk = Toolkit.getDefaultToolkit();
                ImageIcon image = new ImageIcon(tk.getImage(this.getClass().getResource(normalName)));
                b.setIcon(image);
            }
            catch (Exception e) {
                System.out.println("cannnot load icon: " + code);
            }
            b.setText(compartmentLabel[i3]);
            b.addActionListener(this);
            this.compartmentPanel.add(b);
            this.bgroup.add(b);
            this.buttons.addElement(b);
            this.symbols.add(SBFactory.createSymbol(code));
            ++i3;
        }
        contentPane.add(this.reactionPanel);
        this.reactionPanel.setRequestFocusEnabled(false);
        this.reactionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Reaction"));
        this.reactionPanel.setLayout(new GridLayout(gridLayoutRows, gridLayoutCols, gridLayoutHgap, gridLayoutVgap));
        Vector reactionCodes = SBFactory.getReactionCodes();
        int policy = GLinkedLine.getDefaultConnectPolicy();
        GLinkedLine.setDefaultConnectPolicy(0);
        int i4 = 0;
        while (i4 < reactionLabel.length) {
            JToggleButton b = new JToggleButton();
            b.setIconTextGap(10);
            b.setHorizontalAlignment(2);
            b.setRolloverEnabled(true);
            b.setBorder(buttonBorder);
            String code = (String)reactionCodes.elementAt(i4);
            String normalName = "icons/" + code + ".png";
            try {
                Toolkit tk = Toolkit.getDefaultToolkit();
                ImageIcon image = new ImageIcon(tk.getImage(this.getClass().getResource(normalName)));
                b.setIcon(image);
            }
            catch (Exception e) {
                System.out.println("cannnot load icon: " + code);
            }
            b.setText(reactionLabel[i4]);
            b.addActionListener(this);
            this.reactionPanel.add(b);
            this.bgroup.add(b);
            this.buttons.addElement(b);
            this.symbols.add(EditComponentsDialog2.getSymbolByCode(code));
            ++i4;
        }
        GLinkedLine.setDefaultConnectPolicy(policy);
        contentPane.add(this.mixedNotationPanel);
        this.mixedNotationPanel.setRequestFocusEnabled(false);
        this.mixedNotationPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Reduced Notation"));
        this.mixedNotationPanel.setLayout(new GridLayout(gridLayoutRows, gridLayoutCols, gridLayoutHgap, gridLayoutVgap));
        Vector mixedNotationCodes = SBFactory.getMixedNotationCodes();
        int i5 = 0;
        while (i5 < mixedNotationLabel.length) {
            block21: {
                JToggleButton b = new JToggleButton();
                b.setIconTextGap(10);
                b.setHorizontalAlignment(2);
                b.setRolloverEnabled(true);
                b.setBorder(buttonBorder);
                String code = (String)mixedNotationCodes.elementAt(i5);
                String normalName = "icons/" + code + ".png";
                try {
                    Toolkit tk = Toolkit.getDefaultToolkit();
                    ImageIcon image = new ImageIcon(tk.getImage(this.getClass().getResource(normalName)));
                    b.setIcon(image);
                }
                catch (Exception e) {
                    System.out.println("cannnot load icon: " + code);
                }
                b.setText(mixedNotationLabel[i5]);
                b.addActionListener(this);
                this.mixedNotationPanel.add(b);
                this.bgroup.add(b);
                this.buttons.addElement(b);
                int iPolicyBak = GLinkedLine.getDefaultConnectPolicy();
                GLinkedLine.setDefaultConnectPolicy(0);
                int iPntsNumBak = GLinkedLine.getDefaultCreasePointNumber();
                GLinkedLine.setDefaultCreasePointNumber(0);
                try {
                    try {
                        this.symbols.add(SBFactory.createSymbol(code));
                    }
                    catch (Exception exception) {
                        GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                        GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                    GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                    throw throwable;
                }
                GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
            }
            ++i5;
        }
        contentPane.add(this.closeButtonPanel);
        this.closeButtonPanel.setRequestFocusEnabled(false);
        this.closeButtonPanel.setBorder(BorderFactory.createEmptyBorder());
        if (this.buttonAction != null) {
            this.applyAllButton = new JButton(this.buttonAction);
            this.closeButtonPanel.add(this.applyAllButton);
        }
        this.jClose.setText("Close");
        this.jClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditComponentsDialog2.this.closeButton_actionPerformed(e);
            }
        });
        this.closeButtonPanel.add(this.jClose);
        SpringUtilities.makeCompactGrid(contentPane, 6, 1, 5, 5, 4, 4);
    }

    public static SBSymbol getSymbolByCode(String code) {
        SBSymbol symbol = SBFactory.createSymbol(code);
        if (symbol instanceof GLinkConnectSchemeOwner) {
            int policy = 0;
            ((GLinkConnectSchemeOwner)((Object)symbol)).setConnectPolicy(policy);
        }
        if (symbol instanceof GLinkedLineComplex3) {
            ((GLinkedLineComplex3)((Object)symbol)).resetCreaseLineNumber(1, 1, 1);
        } else if (symbol instanceof GLinkedCreaseLine) {
            ((GLinkedCreaseLine)((Object)symbol)).resetCreaseLineNumber(1);
        }
        return symbol;
    }

    public void setPaletteDlg(SBSymbolPaletteDialog dlg, SBSymbolPaletteDialog dlg2) {
        this.paletteDlg = dlg;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i = 0;
        while (i < this.buttons.size()) {
            JToggleButton b = (JToggleButton)this.buttons.elementAt(i);
            if (b == e.getSource()) {
                this.paletteDlg.setPanel(this.symbols.elementAt(i));
                break;
            }
            ++i;
        }
        this.paletteDlg.show();
    }

    void closeButton_actionPerformed(ActionEvent e) {
        this.paletteDlg.dispose();
        this.dispose();
    }
}

