/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sbi.celldesigner.SBModel;

public class CreateCompartmentDialog
extends JDialog {
    private SBModel sbmodel = null;
    private JPanel dialogPanel;
    private JPanel buttonPanel;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField txtCompartmentName = new JTextField();
    private JTextField txtSize = new JTextField();
    private int dialogWidth = 300;
    private int dialogHeight = 150;
    private String compartmentName = null;
    private double compartmentSize = 1.0;
    private boolean bIsCompartmentHasInitSize = false;

    @Override
    public void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.doCancel();
            return;
        }
        super.processWindowEvent(e);
    }

    public CreateCompartmentDialog(Frame frame, SBModel sbmodel, String name) {
        super(frame);
        this.init(sbmodel, name);
    }

    public String getCompartmentName() {
        return this.compartmentName;
    }

    public double getCompartmentSize() {
        return this.compartmentSize;
    }

    private void init(SBModel sbmodel, String name) {
        this.setModal(true);
        this.setTitle("Property of compartment");
        this.setLocation(350, 300);
        this.setResizable(false);
        this.setContentPane(this.getDialogPanel());
        this.setSize(this.dialogWidth, this.dialogHeight);
        this.sbmodel = sbmodel;
        this.txtCompartmentName.setText(name);
        this.txtSize.setText(String.valueOf(1.0));
        this.bIsCompartmentHasInitSize = false;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                CreateCompartmentDialog.this.buttonOK.requestFocusInWindow();
            }
        });
    }

    private JPanel getDialogPanel() {
        int x = 15;
        int y = 15;
        int height = 20;
        int labelW = 40;
        int textW = 200;
        int space = 15;
        if (this.dialogPanel == null) {
            this.dialogPanel = new JPanel();
            this.dialogPanel.setLayout(null);
            JLabel nameLabel = new JLabel("Name");
            nameLabel.setBounds(new Rectangle(x, y, labelW, height));
            this.dialogPanel.add(nameLabel);
            this.txtCompartmentName.setBounds(new Rectangle(x + labelW + space, y, textW, height));
            this.dialogPanel.add(this.txtCompartmentName);
            JLabel sizeLabel = new JLabel("Size");
            sizeLabel.setBounds(new Rectangle(x, y + height + 5, labelW, height));
            this.dialogPanel.add(sizeLabel);
            this.txtSize.setBounds(new Rectangle(x + labelW + space, sizeLabel.getY(), textW, height));
            this.dialogPanel.add(this.txtSize);
            this.dialogWidth = this.txtSize.getX() + this.txtSize.getWidth() + 20;
            this.dialogPanel.add((Component)this.getButtonPanel(), "South");
        }
        return this.dialogPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setVgap(15);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.setBounds(new Rectangle(0, this.txtSize.getY() + this.txtSize.getHeight(), this.dialogWidth, 50));
            this.buttonOK = new JButton("OK");
            this.buttonOK.setPreferredSize(new Dimension(80, 22));
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CreateCompartmentDialog.this.doOK();
                }
            });
            this.buttonCancel = new JButton("Cancel");
            this.buttonCancel.setPreferredSize(new Dimension(120, 22));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CreateCompartmentDialog.this.doCancel();
                }
            });
            this.buttonPanel.add(this.buttonOK);
            this.buttonPanel.add(this.buttonCancel);
            this.dialogHeight = this.buttonPanel.getY() + this.buttonPanel.getPreferredSize().height + 30;
        }
        return this.buttonPanel;
    }

    private void doOK() {
        this.bIsCompartmentHasInitSize = false;
        this.compartmentName = this.txtCompartmentName.getText().trim();
        if (this.compartmentName.toLowerCase().equals("default")) {
            String msg = "The 'Name' [" + this.txtCompartmentName.getText() + "] has been reserved by system.\nPlease try another.";
            JOptionPane.showMessageDialog(this, msg, "Error", 0);
            return;
        }
        if (this.compartmentName.equals("")) {
            String msg = "Please input 'Name' of Compartment.";
            JOptionPane.showMessageDialog(this, msg, "Error", 0);
            return;
        }
        if (this.sbmodel.isSameCompartmentNameExists(this.compartmentName)) {
            try {
                this.compartmentSize = this.sbmodel.getCompartmentSize(this.compartmentName);
            }
            catch (Exception ex) {
                this.compartmentSize = 1.0;
            }
            this.setVisible(false);
            return;
        }
        String sizeString = this.txtSize.getText().trim();
        if (sizeString.equals("")) {
            this.compartmentSize = 1.0;
        } else {
            try {
                this.compartmentSize = Double.parseDouble(sizeString);
            }
            catch (NumberFormatException ex) {
                String msg = "Please input 'Size' with a number.";
                JOptionPane.showMessageDialog(this, msg, "Error", 0);
                return;
            }
        }
        this.bIsCompartmentHasInitSize = true;
        this.setVisible(false);
    }

    private void doCancel() {
        this.bIsCompartmentHasInitSize = false;
        this.compartmentName = null;
        this.setVisible(false);
    }

    public boolean IsCompartmentHasInitSize() {
        return this.bIsCompartmentHasInitSize;
    }
}

