/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import jp.fric.graphics.draw.GCreasePoint;
import jp.fric.graphics.draw.GEditable;
import jp.fric.graphics.draw.GLinkConnectSchemeOwner;
import jp.fric.graphics.draw.GLinkedCreaseLine;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GStructure;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.ReactionLinkPopupMenu;

public class CreasePoint
extends GCreasePoint {
    @Override
    public boolean popupAvailable() {
        return true;
    }

    @Override
    public void showPopup(MouseEvent e, double x, double y, GStructure structure) {
        ReactionLinkPopupMenu popup = ReactionLinkPopupMenu.getInstance();
        Action addanchor = popup.getAction(ReactionLinkPopupMenu.AddAnchorPointAction.class);
        addanchor.setEnabled(false);
        Action removeanchor = popup.getAction(ReactionLinkPopupMenu.RemoveAnchorPointAction.class);
        if (this.isRemovable()) {
            ((ReactionLinkPopupMenu.RemoveAnchorPointAction)removeanchor).setUp(this, structure);
            removeanchor.setEnabled(true);
        } else {
            removeanchor.setEnabled(false);
        }
        if (this.isBaseLink()) {
            popup.resetResourceofDescriptionOfReactionDialog(true);
        } else {
            popup.resetResourceofDescriptionOfReactionDialog(false);
        }
        String text = this.isSquarePolicy() ? "To Polyline" : "To Orthogonal";
        popup.setItemText(MainWindow.ChangeReactionConnectionPolicyAction.class, text);
        Action connectionPolicy = popup.getAction(MainWindow.ChangeReactionConnectionPolicyAction.class);
        connectionPolicy.setEnabled(true);
        if (text.equals("To Polyline")) {
            removeanchor.setEnabled(false);
        } else {
            popup.getAction(MainWindow.ReformReactionAction.class).setEnabled(false);
            GEditable shape = this.getOwner();
            if (shape instanceof GLinkedShape && ((GLinkedShape)((Object)shape)).getLineType() == 0) {
                connectionPolicy.setEnabled(false);
            }
        }
        try {
            if (MainWindow.getLastInstance().getCurrentModel().getUIType() == 2) {
                popup.resetActionStatas(MainWindow.getLastInstance().getCurrentModel().getUIType());
            }
        }
        catch (Exception ex) {
            return;
        }
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    private class ChangeColorShapeActionListener
    implements ActionListener {
        private ChangeColorShapeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow mw = MainWindow.getLastInstance();
            mw.getCurrentModel().showChangeShapeDialog(false);
        }
    }

    private class ReformActionListener
    implements ActionListener {
        private GStructure structure;

        ReformActionListener(GStructure st) {
            this.structure = st;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GEditable editable = CreasePoint.this.getOwner();
            if (editable instanceof GLinkConnectSchemeOwner) {
                ReactionLink glink = (ReactionLink)((GLinkConnectSchemeOwner)((Object)editable)).getReactionLink(this.structure);
                glink.reformSquareLines(this.structure);
            }
        }
    }

    private class RemoveActionListener
    implements ActionListener {
        private GStructure structure;

        RemoveActionListener(GStructure st) {
            this.structure = st;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GEditable editable = CreasePoint.this.getOwner();
            if (editable instanceof GLinkedCreaseLine) {
                ((GLinkedCreaseLine)editable).removeCreasePoint(CreasePoint.this, this.structure);
            }
        }
    }

    private class TogglePolicyActionListener
    implements ActionListener {
        private GStructure structure;

        TogglePolicyActionListener(GStructure st) {
            this.structure = st;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GEditable editable = CreasePoint.this.getOwner();
            if (editable instanceof GLinkConnectSchemeOwner) {
                ReactionLink glink = (ReactionLink)((GLinkConnectSchemeOwner)((Object)editable)).getReactionLink(this.structure);
                glink.toggleConnectPolicy(this.structure);
            }
        }
    }
}

