/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GPaintOrder;
import jp.fric.graphics.draw.GUtil;
import jp.fric.graphics.draw.PaintScheme;
import jp.fric.graphics.draw.ShapeUtil;
import jp.sbi.celldesigner.ComplexSpeciesProperty;
import jp.sbi.celldesigner.ElementSpeciesAlias;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesProperty;
import jp.sbi.celldesigner.SpeciesShape;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.sbmlExtension.SameIDAutoTag;
import jp.sbi.celldesigner.symbol.species.IonChannel;
import jp.sbi.celldesigner.symbol.species.SpeciesSymbolImpl;

public class ComplexSpeciesShape
implements GFramedShape,
SpeciesShape {
    ComplexSpeciesProperty property = null;
    private boolean isActive = false;
    protected int showLinkAnchorMode = 0;
    protected GLinkPositionInfo linkPositionInfo = null;
    private Color color = new Color(0, 0, 0);
    private Vector innerPositions = new Vector();
    private Rectangle2D.Double frameBounds = null;
    private Rectangle2D.Double repaintBounds = null;
    private static MonoSpeciesShape selectedMonoSpecies = null;
    private SameIDAutoTag autotag = new SameIDAutoTag();

    public ComplexSpeciesShape() {
        ComplexSpeciesProperty property = new ComplexSpeciesProperty();
        this.setProperty(property);
    }

    public Rectangle2D.Double add(SpeciesAlias alias) {
        this.property.addSpeciesAlias(alias);
        this.innerPositions.add(new Point2D.Double());
        return this.updatePositions();
    }

    private synchronized Rectangle2D.Double updatePositions() {
        MonoSpeciesShape mono;
        this.frameBounds = null;
        Vector monoSpeciesShapes = this.getMonoSpeciesShapes();
        int i = 0;
        while (i < monoSpeciesShapes.size()) {
            mono = (MonoSpeciesShape)monoSpeciesShapes.elementAt(i);
            this.frameBounds = GUtil.union(this.frameBounds, mono.getFrameBounds());
            ++i;
        }
        if (this.frameBounds != null) {
            i = 0;
            while (i < monoSpeciesShapes.size()) {
                mono = (MonoSpeciesShape)monoSpeciesShapes.elementAt(i);
                Point2D.Double innerPosition = (Point2D.Double)this.innerPositions.elementAt(i);
                Rectangle2D.Double bounds = mono.getFrameBounds();
                innerPosition.x = bounds.x - this.frameBounds.x;
                innerPosition.y = bounds.y - this.frameBounds.y;
                ++i;
            }
        }
        return this.frameBounds;
    }

    private Vector getMonoSpeciesShapes() {
        Vector speciesAliases = this.property.getSpeciesAliases();
        Vector<GFramedShape> monoSpeciesShapes = new Vector<GFramedShape>();
        int i = 0;
        while (i < speciesAliases.size()) {
            SpeciesAlias alias = (SpeciesAlias)speciesAliases.elementAt(i);
            GFramedShape shape = alias.getGFramedShape();
            monoSpeciesShapes.add(shape);
            ++i;
        }
        return monoSpeciesShapes;
    }

    private void reOrderShapes(GFramedShape shape, int flg) {
        Vector speciesAliases = this.property.getSpeciesAliases();
        int i = 0;
        while (i < speciesAliases.size()) {
            SpeciesAlias alias = (SpeciesAlias)speciesAliases.elementAt(i);
            GFramedShape wshape = alias.getGFramedShape();
            if (flg == 2) {
                if (shape == wshape) {
                    if (i == 0) break;
                    speciesAliases.insertElementAt(speciesAliases.elementAt(i), 0);
                    speciesAliases.remove(i + 1);
                    GPaintOrder.setOrderMode(0);
                    break;
                }
            } else if (flg == 1 && shape == wshape) {
                if (i == speciesAliases.size() - 1) break;
                speciesAliases.add(speciesAliases.elementAt(i));
                speciesAliases.remove(i);
                GPaintOrder.setOrderMode(0);
                break;
            }
            ++i;
        }
    }

    @Override
    public Rectangle2D.Double setProperty(SpeciesProperty property) {
        if (property instanceof ComplexSpeciesProperty) {
            this.property = (ComplexSpeciesProperty)property;
            return this.frameBounds;
        }
        return null;
    }

    @Override
    public SpeciesProperty getProperty() {
        return this.property;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public SpeciesShape duplicate() {
        ComplexSpeciesShape complex2 = new ComplexSpeciesShape();
        ComplexSpeciesProperty property2 = new ComplexSpeciesProperty();
        complex2.setProperty(property2);
        Vector speciesAliases = this.property.getSpeciesAliases();
        int i = 0;
        while (i < speciesAliases.size()) {
            SpeciesAlias alias1 = (SpeciesAlias)speciesAliases.elementAt(i);
            SpeciesAlias alias2 = alias1.duplicate();
            complex2.add(alias2);
            ++i;
        }
        complex2.getSameIDAutoTag().setAngle(this.autotag.getAngle());
        return complex2;
    }

    @Override
    public Rectangle2D.Double getRepaintBounds() {
        return this.repaintBounds;
    }

    @Override
    public Rectangle2D.Double getFrameBounds() {
        return this.frameBounds;
    }

    @Override
    public void resetShape() {
        Vector monoSpeciesShapes = this.getMonoSpeciesShapes();
        int i = 0;
        while (i < monoSpeciesShapes.size()) {
            MonoSpeciesShape mono = (MonoSpeciesShape)monoSpeciesShapes.elementAt(i);
            mono.resetShape();
            ++i;
        }
    }

    @Override
    public Point2D.Double[] getEdgePoints() {
        Vector monoSpeciesShapes = this.getMonoSpeciesShapes();
        int pointsSize = 0;
        int i = 0;
        while (i < monoSpeciesShapes.size()) {
            MonoSpeciesShape mono = (MonoSpeciesShape)monoSpeciesShapes.elementAt(i);
            SpeciesSymbol symbol = mono.getSpeciesSymbol();
            pointsSize += symbol.pointsSize();
            ++i;
        }
        Point2D.Double[] points = new Point2D.Double[pointsSize];
        int k = 0;
        int i2 = 0;
        while (i2 < monoSpeciesShapes.size()) {
            MonoSpeciesShape mono = (MonoSpeciesShape)monoSpeciesShapes.elementAt(i2);
            SpeciesSymbol symbol = mono.getSpeciesSymbol();
            Point2D.Double[] p = symbol.getEdgePoints();
            int s = 0;
            while (s < p.length) {
                points[k] = p[s];
                ++k;
                ++s;
            }
            ++i2;
        }
        return points;
    }

    @Override
    public boolean inShape(double x, double y) {
        if (this.property == null) {
            return false;
        }
        Vector monoSpeciesShapes = this.getMonoSpeciesShapes();
        int i = 0;
        while (i < monoSpeciesShapes.size()) {
            MonoSpeciesShape mono = (MonoSpeciesShape)monoSpeciesShapes.elementAt(i);
            boolean inMono = false;
            if (mono.inShape(x, y)) {
                inMono = true;
                if (GPaintOrder.isMousePressed() && GPaintOrder.checkOrderMode() == 1) {
                    selectedMonoSpecies = mono;
                }
            } else if (this.isActive) {
                boolean originalActive = mono.isActive();
                mono.setActive(true);
                if (mono.inShape(x, y)) {
                    inMono = true;
                    if (GPaintOrder.isMousePressed() && GPaintOrder.checkOrderMode() == 1) {
                        selectedMonoSpecies = mono;
                    }
                }
                mono.setActive(originalActive);
            }
            if (inMono) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Rectangle2D.Double updateShape(double x, double y, double w, double h) {
        if (this.property == null || w == 0.0 || h == 0.0) {
            return null;
        }
        Vector monoSpeciesShapes = this.getMonoSpeciesShapes();
        if (this.frameBounds == null) {
            this.frameBounds = new Rectangle2D.Double(x, y, w, h);
        }
        double pre_x = this.frameBounds.x;
        double pre_y = this.frameBounds.y;
        double pre_w = this.frameBounds.width;
        double pre_h = this.frameBounds.height;
        this.frameBounds.x = x;
        this.frameBounds.y = y;
        this.frameBounds.width = w;
        this.frameBounds.height = h;
        double scale_x = w / pre_w;
        double scale_y = h / pre_h;
        this.repaintBounds = null;
        int i = 0;
        while (i < monoSpeciesShapes.size()) {
            MonoSpeciesShape mono = (MonoSpeciesShape)monoSpeciesShapes.elementAt(i);
            Rectangle2D.Double monoFrameBounds = mono.getFrameBounds();
            Point2D.Double innerPosition = (Point2D.Double)this.innerPositions.elementAt(i);
            innerPosition.x *= scale_x;
            innerPosition.y *= scale_y;
            double ax = x + innerPosition.x;
            double ay = y + innerPosition.y;
            double aw = monoFrameBounds.width * scale_x;
            double ah = monoFrameBounds.height * scale_y;
            Rectangle2D.Double monoRepaintBounds = mono.updateShape(ax, ay, aw, ah);
            this.repaintBounds = GUtil.union(this.repaintBounds, monoRepaintBounds);
            if (this.isActive) {
                Rectangle2D.Double monoActiveBounds = mono.getActiveShapeBounds();
                this.repaintBounds = GUtil.union(this.repaintBounds, monoActiveBounds);
            }
            ++i;
        }
        return (Rectangle2D.Double)this.repaintBounds.clone();
    }

    protected Point2D.Double[] setupLinkAnchorCoord() {
        return SpeciesSymbolImpl.setupLinkAnchorCoordStatic(this.frameBounds);
    }

    private void drawLinkAnchors(Graphics2D g2, boolean drawOnlyActive) {
        GLinkPositionInfo lpi1;
        Point2D.Double[] array = this.setupLinkAnchorCoord();
        GLinkPositionInfo gLinkPositionInfo = lpi1 = this.linkPositionInfo != null ? this.linkPositionInfo.getChildInfo() : null;
        if (lpi1 == null) {
            SpeciesSymbolImpl.drawLinkAnchorsStatic(g2, this.linkPositionInfo, array, drawOnlyActive);
            return;
        }
        if (lpi1.hasActive()) {
            SpeciesSymbolImpl.drawLinkAnchorsStatic(g2, this.linkPositionInfo, array, drawOnlyActive);
        }
        String name = lpi1.getName();
        ComplexSpeciesProperty complexProperty = (ComplexSpeciesProperty)this.getProperty();
        Vector aliases = complexProperty.getSpeciesAliases();
        int i = 0;
        while (i < aliases.size()) {
            ElementSpeciesAlias a = (ElementSpeciesAlias)aliases.elementAt(i);
            if (a.getInnerId().equals(name)) {
                GFramedShape s1 = a.getGFramedShape();
                if (!(s1 instanceof MonoSpeciesShape)) break;
                ((MonoSpeciesShape)s1).drawLinkAnchors(g2, lpi1, drawOnlyActive);
                break;
            }
            ++i;
        }
        if (!lpi1.hasActive()) {
            SpeciesSymbolImpl.drawLinkAnchorsStatic(g2, this.linkPositionInfo, array, drawOnlyActive);
        }
    }

    @Override
    public void drawShape(Graphics2D g2, int colorflg) {
        if (this.property == null) {
            return;
        }
        if (this.isActive) {
            Color originalColor = g2.getColor();
            Stroke originalStroke = g2.getStroke();
            RenderingHints originalHints = g2.getRenderingHints();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setStroke(STROKE_ACTIVE);
            this.drawActiveEdge(g2);
            g2.setStroke(originalStroke);
            g2.setRenderingHints(originalHints);
            g2.setColor(Color.white);
            this.fillActiveEdge(g2);
            g2.setColor(originalColor);
        }
        this.drawInner(g2, colorflg);
        if (this.showLinkAnchorMode != 0) {
            boolean drawOnlyActive = this.showLinkAnchorMode == 2;
            this.drawLinkAnchors(g2, drawOnlyActive);
        }
    }

    protected void drawActiveEdge(Graphics2D g2) {
        Vector monoSpeciesShapes = this.getMonoSpeciesShapes();
        int i = 0;
        while (i < monoSpeciesShapes.size()) {
            MonoSpeciesShape mono = (MonoSpeciesShape)monoSpeciesShapes.elementAt(i);
            mono.drawActiveEdge(g2);
            ++i;
        }
    }

    protected void fillActiveEdge(Graphics2D g2) {
        if (GPaintOrder.checkOrderMode() == 1) {
            this.reOrderShapes(selectedMonoSpecies, GPaintOrder.getOrderFlg());
        }
        Vector monoSpeciesShapes = this.getMonoSpeciesShapes();
        int i = 0;
        while (i < monoSpeciesShapes.size()) {
            MonoSpeciesShape mono = (MonoSpeciesShape)monoSpeciesShapes.elementAt(i);
            mono.fillActiveEdge(g2);
            ++i;
        }
    }

    protected void drawInner(Graphics2D g2, int colorflg) {
        MonoSpeciesShape mono;
        if (GPaintOrder.checkOrderMode() == 1) {
            this.reOrderShapes(selectedMonoSpecies, GPaintOrder.getOrderFlg());
        }
        Vector monoSpeciesShapes = this.getMonoSpeciesShapes();
        int i = 0;
        while (i < monoSpeciesShapes.size()) {
            block7: {
                block6: {
                    mono = (MonoSpeciesShape)monoSpeciesShapes.elementAt(i);
                    if (!mono.isActive()) break block6;
                    if (mono.getSpeciesSymbol() instanceof IonChannel) break block7;
                    Color originalColor = g2.getColor();
                    Stroke originalStroke = g2.getStroke();
                    RenderingHints originalHints = g2.getRenderingHints();
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setStroke(STROKE_ACTIVE);
                    mono.drawActiveEdge(g2);
                    g2.setStroke(originalStroke);
                    g2.setRenderingHints(originalHints);
                    g2.setColor(Color.white);
                    mono.fillActiveEdge(g2);
                    g2.setColor(originalColor);
                }
                mono.drawInner(g2, colorflg);
            }
            ++i;
        }
        i = 0;
        while (i < monoSpeciesShapes.size()) {
            mono = (MonoSpeciesShape)monoSpeciesShapes.elementAt(i);
            mono.drawInner(g2, colorflg);
            ++i;
        }
    }

    @Override
    public GFramedShape createCopy() {
        return (GFramedShape)((Object)this.duplicate());
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setPaintScheme(PaintScheme painter) {
    }

    @Override
    public void showLinkAnchors(GLinkPositionInfo lpi, boolean drawOnlyActive) {
        this.showLinkAnchorMode = drawOnlyActive ? 2 : 1;
        this.linkPositionInfo = (GLinkPositionInfo)lpi.clone();
    }

    @Override
    public void hideLinkAnchors() {
        this.showLinkAnchorMode = 0;
        this.linkPositionInfo = null;
    }

    @Override
    public GLinkPositionInfo getPointedLinkPosition(double x, double y) {
        if (!this.repaintBounds.contains(x, y)) {
            return null;
        }
        ComplexSpeciesProperty complexProperty = (ComplexSpeciesProperty)this.getProperty();
        Vector aliases = complexProperty.getSpeciesAliases();
        GLinkPositionInfo lpi = null;
        int i = 0;
        while (i < aliases.size()) {
            ElementSpeciesAlias a = (ElementSpeciesAlias)aliases.elementAt(i);
            GLinkPositionInfo lpi1 = a.getPointedLinkPosition(x, y);
            if (lpi1 != null && (lpi == null || lpi1.getDistanceSq() < lpi.getDistanceSq())) {
                lpi = lpi1;
                lpi.setName(a.getInnerId());
            }
            ++i;
        }
        Point2D.Double[] array = this.setupLinkAnchorCoord();
        GLinkPositionInfo lpi1 = ShapeUtil.getNearLinkAnchorPosition(array, x, y);
        if (lpi != null) {
            if (lpi1.getDistanceSq() < lpi.getDistanceSq()) {
                lpi.setPosition(16);
            } else {
                lpi1.setPosition(16);
            }
        }
        lpi1.setChildInfo(lpi);
        lpi = lpi1;
        return lpi;
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPosition(GLinkPositionInfo lpi) {
        GLinkPositionInfo lpi1;
        GLinkPositionInfo gLinkPositionInfo = lpi1 = lpi != null ? lpi.getChildInfo() : null;
        if (lpi1 == null || lpi1.getPosition() == 16) {
            int ii = lpi.getPosition();
            if (ii != 16) {
                int index = ShapeUtil.translateGLinkPositionToIndex(ii);
                return SpeciesSymbolImpl.getCoordinatesOfLinkPositionByInternalIndex(this.frameBounds, index);
            }
        } else {
            String name = lpi1.getName();
            ComplexSpeciesProperty complexProperty = (ComplexSpeciesProperty)this.getProperty();
            Vector aliases = complexProperty.getSpeciesAliases();
            int i = 0;
            while (i < aliases.size()) {
                GFramedShape s1;
                ElementSpeciesAlias a = (ElementSpeciesAlias)aliases.elementAt(i);
                if (a.getInnerId().equals(name) && (s1 = a.getGFramedShape()) instanceof MonoSpeciesShape) {
                    return ((MonoSpeciesShape)s1).getCoordinatesOfLinkPosition(lpi1);
                }
                ++i;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public double getLineWidth() {
        return 0.0;
    }

    public SameIDAutoTag getSameIDAutoTag() {
        return this.autotag;
    }
}

