/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.util.Vector;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesProperty;
import jp.sbi.celldesigner.SpeciesShape;
import jp.sbi.celldesigner.sbmlExtension.ModelAnnotation;
import org.sbml.libsbml.Species;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComplexSpeciesProperty
implements SpeciesProperty {
    private Vector speciesAliases = new Vector();
    private Vector readingEntries = null;

    public void setSpeciesAliases(Vector speciesAliases) {
        this.speciesAliases = speciesAliases;
    }

    public synchronized void addSpeciesAlias(SpeciesAlias alias) {
        String innerId = "inner" + this.speciesAliases.size();
        alias.setInnerId(innerId);
        this.speciesAliases.add(alias);
    }

    public Vector getSpeciesAliases() {
        return this.speciesAliases;
    }

    @Override
    public SpeciesProperty deepClone() {
        ComplexSpeciesProperty property2 = new ComplexSpeciesProperty();
        int i = 0;
        while (i < this.speciesAliases.size()) {
            SpeciesAlias alias1 = (SpeciesAlias)this.speciesAliases.elementAt(i);
            SpeciesAlias alias2 = alias1.duplicate();
            property2.addSpeciesAlias(alias2);
            ++i;
        }
        return property2;
    }

    @Override
    public boolean equals(SpeciesProperty property) {
        if (!(property instanceof ComplexSpeciesProperty)) {
            return false;
        }
        ComplexSpeciesProperty target = (ComplexSpeciesProperty)property;
        Vector targetSpeciesAliases = target.getSpeciesAliases();
        if (targetSpeciesAliases.size() != this.speciesAliases.size()) {
            return false;
        }
        int i = 0;
        while (i < this.speciesAliases.size()) {
            SpeciesProperty m2;
            SpeciesAlias a1 = (SpeciesAlias)targetSpeciesAliases.elementAt(i);
            SpeciesAlias a2 = (SpeciesAlias)this.speciesAliases.elementAt(i);
            SpeciesProperty m1 = ((SpeciesShape)((Object)a1.getGFramedShape())).getProperty();
            if (!m1.equals(m2 = ((SpeciesShape)((Object)a2.getGFramedShape())).getProperty())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void readDOMTree(Element element) {
        if (element == null) {
            return;
        }
        NodeList childlist = element.getChildNodes();
        int childsize = childlist.getLength();
        int i = 0;
        while (i < childsize) {
            Node node = childlist.item(i);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && node.getLocalName().equals("listOfHeterodimerEntries")) {
                this.readingEntries = new Vector();
                NodeList grandchild = node.getChildNodes();
                int grandchildsize = grandchild.getLength();
                int j = 0;
                while (j < grandchildsize) {
                    Element elem;
                    Node gn = grandchild.item(j);
                    if (gn.getNodeType() == 1 && gn.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && (elem = (Element)gn).getLocalName().equals("heterodimerEntry")) {
                        String innerId = elem.getAttributeNS(null, "innerId");
                        String originalSpecies = elem.getAttributeNS(null, "originalSpecies");
                        MonoSpeciesProperty property = new MonoSpeciesProperty();
                        property.readDOMTree(elem);
                        this.readingEntries.add(new Object[]{innerId, originalSpecies, property});
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
    }

    public void clearReadingEntries() {
        this.readingEntries = null;
    }

    public Vector getReadingEntries() {
        return this.readingEntries;
    }

    public void dump() {
        int i = 0;
        while (i < this.speciesAliases.size()) {
            SpeciesAlias speciesAlias = (SpeciesAlias)this.speciesAliases.elementAt(i);
            ++i;
        }
    }

    @Override
    public void writeDOMTree(Node node) {
        Document doc = node.getOwnerDocument();
        String URI2 = node.getNamespaceURI();
        String ns = ModelAnnotation.getOutputNamespace();
        Element listelem = doc.createElementNS(URI2, String.valueOf(ns) + ":listOfHeterodimerEntries");
        node.appendChild(listelem);
        int i = 0;
        while (i < this.speciesAliases.size()) {
            SpeciesAlias alias = (SpeciesAlias)this.speciesAliases.elementAt(i);
            Species species = alias.getOriginalSpecies();
            if (species != null) {
                String innerId = alias.getInnerId();
                String speciesId = species.getId();
                Element elem = doc.createElementNS(URI2, String.valueOf(ns) + ":heterodimerEntry");
                listelem.appendChild(elem);
                elem.setAttributeNS(null, "innerId", innerId);
                elem.setAttributeNS(null, "originalSpecies", speciesId);
                SpeciesProperty property = ((SpeciesShape)((Object)alias.getGFramedShape())).getProperty();
                property.writeDOMTree(elem);
            }
            ++i;
        }
    }

    public void updateAnnotation(StringBuffer buf) {
        buf.append("<celldesigner:heterodimerIdentity>\n");
        buf.append("<celldesigner:listOfHeterodimerEntries>\n");
        int k = 0;
        while (k < this.getSpeciesAliases().size()) {
            SpeciesAlias alias = (SpeciesAlias)this.getSpeciesAliases().elementAt(k);
            Species sp = alias.getOriginalSpecies();
            if (sp != null) {
                String innerId = alias.getInnerId();
                String speciesId = sp.getId();
                buf.append("<celldesigner:heterodimerEntry innerId=\"" + innerId + "\" originalSpecies=\"" + speciesId + "\"/>\n");
                SpeciesProperty spProperty = ((SpeciesShape)((Object)alias.getGFramedShape())).getProperty();
                if (spProperty instanceof MonoSpeciesProperty) {
                    MonoSpeciesProperty monoProperty = (MonoSpeciesProperty)spProperty;
                    monoProperty.updateAnnotation(buf);
                } else {
                    ComplexSpeciesProperty comProperty = (ComplexSpeciesProperty)spProperty;
                    comProperty.updateAnnotation(buf);
                }
            }
            ++k;
        }
        buf.append("</celldesigner:listOfHeterodimerEntries>\n");
        buf.append("</celldesigner:heterodimerIdentity>\n");
    }

    @Override
    public String createSpeciesName() {
        String name = "Complex(";
        int i = 0;
        while (i < this.speciesAliases.size()) {
            SpeciesAlias alias = (SpeciesAlias)this.speciesAliases.elementAt(i);
            SpeciesProperty property = ((SpeciesShape)((Object)alias.getGFramedShape())).getProperty();
            name = String.valueOf(name) + property.createSpeciesName();
            name = i + 1 < this.speciesAliases.size() ? String.valueOf(name) + "/" : String.valueOf(name) + ")";
            ++i;
        }
        return name;
    }
}

