/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.fric.graphics.draw.GAtom;
import jp.fric.graphics.draw.GAtomImpl;
import jp.fric.graphics.draw.GContainableAtom;
import jp.fric.graphics.draw.GContainer;
import jp.fric.graphics.draw.GContainerTarget;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;
import jp.fric.graphics.draw.PaintSchemeFactory;
import jp.fric.util.Debug;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.ComplexSpeciesProperty;
import jp.sbi.celldesigner.ComplexSpeciesShape;
import jp.sbi.celldesigner.InformationBox;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.PopupSpeciesNameFontDialog;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesAliasPopupMenu;
import jp.sbi.celldesigner.SpeciesProperty;
import jp.sbi.celldesigner.SpeciesShape;
import jp.sbi.celldesigner.SpeciesShapePainting;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.layer.symbol.species.LayerMonoSpeciesShape;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesAlias;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNA;
import jp.sbi.celldesigner.sbmlExtension.Gene;
import jp.sbi.celldesigner.sbmlExtension.ModelAnnotation;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import jp.sbi.celldesigner.sbmlExtension.RNA;
import jp.sbi.celldesigner.sbmlExtension.SBaseReferrerObserver;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComplexSpeciesAlias
extends GContainableAtom
implements SpeciesAlias {
    private int prevSpeciesIndex = -1;
    private Species originalSpecies = null;
    private Species historicalSpecies = null;
    private boolean isActive = false;
    private String innerId = "";
    private Vector observers = null;
    private int backupViewStateForParentBrief = -1;
    private Point2D.Double backupSize = new Point2D.Double(0.0, 0.0);
    public static final String BACKUPSIZE = "backupSize";
    public static final String BACKUPVIEW = "backupView";
    public static final String BACKUPINNERPOSITION = "innerPosition";
    private Vector backupChildrenInfo = new Vector();
    private Vector listOfLayerText = new Vector();
    private String strTempNotesStr = null;

    @Override
    public Point2D.Double getDefaultSize() {
        SpeciesSymbol symbol;
        GFramedShape shape = super.getGFramedShape();
        if (shape instanceof MonoSpeciesShape && (symbol = ((MonoSpeciesShape)shape).getSpeciesSymbol()) != null) {
            String code = ((SBSymbol)((Object)symbol)).getCode();
            Dimension d = (Dimension)Preference.defaultSpeciesSize.get(code);
            if (d == null) {
                d = symbol.defaultSize();
            }
            return new Point2D.Double(d.width, d.height);
        }
        return new Point2D.Double();
    }

    @Override
    public void setPrevSpeciesIndex(int index) {
        this.prevSpeciesIndex = index;
    }

    @Override
    public int getPrevSpeciesIndex() {
        return this.prevSpeciesIndex;
    }

    @Override
    public void setOriginalSpecies(Species species) {
        this.setReferringSBase((SBase)species);
    }

    @Override
    public Species getOriginalSpecies() {
        return (Species)this.getReferringSBase();
    }

    @Override
    public void setHistoricalSpecies(Species species) {
        this.historicalSpecies = species;
    }

    @Override
    public Species getHistoricalSpecies() {
        return this.historicalSpecies;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
        ((SpeciesShape)((Object)super.getGFramedShape())).setActive(isActive);
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setInnerId(String innerId) {
        this.innerId = innerId;
    }

    @Override
    public String getInnerId() {
        return this.innerId;
    }

    @Override
    public SpeciesAlias duplicate() {
        SpeciesShape shape = (SpeciesShape)((Object)super.getGFramedShape());
        SpeciesShape shape2 = shape.duplicate();
        ComplexSpeciesAlias alias2 = new ComplexSpeciesAlias();
        alias2.setGFramedShape((GFramedShape)((Object)shape2));
        Species copy = this.originalSpecies.cloneObject();
        alias2.setOriginalSpecies(copy);
        alias2.setInnerId(this.innerId);
        alias2.setActive(this.isActive);
        alias2.setPrevSpeciesIndex(this.prevSpeciesIndex);
        Rectangle2D.Double bounds = shape.getFrameBounds();
        if (bounds != null) {
            alias2.setFramePosition(bounds.x, bounds.y);
            alias2.setFrameSize(bounds.width, bounds.height);
            alias2.update();
        }
        return alias2;
    }

    @Override
    public GElement createCopy() {
        ComplexSpeciesAlias alias = (ComplexSpeciesAlias)super.createCopy();
        alias.backupChildrenInfo = (Vector)this.backupChildrenInfo.clone();
        alias.backupSize = new Point2D.Double(this.backupSize.x, this.backupSize.y);
        alias.backupViewStateForParentBrief = this.backupViewStateForParentBrief;
        Species copy = this.originalSpecies.cloneObject();
        alias.setOriginalSpecies(copy);
        GFramedShape shape = alias.getGFramedShape();
        if (shape instanceof ComplexSpeciesShape) {
            ComplexSpeciesProperty complexProperty = (ComplexSpeciesProperty)((SpeciesShape)((Object)shape)).getProperty();
            Vector speciesAliases = complexProperty.getSpeciesAliases();
            int i = 0;
            while (i < speciesAliases.size()) {
                ComplexSpeciesAlias a = (ComplexSpeciesAlias)speciesAliases.elementAt(i);
                Species s = a.getOriginalSpecies();
                Species s_copy = s.cloneObject();
                a.setOriginalSpecies(s_copy);
                ++i;
            }
        }
        try {
            Vector proteins = alias.getInnerProteinRefs();
            int i = 0;
            while (i < proteins.size()) {
                Protein p = (Protein)proteins.elementAt(i);
                Protein p_copy = p.deepClone();
                alias.replaceInnerProteinRef(p, p_copy);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        alias.setActive(this.isActive);
        ((GAtomImpl)alias).changeView(new Integer(this.getCurrentView()));
        if (this.getInfoBox() != null) {
            alias.setInfoBox((InformationBox)this.getInfoBox().createCopy());
        } else {
            alias.setInfoBox(null);
        }
        LibSBMLUtil.updateInfoParent(alias);
        return alias;
    }

    @Override
    public Rectangle2D.Double getRepaintBounds() {
        Rectangle2D.Double r = super.getRepaintBounds();
        SpeciesShape shape = (SpeciesShape)((Object)super.getGFramedShape());
        if (shape == null) {
            return r;
        }
        if (this.infoBox == null) {
            return GUtil.union(r, shape.getRepaintBounds());
        }
        Rectangle2D.Double area = null;
        area = GUtil.union(r, shape.getRepaintBounds());
        area = GUtil.union(area, this.infoBox.getRepaintBounds());
        return area;
    }

    @Override
    public Rectangle2D.Double getBoundsAsTarget() {
        Rectangle2D.Double r = this.getBounds();
        SpeciesShape shape = (SpeciesShape)((Object)super.getGFramedShape());
        if (shape instanceof MonoSpeciesShape) {
            int linewidth = 2 + (int)((MonoSpeciesShape)shape).getLineWidth();
            r.x -= (double)(linewidth /= 2);
            r.y -= (double)linewidth;
            r.width += (double)(2 * linewidth);
            r.height += (double)(2 * linewidth);
        }
        return r;
    }

    @Override
    public boolean isMonoProtein() {
        if (this.originalSpecies == null) {
            if (Preference.isDebug) {
                System.out.println("DEBUG: Original species is null in " + this);
            }
            return false;
        }
        SpeciesAnnotation annotation = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)this.originalSpecies, null);
        SpeciesProperty property = annotation.getSpeciesProperty();
        if (property instanceof MonoSpeciesProperty) {
            return ((MonoSpeciesProperty)property).getType().equals("PROTEIN");
        }
        return false;
    }

    @Override
    public Vector getInnerProteinRefs() throws Exception {
        SpeciesShape shape = (SpeciesShape)((Object)super.getGFramedShape());
        Vector<Protein> rtn = new Vector<Protein>();
        if (shape instanceof MonoSpeciesShape) {
            MonoSpeciesProperty monoProperty = (MonoSpeciesProperty)shape.getProperty();
            if (monoProperty.getType().equals("PROTEIN")) {
                Protein p = monoProperty.getProtein();
                if (p == null) {
                    throw new Exception("addProteinReferer(), property.getProtein()==null at alias=" + this.getName());
                }
                rtn.add(p);
            }
        } else if (shape instanceof ComplexSpeciesShape) {
            ComplexSpeciesProperty complexProperty = (ComplexSpeciesProperty)shape.getProperty();
            Vector aliases = complexProperty.getSpeciesAliases();
            int i = 0;
            while (i < aliases.size()) {
                ComplexSpeciesAlias a = (ComplexSpeciesAlias)aliases.elementAt(i);
                MonoSpeciesProperty monoProperty = (MonoSpeciesProperty)((SpeciesShape)((Object)a.getGFramedShape())).getProperty();
                if (monoProperty.getType().equals("PROTEIN")) {
                    Protein p = monoProperty.getProtein();
                    if (p == null) {
                        throw new Exception("addProteinReferer(), property.getProtein()==null at alias=" + this.getName());
                    }
                    if (!rtn.contains(p)) {
                        rtn.add(p);
                    }
                }
                ++i;
            }
        }
        return rtn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void replaceInnerProteinRef(Protein prev, Protein protein) throws Exception {
        SpeciesShape shape = (SpeciesShape)((Object)super.getGFramedShape());
        if (shape instanceof MonoSpeciesShape) {
            MonoSpeciesProperty monoProperty = (MonoSpeciesProperty)shape.getProperty();
            if (monoProperty.getType().equals("PROTEIN")) {
                Protein p = monoProperty.getProtein();
                if (p == null) {
                    throw new Exception("replaceInnerProteinRef(), property.getProtein()==null at alias=" + this.getName());
                }
                if (p != prev) throw new Exception("replaceInnerProteinRef(), protein ref is different at alias=" + this.getName());
                monoProperty.setProtein(protein);
                monoProperty.resetModificationsSize();
            }
        } else if (shape instanceof ComplexSpeciesShape) {
            ComplexSpeciesProperty complexProperty = (ComplexSpeciesProperty)shape.getProperty();
            Vector aliases = complexProperty.getSpeciesAliases();
            int i = 0;
            while (i < aliases.size()) {
                ComplexSpeciesAlias a = (ComplexSpeciesAlias)aliases.elementAt(i);
                MonoSpeciesProperty monoProperty = (MonoSpeciesProperty)((SpeciesShape)((Object)a.getGFramedShape())).getProperty();
                if (monoProperty.getType().equals("PROTEIN")) {
                    Protein p = monoProperty.getProtein();
                    if (p == null) {
                        throw new Exception("replaceInnerProteinRef(), property.getProtein()==null at alias=" + this.getName());
                    }
                    if (p == prev) {
                        monoProperty.setProtein(protein);
                        monoProperty.resetModificationsSize();
                    }
                }
                ++i;
            }
        }
        shape.resetShape();
    }

    @Override
    public boolean isMonoGene() {
        if (this.originalSpecies == null) {
            if (Preference.isDebug) {
                System.out.println("DEBUG: Original species is null in " + this);
            }
            return false;
        }
        SpeciesAnnotation annotation = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)this.originalSpecies, null);
        SpeciesProperty property = annotation.getSpeciesProperty();
        if (property instanceof MonoSpeciesProperty) {
            return ((MonoSpeciesProperty)property).getType().equals("GENE");
        }
        return false;
    }

    @Override
    public Vector getInnerGeneRefs() throws Exception {
        SpeciesShape shape = (SpeciesShape)((Object)super.getGFramedShape());
        Vector<Gene> rtn = new Vector<Gene>();
        if (shape instanceof MonoSpeciesShape) {
            MonoSpeciesProperty monoProperty = (MonoSpeciesProperty)shape.getProperty();
            if (monoProperty.getType().equals("GENE")) {
                Gene g = monoProperty.getGene();
                if (g == null) {
                    throw new Exception("addGeneReferer(), property.getGene()==null at alias=" + this.getName());
                }
                rtn.add(g);
            }
        } else if (shape instanceof ComplexSpeciesShape) {
            ComplexSpeciesProperty complexProperty = (ComplexSpeciesProperty)shape.getProperty();
            Vector aliases = complexProperty.getSpeciesAliases();
            int i = 0;
            while (i < aliases.size()) {
                ComplexSpeciesAlias a = (ComplexSpeciesAlias)aliases.elementAt(i);
                MonoSpeciesProperty monoProperty = (MonoSpeciesProperty)((SpeciesShape)((Object)a.getGFramedShape())).getProperty();
                if (monoProperty.getType().equals("GENE")) {
                    Gene g = monoProperty.getGene();
                    if (g == null) {
                        throw new Exception("addGeneReferer(), property.getGene()==null at alias=" + this.getName());
                    }
                    if (!rtn.contains(g)) {
                        rtn.add(g);
                    }
                }
                ++i;
            }
        }
        return rtn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void replaceInnerGeneRef(Gene prev, Gene gene) throws Exception {
        SpeciesShape shape = (SpeciesShape)((Object)super.getGFramedShape());
        if (shape instanceof MonoSpeciesShape) {
            MonoSpeciesProperty monoProperty = (MonoSpeciesProperty)shape.getProperty();
            if (monoProperty.getType().equals("GENE")) {
                Gene g = monoProperty.getGene();
                if (g == null) {
                    throw new Exception("replaceInnerGeneRef(), property.getGene()==null at alias=" + this.getName());
                }
                if (g != prev) throw new Exception("replaceInnerGeneRef(), gene ref is different at alias=" + this.getName());
                monoProperty.setGene(gene);
                monoProperty.resetModificationsTranscriptionsSize();
            }
        } else if (shape instanceof ComplexSpeciesShape) {
            ComplexSpeciesProperty complexProperty = (ComplexSpeciesProperty)shape.getProperty();
            Vector aliases = complexProperty.getSpeciesAliases();
            int i = 0;
            while (i < aliases.size()) {
                ComplexSpeciesAlias a = (ComplexSpeciesAlias)aliases.elementAt(i);
                MonoSpeciesProperty monoProperty = (MonoSpeciesProperty)((SpeciesShape)((Object)a.getGFramedShape())).getProperty();
                if (monoProperty.getType().equals("GENE")) {
                    Gene g = monoProperty.getGene();
                    if (g == null) {
                        throw new Exception("replaceInnerGeneRef(), property.getGene()==null at alias=" + this.getName());
                    }
                    if (g == prev) {
                        monoProperty.setGene(gene);
                        monoProperty.resetModificationsTranscriptionsSize();
                    }
                }
                ++i;
            }
        }
        shape.resetShape();
    }

    @Override
    public boolean isMonoRNA() {
        if (this.originalSpecies == null) {
            if (Preference.isDebug) {
                System.out.println("DEBUG: Original species is null in " + this);
            }
            return false;
        }
        SpeciesAnnotation annotation = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)this.originalSpecies, null);
        SpeciesProperty property = annotation.getSpeciesProperty();
        if (property instanceof MonoSpeciesProperty) {
            return ((MonoSpeciesProperty)property).getType().equals("RNA");
        }
        return false;
    }

    @Override
    public Vector getInnerRNARefs() throws Exception {
        SpeciesShape shape = (SpeciesShape)((Object)super.getGFramedShape());
        Vector<RNA> rtn = new Vector<RNA>();
        if (shape instanceof MonoSpeciesShape) {
            MonoSpeciesProperty monoProperty = (MonoSpeciesProperty)shape.getProperty();
            if (monoProperty.getType().equals("RNA")) {
                RNA g = monoProperty.getRNA();
                if (g == null) {
                    throw new Exception("addRNAReferer(), property.getRNA()==null at alias=" + this.getName());
                }
                rtn.add(g);
            }
        } else if (shape instanceof ComplexSpeciesShape) {
            ComplexSpeciesProperty complexProperty = (ComplexSpeciesProperty)shape.getProperty();
            Vector aliases = complexProperty.getSpeciesAliases();
            int i = 0;
            while (i < aliases.size()) {
                ComplexSpeciesAlias a = (ComplexSpeciesAlias)aliases.elementAt(i);
                MonoSpeciesProperty monoProperty = (MonoSpeciesProperty)((SpeciesShape)((Object)a.getGFramedShape())).getProperty();
                if (monoProperty.getType().equals("RNA")) {
                    RNA g = monoProperty.getRNA();
                    if (g == null) {
                        throw new Exception("addGeneReferer(), property.getRNA()==null at alias=" + this.getName());
                    }
                    if (!rtn.contains(g)) {
                        rtn.add(g);
                    }
                }
                ++i;
            }
        }
        return rtn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void replaceInnerRNARef(RNA prev, RNA rna) throws Exception {
        SpeciesShape shape = (SpeciesShape)((Object)super.getGFramedShape());
        if (shape instanceof MonoSpeciesShape) {
            MonoSpeciesProperty monoProperty = (MonoSpeciesProperty)shape.getProperty();
            if (monoProperty.getType().equals("RNA")) {
                RNA g = monoProperty.getRNA();
                if (g == null) {
                    throw new Exception("replaceInnerRNARef(), property.getRNA()==null at alias=" + this.getName());
                }
                if (g != prev) throw new Exception("replaceInnerRNARef(), rna ref is different at alias=" + this.getName());
                monoProperty.setRNA(rna);
                monoProperty.resetModificationsTranscriptionsSize();
            }
        } else if (shape instanceof ComplexSpeciesShape) {
            ComplexSpeciesProperty complexProperty = (ComplexSpeciesProperty)shape.getProperty();
            Vector aliases = complexProperty.getSpeciesAliases();
            int i = 0;
            while (i < aliases.size()) {
                ComplexSpeciesAlias a = (ComplexSpeciesAlias)aliases.elementAt(i);
                MonoSpeciesProperty monoProperty = (MonoSpeciesProperty)((SpeciesShape)((Object)a.getGFramedShape())).getProperty();
                if (monoProperty.getType().equals("RNA")) {
                    RNA g = monoProperty.getRNA();
                    if (g == null) {
                        throw new Exception("replaceInnerRNARef(), property.getRNA()==null at alias=" + this.getName());
                    }
                    if (g == prev) {
                        monoProperty.setRNA(rna);
                        monoProperty.resetModificationsTranscriptionsSize();
                    }
                }
                ++i;
            }
        }
        shape.resetShape();
    }

    @Override
    public boolean isMonoAntiSenseRNA() {
        if (this.originalSpecies == null) {
            if (Preference.isDebug) {
                System.out.println("DEBUG: Original species is null in " + this);
            }
            return false;
        }
        SpeciesAnnotation annotation = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)this.originalSpecies, null);
        SpeciesProperty property = annotation.getSpeciesProperty();
        if (property instanceof MonoSpeciesProperty) {
            return ((MonoSpeciesProperty)property).getType().equals("ANTISENSE_RNA");
        }
        return false;
    }

    @Override
    public Vector getInnerAntiSenseRNARefs() throws Exception {
        SpeciesShape shape = (SpeciesShape)((Object)super.getGFramedShape());
        Vector<AntiSenseRNA> rtn = new Vector<AntiSenseRNA>();
        if (shape instanceof MonoSpeciesShape) {
            MonoSpeciesProperty monoProperty = (MonoSpeciesProperty)shape.getProperty();
            if (monoProperty.getType().equals("ANTISENSE_RNA")) {
                AntiSenseRNA g = monoProperty.getAntiSenseRNA();
                if (g == null) {
                    throw new Exception("addAntiSenseRNAReferer(), property.getAntiSenseRNA()==null at alias=" + this.getName());
                }
                rtn.add(g);
            }
        } else if (shape instanceof ComplexSpeciesShape) {
            ComplexSpeciesProperty complexProperty = (ComplexSpeciesProperty)shape.getProperty();
            Vector aliases = complexProperty.getSpeciesAliases();
            int i = 0;
            while (i < aliases.size()) {
                ComplexSpeciesAlias a = (ComplexSpeciesAlias)aliases.elementAt(i);
                MonoSpeciesProperty monoProperty = (MonoSpeciesProperty)((SpeciesShape)((Object)a.getGFramedShape())).getProperty();
                if (monoProperty.getType().equals("ANTISENSE_RNA")) {
                    AntiSenseRNA g = monoProperty.getAntiSenseRNA();
                    if (g == null) {
                        throw new Exception("addAntiSenseRNAReferer(), property.getAntiSenseRNA()==null at alias=" + this.getName());
                    }
                    if (!rtn.contains(g)) {
                        rtn.add(g);
                    }
                }
                ++i;
            }
        }
        return rtn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void replaceInnerAntiSenseRNARef(AntiSenseRNA prev, AntiSenseRNA asrna) throws Exception {
        SpeciesShape shape = (SpeciesShape)((Object)super.getGFramedShape());
        if (shape instanceof MonoSpeciesShape) {
            MonoSpeciesProperty monoProperty = (MonoSpeciesProperty)shape.getProperty();
            if (monoProperty.getType().equals("ANTISENSE_RNA")) {
                AntiSenseRNA g = monoProperty.getAntiSenseRNA();
                if (g == null) {
                    throw new Exception("replaceInnerAntiSenseRNARef(), property.getAntiSenseRNA()==null at alias=" + this.getName());
                }
                if (g != prev) throw new Exception("replaceInnerGeneRef(), antisenserna ref is different at alias=" + this.getName());
                monoProperty.setAntiSenseRNA(asrna);
                monoProperty.resetModificationsTranscriptionsSize();
            }
        } else if (shape instanceof ComplexSpeciesShape) {
            ComplexSpeciesProperty complexProperty = (ComplexSpeciesProperty)shape.getProperty();
            Vector aliases = complexProperty.getSpeciesAliases();
            int i = 0;
            while (i < aliases.size()) {
                ComplexSpeciesAlias a = (ComplexSpeciesAlias)aliases.elementAt(i);
                MonoSpeciesProperty monoProperty = (MonoSpeciesProperty)((SpeciesShape)((Object)a.getGFramedShape())).getProperty();
                if (monoProperty.getType().equals("ANTISENSE_RNA")) {
                    AntiSenseRNA g = monoProperty.getAntiSenseRNA();
                    if (g == null) {
                        throw new Exception("replaceInnerAntiSenseRNARef(), property.getAntiSenseRNA()==null at alias=" + this.getName());
                    }
                    if (g == prev) {
                        monoProperty.setAntiSenseRNA(asrna);
                        monoProperty.resetModificationsTranscriptionsSize();
                    }
                }
                ++i;
            }
        }
        shape.resetShape();
    }

    @Override
    public boolean isIncludedInComplex() {
        if (this.container == null) {
            return false;
        }
        return this.container instanceof ComplexSpeciesAlias;
    }

    @Override
    public void readDOMTree(SBModel sbModel, Element element, Model model, ListOf listOfProteins, ListOf listOfGenes, ListOf listOfRNAs, ListOf listOfAntiSenseRNAs, Vector compartmentAliases) {
        block81: {
            SpeciesSymbol symbol;
            GFramedShape shape;
            String caId;
            Element e;
            String angle;
            int view;
            SpeciesProperty property;
            if (element == null) {
                return;
            }
            String id = element.getAttributeNS(null, "id");
            super.setName(id);
            Species s = null;
            SpeciesAnnotation sExt = null;
            String speciesId = element.getAttributeNS(null, "species");
            Species sbase = model.getSpecies(speciesId);
            if (sbase != null) {
                s = sbase;
                this.setOriginalSpecies(s);
                sExt = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)s, null);
                if (sExt != null) {
                    sExt.addReference(this);
                }
            } else {
                return;
            }
            NodeList childlist = element.getChildNodes();
            int childsize = childlist.getLength();
            Node activityNode = null;
            Node boundsNode = null;
            Node viewNode = null;
            Node briefViewNode = null;
            Node usualViewNode = null;
            Node backupSizeNode = null;
            Node backupViewNode = null;
            Node autotagNode = null;
            Node structuralStateNode = null;
            Element infobox = null;
            Node fontNode = null;
            int i = 0;
            while (i < childsize) {
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                    String localName = node.getLocalName();
                    if (localName.equals("activity")) {
                        activityNode = node;
                    } else if (localName.equals("bounds")) {
                        boundsNode = node;
                    } else if (localName.equals("font")) {
                        fontNode = node;
                    } else if (localName.equals("view")) {
                        viewNode = node;
                    } else if (localName.equals("briefView")) {
                        briefViewNode = node;
                    } else if (localName.equals("usualView")) {
                        usualViewNode = node;
                    } else if (localName.equals(BACKUPSIZE)) {
                        backupSizeNode = node;
                    } else if (localName.equals(BACKUPVIEW)) {
                        backupViewNode = node;
                    } else if (localName.equals("AutoTag")) {
                        autotagNode = node;
                    } else if (localName.equals("structuralState")) {
                        structuralStateNode = node;
                    } else if (localName.equals("info")) {
                        infobox = (Element)node;
                    }
                }
                ++i;
            }
            if (sExt != null && (property = sExt.getSpeciesProperty()) instanceof MonoSpeciesProperty) {
                AntiSenseRNA antisenserna;
                RNA rna;
                Gene gene;
                Protein protein;
                MonoSpeciesProperty monoProperty = (MonoSpeciesProperty)property;
                String type = monoProperty.getType();
                String someId = monoProperty.getReadingSomeId();
                if (!someId.equals("")) {
                    if (type.equals("PROTEIN")) {
                        Protein p = sbModel.getProtein(someId);
                        monoProperty.setProtein(p);
                    } else if (type.equals("GENE")) {
                        Gene g = sbModel.getGene(someId);
                        monoProperty.setGene(g);
                    } else if (type.equals("RNA")) {
                        RNA r = sbModel.getRNA(someId);
                        monoProperty.setRNA(r);
                    } else if (type.equals("ANTISENSE_RNA")) {
                        AntiSenseRNA asr = sbModel.getAntiSenseRNA(someId);
                        monoProperty.setAntiSenseRNA(asr);
                    }
                    monoProperty.clearReadingSomeId();
                }
                if ((protein = monoProperty.getProtein()) != null) {
                    protein.addReference(this);
                }
                if ((gene = monoProperty.getGene()) != null) {
                    gene.addReference(this);
                }
                if ((rna = monoProperty.getRNA()) != null) {
                    rna.addReference(this);
                }
                if ((antisenserna = monoProperty.getAntiSenseRNA()) != null) {
                    antisenserna.addReference(this);
                }
                if (s.getName().equals("")) {
                    s.setName(monoProperty.createSpeciesName());
                }
                MonoSpeciesProperty usualProperty = (MonoSpeciesProperty)monoProperty.deepClone();
                MonoSpeciesShape usualShape = new MonoSpeciesShape();
                usualShape.setProperty(usualProperty);
                this.setGFramedShape(usualShape);
                String code = usualProperty.getType();
                if (protein != null) {
                    code = protein.getType();
                }
                if (gene != null) {
                    code = gene.getType();
                }
                if (rna != null) {
                    code = rna.getType();
                }
                if (antisenserna != null) {
                    code = antisenserna.getType();
                }
                usualShape.buildPaintingsForType(code);
                usualShape.changeView(new Integer(this.currentView));
                String briefType = SBFactory.getBriefViewType(code);
                Dimension d = (Dimension)Preference.defaultSpeciesSize.get(briefType);
                if (d == null) {
                    SpeciesSymbol briefSymbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(briefType));
                    d = briefSymbol.defaultSize();
                }
                this.setFrameSize(1, d.width, d.height);
                int[] nArray = new int[2];
                nArray[1] = 1;
                int[] views = nArray;
                int i2 = 0;
                while (i2 < childsize) {
                    Node node = childlist.item(i2);
                    if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                        String localName = node.getLocalName();
                        int j = 0;
                        while (j < views.length) {
                            if (localName.equals(String.valueOf(this.getViewString(views[j])) + "View")) {
                                this.buildViewByDOMTree(node, views[j]);
                            }
                            ++j;
                        }
                    }
                    ++i2;
                }
                try {
                    this.readSubXmlNodeOfDOMTreeFromAppVer4(this, childlist);
                }
                catch (Exception myErr) {
                    this.clearVectTagAliasUsingOnlyWhenBuidTagByReadFromDOMTree();
                    this.clearVectTagLinkUsingOnlyWhenBuidTagByReadFromDOMTree();
                }
            }
            String viewString = ((Element)viewNode).getAttributeNS(null, "state");
            this.currentView = view = this.getViewConstant(viewString);
            if (autotagNode != null) {
                String strAutotagangle = ((Element)autotagNode).getAttributeNS(null, "angle");
                double dAutotagangle = 0.0;
                try {
                    dAutotagangle = Double.parseDouble(strAutotagangle);
                }
                catch (Exception myErr) {
                    dAutotagangle = 0.39269908169872414;
                }
                MonoSpeciesShape shape2 = (MonoSpeciesShape)this.getGFramedShape();
                shape2.getSameIDAutoTag().setAngle(dAutotagangle);
            }
            if (structuralStateNode != null && (angle = ((Element)structuralStateNode).getAttributeNS(null, "angle")) != null && !angle.trim().equals("")) {
                MonoSpeciesShape shape3 = (MonoSpeciesShape)this.getGFramedShape();
                shape3.setStructuralStateAngle(Double.parseDouble(angle));
            }
            if (backupSizeNode != null) {
                e = (Element)backupSizeNode;
                String str_w = e.getAttributeNS(null, "w");
                String str_h = e.getAttributeNS(null, "h");
                double w = Double.parseDouble(str_w);
                double h = Double.parseDouble(str_h);
                Point2D.Double backupSize = new Point2D.Double(w, h);
                this.setBackupSize(backupSize);
            }
            if (backupViewNode != null) {
                e = (Element)backupViewNode;
                int backViewState = this.getViewConstant(e.getAttributeNS(null, "state"));
                this.setBackupState(backViewState);
                if (this.getCurrentView() == 3) {
                    int tempView = backViewState;
                    if (tempView == 2) {
                        tempView = 0;
                    } else if (tempView == 3) {
                        tempView = 1;
                    }
                    this.setInnerPosition(tempView, this.readBackupInnerPosition(element));
                    ((MonoSpeciesShape)this.getGFramedShape()).changeView(new Integer(tempView));
                }
            }
            Rectangle2D.Double readBounds = this.readBoundsDOMTree((Element)boundsNode);
            this.setFramePosition(readBounds.x, readBounds.y);
            this.setFrameSize(readBounds.width, readBounds.height);
            if (fontNode != null) {
                String str_size = ((Element)fontNode).getAttributeNS(null, "size");
                MonoSpeciesShape moshape = (MonoSpeciesShape)this.getGFramedShape();
                try {
                    int size = Integer.parseInt(str_size);
                    if (!PopupSpeciesNameFontDialog.checkerFontSizeEffectiveness(size)) {
                        throw new Exception();
                    }
                    moshape.setNameFontSize(size);
                }
                catch (Exception ex) {
                    moshape.setNameFontSize(12);
                }
            }
            if (!(caId = element.getAttributeNS(null, "compartmentAlias")).equals("")) {
                GElement matched = null;
                int i3 = 0;
                while (i3 < compartmentAliases.size()) {
                    GElement ca = (GElement)compartmentAliases.elementAt(i3);
                    if (ca.getName().equals(caId)) {
                        matched = ca;
                        break;
                    }
                    ++i3;
                }
                if (matched != null) {
                    GStructure.setContainerTarget((GContainer)((Object)matched), this);
                } else {
                    Debug.println("[ElementSpeciesAlias]readDOMTree(), compartmentAlias==null, compartmentAliasID=" + caId);
                }
            }
            if (activityNode != null) {
                String str = activityNode.getFirstChild().getNodeValue();
                this.setActive(str.equals("active"));
            }
            if (infobox != null && (shape = super.getGFramedShape()) instanceof MonoSpeciesShape && (symbol = ((MonoSpeciesShape)shape).getSpeciesSymbol()) != null) {
                String state = infobox.getAttributeNS(null, "state");
                String label1 = infobox.getAttributeNS(null, "prefix");
                String label2 = infobox.getAttributeNS(null, "label");
                String angle2 = infobox.getAttributeNS(null, "angle");
                try {
                    if (InformationBox.isValidForInfo(state, label1, label2)) {
                        this.infoBox = new InformationBox(state, label1, label2, this);
                        try {
                            this.infoBox.setAngle(Double.valueOf(angle2));
                        }
                        catch (Exception ex) {
                            this.infoBox.setAngle(-1.5707963267948966);
                            SpeciesSymbol speciesSymbol = this.getSpeciesSymbol();
                            if (speciesSymbol != null) {
                                this.infoBox.setAngle(speciesSymbol.getDefaultAngle());
                            }
                        }
                    } else if (this.infoBox != null) {
                        this.infoBox.resetStateString();
                    }
                }
                catch (Exception ex) {
                    if (this.infoBox == null) break block81;
                    this.infoBox.resetStateString();
                }
            }
        }
    }

    public static void updateAnnotation(StringBuffer buf, ComplexSpeciesAlias alias, Vector vTagLinks) {
        if (alias.getOriginalSpecies() == null) {
            Debug.println("[ComplexSpecieAlias]printXML(), originalSpecies=null, id=" + alias.getName());
            return;
        }
        String myId = alias.getName();
        String speciesId = alias.getOriginalSpecies().getId();
        GElement ca = (GElement)((Object)alias.getContainer());
        buf.append("<celldesigner:complexSpeciesAlias id=\"" + myId + "\" species=\"" + speciesId + "\"");
        if (ca != null) {
            if (ca instanceof ComplexSpeciesAlias) {
                buf.append(" complexSpeciesAlias=\"" + ca.getName() + "\">\n");
            } else if (ca instanceof CompartmentAlias) {
                buf.append(" compartmentAlias=\"" + ca.getName() + "\">\n");
            }
        } else {
            buf.append(">\n");
        }
        buf.append("<celldesigner:activity>");
        if (alias.isActive) {
            buf.append("active");
        } else {
            buf.append("inactive");
        }
        buf.append("</celldesigner:activity>\n");
        Rectangle2D.Double bounds = ((SpeciesShape)((Object)alias.getGFramedShape())).getFrameBounds();
        if (bounds != null) {
            buf.append("<celldesigner:bounds x=\"" + bounds.x + "\" y=\"" + bounds.y + "\" w=\"" + bounds.width + "\" h=\"" + bounds.height + "\"/>\n");
        }
        MonoSpeciesShape shape = (MonoSpeciesShape)alias.getGFramedShape();
        buf.append("<celldesigner:font size=\"" + shape.getNameFontSize() + "\"/>\n");
        buf.append("<celldesigner:view state=\"" + alias.getCurrentViewString() + "\"/>\n");
        buf.append("<celldesigner:backupSize w=\"" + alias.getBackupSize().x + "\" h=\"" + alias.getBackupSize().y + "\"/>\n");
        buf.append("<celldesigner:backupView state=\"" + alias.getViewString(alias.getBackupState()) + "\"/>\n");
        Vector shapes = shape.getMShapes();
        if (shapes != null) {
            ModificationShape mAutoTagShape = null;
            int k = 0;
            while (k < shapes.size()) {
                ModificationShape mShape = (ModificationShape)shapes.get(k);
                if (mShape.getSameIDAutoTag() != null) {
                    mAutoTagShape = mShape;
                    break;
                }
                ++k;
            }
            ModificationShape structuralStateShape = null;
            int k2 = 0;
            while (k2 < shapes.size()) {
                ModificationShape mShape = (ModificationShape)shapes.get(k2);
                if (mShape.getStructuralState() != null) {
                    structuralStateShape = mShape;
                    break;
                }
                ++k2;
            }
            if (structuralStateShape != null) {
                double angle = structuralStateShape.getStructuralState().getAngle();
                buf.append("<celldesigner:structuralState angle=\"" + angle + "\"/>\n");
            }
        }
        MonoSpeciesShape monoShape = (MonoSpeciesShape)alias.getGFramedShape();
        int icurrviewBak = alias.currentView;
        Rectangle2D.Double currsymbolboundsBak = monoShape.getSpeciesSymbol().getSymbolBounds();
        int[] nArray = new int[2];
        nArray[1] = 1;
        int[] views = nArray;
        int i = 0;
        while (i < views.length) {
            buf.append("<celldesigner:" + alias.getViewString(views[i]) + "View>\n");
            Point2D.Double position = alias.getInnerPosition(views[i]);
            if (position != null) {
                buf.append("<celldesigner:innerPosition x=\"" + position.x + "\" y=\"" + position.y + "\"/>\n");
            }
            Point2D.Double size = alias.getFrameSize(views[i]);
            buf.append("<celldesigner:boxSize width=\"" + size.x + "\" height=\"" + size.y + "\"/>\n");
            monoShape.changeView(new Integer(views[i]));
            buf.append("<celldesigner:singleLine width=\"" + monoShape.getSpeciesShapePainting().getLineWidth() + "\"/>\n");
            buf.append("<celldesigner:paint color=\"" + Integer.toHexString(monoShape.getSpeciesShapePainting().getColor().getRGB()) + "\" scheme=\"" + monoShape.getSpeciesShapePainting().getPaintScheme().getCode() + "\"/>\n");
            buf.append("</celldesigner:" + alias.getViewString(views[i]) + "View>\n");
            ++i;
        }
        if (vTagLinks != null && vTagLinks.size() > 0) {
            ComplexSpeciesAlias.appendXMLTagOfTagLink(buf, vTagLinks);
        }
        InformationBox ib = alias.getInfoBox();
        try {
            if (InformationBox.isValidForInfo(ib)) {
                String state = ib.getStateString();
                String label1 = ib.getLabel1String();
                String label2 = ib.getLabel2String();
                double angle = ib.getAngle();
                buf.append("<celldesigner:info state=\"" + state + "\" " + "prefix" + "=\"" + label1 + "\" " + "label" + "=\"" + StringTool.toEscape(label2) + "\" " + "angle" + "=\"" + Double.toString(angle) + "\" " + "/>\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        buf.append("</celldesigner:complexSpeciesAlias>\n");
        monoShape.changeView(new Integer(icurrviewBak));
        if (currsymbolboundsBak != null) {
            monoShape.getSpeciesSymbol().setSymbolBounds(currsymbolboundsBak.x, currsymbolboundsBak.y, currsymbolboundsBak.width, currsymbolboundsBak.height);
        }
    }

    private Rectangle2D.Double readBoundsDOMTree(Element boundElement) {
        String str_x = boundElement.getAttributeNS(null, "x");
        String str_y = boundElement.getAttributeNS(null, "y");
        String str_w = boundElement.getAttributeNS(null, "w");
        String str_h = boundElement.getAttributeNS(null, "h");
        try {
            double x = Double.parseDouble(str_x);
            double y = Double.parseDouble(str_y);
            double w = Double.parseDouble(str_w);
            double h = Double.parseDouble(str_h);
            return new Rectangle2D.Double(x, y, w, h);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void buildViewByDOMTree(Node node, int view) {
        MonoSpeciesShape shape = (MonoSpeciesShape)this.getGFramedShape();
        shape.changeView(new Integer(view));
        NodeList childlist = node.getChildNodes();
        int childsize = childlist.getLength();
        int i = 0;
        while (i < childsize) {
            Node n = childlist.item(i);
            if (n.getNodeType() == 1 && n.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                String localName = n.getLocalName();
                if (localName.equals("boxSize")) {
                    Point2D.Double boxSize = this.readBoxSizeDOMTree((Element)n);
                    this.setFrameSize(view, boxSize.x, boxSize.y);
                } else if (localName.equals("singleLine")) {
                    Element selem = (Element)n;
                    String str_width = selem.getAttributeNS(null, "width");
                    double width = Double.parseDouble(str_width);
                    if (width < 1.0) {
                        width = 1.0;
                    }
                    shape.setLineWidth(width);
                } else if (localName.equals("paint")) {
                    Element pelem = (Element)n;
                    String str_color = pelem.getAttributeNS(null, "color");
                    String str_scheme = pelem.getAttributeNS(null, "scheme");
                    long l = Long.parseLong(str_color, 16);
                    shape.setColor(new Color((int)l, true));
                    shape.setPaintScheme(PaintSchemeFactory.createByCode(str_scheme));
                }
            }
            ++i;
        }
        shape.changeView(new Integer(this.currentView));
    }

    private Point2D.Double readInnerPositionDOMTree(Element positionElement) {
        String str_x = positionElement.getAttributeNS(null, "x");
        String str_y = positionElement.getAttributeNS(null, "y");
        try {
            double x = Double.parseDouble(str_x);
            double y = Double.parseDouble(str_y);
            return new Point2D.Double(x, y);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Point2D.Double readBoxSizeDOMTree(Element boxSizeElement) {
        String str_width = boxSizeElement.getAttributeNS(null, "width");
        String str_height = boxSizeElement.getAttributeNS(null, "height");
        try {
            double width = Double.parseDouble(str_width);
            double height = Double.parseDouble(str_height);
            return new Point2D.Double(width, height);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void writeBoundsDOMTree(Node node, Rectangle2D.Double bounds) {
        String ns = ModelAnnotation.getOutputNamespace();
        Document doc = node.getOwnerDocument();
        String URI2 = node.getNamespaceURI();
        Element elem = doc.createElementNS(URI2, String.valueOf(ns) + ":bounds");
        node.appendChild(elem);
        elem.setAttributeNS(null, "x", Double.toString(bounds.x));
        elem.setAttributeNS(null, "y", Double.toString(bounds.y));
        elem.setAttributeNS(null, "w", Double.toString(bounds.width));
        elem.setAttributeNS(null, "h", Double.toString(bounds.height));
    }

    private void writeInnerPositionDOMTree(Node node, Point2D.Double position) {
        if (position == null) {
            return;
        }
        String ns = ModelAnnotation.getOutputNamespace();
        Document doc = node.getOwnerDocument();
        String URI2 = node.getNamespaceURI();
        Element elem = doc.createElementNS(URI2, BACKUPINNERPOSITION);
        elem.setPrefix(ns);
        node.appendChild(elem);
        elem.setAttributeNS(null, "x", Double.toString(position.x));
        elem.setAttributeNS(null, "y", Double.toString(position.y));
    }

    private void writeBoxSizeDOMTree(Node node, Point2D.Double size) {
        String ns = ModelAnnotation.getOutputNamespace();
        Document doc = node.getOwnerDocument();
        String URI2 = node.getNamespaceURI();
        Element elem = doc.createElementNS(URI2, "boxSize");
        elem.setPrefix(ns);
        node.appendChild(elem);
        elem.setAttributeNS(null, "width", Double.toString(size.x));
        elem.setAttributeNS(null, "height", Double.toString(size.y));
    }

    private void writePaintingDOMTree(Node node, SpeciesShapePainting painting) {
        String ns = ModelAnnotation.getOutputNamespace();
        Document doc = node.getOwnerDocument();
        String URI2 = node.getNamespaceURI();
        Element lelem = doc.createElementNS(URI2, String.valueOf(ns) + ":singleLine");
        node.appendChild(lelem);
        lelem.setAttributeNS(null, "width", Double.toString(painting.getLineWidth()));
        Element pelem = doc.createElementNS(URI2, String.valueOf(ns) + ":paint");
        node.appendChild(pelem);
        pelem.setAttributeNS(null, "color", Integer.toHexString(painting.getColor().getRGB()));
        pelem.setAttributeNS(null, "scheme", painting.getPaintScheme().getCode());
    }

    @Override
    public Rectangle2D update() {
        MonoSpeciesShape mono;
        ComplexSpeciesAlias parent;
        if (this.currentView == 3 && (parent = (ComplexSpeciesAlias)this.getContainer()) != null) {
            SpeciesSymbol pSymbol = ((MonoSpeciesShape)parent.getGFramedShape()).getSpeciesSymbol();
            Rectangle2D.Double psBounds = pSymbol.getSymbolBounds();
            this.setFramePosition(psBounds.x, psBounds.y);
            this.setFrameSize(psBounds.width, psBounds.height);
        }
        Rectangle2D redrawArea = super.update();
        this.updateLayerText();
        Rectangle2D.Double rtn3 = null;
        if (this.infoBox != null) {
            this.infoBox.resetCenterPointByAngle();
            rtn3 = this.infoBox.getRepaintBounds();
        }
        if ((mono = (MonoSpeciesShape)super.getGFramedShape()).getNameImage() != null) {
            Rectangle2D bouds = mono.getNameImage().update();
            redrawArea = GUtil.union(redrawArea, bouds);
        }
        return GUtil.union(redrawArea, rtn3);
    }

    @Override
    public void changeView(Integer viewInt) {
        super.changeView(viewInt);
        ((MonoSpeciesShape)this.framedShape).changeView(viewInt);
    }

    @Override
    public void changeView() {
        super.changeView();
        ((MonoSpeciesShape)this.framedShape).changeView(new Integer(this.currentView));
    }

    @Override
    public void setReferringSBase(SBase sbase) {
        this.originalSpecies = (Species)sbase;
        this.notifyObserver();
    }

    @Override
    public SBase removeReferringSBase() {
        Species sbase = this.originalSpecies;
        this.originalSpecies = null;
        this.notifyObserver();
        return sbase;
    }

    @Override
    public SBase getReferringSBase() {
        return this.originalSpecies;
    }

    @Override
    public void notifyObserver() {
        if (this.observers == null) {
            return;
        }
        int i = 0;
        while (i < this.observers.size()) {
            SBaseReferrerObserver obs = (SBaseReferrerObserver)this.observers.elementAt(i);
            obs.update(this, (SBase)this.originalSpecies);
            ++i;
        }
    }

    @Override
    public void addObserver(SBaseReferrerObserver observer) {
        if (this.observers == null) {
            this.observers = new Vector();
        }
        this.observers.addElement(observer);
    }

    @Override
    public void removeObserver(SBaseReferrerObserver observer) {
        if (this.observers == null) {
            return;
        }
        observer.removed();
        this.observers.removeElement(observer);
        if (this.observers.size() == 0) {
            this.observers = null;
        }
    }

    @Override
    public void removeAllObservers() {
        if (this.observers == null) {
            return;
        }
        int i = 0;
        while (i < this.observers.size()) {
            ((SBaseReferrerObserver)this.observers.elementAt(i)).removed();
            ++i;
        }
        this.observers.removeAllElements();
        this.observers = null;
    }

    @Override
    public boolean popupAvailable() {
        return true;
    }

    @Override
    public void showPopup(MouseEvent e, double x, double y, GStructure structure) {
        SpeciesAliasPopupMenu popup = SpeciesAliasPopupMenu.getInstance();
        int menucount = popup.getComponentCount();
        int i = 0;
        while (i < menucount) {
            popup.getComponent(i).setVisible(true);
            ++i;
        }
        boolean enbl = false;
        try {
            String cmp = this.originalSpecies.getCompartment();
            if (cmp != null && !cmp.trim().equals("")) {
                enbl = true;
            }
        }
        catch (Exception myErr) {
            enbl = false;
        }
        popup.changeEditSpeciesActionEnable(enbl);
        String edittext = "";
        String notestext = "Notes...";
        edittext = "Edit...";
        if (this.isMonoProtein()) {
            edittext = "Edit Protein...";
            notestext = "Protein Notes...";
        } else if (this.isMonoGene()) {
            edittext = "Edit Gene...";
            notestext = "Gene Notes...";
        } else if (this.isMonoRNA()) {
            edittext = "Edit RNA...";
            notestext = "RNA Notes...";
        } else if (this.isMonoAntiSenseRNA()) {
            edittext = "Edit asRNA...";
            notestext = "asRNA Notes...";
        }
        popup.setItemText(MainWindow.OpenProteinEtcEditDialogAction.class, edittext);
        popup.setItemText(MainWindow.ProteinNotesAction.class, notestext);
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    public void changeComplexView(Integer viewInt) {
        block12: {
            int i;
            if (viewInt == 3) {
                return;
            }
            super.changeView(viewInt);
            Vector contains = super.getTargets();
            Vector<ComplexSpeciesAlias> childComplexes = new Vector<ComplexSpeciesAlias>();
            if (contains != null && contains.size() != 0) {
                int tempView = viewInt;
                if (tempView == 2) {
                    tempView = 0;
                }
                int i2 = 0;
                while (i2 < contains.size()) {
                    if (contains.get(i2) instanceof ComplexSpeciesAlias) {
                        childComplexes.add((ComplexSpeciesAlias)contains.get(i2));
                    } else {
                        ((GAtom)contains.get(i2)).changeView(new Integer(tempView));
                    }
                    ++i2;
                }
            }
            ((MonoSpeciesShape)this.framedShape).changeView(viewInt);
            if (childComplexes.size() <= 0) break block12;
            if (viewInt == 1) {
                i = 0;
                while (i < childComplexes.size()) {
                    if (((ComplexSpeciesAlias)childComplexes.elementAt(i)).getCurrentView() != 3) {
                        ((ComplexSpeciesAlias)childComplexes.elementAt(i)).setComplexParentBriefView();
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < childComplexes.size()) {
                    if (((GAtom)childComplexes.elementAt(i)).getCurrentView() == 3) {
                        ((ComplexSpeciesAlias)childComplexes.elementAt(i)).restoreComplexParentBriefView();
                    }
                    ++i;
                }
            }
        }
    }

    public void buildComplexContainer(Element element, Vector createdComplexes) {
        String csaId = element.getAttributeNS(null, "complexSpeciesAlias");
        if (!csaId.equals("")) {
            GElement matched = null;
            int i = 0;
            while (i < createdComplexes.size()) {
                GElement csa = (GElement)createdComplexes.elementAt(i);
                if (csa.getName().equals(csaId)) {
                    matched = csa;
                    break;
                }
                ++i;
            }
            if (matched != null) {
                int tempView = this.getCurrentView();
                if (tempView == 2) {
                    this.currentView = 0;
                }
                GStructure.setContainerTarget((GContainer)((Object)matched), this);
                this.currentView = tempView;
            }
        }
    }

    public Vector changeViewUpdate(GStructure gStructure) {
        Point2D.Double parentPosition = this.getFramePosition();
        Vector targets = this.getTargets();
        int size = targets.size();
        int j = 0;
        while (j < size) {
            GAtom element = (GAtom)targets.elementAt(j);
            Point2D.Double innerPosition = element.getInnerPosition();
            element.setFramePosition(parentPosition.x + innerPosition.x, parentPosition.y + innerPosition.y);
            element.update();
            if (element instanceof ComplexSpeciesAlias) {
                targets.addAll(((ComplexSpeciesAlias)element).changeViewUpdate(gStructure));
                gStructure.changeComplexOrder(this);
            }
            ++j;
        }
        return targets;
    }

    private void setComplexParentBriefView() {
        this.backupViewStateForParentBrief = this.getCurrentView();
        this.backupSize = new Point2D.Double(this.getFrameSize().x, this.getFrameSize().y);
        this.currentView = 3;
        Vector targets = this.getTargets();
        int size = targets.size();
        int i = 0;
        while (i < size) {
            if (targets.elementAt(i) instanceof ComplexSpeciesAlias) {
                ((MonoSpeciesShape)this.framedShape).changeView(new Integer(1));
                if (((ComplexSpeciesAlias)targets.elementAt(i)).getCurrentView() != 3) {
                    ((ComplexSpeciesAlias)targets.elementAt(i)).setComplexParentBriefView();
                }
            } else {
                ((GAtom)targets.elementAt(i)).changeView(new Integer(1));
            }
            ++i;
        }
    }

    private void restoreComplexParentBriefView() {
        this.currentView = this.backupViewStateForParentBrief;
        this.size = this.backupSize;
        int tempView = this.currentView;
        if (tempView == 2) {
            tempView = 0;
        }
        this.setFrameSize(tempView, this.backupSize.x, this.backupSize.y);
        this.innerPosition = this.getInnerPosition(tempView);
        ((MonoSpeciesShape)this.framedShape).changeView(new Integer(this.currentView));
        Vector targets = this.getTargets();
        int size = targets.size();
        int i = 0;
        while (i < size) {
            if (targets.elementAt(i) instanceof ComplexSpeciesAlias) {
                if (this.currentView != 1) {
                    ((ComplexSpeciesAlias)targets.elementAt(i)).restoreComplexParentBriefView();
                }
            } else {
                ((GAtom)targets.elementAt(i)).changeView(new Integer(tempView));
            }
            ++i;
        }
    }

    public boolean isContains(GElement element) {
        Vector targets = this.getTargets();
        if (targets.contains(element)) {
            return true;
        }
        int size = targets.size();
        int i = 0;
        while (i < size) {
            if (targets.elementAt(i) instanceof ComplexSpeciesAlias && ((ComplexSpeciesAlias)targets.elementAt(i)).isContains(element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setBackupSize(Point2D.Double size) {
        this.backupSize = size;
    }

    public Point2D.Double getBackupSize() {
        return this.backupSize;
    }

    public void setBackupState(int backupState) {
        this.backupViewStateForParentBrief = backupState;
    }

    public int getBackupState() {
        return this.backupViewStateForParentBrief;
    }

    public Point2D.Double readBackupInnerPosition(Element complexElement) {
        Point2D.Double innerPosition = new Point2D.Double(0.0, 0.0);
        NodeList childlist = complexElement.getChildNodes();
        int childsize = childlist.getLength();
        String backupViewString = "";
        switch (this.backupViewStateForParentBrief) {
            case 1: {
                backupViewString = "briefView";
                break;
            }
            case 0: {
                backupViewString = "usualView";
                break;
            }
            case 2: {
                backupViewString = "usualView";
                break;
            }
            case 3: {
                backupViewString = "briefView";
            }
        }
        Node backupViewInnerposition = null;
        int i = 0;
        while (i < childsize) {
            String localName;
            Node node = childlist.item(i);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && (localName = node.getLocalName()).equals(backupViewString)) {
                backupViewInnerposition = node;
                break;
            }
            ++i;
        }
        if (backupViewInnerposition != null) {
            NodeList backupChildList = backupViewInnerposition.getChildNodes();
            int size = backupChildList.getLength();
            int i2 = 0;
            while (i2 < size) {
                Node node = backupChildList.item(i2);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && node.getLocalName().equals(BACKUPINNERPOSITION)) {
                    Element innerPotisionElement = (Element)node;
                    double x = Double.parseDouble(innerPotisionElement.getAttributeNS(null, "x"));
                    double y = Double.parseDouble(innerPotisionElement.getAttributeNS(null, "y"));
                    innerPosition = new Point2D.Double(x, y);
                    break;
                }
                ++i2;
            }
        }
        return innerPosition;
    }

    public Vector getAllTargetsInMe(boolean isAsc) {
        int subSize;
        Vector allTargets = new Vector();
        Vector targets = this.getTargets();
        Vector<ComplexSpeciesAlias> childComplexes = new Vector<ComplexSpeciesAlias>();
        Vector childElements = new Vector();
        int size = targets.size();
        int i = 0;
        while (i < size) {
            if (targets.elementAt(i) instanceof ComplexSpeciesAlias) {
                childComplexes.add((ComplexSpeciesAlias)targets.elementAt(i));
            } else {
                childElements.add(targets.elementAt(i));
            }
            ++i;
        }
        if (isAsc) {
            allTargets.addAll(childComplexes);
            allTargets.addAll(childElements);
            subSize = childComplexes.size();
            int i2 = 0;
            while (i2 < subSize) {
                allTargets.addAll(((ComplexSpeciesAlias)childComplexes.elementAt(i2)).getAllTargetsInMe(isAsc));
                ++i2;
            }
        } else {
            subSize = childComplexes.size();
            int i3 = 0;
            while (i3 < subSize) {
                allTargets.addAll(((ComplexSpeciesAlias)childComplexes.elementAt(i3)).getAllTargetsInMe(isAsc));
                ++i3;
            }
            allTargets.addAll(childElements);
            allTargets.addAll(childComplexes);
        }
        return allTargets;
    }

    public ComplexSpeciesAlias findBriefParent() {
        if (this.getCurrentView() != 3) {
            return this;
        }
        ComplexSpeciesAlias parent = (ComplexSpeciesAlias)this.getContainer();
        if (parent == null) {
            return this;
        }
        if (parent.getCurrentView() == 1) {
            return parent;
        }
        return parent.findBriefParent();
    }

    public void backupChildren() {
        this.backupChildrenInfo = (Vector)this.getTargets().clone();
        int size = this.getTargets().size();
        int i = 0;
        while (i < size) {
            if (this.getTargets().elementAt(i) instanceof ComplexSpeciesAlias) {
                ((ComplexSpeciesAlias)this.getTargets().elementAt(i)).backupChildren();
            }
            ++i;
        }
    }

    public void restoreChildren(GStructure structure) {
        if (this.backupChildrenInfo.size() == 0) {
            return;
        }
        this.clearTargets();
        Vector containAtoms = structure.getContainableAtoms();
        int containAtomsSize = containAtoms.size();
        int i = 0;
        while (i < containAtomsSize) {
            if (this.backupChildrenInfo.contains(containAtoms.elementAt(i))) {
                GStructure.setContainerTarget(this, (GContainerTarget)containAtoms.elementAt(i));
            }
            ++i;
        }
        Vector atoms = structure.getAtoms();
        int atomsSize = atoms.size();
        int i2 = 0;
        while (i2 < atomsSize) {
            if (this.backupChildrenInfo.contains(atoms.elementAt(i2))) {
                GStructure.setContainerTarget(this, (GContainerTarget)atoms.elementAt(i2));
            }
            ++i2;
        }
        Vector targets = this.getTargets();
        int targetSize = targets.size();
        int i3 = 0;
        while (i3 < targetSize) {
            if (targets.elementAt(i3) instanceof ComplexSpeciesAlias) {
                ((ComplexSpeciesAlias)targets.elementAt(i3)).restoreChildren(structure);
            }
            ++i3;
        }
        Vector allTargets = this.getAllTargetsInMe(true);
        targetSize = allTargets.size();
        int i4 = 0;
        while (i4 < targetSize) {
            if (this.getContainer() == allTargets.elementAt(i4)) {
                this.setContainer(structure.getOutside(this));
                break;
            }
            ++i4;
        }
    }

    @Override
    public void addLayerText(LayerSpeciesAlias alias) {
        if (this.listOfLayerText == null) {
            this.listOfLayerText = new Vector();
        }
        this.listOfLayerText.addElement(alias);
    }

    @Override
    public void removeLayerText(LayerSpeciesAlias alias) {
        if (this.listOfLayerText == null) {
            this.listOfLayerText = new Vector();
        }
        this.listOfLayerText.removeElement(alias);
    }

    @Override
    public void updateLayerText() {
        GFramedShape shape = super.getGFramedShape();
        int i = 0;
        while (i < this.listOfLayerText.size()) {
            LayerSpeciesAlias alias = (LayerSpeciesAlias)this.listOfLayerText.get(i);
            ((LayerMonoSpeciesShape)alias.getGFramedShape()).setTargetPosition((int)((MonoSpeciesShape)shape).getFrameBounds().x, (int)((MonoSpeciesShape)shape).getFrameBounds().y);
            ++i;
        }
    }

    @Override
    public void setTempNotesStr(String strnode) {
        this.strTempNotesStr = strnode == null ? "" : strnode;
    }

    @Override
    public String getTempNotesStr() {
        return this.strTempNotesStr;
    }

    @Override
    public InformationBox getInfoBox() {
        return this.infoBox;
    }

    @Override
    public void setInfoBox(InformationBox infoBox) {
        this.infoBox = infoBox;
    }

    @Override
    public Point2D.Double getInfoBoxCenterPointByAngle(double agl) {
        double inputangle = LibSBMLUtil.changetoStandandAngle(agl);
        SpeciesSymbol symbol = this.getSpeciesSymbol();
        if (symbol != null) {
            Area areaSearching = new Area(symbol.getOutterShape());
            Rectangle2D.Double myBounds = super.getFrameBounds();
            double dWidthOfInputArea = areaSearching.getBounds2D().getWidth();
            double dHeightOfInputArea = areaSearching.getBounds2D().getHeight();
            double dRofInputArea = Math.sqrt(dWidthOfInputArea * dWidthOfInputArea + dHeightOfInputArea * dHeightOfInputArea);
            double dNewX = Math.cos(inputangle) * dRofInputArea + myBounds.getCenterX();
            double dNewY = Math.sin(inputangle) * dRofInputArea + myBounds.getCenterY();
            Point2D.Double pnt01 = new Point2D.Double(dNewX, dNewY);
            return LibSBMLUtil.calPntInEdgeOfAreaBy1Pnts(areaSearching, null, pnt01, 0.5, 1);
        }
        return null;
    }

    @Override
    public Point2D.Double recalInfoBoxDisplayPostion(Point2D.Double pos) {
        SpeciesSymbol symbol = this.getSpeciesSymbol();
        if (symbol != null) {
            Area areaSearching = new Area(symbol.getOutterShape());
            return LibSBMLUtil.calPntInEdgeOfAreaBy1Pnts(areaSearching, null, new Point2D.Double(pos.x, pos.y), 0.5, 1);
        }
        return null;
    }

    @Override
    public SpeciesSymbol getSpeciesSymbol() {
        SpeciesSymbol symbol;
        GFramedShape shape = super.getGFramedShape();
        if (shape instanceof MonoSpeciesShape && (symbol = ((MonoSpeciesShape)shape).getSpeciesSymbol()) != null) {
            return symbol;
        }
        return null;
    }

    @Override
    public Rectangle2D.Double getMaxRepaintBounds() {
        Rectangle2D.Double rectUnBounds = null;
        rectUnBounds = this.infoBox != null ? GUtil.union(super.getFrameBounds(), this.infoBox.getRepaintBounds()) : (Rectangle2D.Double)super.getFrameBounds().clone();
        return rectUnBounds;
    }

    public static final String getMembersRelationStr(Object obj) {
        if (obj instanceof ComplexSpeciesAlias) {
            String rtn = ((ComplexSpeciesAlias)obj).getMembersRelationStr("");
            if (rtn == null) {
                rtn = "";
            }
            return rtn;
        }
        return "";
    }

    public String getMembersRelationStr(String pfx) {
        String prefix = "";
        if (pfx != null) {
            prefix = pfx;
        }
        if (this.getOriginalSpecies() == null) {
            return null;
        }
        prefix = String.valueOf(prefix) + this.getOriginalSpecies().getId() + "(";
        Vector targets = this.getTargets();
        if (targets == null || targets.size() <= 0) {
            prefix = String.valueOf(prefix) + ")";
            return prefix;
        }
        int size = targets.size();
        String space = "";
        int i = 0;
        while (i < size) {
            if (i > 0) {
                space = " ";
            }
            if (targets.elementAt(i) instanceof ComplexSpeciesAlias) {
                prefix = ((ComplexSpeciesAlias)targets.elementAt(i)).getMembersRelationStr(String.valueOf(prefix) + space);
            } else {
                if (((SpeciesAlias)targets.elementAt(i)).getOriginalSpecies() == null) {
                    return null;
                }
                prefix = String.valueOf(prefix) + space + ((SpeciesAlias)targets.elementAt(i)).getOriginalSpecies().getId();
            }
            ++i;
        }
        prefix = String.valueOf(prefix) + ")";
        return prefix;
    }

    @Override
    public boolean isPhenotype() {
        return false;
    }
}

