/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.util.Vector;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.SpeciesProperty;
import jp.sbi.celldesigner.sbmlExtension.StructuralState;

public class ComplexProperty
extends MonoSpeciesProperty {
    private Vector monoProperties;

    public ComplexProperty() {
        this.monoProperties = new Vector();
    }

    public ComplexProperty(MonoSpeciesProperty property) {
        this.copy(property);
        this.monoProperties = new Vector();
    }

    @Override
    public SpeciesProperty deepClone() {
        ComplexProperty property = new ComplexProperty();
        property.setType(this.type);
        property.setName(this.name);
        property.setHomodimer(this.homodimer);
        property.setHypothetical(this.hypothetical);
        property.monoProperties = new Vector();
        int i = 0;
        while (i < this.monoProperties.size()) {
            MonoSpeciesProperty mono = (MonoSpeciesProperty)this.monoProperties.elementAt(i);
            property.monoProperties.addElement(mono.deepClone());
            ++i;
        }
        property.setStructuralStates(this.structuralStates);
        return property;
    }

    @Override
    public boolean equals(SpeciesProperty property) {
        if (!(property instanceof ComplexProperty)) {
            return false;
        }
        ComplexProperty target = (ComplexProperty)property;
        if (!target.getType().equals(this.type)) {
            return false;
        }
        if (!target.getName().equals(this.name)) {
            return false;
        }
        if (target.getHomodimer() != this.homodimer) {
            return false;
        }
        if (target.getHypothetical() != this.hypothetical) {
            return false;
        }
        if (!this.isVecStructuralStateCanBeSeeAsSame(target.getStructuralStates())) {
            return false;
        }
        return this.isVecPropertyCanBeSeeAsSame(target.getMonoProperties(), this.monoProperties);
    }

    private boolean isVecPropertyCanBeSeeAsSame(Vector v1, Vector v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null && v2 != null) {
            return false;
        }
        if (v1 != null && v2 == null) {
            return false;
        }
        if (v1.size() != v2.size()) {
            return false;
        }
        if (v1.size() == 0) {
            return true;
        }
        int iInitValueOFunmatched = -1;
        int[] havebeenmatched = new int[v1.size()];
        int c = 0;
        while (c < havebeenmatched.length) {
            havebeenmatched[c] = iInitValueOFunmatched;
            ++c;
        }
        int i = 0;
        while (i < v1.size()) {
            MonoSpeciesProperty targetProperty = null;
            boolean targetisComplex = false;
            if (v1.elementAt(i) instanceof ComplexProperty) {
                targetProperty = (ComplexProperty)v1.elementAt(i);
                targetisComplex = true;
            } else if (v1.elementAt(i) instanceof MonoSpeciesProperty) {
                targetProperty = (MonoSpeciesProperty)v1.elementAt(i);
            }
            MonoSpeciesProperty thisProperty = null;
            int k = 0;
            while (k < v2.size()) {
                block21: {
                    MonoSpeciesProperty tempProperty;
                    block23: {
                        block22: {
                            if (havebeenmatched[k] != iInitValueOFunmatched) break block21;
                            tempProperty = null;
                            if (!(v2.elementAt(k) instanceof ComplexProperty)) break block22;
                            if (!targetisComplex) break block21;
                            tempProperty = (ComplexProperty)v2.elementAt(k);
                            break block23;
                        }
                        if (!(v2.elementAt(k) instanceof MonoSpeciesProperty)) break block23;
                        if (targetisComplex) break block21;
                        tempProperty = (MonoSpeciesProperty)v2.elementAt(k);
                    }
                    if (targetisComplex) {
                        if (targetProperty.equals(tempProperty)) {
                            thisProperty = tempProperty;
                            break;
                        }
                    } else if (targetProperty.equals(tempProperty)) {
                        thisProperty = tempProperty;
                        break;
                    }
                }
                ++k;
            }
            if (thisProperty == null) {
                return false;
            }
            havebeenmatched[k] = i++;
        }
        c = 0;
        while (c < havebeenmatched.length) {
            if (havebeenmatched[c] == iInitValueOFunmatched) {
                return false;
            }
            ++c;
        }
        return true;
    }

    private boolean isVecStructuralStateCanBeSeeAsSame(Vector vInput) {
        if (vInput != this.structuralStates) {
            Vector targetStructuralStates = vInput;
            if (targetStructuralStates.size() != this.structuralStates.size()) {
                if (targetStructuralStates.size() == 0 && this.structuralStates.size() == 1) {
                    return StructuralState.isEmptyState((StructuralState)this.structuralStates.get(0));
                }
                if (targetStructuralStates.size() == 1 && this.structuralStates.size() == 0) {
                    return StructuralState.isEmptyState((StructuralState)targetStructuralStates.get(0));
                }
                return false;
            }
            int i = 0;
            while (i < targetStructuralStates.size()) {
                StructuralState targetState = (StructuralState)targetStructuralStates.get(i);
                StructuralState thisState = null;
                int k = 0;
                while (k < this.structuralStates.size()) {
                    StructuralState state = (StructuralState)this.structuralStates.get(k);
                    if (targetState.equals(state)) {
                        thisState = state;
                        break;
                    }
                    ++k;
                }
                if (thisState == null) {
                    return false;
                }
                ++i;
            }
        } else {
            return true;
        }
        return true;
    }

    public Vector getMonoProperties() {
        return this.monoProperties;
    }

    public void setMonoProperties(Vector monoProperties) {
        this.monoProperties = monoProperties;
    }

    private void copy(MonoSpeciesProperty property) {
        this.setType(property.getType());
        this.setName(property.getName());
        this.setHomodimer(property.getHomodimer());
        this.setHypothetical(property.getHypothetical());
        this.setStructuralStates(property.getStructuralStates());
    }
}

