/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import jp.sbi.celldesigner.MainWindow;

public class CompartmentAliasPopupMenu
extends JPopupMenu {
    private static CompartmentAliasPopupMenu uniqueInstance = null;
    private HashMap menuReservoir = null;

    private CompartmentAliasPopupMenu() {
    }

    public static CompartmentAliasPopupMenu getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new CompartmentAliasPopupMenu();
            uniqueInstance.initItems();
        }
        return uniqueInstance;
    }

    private void initItems() {
        MainWindow mw = MainWindow.getLastInstance();
        if (mw == null) {
            return;
        }
        Class[] actionClasses = new Class[]{MainWindow.ChangeIdentityAction.class, MainWindow.InfoBoxEditAction.class, MainWindow.OpenSBMLEditDialogAction.class, MainWindow.GeneralNotesAction.class, MainWindow.ChangeColorAndShapeAction.class, MainWindow.AddTextAction.class};
        this.menuReservoir = new HashMap();
        int i = 0;
        while (i < actionClasses.length) {
            MainWindow.MyAbstractAction action = mw.getAction(actionClasses[i]);
            if (action != null) {
                JMenuItem menu = new JMenuItem(action);
                this.add(menu);
                this.menuReservoir.put(actionClasses[i], menu);
            }
            if (actionClasses[i] == MainWindow.OpenSBMLEditDialogAction.class || actionClasses[i] == MainWindow.GeneralNotesAction.class) {
                this.addSeparator();
            }
            ++i;
        }
        this.setItemText(MainWindow.OpenSBMLEditDialogAction.class, "Edit Compartment...");
        this.setItemText(MainWindow.GeneralNotesAction.class, "Compartment Notes...");
    }

    public void setItemText(Class cl, String text) {
        JMenuItem menu = (JMenuItem)this.menuReservoir.get(cl);
        if (menu != null) {
            menu.setText(text);
        }
    }
}

