/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.sbmlExtension.CompartmentAnnotation;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.SBase;

public class CompartmentAliasDialog
extends JDialog {
    private JTextField textfieldName;
    private JButton okButton;
    private JButton cancelButton;
    private boolean isFirstShowing = true;
    CompartmentAlias showingCompartmentAlias = null;
    SBModel sbmodel;
    JFrame frame;
    public static final int CHANGE_ALL = 1;
    public static final int CHANGE_ONE_IN_ALL = 2;
    public static final int CHANGE_ONE = 3;

    public CompartmentAliasDialog(JFrame frame, SBModel sbmodel, String title) {
        super(frame);
        this.frame = frame;
        this.sbmodel = sbmodel;
        this.setModal(true);
        final JRootPane rootPane = this.getRootPane();
        JPanel panel = new JPanel();
        panel.setLayout(null);
        JLabel labelCompartmentName = new JLabel("Name");
        labelCompartmentName.setBounds(new Rectangle(20, 20, 75, 20));
        this.textfieldName = new JTextField();
        this.textfieldName.setBounds(new Rectangle(80, 20, 350, 20));
        this.textfieldName.setEditable(true);
        this.textfieldName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(CompartmentAliasDialog.this.okButton);
            }
        });
        this.okButton = new JButton("OK");
        this.okButton.setMnemonic(83);
        this.okButton.setBounds(new Rectangle(80, 55, 80, 25));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompartmentAliasDialog.this.okButton_actionPerformed(e);
            }
        });
        this.okButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(CompartmentAliasDialog.this.okButton);
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic(67);
        this.cancelButton.setBounds(new Rectangle(175, 55, 120, 25));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompartmentAliasDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.textfieldName.setText("");
        this.textfieldName.setCaretPosition(0);
        this.getContentPane().add(panel);
        panel.add((Component)labelCompartmentName, null);
        panel.add((Component)this.textfieldName, null);
        panel.add((Component)this.okButton, null);
        panel.add((Component)this.cancelButton, null);
        this.setTitle(title);
        this.setSize(460, 125);
    }

    private void setComponentsEnabled() {
        this.textfieldName.setEditable(false);
        this.okButton.setEnabled(false);
    }

    public void releaseFrame() {
        this.showingCompartmentAlias = null;
        this.sbmodel = null;
    }

    @Override
    public void show() {
        if (this.isFirstShowing) {
            Point p = this.frame.getLocation();
            Dimension he = this.frame.getSize();
            Dimension me = this.getSize();
            int x = p.x + (he.width - me.width) / 2;
            int y = p.y + (he.height - me.height) / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.setLocation(x, y);
            this.isFirstShowing = false;
        }
        this.rootPane.setDefaultButton(this.okButton);
        super.show();
    }

    public void showAliasProperty(CompartmentAlias alias) {
        this.textfieldName.setText(alias.getCompartmentName());
        this.showingCompartmentAlias = alias;
        this.show();
    }

    public void setAliasProperty(CompartmentAlias alias, String tname) {
        this.textfieldName.setText(tname);
        this.showingCompartmentAlias = alias;
        this.editPerformed();
    }

    private void okButton_actionPerformed(ActionEvent e) {
        if (this.showingCompartmentAlias != null) {
            String newName;
            Compartment originalCompartment = this.showingCompartmentAlias.getOriginalCompartment();
            if (originalCompartment == null) {
                this.dispose();
                this.showingCompartmentAlias = null;
                JOptionPane.showMessageDialog(null, "original compartment of alias is null", "Error", 2);
                return;
            }
            boolean isChanged = false;
            String oldName = this.showingCompartmentAlias.getCompartmentName();
            if (!oldName.equals(newName = this.textfieldName.getText())) {
                isChanged = true;
            }
            if (isChanged) {
                int flag = 3;
                CompartmentAnnotation cExt = (CompartmentAnnotation)LibSBMLUtil.getAnnotation((SBase)originalCompartment, null);
                if (cExt.getReferingAliases().size() > 1) {
                    String msg = "Do you change all same compartment in this model?";
                    String titleHere = "Same compartment exists.";
                    int ans = JOptionPane.showConfirmDialog(this, msg, titleHere, 1, 3, null);
                    if (ans == 2) {
                        this.dispose();
                        this.showingCompartmentAlias = null;
                        return;
                    }
                    if (ans == 0) {
                        flag = 1;
                    }
                    if (ans == 1) {
                        flag = 2;
                    }
                }
                if (flag == 3 || flag == 1) {
                    this.sbmodel.changeCompartmentProperty(this.showingCompartmentAlias, newName, flag);
                } else {
                    this.sbmodel.changeCompartmentProperty(this.showingCompartmentAlias, newName, flag);
                }
            }
        }
        this.dispose();
        this.showingCompartmentAlias = null;
    }

    private void editPerformed() {
        if (this.showingCompartmentAlias != null) {
            String newName;
            Compartment originalCompartment = this.showingCompartmentAlias.getOriginalCompartment();
            if (originalCompartment == null) {
                this.showingCompartmentAlias = null;
                JOptionPane.showMessageDialog(null, "original compartment of alias is null", "Error", 2);
                return;
            }
            boolean isChanged = false;
            String oldName = this.showingCompartmentAlias.getCompartmentName();
            if (!oldName.equals(newName = this.textfieldName.getText())) {
                isChanged = true;
            }
            if (isChanged) {
                int flag = 3;
                CompartmentAnnotation cExt = (CompartmentAnnotation)LibSBMLUtil.getAnnotation((SBase)originalCompartment, null);
                if (cExt.getReferingAliases().size() > 1) {
                    String msg = "Do you change all same compartment in this model?";
                    String title = "Same compartment exists.";
                    int ans = JOptionPane.showConfirmDialog(this, msg, title, 1, 3, null);
                    if (ans == 2) {
                        this.dispose();
                        this.showingCompartmentAlias = null;
                        return;
                    }
                    if (ans == 0) {
                        flag = 1;
                    }
                    if (ans == 1) {
                        flag = 2;
                    }
                }
                if (flag == 3 || flag == 1) {
                    this.sbmodel.changeCompartmentProperty(this.showingCompartmentAlias, newName, flag);
                } else {
                    this.sbmodel.changeCompartmentProperty(this.showingCompartmentAlias, newName, flag);
                }
            }
        }
        this.showingCompartmentAlias = null;
    }

    private void cancelButton_actionPerformed(ActionEvent e) {
        this.dispose();
        this.showingCompartmentAlias = null;
    }
}

