/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.fric.graphics.draw.GColoredShape;
import jp.fric.graphics.draw.GContainer;
import jp.fric.graphics.draw.GContainerTarget;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GFramedContainer;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;
import jp.fric.graphics.draw.PaintSchemeFactory;
import jp.fric.util.Debug;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.CompartmentAliasPopupMenu;
import jp.sbi.celldesigner.CompartmentShapePainting;
import jp.sbi.celldesigner.CompartmentSymbol;
import jp.sbi.celldesigner.InformationBox;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.NameImage;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.layer.symbol.species.LayerMonoSpeciesShape;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesAlias;
import jp.sbi.celldesigner.sbmlExtension.CompartmentAnnotation;
import jp.sbi.celldesigner.sbmlExtension.ModelAnnotation;
import jp.sbi.celldesigner.symbol.color.CompartmentColorScheme;
import jp.sbi.celldesigner.symbol.compartment.CompartmentOval;
import jp.sbi.celldesigner.symbol.compartment.CompartmentSquare;
import jp.sbi.celldesigner.symbol.compartment.Membrane;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClosedCompartmentAlias
extends GFramedContainer
implements CompartmentAlias {
    private NameImage nameImage = null;
    private double namedx = 0.0;
    private double namedy = 0.0;
    private int prevCompartmentIndex = -1;
    private Compartment originalCompartment = null;
    private Compartment historicalCompartment = null;
    private SBSymbol symbol = null;
    private static final CompartmentAliasPopupMenu ComparmentAliasPopup = null;
    private Vector listOfLayerText;
    private double compartmentInitSize = 1.0;
    private boolean isNamePositionBuilded = false;
    private boolean bIsCompartmentHasInitSize = false;
    private InformationBox infoBox = new InformationBox(this);

    public ClosedCompartmentAlias() {
        this.listOfLayerText = new Vector();
    }

    @Override
    public void setSymbol(SBSymbol symbol) throws Exception {
        if (symbol instanceof CompartmentSymbol) {
            this.symbol = symbol;
            super.setGFramedShape((GFramedShape)((Object)symbol));
        } else {
            throw new Exception("symbol must be CompartmentSymbol, code=" + symbol.getCode());
        }
    }

    @Override
    public SBSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public void setCompartmentName(String name) {
        if (this.nameImage == null) {
            this.nameImage = new NameImage(name, this);
            Dimension nameImageSize = this.nameImage.getNameImageSize();
            Dimension realNameImageSize = (Dimension)nameImageSize.clone();
            if (nameImageSize.width > NameImage.getVirtualMoveableNameImageFrameDimension().width) {
                nameImageSize.width = NameImage.getVirtualMoveableNameImageFrameDimension().width;
            }
            Dimension movableareaNameImageSize = (Dimension)nameImageSize.clone();
            this.setNameImagePositionWithOffset(this.getDefaultCompartmentNamePostion(), realNameImageSize, movableareaNameImageSize);
        } else {
            Point2D.Double oldPos = (Point2D.Double)this.nameImage.getFramePosition().clone();
            Point2D.Double oldSize = (Point2D.Double)this.nameImage.getFrameSize().clone();
            this.nameImage = new NameImage(name, this);
            Point2D.Double newSize = this.nameImage.getFrameSize();
            Point2D.Double newPos = new Point2D.Double(oldPos.x - (newSize.x - oldSize.x) / 2.0, oldPos.y - (newSize.y - oldSize.y) / 2.0);
            this.setNameImagePosition(newPos.x, newPos.y);
        }
    }

    @Override
    public String getCompartmentName() {
        if (this.nameImage == null) {
            return "";
        }
        return this.nameImage.getString();
    }

    @Override
    public void setPrevCompartmentIndex(int index) {
        this.prevCompartmentIndex = index;
    }

    @Override
    public int getPrevCompartmentIndex() {
        return this.prevCompartmentIndex;
    }

    @Override
    public void setOriginalCompartment(Compartment compartment) {
        this.originalCompartment = compartment;
    }

    @Override
    public Compartment getOriginalCompartment() {
        return this.originalCompartment;
    }

    @Override
    public void setHistoricalCompartment(Compartment compartment) {
        this.historicalCompartment = compartment;
    }

    @Override
    public Compartment getHistoricalCompartment() {
        return this.historicalCompartment;
    }

    @Override
    public void setGFramedShape(GFramedShape framedShape) throws Exception {
        super.setGFramedShape(framedShape);
        this.symbol = (SBSymbol)((Object)framedShape);
    }

    @Override
    public GElement createCopy() {
        ClosedCompartmentAlias alias = (ClosedCompartmentAlias)super.createCopy();
        Compartment c = this.originalCompartment.cloneObject();
        alias.setOriginalCompartment(c);
        alias.setCompartmentName(this.getCompartmentName());
        alias.namedx = this.namedx;
        alias.namedy = this.namedy;
        if (this.getInfoBox() != null) {
            alias.setInfoBox((InformationBox)this.getInfoBox().createCopy());
        } else {
            alias.setInfoBox(null);
        }
        LibSBMLUtil.updateInfoParent(alias);
        return alias;
    }

    @Override
    public Rectangle2D.Double getRepaintBounds() {
        if (this.nameImage == null) {
            return super.getRepaintBounds();
        }
        if (this.infoBox == null) {
            return GUtil.union(super.getRepaintBounds(), this.nameImage.getRepaintBounds());
        }
        Rectangle2D.Double area = null;
        area = GUtil.union(super.getRepaintBounds(), this.nameImage.getRepaintBounds());
        area = GUtil.union(area, this.infoBox.getRepaintBounds());
        return area;
    }

    @Override
    public Rectangle2D update() {
        Point2D.Double point;
        if (this.symbol == null) {
            return null;
        }
        Rectangle2D rtn = super.update();
        Rectangle2D.Double rtn2 = null;
        if (this.nameImage != null && (point = this.getDefaultCompartmentNamePostion()) != null) {
            this.nameImage.setFramePosition(point.x + this.namedx, point.y + this.namedy);
            rtn2 = (Rectangle2D.Double)this.nameImage.update();
        }
        Rectangle2D.Double rtn3 = null;
        if (this.infoBox != null) {
            this.infoBox.resetCenterPointByAngle();
            rtn3 = this.infoBox.getRepaintBounds();
        }
        return GUtil.union(rtn, GUtil.union(rtn2, rtn3));
    }

    @Override
    public void draw(Graphics2D g2) {
        if (this.symbol == null) {
            return;
        }
        super.draw(g2);
        if (this.nameImage != null) {
            Point2D.Double point = this.getDefaultCompartmentNamePostion();
            if (point == null) {
                return;
            }
            this.nameImage.draw(g2);
        }
        if (this.infoBox != null) {
            this.infoBox.draw(g2);
        }
    }

    @Override
    public void readDOMTree(Element element, Model model) {
        if (element == null) {
            Debug.println("[CompartmentAlias]readDOMTree(), element==null");
            return;
        }
        String id = element.getAttributeNS(null, "id");
        super.setName(id);
        String compartmentId = element.getAttributeNS(null, "compartment");
        Compartment sbase = model.getCompartment(compartmentId);
        if (sbase != null) {
            Compartment c = sbase;
            this.setOriginalCompartment(c);
            CompartmentAnnotation cExt = (CompartmentAnnotation)LibSBMLUtil.getAnnotation((SBase)c, null);
            if (cExt != null) {
                cExt.addReference(this);
                String name = cExt.getCompartmentName();
                if (name.equals("")) {
                    name = c.getName();
                    if (name.equals("")) {
                        name = c.getId();
                    }
                    cExt.setCompartmentName(name);
                }
                this.setCompartmentName(name);
                if (c.getName().equals("")) {
                    c.setName(name);
                }
            } else {
                Debug.println("[CompartmentAlias]readDOMTree(), CompartmentAnnotation==null, compartmentId=" + compartmentId);
            }
        } else {
            Debug.println("[CompartmentAlias]readDOMTree(), compartment==null, compartmentId=" + compartmentId);
            return;
        }
        NodeList childlist = element.getChildNodes();
        int childsize = childlist.getLength();
        boolean boundsExist = false;
        int i = 0;
        while (i < childsize) {
            block38: {
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                    Element elem = (Element)node;
                    String tag = elem.getLocalName();
                    if (tag.equals("class")) {
                        String type = elem.getFirstChild().getNodeValue();
                        SBSymbol symbol = SBFactory.createSymbol(SBFactory.filterSynonym(type));
                        if (symbol != null) {
                            try {
                                this.setSymbol(symbol);
                            }
                            catch (Exception e) {
                                Debug.println("[CompartmentAlias]readDOMTree()," + e.getMessage());
                            }
                            CompartmentShapePainting painting = new CompartmentShapePainting(CompartmentColorScheme.getMembrane(type), CompartmentColorScheme.getColor(type), CompartmentColorScheme.getScheme(type));
                            ((CompartmentSymbol)((Object)symbol)).setCompartmentShapePainting(painting);
                        } else {
                            Debug.println("[CompartmentAlias]readDOMTree(), createSymbol==null, compartmentId=" + compartmentId + ", type=" + type);
                        }
                    } else if (tag.equals("bounds")) {
                        String str_x = elem.getAttributeNS(null, "x");
                        String str_y = elem.getAttributeNS(null, "y");
                        String str_w = elem.getAttributeNS(null, "w");
                        String str_h = elem.getAttributeNS(null, "h");
                        try {
                            double x = Double.parseDouble(str_x);
                            double y = Double.parseDouble(str_y);
                            double width = Double.parseDouble(str_w);
                            double height = Double.parseDouble(str_h);
                            super.setFramePosition(x, y);
                            super.setFrameSize(width, height);
                        }
                        catch (Exception e) {
                            Debug.println("[CompartmentAlias]readDOMTree(), e=" + e.getMessage());
                        }
                        boundsExist = true;
                    } else if (tag.equals("doubleLine")) {
                        if (this.getSymbol() == null) {
                            Debug.println("[CompartmentAlias]readDOMTree(), Symbol not set yet. compartmentId=" + compartmentId);
                        } else {
                            String str_thick = elem.getAttributeNS(null, "thickness");
                            String str_outer = elem.getAttributeNS(null, "outerWidth");
                            String str_inner = elem.getAttributeNS(null, "innerWidth");
                            Membrane m = new Membrane(Double.parseDouble(str_thick), Double.parseDouble(str_outer), Double.parseDouble(str_inner));
                            ((CompartmentSymbol)((Object)this.getSymbol())).setMembrane(m);
                        }
                    } else if (tag.equals("paint")) {
                        if (this.getSymbol() == null) {
                            Debug.println("[CompartmentAlias]readDOMTree(), Symbol not set yet. compartmentId=" + compartmentId);
                        } else {
                            String str_color = elem.getAttributeNS(null, "color");
                            String str_scheme = elem.getAttributeNS(null, "scheme");
                            long l = Long.parseLong(str_color, 16);
                            GColoredShape cshape = (GColoredShape)((Object)this.getSymbol());
                            cshape.setColor(new Color((int)l, true));
                            cshape.setPaintScheme(PaintSchemeFactory.createByCode(str_scheme));
                        }
                    } else if (tag.equals("info") && this.symbol != null) {
                        String state = elem.getAttributeNS(null, "state");
                        String label1 = elem.getAttributeNS(null, "prefix");
                        String label2 = elem.getAttributeNS(null, "label");
                        String angle = elem.getAttributeNS(null, "angle");
                        try {
                            if (InformationBox.isValidForInfo(state, label1, label2)) {
                                this.infoBox = new InformationBox(state, label1, label2, this);
                                try {
                                    this.infoBox.setAngle(Double.valueOf(angle));
                                }
                                catch (Exception ex) {
                                    this.infoBox.setAngle(-1.5707963267948966);
                                    if (this.symbol != null) {
                                        this.infoBox.setAngle(((CompartmentSymbol)((Object)this.symbol)).getDefaultAngle());
                                    }
                                }
                            } else if (this.infoBox != null) {
                                this.infoBox.resetStateString();
                            }
                        }
                        catch (Exception ex) {
                            if (this.infoBox == null) break block38;
                            this.infoBox.resetStateString();
                        }
                    }
                }
            }
            ++i;
        }
        if (!boundsExist) {
            Debug.println("[CompartmentAlias]readDOMTree(), lack of \"bounds\" tag");
        }
    }

    public void readDOMTree(SBModel sbModel, Element element, Model model) {
        if (element == null) {
            Debug.println("[CompartmentAlias]readDOMTree(), element==null");
            return;
        }
        String id = element.getAttributeNS(null, "id");
        super.setName(id);
        String compartmentId = element.getAttributeNS(null, "compartment");
        Compartment sbase = model.getCompartment(compartmentId);
        if (sbase != null) {
            Compartment c = sbase;
            this.setOriginalCompartment(c);
            CompartmentAnnotation cExt = (CompartmentAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)c, null);
            if (cExt != null) {
                cExt.addReference(this);
                String name = cExt.getCompartmentName();
                if (name.equals("")) {
                    name = c.getName();
                    if (name.equals("")) {
                        name = c.getId();
                    }
                    cExt.setCompartmentName(name);
                }
                this.setCompartmentName(name);
                if (c.getName().equals("")) {
                    c.setName(name);
                }
            } else {
                Debug.println("[CompartmentAlias]readDOMTree(), CompartmentAnnotation==null, compartmentId=" + compartmentId);
            }
        } else {
            Debug.println("[CompartmentAlias]readDOMTree(), compartment==null, compartmentId=" + compartmentId);
            return;
        }
        NodeList childlist = element.getChildNodes();
        int childsize = childlist.getLength();
        boolean namepositionGetted = false;
        double dnamex = 0.0;
        double dnamey = 0.0;
        boolean boundsExist = false;
        int i = 0;
        while (i < childsize) {
            block46: {
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                    Element elem = (Element)node;
                    String tag = elem.getLocalName();
                    if (tag.equals("class")) {
                        String type = elem.getFirstChild().getNodeValue();
                        SBSymbol symbol = SBFactory.createSymbol(SBFactory.filterSynonym(type));
                        if (symbol != null) {
                            try {
                                this.setSymbol(symbol);
                            }
                            catch (Exception e) {
                                Debug.println("[CompartmentAlias]readDOMTree()," + e.getMessage());
                            }
                            CompartmentShapePainting painting = new CompartmentShapePainting(CompartmentColorScheme.getMembrane(type), CompartmentColorScheme.getColor(type), CompartmentColorScheme.getScheme(type));
                            ((CompartmentSymbol)((Object)symbol)).setCompartmentShapePainting(painting);
                        } else {
                            Debug.println("[CompartmentAlias]readDOMTree(), createSymbol==null, compartmentId=" + compartmentId + ", type=" + type);
                        }
                    } else if (tag.equals("bounds")) {
                        String str_x = elem.getAttributeNS(null, "x");
                        String str_y = elem.getAttributeNS(null, "y");
                        String str_w = elem.getAttributeNS(null, "w");
                        String str_h = elem.getAttributeNS(null, "h");
                        try {
                            double x = Double.parseDouble(str_x);
                            double y = Double.parseDouble(str_y);
                            double width = Double.parseDouble(str_w);
                            double height = Double.parseDouble(str_h);
                            super.setFramePosition(x, y);
                            super.setFrameSize(width, height);
                        }
                        catch (Exception e) {
                            Debug.println("[CompartmentAlias]readDOMTree(), e=" + e.getMessage());
                        }
                        boundsExist = true;
                    } else if (tag.equals("doubleLine")) {
                        if (this.getSymbol() == null) {
                            Debug.println("[CompartmentAlias]readDOMTree(), Symbol not set yet. compartmentId=" + compartmentId);
                        } else {
                            String str_thick = elem.getAttributeNS(null, "thickness");
                            String str_outer = elem.getAttributeNS(null, "outerWidth");
                            String str_inner = elem.getAttributeNS(null, "innerWidth");
                            Membrane m = new Membrane(Double.parseDouble(str_thick), Double.parseDouble(str_outer), Double.parseDouble(str_inner));
                            ((CompartmentSymbol)((Object)this.getSymbol())).setMembrane(m);
                            Point2D.Double position = this.getDefaultCompartmentNamePostion();
                            if (namepositionGetted) {
                                this.namedx = dnamex - position.x;
                                this.namedy = dnamey - position.y;
                            } else {
                                Dimension nameImageSize = this.nameImage.getNameImageSize();
                                Dimension realNameImageSize = (Dimension)nameImageSize.clone();
                                if (nameImageSize.width > NameImage.getVirtualMoveableNameImageFrameDimension().width) {
                                    nameImageSize.width = NameImage.getVirtualMoveableNameImageFrameDimension().width;
                                }
                                Dimension movableareaNameImageSize = (Dimension)nameImageSize.clone();
                                this.setNameImagePositionWithOffset(this.getDefaultCompartmentNamePostion(), realNameImageSize, movableareaNameImageSize);
                            }
                        }
                    } else if (tag.equals("paint")) {
                        if (this.getSymbol() == null) {
                            Debug.println("[CompartmentAlias]readDOMTree(), Symbol not set yet. compartmentId=" + compartmentId);
                        } else {
                            String str_color = elem.getAttributeNS(null, "color");
                            String str_scheme = elem.getAttributeNS(null, "scheme");
                            long l = Long.parseLong(str_color, 16);
                            GColoredShape cshape = (GColoredShape)((Object)this.getSymbol());
                            cshape.setColor(new Color((int)l, true));
                            cshape.setPaintScheme(PaintSchemeFactory.createByCode(str_scheme));
                        }
                    } else if (tag.equals("namePoint")) {
                        if (boundsExist) {
                            String namex = elem.getAttributeNS(null, "x");
                            String namey = elem.getAttributeNS(null, "y");
                            try {
                                dnamex = Double.parseDouble(namex);
                                dnamey = Double.parseDouble(namey);
                                namepositionGetted = true;
                            }
                            catch (Exception e) {
                                dnamex = 0.0;
                                dnamey = 0.0;
                            }
                        }
                    } else if (tag.equals("info") && this.symbol != null) {
                        String state = elem.getAttributeNS(null, "state");
                        String label1 = elem.getAttributeNS(null, "prefix");
                        String label2 = elem.getAttributeNS(null, "label");
                        String angle = elem.getAttributeNS(null, "angle");
                        try {
                            if (InformationBox.isValidForInfo(state, label1, label2)) {
                                this.infoBox = new InformationBox(state, label1, label2, this);
                                try {
                                    this.infoBox.setAngle(Double.valueOf(angle));
                                }
                                catch (Exception ex) {
                                    this.infoBox.setAngle(-1.5707963267948966);
                                    if (this.symbol != null) {
                                        this.infoBox.setAngle(((CompartmentSymbol)((Object)this.symbol)).getDefaultAngle());
                                    }
                                }
                            } else if (this.infoBox != null) {
                                this.infoBox.resetStateString();
                            }
                        }
                        catch (Exception ex) {
                            if (this.infoBox == null) break block46;
                            this.infoBox.resetStateString();
                        }
                    }
                }
            }
            ++i;
        }
        if (!boundsExist) {
            Debug.println("[CompartmentAlias]readDOMTree(), lack of \"bounds\" tag");
        }
    }

    @Override
    public void buildOutside(GStructure structure) {
        GContainer outsideAlias = structure.getOutside(this);
        if (outsideAlias != null) {
            GStructure.setContainerTarget(outsideAlias, this);
        }
    }

    @Override
    public void writeDOMTree(Node node) {
        if (this.getOriginalCompartment() == null) {
            Debug.println("[CompartmentAlias]printXML(), originalCompartment=null, id=" + super.getName());
            return;
        }
        Rectangle2D.Double bounds = super.getFrameBounds();
        if (bounds == null) {
            Debug.println("[CompartmentAlias]printXML(), getbounds()=null, name=" + super.getName());
            return;
        }
        String ns = ModelAnnotation.getOutputNamespace();
        Document doc = node.getOwnerDocument();
        String myId = super.getName();
        String compartmentId = this.getOriginalCompartment().getId();
        String type = "";
        if (this.symbol != null) {
            type = this.symbol.getCode();
        }
        String tag = String.valueOf(ns) + ":compartmentAlias";
        String typeTag = String.valueOf(ns) + ":class";
        String childtag = String.valueOf(ns) + ":bounds";
        Element elem = doc.createElementNS("http://www.sbml.org/2001/ns/celldesigner", tag);
        node.appendChild(elem);
        elem.setAttributeNS(null, "id", myId);
        elem.setAttributeNS(null, "compartment", compartmentId);
        Element telem = doc.createElementNS("http://www.sbml.org/2001/ns/celldesigner", typeTag);
        elem.appendChild(telem);
        telem.appendChild(doc.createTextNode(type));
        Element belem = doc.createElementNS("http://www.sbml.org/2001/ns/celldesigner", childtag);
        elem.appendChild(belem);
        belem.setAttributeNS(null, "x", Double.toString(bounds.x));
        belem.setAttributeNS(null, "y", Double.toString(bounds.y));
        belem.setAttributeNS(null, "w", Double.toString(bounds.width));
        belem.setAttributeNS(null, "h", Double.toString(bounds.height));
        CompartmentSymbol symbol = (CompartmentSymbol)((Object)this.getSymbol());
        this.writePaintingDOMTree(elem, symbol.getComparmentShapePainting());
    }

    public static void updateAnnotation(StringBuffer buf, ClosedCompartmentAlias alias) {
        if (alias.getOriginalCompartment() == null) {
            Debug.println("[CompartmentAlias]printXML(), originalCompartment=null, id=" + alias.getName());
            return;
        }
        Rectangle2D.Double bounds = alias.getFrameBounds();
        if (bounds == null) {
            Debug.println("[CompartmentAlias]printXML(), getbounds()=null, name=" + alias.getName());
            return;
        }
        String myId = alias.getName();
        String compartmentId = alias.getOriginalCompartment().getId();
        String type = "";
        if (alias.getSymbol() != null) {
            type = alias.getSymbol().getCode();
        }
        buf.append("<celldesigner:compartmentAlias id=\"" + myId + "\" compartment=\"" + compartmentId + "\">\n");
        buf.append("<celldesigner:class>" + type + "</celldesigner:" + "class>\n");
        buf.append("<celldesigner:bounds x=\"" + bounds.x + "\" y=\"" + bounds.y + "\" w=\"" + bounds.width + "\" h=\"" + bounds.height + "\"/>\n");
        Point2D.Double point = alias.getCompartmentNameImage().getFramePosition();
        if (point != null) {
            buf.append("<celldesigner:namePoint x=\"" + point.x + "\" y=\"" + point.y + "\"/>\n");
        }
        CompartmentSymbol symbol = (CompartmentSymbol)((Object)alias.getSymbol());
        ClosedCompartmentAlias.writePaintingDOMTree(buf, symbol.getComparmentShapePainting());
        InformationBox information = alias.getInfoBox();
        try {
            if (InformationBox.isValidForInfo(information)) {
                String state = information.getStateString();
                String label1 = information.getLabel1String();
                String label2 = information.getLabel2String();
                double angle = information.getAngle();
                buf.append("<celldesigner:info state=\"" + state + "\" " + "prefix" + "=\"" + label1 + "\" " + "label" + "=\"" + StringTool.toEscape(label2) + "\" " + "angle" + "=\"" + Double.toString(angle) + "\" " + "/>\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        buf.append("</celldesigner:compartmentAlias>\n");
    }

    private static void writePaintingDOMTree(StringBuffer buf, CompartmentShapePainting painting) {
        Membrane m = painting.getMembrane();
        buf.append("<celldesigner:doubleLine thickness=\"" + m.getThickness() + "\" outerWidth=\"" + m.getOuterLineWidth() + "\" innerWidth=\"" + m.getInnerLineWidth() + "\"/>\n");
        buf.append("<celldesigner:paint color=\"" + Integer.toHexString(painting.getColor().getRGB()) + "\" scheme=\"" + painting.getPaintScheme().getCode() + "\"/>\n");
    }

    private void writePaintingDOMTree(Node node, CompartmentShapePainting painting) {
        String ns = ModelAnnotation.getOutputNamespace();
        Document doc = node.getOwnerDocument();
        String URI2 = node.getNamespaceURI();
        Element lelem = doc.createElementNS(URI2, String.valueOf(ns) + ":doubleLine");
        node.appendChild(lelem);
        Membrane m = painting.getMembrane();
        lelem.setAttributeNS(null, "thickness", Double.toString(m.getThickness()));
        lelem.setAttributeNS(null, "outerWidth", Double.toString(m.getOuterLineWidth()));
        lelem.setAttributeNS(null, "innerWidth", Double.toString(m.getInnerLineWidth()));
        Element pelem = doc.createElementNS(URI2, String.valueOf(ns) + ":paint");
        node.appendChild(pelem);
        pelem.setAttributeNS(null, "color", Integer.toHexString(painting.getColor().getRGB()));
        pelem.setAttributeNS(null, "scheme", painting.getPaintScheme().getCode());
    }

    @Override
    public boolean popupAvailable() {
        return true;
    }

    @Override
    public void showPopup(MouseEvent e, double x, double y, GStructure structure) {
        CompartmentAliasPopupMenu popup = CompartmentAliasPopupMenu.getInstance();
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    public void addLayerText(LayerSpeciesAlias alias) {
        if (this.listOfLayerText == null) {
            this.listOfLayerText = new Vector();
        }
        this.listOfLayerText.addElement(alias);
    }

    public void removeLayerText(LayerSpeciesAlias alias) {
        if (this.listOfLayerText == null) {
            this.listOfLayerText = new Vector();
        }
        this.listOfLayerText.removeElement(alias);
    }

    public void updateLayerText() {
        GFramedShape shape = super.getGFramedShape();
        int i = 0;
        while (i < this.listOfLayerText.size()) {
            LayerSpeciesAlias alias = (LayerSpeciesAlias)this.listOfLayerText.get(i);
            ((LayerMonoSpeciesShape)alias.getGFramedShape()).setTargetPosition((int)((MonoSpeciesShape)shape).getFrameBounds().x, (int)((MonoSpeciesShape)shape).getFrameBounds().y);
            ++i;
        }
    }

    @Override
    public NameImage getCompartmentNameImage() {
        return this.nameImage;
    }

    @Override
    public void setNameImagePosition(double x, double y) {
        Point2D.Double position = this.getDefaultCompartmentNamePostion();
        this.namedx = x - position.x;
        this.namedy = y - position.y;
    }

    public Point2D.Double setNameImagePosition(Point2D.Double pos) {
        this.setNameImagePosition(pos.x, pos.y);
        return pos;
    }

    @Override
    public Point2D.Double getDefaultCompartmentNamePostion() {
        Point2D.Double position = null;
        if (this.symbol == null) {
            return position;
        }
        if (this.nameImage == null) {
            return position;
        }
        Dimension nameImageSize = this.nameImage.getNameImageSize();
        if (nameImageSize.width == 0 || nameImageSize.height == 0) {
            return position;
        }
        if (nameImageSize.width > NameImage.getVirtualMoveableNameImageFrameDimension().width) {
            nameImageSize.width = NameImage.getVirtualMoveableNameImageFrameDimension().width;
        }
        Rectangle2D.Double myBounds = null;
        try {
            myBounds = super.getFrameBounds();
        }
        catch (Exception myErr) {
            myBounds = null;
        }
        if (myBounds == null) {
            return position;
        }
        double x = myBounds.x + (myBounds.width - (double)nameImageSize.width) / 2.0;
        double y = myBounds.y + myBounds.height - ((CompartmentSymbol)((Object)this.symbol)).getThickness() - (double)nameImageSize.height;
        position = new Point2D.Double(x, y);
        return position;
    }

    public Point2D.Double getCompartmentNameDefaultDisplayPostion() {
        Point2D.Double position = null;
        Rectangle2D.Double myBounds = super.getFrameBounds();
        Dimension nameImageSize = this.nameImage.getNameImageSize();
        double x = myBounds.x + (myBounds.width - (double)nameImageSize.width) / 2.0;
        double y = this.getNameImageAvailableDrawAreaBottom();
        position = new Point2D.Double(x, y);
        return position;
    }

    public Point2D.Double getCompartmentNameCenterDisplayPostion() {
        Point2D.Double position = null;
        Rectangle2D.Double myBounds = super.getFrameBounds();
        Dimension nameImageSize = this.nameImage.getNameImageSize();
        Point2D.Double defaultPosition = this.getCompartmentNameDefaultDisplayPostion();
        double newX = defaultPosition.x;
        double newY = myBounds.getCenterY() - (double)nameImageSize.height / 2.0;
        position = new Point2D.Double(newX, newY);
        return position;
    }

    public String enoughtoPlaceNameString() {
        String strW = "1";
        String strH = "1";
        Rectangle2D.Double myBounds = super.getFrameBounds();
        double dThickness = ((CompartmentSymbol)((Object)this.symbol)).getThickness();
        double dInnerLineWidth = ((CompartmentSymbol)((Object)this.symbol)).getMembrane().getInnerLineWidth();
        Dimension nameImageSize = this.nameImage.getNameImageSize();
        if (nameImageSize.width > NameImage.getVirtualMoveableNameImageFrameDimension().width) {
            nameImageSize.width = NameImage.getVirtualMoveableNameImageFrameDimension().width;
        }
        if (this.getNameImageAvailableDrawAreaLeft() > this.getNameImageAvailableDrawAreaRight()) {
            strW = "0";
        }
        if (myBounds.height < dThickness * 2.0 + dInnerLineWidth + (double)nameImageSize.height) {
            strH = "0";
        }
        return String.valueOf(strW) + strH;
    }

    public Point2D.Double getGoodDisplayPostion() {
        Point2D.Double rtn = this.enoughtoPlaceNameString().equals("00") ? this.getCompartmentNameCenterDisplayPostion() : (this.enoughtoPlaceNameString().equals("01") ? new Point2D.Double(this.getCompartmentNameCenterDisplayPostion().x, this.getCompartmentNameDefaultDisplayPostion().y) : (this.enoughtoPlaceNameString().equals("10") ? new Point2D.Double(this.getCompartmentNameDefaultDisplayPostion().x, this.getCompartmentNameCenterDisplayPostion().y) : this.getCompartmentNameDefaultDisplayPostion()));
        return rtn;
    }

    public double getNameImageAvailableDrawAreaTop() {
        Rectangle2D.Double myBounds = super.getFrameBounds();
        double dMinY = 0.0;
        double dRtn = myBounds.y + ((CompartmentSymbol)((Object)this.symbol)).getThickness() + ((CompartmentSymbol)((Object)this.symbol)).getMembrane().getInnerLineWidth() / 2.0;
        if (dRtn < dMinY) {
            dRtn = dMinY;
        }
        return dRtn;
    }

    public double getNameImageAvailableDrawAreaBottom() {
        double dMinY = 0.0;
        double dMaxY = 0.0;
        Rectangle2D.Double myMaxArea = this.getMaxArea();
        if (myMaxArea != null && myMaxArea.height > 0.0) {
            dMaxY = myMaxArea.height;
        } else {
            try {
                dMaxY = MainWindow.getLastInstance().getCurrentModel().getModelSize().getHeight();
            }
            catch (Exception myErr) {
                return 0.0;
            }
        }
        Rectangle2D.Double myBounds = super.getFrameBounds();
        Dimension nameImageSize = this.nameImage.getNameImageSize();
        dMaxY -= (double)nameImageSize.height;
        double dRtn = myBounds.y + myBounds.height - ((CompartmentSymbol)((Object)this.symbol)).getThickness() - ((CompartmentSymbol)((Object)this.symbol)).getMembrane().getInnerLineWidth() / 2.0 - (double)nameImageSize.height;
        if (dRtn > dMaxY) {
            dRtn = dMaxY;
        }
        if (dRtn < dMinY) {
            dRtn = dMinY;
        }
        return dRtn;
    }

    public double getNameImageAvailableDrawAreaLeft() {
        Rectangle2D.Double myBounds = super.getFrameBounds();
        Dimension nameImageSize = this.nameImage.getNameImageSize();
        double dOldNameImageWidth = nameImageSize.width;
        if (nameImageSize.width > NameImage.getVirtualMoveableNameImageFrameDimension().width) {
            nameImageSize.width = NameImage.getVirtualMoveableNameImageFrameDimension().width;
        }
        double dMinX = 0.0;
        double dRtn = myBounds.x + ((CompartmentSymbol)((Object)this.symbol)).getThickness() + ((CompartmentSymbol)((Object)this.symbol)).getMembrane().getInnerLineWidth() / 2.0 - (dOldNameImageWidth - (double)nameImageSize.width) / 2.0;
        if (this.symbol instanceof CompartmentSquare) {
            dRtn += 5.0;
        }
        if (dRtn < dMinX) {
            dRtn = dMinX;
        }
        return dRtn;
    }

    public double getNameImageAvailableDrawAreaRight() {
        double dMinX = 0.0;
        double dMaxX = 0.0;
        Rectangle2D.Double myMaxArea = this.getMaxArea();
        if (myMaxArea != null && myMaxArea.width > 0.0) {
            dMaxX = myMaxArea.width;
        } else {
            try {
                dMaxX = MainWindow.getLastInstance().getCurrentModel().getModelSize().getWidth();
            }
            catch (Exception myErr) {
                return 0.0;
            }
        }
        Rectangle2D.Double myBounds = super.getFrameBounds();
        Dimension nameImageSize = this.nameImage.getNameImageSize();
        Dimension realNameImageSize = (Dimension)nameImageSize.clone();
        double dRealNameImageWidth = realNameImageSize.width;
        if (nameImageSize.width > NameImage.getVirtualMoveableNameImageFrameDimension().width) {
            nameImageSize.width = NameImage.getVirtualMoveableNameImageFrameDimension().width;
        }
        Dimension movableareaNameImageSize = (Dimension)nameImageSize.clone();
        dMaxX -= (double)realNameImageSize.width;
        double dRtn = myBounds.x + myBounds.width - ((CompartmentSymbol)((Object)this.symbol)).getThickness() - ((CompartmentSymbol)((Object)this.symbol)).getMembrane().getInnerLineWidth() / 2.0 - dRealNameImageWidth / 2.0 - (double)nameImageSize.width / 2.0;
        if (this.symbol instanceof CompartmentSquare) {
            dRtn -= 3.0;
        }
        if (dRtn > dMaxX) {
            dRtn = dMaxX;
        }
        if (dRtn < dMinX) {
            dRtn = dMinX;
        }
        return dRtn;
    }

    @Override
    public Point2D.Double recalCompartmentNameDisplayPostion(Point2D.Double pos) {
        if (this.symbol instanceof CompartmentOval) {
            Rectangle2D.Double myBounds = super.getFrameBounds();
            Dimension nameImageSize = this.nameImage.getNameImageSize();
            Dimension realNameImageSize = (Dimension)nameImageSize.clone();
            if (nameImageSize.width > NameImage.getVirtualMoveableNameImageFrameDimension().width) {
                nameImageSize.width = NameImage.getVirtualMoveableNameImageFrameDimension().width;
            }
            Dimension movableareaNameImageSize = (Dimension)nameImageSize.clone();
            double dNewX = pos.x + (double)realNameImageSize.width / 2.0 - (double)movableareaNameImageSize.width / 2.0;
            double dNewY = pos.y + (double)realNameImageSize.height / 2.0 - (double)movableareaNameImageSize.height / 2.0;
            Point2D.Double pntInput = new Point2D.Double(dNewX, dNewY);
            Point2D.Double pntFrameCenter = new Point2D.Double(myBounds.getCenterX(), myBounds.getCenterY());
            Point2D.Double pntDefaultNameImgLeftTop = new Point2D.Double(myBounds.getCenterX() - (double)(nameImageSize.width / 2), myBounds.getCenterY() - (double)(nameImageSize.height / 2));
            double dWF = myBounds.width - ((CompartmentSymbol)((Object)this.symbol)).getThickness() * 2.0 - ((CompartmentSymbol)((Object)this.symbol)).getMembrane().getInnerLineWidth();
            double dHF = myBounds.height - ((CompartmentSymbol)((Object)this.symbol)).getThickness() * 2.0 - ((CompartmentSymbol)((Object)this.symbol)).getMembrane().getInnerLineWidth();
            if (dWF < (double)nameImageSize.width) {
                return this.setNameImagePositionWithOffset(pntDefaultNameImgLeftTop, realNameImageSize, movableareaNameImageSize);
            }
            if (dHF < (double)nameImageSize.height) {
                return this.setNameImagePositionWithOffset(pntDefaultNameImgLeftTop, realNameImageSize, movableareaNameImageSize);
            }
            double dMovedX = pntFrameCenter.x;
            double dMovedY = pntFrameCenter.y;
            double dEclipseA = dWF / 2.0;
            double dEclipseB = dHF / 2.0;
            double dWf = nameImageSize.width;
            double dHf = nameImageSize.height;
            Point2D.Double pntOofNameImageATnewXY = new Point2D.Double(pntInput.x + dWf / 2.0 - dMovedX, pntInput.y + dHf / 2.0 - dMovedY);
            Point2D.Double pntAofNameImageATnewXY = new Point2D.Double(pntOofNameImageATnewXY.x - dWf / 2.0, pntOofNameImageATnewXY.y - dHf / 2.0);
            Point2D.Double pntBofNameImageATnewXY = new Point2D.Double(pntAofNameImageATnewXY.x + dWf, pntAofNameImageATnewXY.y);
            Point2D.Double pntCofNameImageATnewXY = new Point2D.Double(pntAofNameImageATnewXY.x, pntAofNameImageATnewXY.y + dHf);
            Point2D.Double pntDofNameImageATnewXY = new Point2D.Double(pntAofNameImageATnewXY.x + dWf, pntAofNameImageATnewXY.y + dHf);
            double dResult = this.calPointEclipseRelation(new Point2D.Double(dWf / 2.0, dHf / 2.0), dEclipseA, dEclipseB);
            if (dResult >= 1.0) {
                return this.setNameImagePositionWithOffset(pntDefaultNameImgLeftTop, realNameImageSize, movableareaNameImageSize);
            }
            Point2D.Double pnt11 = new Point2D.Double(this.getXineclipsebyY(dHf / 2.0, dEclipseA, dEclipseB), dHf / 2.0);
            Point2D.Double pnt42 = new Point2D.Double(pnt11.x, -1.0 * pnt11.y);
            Point2D.Double pnt22 = new Point2D.Double(-1.0 * pnt11.x, pnt11.y);
            Point2D.Double pnt31 = new Point2D.Double(-1.0 * pnt11.x, -1.0 * pnt11.y);
            Point2D.Double pnt12 = new Point2D.Double(dWf / 2.0, this.getYineclipsebyX(dWf / 2.0, dEclipseA, dEclipseB));
            Point2D.Double pnt21 = new Point2D.Double(-1.0 * pnt12.x, pnt12.y);
            Point2D.Double pnt32 = new Point2D.Double(-1.0 * pnt12.x, -1.0 * pnt12.y);
            Point2D.Double pnt41 = new Point2D.Double(pnt12.x, -1.0 * pnt12.y);
            double Ymax = pnt12.y;
            double Ymin = pnt32.y;
            double Xmax = pnt11.x;
            double Xmin = pnt31.x;
            double dLen1 = this.calPointEclipseRelation(pntAofNameImageATnewXY, dEclipseA, dEclipseB);
            double dLen2 = this.calPointEclipseRelation(pntBofNameImageATnewXY, dEclipseA, dEclipseB);
            double dLen3 = this.calPointEclipseRelation(pntCofNameImageATnewXY, dEclipseA, dEclipseB);
            double dLen4 = this.calPointEclipseRelation(pntDofNameImageATnewXY, dEclipseA, dEclipseB);
            double dONE = 1.00001;
            if (dLen1 <= dONE && dLen2 <= dONE && dLen3 <= dONE && dLen4 <= dONE) {
                return this.setNameImagePositionWithOffset(new Point2D.Double(pntAofNameImageATnewXY.x + dMovedX, pntAofNameImageATnewXY.y + dMovedY), realNameImageSize, movableareaNameImageSize);
            }
            String strSyouGen = "";
            if (pntOofNameImageATnewXY.x == 0.0 && pntOofNameImageATnewXY.y == 0.0) {
                strSyouGen = "P00";
                return this.setNameImagePositionWithOffset(pntDefaultNameImgLeftTop, realNameImageSize, movableareaNameImageSize);
            }
            if (pntOofNameImageATnewXY.x > -1.0 * dWf / 2.0 && pntOofNameImageATnewXY.x < dWf / 2.0) {
                if (pntOofNameImageATnewXY.y > 0.0) {
                    strSyouGen = "+Y";
                    if (pntCofNameImageATnewXY.y >= Ymax) {
                        return this.setNameImagePositionWithOffset(new Point2D.Double(pnt21.x + dMovedX, pnt21.y - dHf + dMovedY), realNameImageSize, movableareaNameImageSize);
                    }
                } else {
                    strSyouGen = "-Y";
                    if (pntAofNameImageATnewXY.y <= Ymin) {
                        return this.setNameImagePositionWithOffset(new Point2D.Double(pnt32.x + dMovedX, pnt32.y + dMovedY), realNameImageSize, movableareaNameImageSize);
                    }
                }
            } else if (pntOofNameImageATnewXY.y > -1.0 * dHf && pntOofNameImageATnewXY.y < dHf) {
                if (pntOofNameImageATnewXY.x > 0.0) {
                    strSyouGen = "+X";
                    if (pntDofNameImageATnewXY.x > Xmax) {
                        return this.setNameImagePositionWithOffset(new Point2D.Double(pnt42.x - dWf + dMovedX, pnt42.y + dMovedY), realNameImageSize, movableareaNameImageSize);
                    }
                } else {
                    strSyouGen = "-X";
                    if (pntAofNameImageATnewXY.x < Xmin) {
                        return this.setNameImagePositionWithOffset(new Point2D.Double(pnt31.x + dMovedX, pnt31.y + dMovedY), realNameImageSize, movableareaNameImageSize);
                    }
                }
            }
            if (pntOofNameImageATnewXY.x >= 0.0 && pntOofNameImageATnewXY.y >= 0.0) {
                strSyouGen = "I";
            } else if (pntOofNameImageATnewXY.x < 0.0 && pntOofNameImageATnewXY.y >= 0.0) {
                strSyouGen = "II";
            } else if (pntOofNameImageATnewXY.x < 0.0 && pntOofNameImageATnewXY.y < 0.0) {
                strSyouGen = "III";
            } else if (pntOofNameImageATnewXY.x >= 0.0 && pntOofNameImageATnewXY.y < 0.0) {
                strSyouGen = "IV";
            }
            Point2D.Double pntforCal = new Point2D.Double(0.0, 0.0);
            if (strSyouGen.equals("I")) {
                pntforCal = new Point2D.Double(pntDofNameImageATnewXY.x, pntDofNameImageATnewXY.y);
            } else if (strSyouGen.equals("II")) {
                pntforCal = new Point2D.Double(-1.0 * pntCofNameImageATnewXY.x, pntCofNameImageATnewXY.y);
            } else if (strSyouGen.equals("III")) {
                pntforCal = new Point2D.Double(-1.0 * pntAofNameImageATnewXY.x, -1.0 * pntAofNameImageATnewXY.y);
            } else if (strSyouGen.equals("IV")) {
                pntforCal = new Point2D.Double(pntBofNameImageATnewXY.x, -1.0 * pntBofNameImageATnewXY.y);
            }
            Point2D.Double pntSyougenIRightTop = this.getPointINeclipseByapoint(pntforCal, dEclipseA, dEclipseB);
            if (strSyouGen.equals("I")) {
                pntforCal = new Point2D.Double(pntSyougenIRightTop.x, pntSyougenIRightTop.y);
                return this.setNameImagePositionWithOffset(new Point2D.Double(pntforCal.x - dWf + dMovedX, pntforCal.y - dHf + dMovedY), realNameImageSize, movableareaNameImageSize);
            }
            if (strSyouGen.equals("II")) {
                pntforCal = new Point2D.Double(-1.0 * pntSyougenIRightTop.x, pntSyougenIRightTop.y);
                return this.setNameImagePositionWithOffset(new Point2D.Double(pntforCal.x + dMovedX, pntforCal.y - dHf + dMovedY), realNameImageSize, movableareaNameImageSize);
            }
            if (strSyouGen.equals("III")) {
                pntforCal = new Point2D.Double(-1.0 * pntSyougenIRightTop.x, -1.0 * pntSyougenIRightTop.y);
                return this.setNameImagePositionWithOffset(new Point2D.Double(pntforCal.x + dMovedX, pntforCal.y + dMovedY), realNameImageSize, movableareaNameImageSize);
            }
            if (strSyouGen.equals("IV")) {
                pntforCal = new Point2D.Double(pntSyougenIRightTop.x, -1.0 * pntSyougenIRightTop.y);
                return this.setNameImagePositionWithOffset(new Point2D.Double(pntforCal.x - dWf + dMovedX, pntforCal.y + dMovedY), realNameImageSize, movableareaNameImageSize);
            }
            return this.setNameImagePositionWithOffset(pntDefaultNameImgLeftTop, realNameImageSize, movableareaNameImageSize);
        }
        double newX = pos.x;
        double newY = pos.y;
        double dLeft = this.getNameImageAvailableDrawAreaLeft();
        double dRight = this.getNameImageAvailableDrawAreaRight();
        double dTop = this.getNameImageAvailableDrawAreaTop();
        double dBottom = this.getNameImageAvailableDrawAreaBottom();
        if (this.enoughtoPlaceNameString().equals("00")) {
            newX = this.getCompartmentNameCenterDisplayPostion().x;
            newY = this.getCompartmentNameCenterDisplayPostion().y;
        } else if (this.enoughtoPlaceNameString().equals("01")) {
            newX = this.getCompartmentNameCenterDisplayPostion().x;
            if (pos.y < dTop) {
                newY = dTop;
            }
            if (pos.y > dBottom) {
                newY = dBottom;
            }
        } else if (this.enoughtoPlaceNameString().equals("10")) {
            if (pos.x < dLeft) {
                newX = dLeft;
            }
            if (pos.x > dRight) {
                newX = dRight;
            }
            newY = this.getCompartmentNameCenterDisplayPostion().y;
        } else {
            if (pos.x < dLeft) {
                newX = dLeft;
            }
            if (pos.x > dRight) {
                newX = dRight;
            }
            if (pos.y < dTop) {
                newY = dTop;
            }
            if (pos.y > dBottom) {
                newY = dBottom;
            }
        }
        Point2D.Double newPnt = this.makeNameImageLeftTopPointInDrawAreaDimension(new Point2D.Double(newX, newY));
        newX = newPnt.x;
        newY = newPnt.y;
        this.setNameImagePosition(newX, newY);
        Point2D.Double rtn = new Point2D.Double(newX, newY);
        return rtn;
    }

    private Point2D.Double getPointINeclipseByapoint(Point2D.Double pnt, double dEclipseA, double dEclipseB) {
        double dYdivX = pnt.y / pnt.x;
        double dXinEclipse = Math.sqrt(dEclipseA * dEclipseA * dEclipseB * dEclipseB / (dEclipseB * dEclipseB + dEclipseA * dEclipseA * dYdivX * dYdivX));
        double dYinEclipse = dXinEclipse * dYdivX;
        return new Point2D.Double(dXinEclipse, dYinEclipse);
    }

    private double getYineclipsebyX(double x, double dEclipseA, double dEclipseB) {
        return dEclipseB / dEclipseA * Math.sqrt(dEclipseA * dEclipseA - x * x);
    }

    private double getXineclipsebyY(double y, double dEclipseA, double dEclipseB) {
        return dEclipseA / dEclipseB * Math.sqrt(dEclipseB * dEclipseB - y * y);
    }

    private double calPointEclipseRelation(Point2D.Double pnt, double dEclipseA, double dEclipseB) {
        return pnt.x * pnt.x / (dEclipseA * dEclipseA) + pnt.y * pnt.y / (dEclipseB * dEclipseB);
    }

    public boolean isNamePositionBuilded() {
        return this.isNamePositionBuilded;
    }

    private void setNamePositionBuildedFlg(boolean flg) {
        this.isNamePositionBuilded = flg;
    }

    private void namePositionBuilded() {
        this.isNamePositionBuilded = true;
    }

    @Override
    public Rectangle2D.Double getInnerBound() {
        CompartmentSymbol csymbol = (CompartmentSymbol)((Object)this.symbol);
        double thickness = csymbol.getThickness();
        Rectangle2D.Double bounds = (Rectangle2D.Double)this.getFrameBounds().clone();
        return new Rectangle2D.Double(bounds.x + (thickness += csymbol.getMembrane().getInnerLineWidth() + csymbol.getMembrane().getOuterLineWidth()), bounds.y + thickness, bounds.width - 2.0 * thickness, bounds.height - 2.0 * thickness);
    }

    public void resetCompartmentNameWithNewNameDefaultPostion(String input) {
        try {
            String name = "";
            if (input != null) {
                name = input;
            }
            if (this.nameImage == null || this.nameImage.getIDString() == null) {
                this.setCompartmentName(name);
                return;
            }
            if (name.equals(this.nameImage.getString())) {
                this.resetNameImgPostionToDefaultPostion();
                return;
            }
            this.nameImage = null;
            this.setCompartmentName(name);
            return;
        }
        catch (Exception myErr) {
            return;
        }
    }

    public void resetNameImgPostionToDefaultPostion() {
        if (this.nameImage == null) {
            return;
        }
        Dimension nameImageSize = this.nameImage.getNameImageSize();
        Dimension realNameImageSize = (Dimension)nameImageSize.clone();
        if (nameImageSize.width > NameImage.getVirtualMoveableNameImageFrameDimension().width) {
            nameImageSize.width = NameImage.getVirtualMoveableNameImageFrameDimension().width;
        }
        Dimension movableareaNameImageSize = (Dimension)nameImageSize.clone();
        Point2D.Double pnt = this.setNameImagePositionWithOffset(this.getDefaultCompartmentNamePostion(), realNameImageSize, movableareaNameImageSize);
        if (pnt != null) {
            this.nameImage.setFramePositionWithoutRecalcPostion(pnt.x, pnt.y);
        }
    }

    public Point2D.Double setNameImagePositionWithOffset(Point2D.Double pos, Dimension realNameImageSize, Dimension movableareaNameImageSize) {
        if (pos == null) {
            return null;
        }
        if (realNameImageSize == null) {
            return null;
        }
        if (movableareaNameImageSize == null) {
            return null;
        }
        double dNewX = pos.x + (double)movableareaNameImageSize.width / 2.0 - (double)realNameImageSize.width / 2.0;
        double dNewY = pos.y + (double)movableareaNameImageSize.height / 2.0 - (double)realNameImageSize.height / 2.0;
        Point2D.Double newPnt = this.makeNameImageLeftTopPointInDrawAreaDimension(new Point2D.Double(dNewX, dNewY));
        this.setNameImagePosition(newPnt);
        return newPnt;
    }

    private Point2D.Double makeNameImageLeftTopPointInDrawAreaDimension(Point2D.Double inputPnt) {
        Point2D.Double rtn = null;
        Dimension dimsion = null;
        try {
            dimsion = new Dimension((int)this.getMaxArea().width, (int)this.getMaxArea().height);
            rtn = GStructure.makeGElementLeftTopPointInDrawAreaDimension(dimsion, this.nameImage, inputPnt, dimsion);
        }
        catch (Exception myErr) {
            return inputPnt;
        }
        return rtn;
    }

    private Point2D.Double makeClosedCompartmentLeftTopPointInDrawAreaDimension(Point2D.Double inputPnt) {
        Point2D.Double rtn = null;
        Dimension dimsion = null;
        try {
            dimsion = new Dimension((int)this.getMaxArea().width, (int)this.getMaxArea().height);
            rtn = GStructure.makeGElementLeftTopPointInDrawAreaDimension(dimsion, this, inputPnt, dimsion);
        }
        catch (Exception myErr) {
            return inputPnt;
        }
        return rtn;
    }

    @Override
    public void backupNameImagePositionBeforeChangeCompartment() {
        if (this.nameImage != null) {
            this.nameImage.backupPositionBeforeChangeCompartment();
        }
        Vector targets = this.getTargets();
        int size = targets.size();
        int i = 0;
        while (i < size) {
            if (targets.elementAt(i) instanceof CompartmentAlias) {
                ((CompartmentAlias)targets.elementAt(i)).backupNameImagePositionBeforeChangeCompartment();
            }
            ++i;
        }
    }

    @Override
    public Rectangle2D restoreNameImagePositionAfterChangeCompartmentCancled() {
        Rectangle2D.Double redrawArea = null;
        Rectangle2D rec = null;
        if (this.nameImage != null) {
            rec = this.nameImage.restorePositionAfterChangeCompartmentCancled();
            redrawArea = GUtil.union(redrawArea, rec);
        }
        Vector targets = this.getTargets();
        int size = targets.size();
        int i = 0;
        while (i < size) {
            if (targets.elementAt(i) instanceof CompartmentAlias) {
                rec = ((CompartmentAlias)targets.elementAt(i)).restoreNameImagePositionAfterChangeCompartmentCancled();
                redrawArea = GUtil.union(redrawArea, rec);
            }
            ++i;
        }
        return redrawArea;
    }

    @Override
    public Rectangle2D.Double getCompartmentMaxRepaintBounds() {
        Rectangle2D.Double rectUnBounds = null;
        Rectangle2D.Double rectCmpFrm = this.getFrameBounds();
        Rectangle2D.Double rectNmImgBounds = null;
        try {
            rectNmImgBounds = this.getCompartmentNameImage().getBounds();
            rectUnBounds = GUtil.union(rectCmpFrm, rectNmImgBounds);
            Vector targets = this.getTargets();
            int i = 0;
            while (targets != null && i < targets.size()) {
                GContainerTarget target = (GContainerTarget)targets.get(i);
                if (target instanceof ClosedCompartmentAlias) {
                    rectUnBounds = GUtil.union(rectUnBounds, ((ClosedCompartmentAlias)target).getCompartmentMaxRepaintBounds());
                }
                ++i;
            }
            if (this.infoBox != null) {
                rectUnBounds = GUtil.union(rectUnBounds, this.infoBox.getRepaintBounds());
            }
        }
        catch (Exception myErr) {
            rectUnBounds = rectCmpFrm;
        }
        return rectUnBounds;
    }

    @Override
    public void setCompartmentInitSize(double size) {
        this.compartmentInitSize = size;
    }

    @Override
    public double getCompartmentInitSize() {
        return this.compartmentInitSize;
    }

    @Override
    public void setCompartmentHasInitSizeFlg(boolean flg) {
        this.bIsCompartmentHasInitSize = flg;
    }

    @Override
    public boolean IsCompartmentHasInitSize() {
        return this.bIsCompartmentHasInitSize;
    }

    @Override
    public InformationBox getInfoBox() {
        return this.infoBox;
    }

    @Override
    public void setInfoBox(InformationBox infoBox) {
        this.infoBox = infoBox;
    }

    @Override
    public Point2D.Double getInfoBoxCenterPointByAngle(double agl) {
        double inputangle = LibSBMLUtil.changetoStandandAngle(agl);
        Area areaSearching = new Area(((CompartmentSymbol)((Object)this.symbol)).getOutterShape());
        Rectangle2D.Double myBounds = super.getFrameBounds();
        double dWidthOfInputArea = areaSearching.getBounds2D().getWidth();
        double dHeightOfInputArea = areaSearching.getBounds2D().getHeight();
        double dRofInputArea = Math.sqrt(dWidthOfInputArea * dWidthOfInputArea + dHeightOfInputArea * dHeightOfInputArea);
        double dNewX = Math.cos(inputangle) * dRofInputArea + myBounds.getCenterX();
        double dNewY = Math.sin(inputangle) * dRofInputArea + myBounds.getCenterY();
        Point2D.Double pnt01 = new Point2D.Double(dNewX, dNewY);
        return LibSBMLUtil.calPntInEdgeOfAreaBy1Pnts(areaSearching, null, pnt01, 0.5, 1);
    }

    @Override
    public Point2D.Double recalInfoBoxDisplayPostion(Point2D.Double pos) {
        Area areaSearching = new Area(((CompartmentSymbol)((Object)this.symbol)).getOutterShape());
        return LibSBMLUtil.calPntInEdgeOfAreaBy1Pnts(areaSearching, null, new Point2D.Double(pos.x, pos.y), 0.5, 1);
    }
}

