/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.CelldPanel;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;
import jp.sbi.celldesigner.CelldCellEditor.MiriamListingEditor.DatatypeComboCellEditor;
import jp.sbi.celldesigner.CelldCellEditor.MiriamListingEditor.RelationComboCellEditor;
import jp.sbi.celldesigner.CelldEventProcesser.CellDataProcesser;
import jp.sbi.celldesigner.CelldEventProcesser.CellViewerProcesser;
import jp.sbi.celldesigner.CelldTable.MiriamListingTable;
import jp.sbi.celldesigner.CelldTable.MiriamLstTable.MiriamLstTableModel;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MiriamMainPanel;
import jp.sbi.celldesigner.miriam.MIRIAM;
import jp.sbi.celldesigner.miriam.MiriamUtils;
import jp.sbi.celldesigner.util.ReturnValue;
import jp.sbi.sbml.MiriamDefinition;
import jp.sbi.sbml.MiriamSubDefinition;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.SBase;

public class MiriamListingEditorPanel
extends JPanel
implements CellDataProcesser,
CellViewerProcesser {
    private JScrollPane jScrollPane = null;
    private MiriamListingTable jTableMiriamEditor = null;
    private Window parentWindow = null;
    private SBase editingSBase = null;
    private Vector miriamdatas = new Vector();
    protected boolean inProcessingEvent = false;

    public MiriamListingEditorPanel(Window parent) {
        this.parentWindow = parent;
        this.setBounds(new Rectangle(0, 0, 740, 280));
        this.setLayout(null);
        this.add((Component)this.getJScrollPane(), null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                try {
                    if (MiriamListingEditorPanel.this.jTableMiriamEditor.isEditing()) {
                        MiriamListingEditorPanel.this.jTableMiriamEditor.editingStopped(new ChangeEvent(this));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane(22, 30);
            this.jScrollPane.setBounds(new Rectangle(5, 5, 730, 272));
            this.jScrollPane.getViewport().add((Component)this.getJTableMiriamEditor(), null);
            this.jScrollPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    try {
                        MiriamListingEditorPanel.this.noticeEditingStopped(MiriamListingEditorPanel.this.jScrollPane);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return this.jScrollPane;
    }

    public MiriamListingTable getJTableMiriamEditor() {
        if (this.jTableMiriamEditor == null) {
            this.jTableMiriamEditor = new MiriamListingTable();
            this.jTableMiriamEditor.setSelectionMode(0);
            this.jTableMiriamEditor.getTableHeader().setReorderingAllowed(false);
            this.jTableMiriamEditor.setRowHeight(25);
            this.initTableModel();
            this.initTableData(this.miriamdatas);
        }
        return this.jTableMiriamEditor;
    }

    public Window getParentWindow() {
        return this.parentWindow;
    }

    public Vector getMiriamDatas() {
        return this.miriamdatas;
    }

    public void initTableModel() {
        MiriamLstTableModel tablemodel = new MiriamLstTableModel(this.jTableMiriamEditor);
        this.jTableMiriamEditor.setModel(tablemodel);
        tablemodel.resetModel(this);
    }

    public void initTableData(SBase sbase) {
        Vector<String[]> miriamdatas = null;
        Vector vecDatas = LibSBMLUtil.getMiriamDatasFromAnnotationOfSBase(sbase);
        if (vecDatas == null || vecDatas.size() <= 0) {
            miriamdatas = null;
        } else {
            miriamdatas = new Vector<String[]>();
            int iColCount = this.jTableMiriamEditor.getColumnCount();
            int i = 0;
            while (i < vecDatas.size()) {
                MiriamDefinition miriam = (MiriamDefinition)vecDatas.get(i);
                String relation = miriam.getRelation();
                Vector subdatas = miriam.getDatas();
                int iSubDataCount = subdatas.size();
                int j = 0;
                while (j < iSubDataCount) {
                    String utfId;
                    String[] aRowData = new String[iColCount];
                    int k = 0;
                    while (k < iColCount) {
                        aRowData[k] = "";
                        ++k;
                    }
                    MiriamSubDefinition singleDate = (MiriamSubDefinition)subdatas.get(j);
                    aRowData[0] = Integer.toString(i + 1);
                    aRowData[1] = Integer.toString(j + 1);
                    aRowData[2] = relation;
                    aRowData[3] = singleDate.strDataType;
                    aRowData[4] = utfId = MiriamUtils.changeMiriamIdFormat(singleDate.strId, false);
                    aRowData[5] = new String("A");
                    aRowData[6] = new String("D");
                    aRowData[7] = new String("R");
                    aRowData[8] = new String("S");
                    miriamdatas.add(aRowData);
                    ++j;
                }
                ++i;
            }
        }
        this.initTableData(miriamdatas);
    }

    public void initTableData(Vector newdatas) {
        try {
            try {
                this.jTableMiriamEditor.cancelEditing(new ChangeEvent(this));
            }
            catch (Exception exception) {
                // empty catch block
            }
            MiriamLstTableModel tablemodel = (MiriamLstTableModel)this.jTableMiriamEditor.getModel();
            try {
                int i = this.miriamdatas.size() - 1;
                while (i >= 0) {
                    tablemodel.removeRow(i);
                    --i;
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            this.miriamdatas = newdatas;
            if (this.miriamdatas != null) {
                int i = 0;
                while (i < this.miriamdatas.size()) {
                    tablemodel.addRow((String[])this.miriamdatas.get(i));
                    ++i;
                }
            }
        }
        catch (Exception myErr) {
            this.initTableModel();
            this.miriamdatas = null;
        }
    }

    @Override
    public boolean isFirstDataOfARecords(int row, int col) {
        block12: {
            block13: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                try {
                                    if (this.miriamdatas != null && this.miriamdatas.size() > 0) break block8;
                                    return false;
                                }
                                catch (Exception exception) {
                                    return false;
                                }
                            }
                            if (row >= 0) break block9;
                            return false;
                        }
                        if (row < this.miriamdatas.size()) break block10;
                        return false;
                    }
                    if (this.miriamdatas.size() != 1) break block11;
                    if (row == 0) {
                        return true;
                    }
                    break block12;
                }
                if (row != 0) break block13;
                return true;
            }
            String valueCurr = ((String[])this.miriamdatas.get(row))[0];
            String valuePrev = ((String[])this.miriamdatas.get(row - 1))[0];
            if (valueCurr == null || valuePrev == null || valueCurr.equals(valuePrev)) break block12;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLastDataOfARecords(int row, int col) {
        block4: {
            if (row + 1 != this.miriamdatas.size()) break block4;
            return true;
        }
        try {
            String valueCurr = ((String[])this.miriamdatas.get(row))[0];
            String valueNext = ((String[])this.miriamdatas.get(row + 1))[0];
            int iValueCurr = Integer.parseInt(valueCurr);
            int iValueNext = Integer.parseInt(valueNext);
            if (iValueCurr != iValueNext) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void resetPanelFromObject() {
        this.setPanelFromObject(this.editingSBase);
    }

    public void setPanelFromObject(SBase sbase) {
        this.editingSBase = sbase;
        this.initTableData((Vector)null);
        this.initTableData(sbase);
    }

    public void updateObjectFromDialog(Object newdatas) {
        if (newdatas == null) {
            MiriamMainPanel.updateSBaseAnnotation(this.editingSBase, new Vector());
        } else if (newdatas instanceof Vector) {
            MiriamMainPanel.updateSBaseAnnotation(this.editingSBase, (Vector)newdatas);
        }
    }

    public void noticeEditingStopped(Object source) {
        try {
            if (this.jTableMiriamEditor != null && this.jTableMiriamEditor.isEditing()) {
                this.jTableMiriamEditor.editingStopped(new ChangeEvent(source));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void repaintTable(Object any) {
    }

    @Override
    public void UpdateTableRealData(int row, int col, Object value) {
        block19: {
            String strNewValue = "";
            if (value != null) {
                strNewValue = value.toString();
            }
            try {
                if (col != 2) {
                    String[] aRow = (String[])this.miriamdatas.get(row);
                    if (!strNewValue.equals(aRow[col])) {
                        aRow[col] = strNewValue;
                        ((DefaultTableModel)this.jTableMiriamEditor.getModel()).setValueAt(strNewValue, row, col);
                    }
                    break block19;
                }
                if (this.inProcessingEvent) break block19;
                this.inProcessingEvent = true;
                try {
                    try {
                        this.jTableMiriamEditor.setIgnoreRepaint(true);
                        try {
                            try {
                                String[] aRowData = (String[])this.miriamdatas.get(row);
                                String strNo1 = aRowData[0];
                                int i = 0;
                                while (i < this.miriamdatas.size()) {
                                    try {
                                        String[] aRow = (String[])this.miriamdatas.get(i);
                                        if (aRow != null && aRow[0] != null && aRow[0].equals(strNo1) && !strNewValue.equals(aRow[col])) {
                                            aRow[col] = strNewValue;
                                            ((DefaultTableModel)this.jTableMiriamEditor.getModel()).setValueAt(strNewValue, i, col);
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    ++i;
                                }
                            }
                            catch (Exception exception) {
                                this.jTableMiriamEditor.setIgnoreRepaint(false);
                                this.jTableMiriamEditor.repaint();
                            }
                        }
                        finally {
                            this.jTableMiriamEditor.setIgnoreRepaint(false);
                            this.jTableMiriamEditor.repaint();
                        }
                    }
                    catch (Exception exception) {
                        this.inProcessingEvent = false;
                    }
                }
                finally {
                    this.inProcessingEvent = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void AddARelationRealData(int targetRowNum) {
        if (!this.inProcessingEvent) {
            this.inProcessingEvent = true;
            try {
                try {
                    int iColumnCount = ((DefaultTableModel)this.jTableMiriamEditor.getModel()).getColumnCount();
                    Object[] aNewRowData = new String[iColumnCount];
                    int iValueCurr = -1;
                    if (this.miriamdatas == null) {
                        this.miriamdatas = new Vector();
                        iValueCurr = 0;
                    } else if (this.miriamdatas.size() == 0) {
                        iValueCurr = 0;
                    } else {
                        String[] lastRowData = (String[])this.miriamdatas.get(this.miriamdatas.size() - 1);
                        iValueCurr = Integer.parseInt(lastRowData[0]);
                    }
                    int iValueNext = iValueCurr + 1;
                    aNewRowData[0] = "" + iValueNext;
                    aNewRowData[1] = "1";
                    RelationComboCellEditor relcombo = new RelationComboCellEditor(null);
                    aNewRowData[2] = new String(relcombo.getFirstValidDataInListbox());
                    DatatypeComboCellEditor dtpcombo = new DatatypeComboCellEditor(null);
                    aNewRowData[3] = new String(dtpcombo.getFirstValidDataInListbox());
                    aNewRowData[4] = "";
                    aNewRowData[5] = new String("A");
                    aNewRowData[6] = new String("D");
                    aNewRowData[7] = new String("R");
                    aNewRowData[8] = new String("S");
                    this.miriamdatas.add(aNewRowData);
                    ((DefaultTableModel)this.jTableMiriamEditor.getModel()).insertRow(targetRowNum, aNewRowData);
                    this.jTableMiriamEditor.setRowSelectionInterval(targetRowNum, targetRowNum);
                }
                catch (Exception exception) {
                    this.inProcessingEvent = false;
                }
            }
            finally {
                this.inProcessingEvent = false;
            }
        }
    }

    @Override
    public void AddADatatypeRealData(int currRowNum) {
        if (!this.inProcessingEvent) {
            this.inProcessingEvent = true;
            try {
                try {
                    String[] aRowData = (String[])this.miriamdatas.get(currRowNum);
                    Object[] aNewRowData = new String[aRowData.length];
                    aNewRowData[0] = new String(aRowData[0]);
                    int iValueCurr = Integer.parseInt(aRowData[1]);
                    int iValueNext = iValueCurr + 1;
                    aNewRowData[1] = "" + iValueNext;
                    aNewRowData[2] = new String(aRowData[2]);
                    aNewRowData[3] = new String(aRowData[3]);
                    aNewRowData[4] = "";
                    aNewRowData[5] = new String("A");
                    aNewRowData[6] = new String("D");
                    aNewRowData[7] = new String("R");
                    aNewRowData[8] = new String("S");
                    int iNewRowNum = currRowNum + 1;
                    this.miriamdatas.add(iNewRowNum, aNewRowData);
                    ((DefaultTableModel)this.jTableMiriamEditor.getModel()).insertRow(iNewRowNum, aNewRowData);
                    this.jTableMiriamEditor.setRowSelectionInterval(iNewRowNum, iNewRowNum);
                }
                catch (Exception exception) {
                    this.inProcessingEvent = false;
                }
            }
            finally {
                this.inProcessingEvent = false;
            }
        }
    }

    @Override
    public void RemoveARelationRealData(int currRowNum) {
        if (!this.inProcessingEvent) {
            this.inProcessingEvent = true;
            try {
                try {
                    this.jTableMiriamEditor.setIgnoreRepaint(true);
                    try {
                        try {
                            String[] aRowData = (String[])this.miriamdatas.get(currRowNum);
                            String strNo1 = aRowData[0];
                            int i = this.miriamdatas.size() - 1;
                            while (i >= 0) {
                                try {
                                    String[] aRow = (String[])this.miriamdatas.get(i);
                                    if (aRow != null && aRow[0] != null && aRow[0].equals(strNo1)) {
                                        this.miriamdatas.remove(i);
                                        ((DefaultTableModel)this.jTableMiriamEditor.getModel()).removeRow(i);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                --i;
                            }
                            this.jTableMiriamEditor.clearSelection();
                        }
                        catch (Exception exception) {
                            this.jTableMiriamEditor.setIgnoreRepaint(false);
                            this.jTableMiriamEditor.repaint();
                        }
                    }
                    finally {
                        this.jTableMiriamEditor.setIgnoreRepaint(false);
                        this.jTableMiriamEditor.repaint();
                    }
                }
                catch (Exception exception) {
                    this.inProcessingEvent = false;
                }
            }
            finally {
                this.inProcessingEvent = false;
            }
        }
    }

    @Override
    public void RemoveADatatypeRealData(int currRowNum) {
        if (!this.inProcessingEvent) {
            this.inProcessingEvent = true;
            try {
                try {
                    this.miriamdatas.remove(currRowNum);
                    ((DefaultTableModel)this.jTableMiriamEditor.getModel()).removeRow(currRowNum);
                    this.jTableMiriamEditor.clearSelection();
                }
                catch (Exception exception) {
                    this.inProcessingEvent = false;
                }
            }
            finally {
                this.inProcessingEvent = false;
            }
        }
    }

    public ReturnValue inputChecker() {
        int i;
        MIRIAM miriam = MainWindow.getInstanceOfMIRIAM();
        boolean haveErr = false;
        ReturnValue rtn = new ReturnValue();
        Vector vectErrs = new Vector();
        Vector vMiriamDatas = this.getMiriamDatas();
        if (vMiriamDatas == null || vMiriamDatas.size() <= 0) {
            rtn.bSuccess = true;
            rtn.rtnObj = null;
            return rtn;
        }
        try {
            int iNo1 = 1;
            int iNo2 = 1;
            String[] aRowData = (String[])vMiriamDatas.get(0);
            String sPrevNo1 = aRowData[0];
            aRowData[0] = "" + iNo1;
            aRowData[1] = "" + iNo2;
            i = 1;
            while (i < vMiriamDatas.size()) {
                aRowData = (String[])vMiriamDatas.get(i);
                if (sPrevNo1.trim().equals(aRowData[0].trim())) {
                    aRowData[0] = "" + iNo1;
                    aRowData[1] = "" + ++iNo2;
                } else {
                    sPrevNo1 = aRowData[0];
                    aRowData[0] = "" + ++iNo1;
                    iNo2 = 1;
                    aRowData[1] = "" + iNo2;
                }
                ++i;
            }
        }
        catch (Exception myErr) {
            rtn.bError = true;
            rtn.rtnObj = "Exited because of System Error.";
            return rtn;
        }
        String sPrevNo1 = "init...";
        Vector<String> vectPrevs = new Vector<String>();
        int i2 = 0;
        while (i2 < vMiriamDatas.size()) {
            String[] aRowData = (String[])vMiriamDatas.get(i2);
            if (!sPrevNo1.trim().equals(aRowData[0].trim())) {
                vectPrevs = new Vector();
                sPrevNo1 = aRowData[0];
            }
            boolean haveRela = false;
            if (aRowData[2] == null || aRowData[2].trim().equals("")) {
                haveErr = true;
                this.makeErrDisplayMsg(vectErrs, i2, " [Relation] can not be blank.");
            } else {
                haveRela = true;
            }
            boolean haveDatatype = false;
            if (aRowData[3] == null || aRowData[3].trim().equals("")) {
                haveErr = true;
                this.makeErrDisplayMsg(vectErrs, i2, " [DataType] can not be blank.");
            } else {
                haveDatatype = true;
            }
            if (aRowData[4] == null || aRowData[4].trim().equals("")) {
                haveErr = true;
                this.makeErrDisplayMsg(vectErrs, i2, " [ID] can not be blank.");
            } else {
                aRowData[4] = aRowData[4].trim();
                if (haveRela && haveDatatype) {
                    if (MiriamUtils.checkMiriamDatatypeID(miriam, aRowData[3], aRowData[4])) {
                        if (vectPrevs.contains(String.valueOf(aRowData[3]) + aRowData[4])) {
                            haveErr = true;
                            this.makeErrDisplayMsg(vectErrs, i2, " [ID] is repetition.");
                        } else {
                            vectPrevs.add(String.valueOf(aRowData[3]) + aRowData[4]);
                        }
                    } else {
                        haveErr = true;
                        this.makeErrDisplayMsg(vectErrs, i2, " [ID] is not satisfied.");
                    }
                }
            }
            ++i2;
        }
        if (haveErr) {
            rtn.bError = true;
            rtn.rtnObj = vectErrs;
            return rtn;
        }
        Vector<MiriamDefinition> vectMiriam = new Vector<MiriamDefinition>();
        MiriamDefinition miriamData = new MiriamDefinition();
        sPrevNo1 = "init...";
        i = 0;
        while (i < vMiriamDatas.size()) {
            String[] aRowData = (String[])vMiriamDatas.get(i);
            if (!sPrevNo1.trim().equals(aRowData[0].trim())) {
                if (i > 0) {
                    vectMiriam.add(miriamData);
                }
                miriamData = new MiriamDefinition();
                miriamData.setRelation(aRowData[2]);
                miriamData.setDatas(new Vector());
                sPrevNo1 = aRowData[0];
            }
            String strDataType = new String(aRowData[3]);
            String strID = new String(aRowData[4]);
            String strNewUri = MiriamUtils.makeUriUsingNameAndID(miriam, aRowData[3], aRowData[4]);
            MiriamSubDefinition newsingle = new MiriamSubDefinition();
            newsingle.strDataType = strDataType;
            newsingle.strId = strID;
            newsingle.strUri = strNewUri;
            miriamData.getDatas().add(newsingle);
            ++i;
        }
        vectMiriam.add(miriamData);
        rtn.bSuccess = true;
        rtn.rtnObj = vectMiriam;
        return rtn;
    }

    private void makeErrDisplayMsg(Vector errs, int row, String msg) {
        if (row < 0) {
            return;
        }
        if (msg == null) {
            return;
        }
        if (errs == null) {
            errs = new Vector<String>();
        }
        if (row < 9) {
            errs.add("Err. @(row 0" + (row + 1) + ") ==>> " + msg);
        } else {
            errs.add("Err. @(row " + (row + 1) + ") ==>> " + msg);
        }
    }

    public void showPleaseSelcetDataMsg() {
        JOptionPane.showMessageDialog(this.parentWindow, "Please select a data from list.");
    }

    public SBase getEditingSBase() {
        return this.editingSBase;
    }
}

