/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.CelldPanel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import jp.sbi.celldesigner.CelldListener.MiriamListingEditor.PopupMenuListener;
import jp.sbi.celldesigner.CelldPanel.MiriamListingEditorPanel;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MiriamListingEditorDialog;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.miriam.MiriamUtils;
import jp.sbi.celldesigner.util.ReturnValue;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.SBase;

public class MiriamListingEditorButtonPanel
extends JPanel {
    private static final int iMaxDisplayErrRow = 10;
    private static final String title = "Warning";
    private static final String messageForClearAll = "Are you sure to CLEAR ALL.";
    private MiriamListingEditorPanel miriamListingEditorPanel = null;
    private JButton jButtonMiriamOk;
    private JButton jButtonMiriamAddRelation;
    private JButton jButtonMiriamAddDataType;
    private JButton jButtonMiriamRemoveDataType;
    private JButton jButtonMiriamAccess;
    private JButton jButtonMiriamClearAll;

    public MiriamListingEditorButtonPanel(MiriamListingEditorPanel lstPanel) {
        this.miriamListingEditorPanel = lstPanel;
        this.add(this.getJButtonMiriamAccess());
        this.add(this.getJButtonMiriamAddRelation());
        this.add(this.getJButtonMiriamAddDataType());
        this.add(this.getJButtonMiriamRemoveDataType());
        this.add(this.getJButtonOk());
        this.add(this.getJButtonMiriamClearAll());
    }

    private JButton getJButtonOk() {
        if (this.jButtonMiriamOk == null) {
            this.jButtonMiriamOk = new JButton("Ok");
            this.jButtonMiriamOk.setEnabled(false);
            this.jButtonMiriamOk.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (MiriamListingEditorButtonPanel.this.miriamListingEditorPanel != null) {
                        MiriamListingEditorButtonPanel.this.miriamListingEditorPanel.noticeEditingStopped(MiriamListingEditorButtonPanel.this.jButtonMiriamOk);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e) && MiriamListingEditorButtonPanel.this.jButtonMiriamOk.contains(e.getPoint())) {
                        MiriamListingEditorButtonPanel.this.okbtn_actionPerformed();
                    }
                }
            });
        }
        return this.jButtonMiriamOk;
    }

    private JButton getJButtonMiriamAddRelation() {
        if (this.jButtonMiriamAddRelation == null) {
            this.jButtonMiriamAddRelation = new JButton("Add Relation");
            this.jButtonMiriamAddRelation.setEnabled(false);
            this.jButtonMiriamAddRelation.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!MiriamListingEditorButtonPanel.this.jButtonMiriamAddRelation.isEnabled()) {
                        return;
                    }
                    if (MiriamListingEditorButtonPanel.this.miriamListingEditorPanel != null) {
                        MiriamListingEditorButtonPanel.this.miriamListingEditorPanel.noticeEditingStopped(MiriamListingEditorButtonPanel.this.jButtonMiriamAddRelation);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (!MiriamListingEditorButtonPanel.this.jButtonMiriamAddRelation.isEnabled()) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(e) && MiriamListingEditorButtonPanel.this.jButtonMiriamAddRelation.contains(e.getPoint())) {
                        MiriamListingEditorButtonPanel.this.reladdbtn_actionPerformed();
                    }
                }
            });
        }
        return this.jButtonMiriamAddRelation;
    }

    private JButton getJButtonMiriamAddDataType() {
        if (this.jButtonMiriamAddDataType == null) {
            this.jButtonMiriamAddDataType = new JButton("Add DataType");
            this.jButtonMiriamAddDataType.setEnabled(false);
            this.jButtonMiriamAddDataType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block6: {
                        try {
                            int[] rows = MiriamListingEditorButtonPanel.this.miriamListingEditorPanel.getJTableMiriamEditor().getSelectedRows();
                            if (rows.length == 1) {
                                MiriamListingEditorButtonPanel.this.miriamListingEditorPanel.noticeEditingStopped(MiriamListingEditorButtonPanel.this.jButtonMiriamAddRelation);
                                int row = rows[0];
                                int iMax = MiriamListingEditorButtonPanel.this.miriamListingEditorPanel.getMiriamDatas().size();
                                boolean found = false;
                                int i = 0;
                                while (i < iMax) {
                                    if (MiriamListingEditorButtonPanel.this.miriamListingEditorPanel.isLastDataOfARecords(row, -1)) {
                                        found = true;
                                        break;
                                    }
                                    ++row;
                                    ++i;
                                }
                                if (found) {
                                    MiriamListingEditorButtonPanel.this.miriamListingEditorPanel.AddADatatypeRealData(row);
                                }
                                break block6;
                            }
                            MiriamListingEditorButtonPanel.this.miriamListingEditorPanel.showPleaseSelcetDataMsg();
                            return;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        return this.jButtonMiriamAddDataType;
    }

    private JButton getJButtonMiriamRemoveDataType() {
        if (this.jButtonMiriamRemoveDataType == null) {
            this.jButtonMiriamRemoveDataType = new JButton("Remove");
            this.jButtonMiriamRemoveDataType.setEnabled(false);
            this.jButtonMiriamRemoveDataType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        int[] rows = MiriamListingEditorButtonPanel.this.miriamListingEditorPanel.getJTableMiriamEditor().getSelectedRows();
                        if (rows.length != 1) {
                            MiriamListingEditorButtonPanel.this.miriamListingEditorPanel.showPleaseSelcetDataMsg();
                            return;
                        }
                        MiriamListingEditorButtonPanel.this.miriamListingEditorPanel.noticeEditingStopped(MiriamListingEditorButtonPanel.this.jButtonMiriamAddRelation);
                        MiriamListingEditorButtonPanel.this.miriamListingEditorPanel.RemoveADatatypeRealData(rows[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return this.jButtonMiriamRemoveDataType;
    }

    private JButton getJButtonMiriamAccess() {
        if (this.jButtonMiriamAccess == null) {
            this.jButtonMiriamAccess = new JButton("Access");
            this.jButtonMiriamAccess.setEnabled(false);
            this.jButtonMiriamAccess.addMouseListener(new PopupMenuListener(this.miriamListingEditorPanel, false));
        }
        return this.jButtonMiriamAccess;
    }

    private JButton getJButtonMiriamClearAll() {
        if (this.jButtonMiriamClearAll == null) {
            this.jButtonMiriamClearAll = new JButton("Clear All");
            this.jButtonMiriamClearAll.setEnabled(false);
            this.jButtonMiriamClearAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        int cnt = MiriamListingEditorButtonPanel.this.miriamListingEditorPanel.getMiriamDatas().size();
                        if (cnt <= 0) {
                            return;
                        }
                        if (JOptionPane.showConfirmDialog(null, MiriamListingEditorButtonPanel.messageForClearAll, MiriamListingEditorButtonPanel.title, 0) != 0) {
                            return;
                        }
                        MiriamListingEditorButtonPanel.this.miriamListingEditorPanel.initTableData(new Vector());
                    }
                    catch (Exception myErr) {
                        return;
                    }
                }
            });
        }
        return this.jButtonMiriamClearAll;
    }

    public void setButtonEnable(SBase sbase) {
        if (sbase == null) {
            this.getJButtonOk().setEnabled(false);
            this.getJButtonMiriamAddRelation().setEnabled(false);
            this.getJButtonMiriamAddDataType().setEnabled(false);
            this.getJButtonMiriamRemoveDataType().setEnabled(false);
            this.getJButtonMiriamAccess().setEnabled(false);
            this.getJButtonMiriamClearAll().setEnabled(false);
        } else {
            this.getJButtonOk().setEnabled(true);
            this.getJButtonMiriamAddRelation().setEnabled(true);
            this.getJButtonMiriamAddDataType().setEnabled(true);
            this.getJButtonMiriamRemoveDataType().setEnabled(true);
            this.getJButtonMiriamAccess().setEnabled(true);
            this.getJButtonMiriamClearAll().setEnabled(true);
        }
    }

    public boolean okbtn_actionPerformed() {
        ChangeEvent ce = new ChangeEvent(this.miriamListingEditorPanel.getJTableMiriamEditor());
        this.miriamListingEditorPanel.getJTableMiriamEditor().stopEditing(ce);
        this.miriamListingEditorPanel.getJTableMiriamEditor().clearSelection();
        ReturnValue rtn = this.miriamListingEditorPanel.inputChecker();
        if (rtn.bError) {
            String TITLE = "Error Message";
            String message = "";
            if (rtn.rtnObj instanceof String) {
                message = (String)rtn.rtnObj;
            } else if (rtn.rtnObj instanceof Vector) {
                Vector vectErrs = (Vector)rtn.rtnObj;
                int i = 0;
                while (i < vectErrs.size()) {
                    if (i >= 10) break;
                    message = String.valueOf(message) + (String)vectErrs.get(i) + "\n";
                    ++i;
                }
                message = String.valueOf(message) + "\n";
            }
            JOptionPane.showMessageDialog(this, message, TITLE, 0);
            return false;
        }
        SBase editingSbase = this.miriamListingEditorPanel.getEditingSBase();
        Vector miriamOld = LibSBMLUtil.getMiriamDatasFromAnnotationOfSBase(editingSbase);
        String strannotationOld = MiriamUtils.changeMiriamIdFormat(LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), editingSbase, miriamOld, true).toString(), false);
        String strannotation = MiriamUtils.changeMiriamIdFormat(LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), editingSbase, (Vector)rtn.rtnObj, true).toString(), false);
        this.miriamListingEditorPanel.updateObjectFromDialog(rtn.rtnObj);
        if (!strannotationOld.equals(strannotation)) {
            SBModelFrame sbmfrm = MainWindow.getLastInstance().getCurrentModel();
            sbmfrm.setHasAnySBaseChangedFlg(true);
        }
        if (this.miriamListingEditorPanel.getParentWindow() instanceof MiriamListingEditorDialog) {
            ((MiriamListingEditorDialog)this.miriamListingEditorPanel.getParentWindow()).dismissDialog();
        }
        return true;
    }

    private void reladdbtn_actionPerformed() {
        this.miriamListingEditorPanel.getJTableMiriamEditor().clearSelection();
        try {
            this.miriamListingEditorPanel.AddARelationRealData(this.miriamListingEditorPanel.getMiriamDatas().size());
        }
        catch (Exception myErr) {
            this.miriamListingEditorPanel.AddARelationRealData(0);
        }
    }
}

