/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.CelldListener.MiriamListingEditor;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import jp.sbi.celldesigner.CelldPanel.MiriamListingEditorPanel;
import jp.sbi.celldesigner.CelldTable.MiriamListingTable;
import jp.sbi.celldesigner.MiriamMainPanel;
import jp.sbi.celldesigner.miriam.MiriamUtils;

public class PopupMenuListener
extends MouseAdapter {
    private static final boolean bMustBeRightClickSystemDefault = true;
    private MiriamListingEditorPanel miriamListingEditorPanel = null;
    private boolean bMustBeRightClick = true;
    private boolean bMustBeLeftClick = !this.bMustBeRightClick;

    public PopupMenuListener(MiriamListingEditorPanel panel) {
        this(panel, true);
    }

    public PopupMenuListener(MiriamListingEditorPanel panel, boolean rightClick) {
        this.miriamListingEditorPanel = panel;
        this.bMustBeRightClick = rightClick;
        this.bMustBeLeftClick = !this.bMustBeRightClick;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        try {
            this.showPopupMenu(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showPopupMenu(MouseEvent e) {
        String strID;
        MiriamListingTable table = this.miriamListingEditorPanel.getJTableMiriamEditor();
        if (this.bMustBeRightClick && !e.isPopupTrigger()) {
            return;
        }
        if (this.bMustBeLeftClick && e.isPopupTrigger()) {
            return;
        }
        if (table == null) {
            return;
        }
        if (e.getSource() instanceof JButton && !((JButton)e.getSource()).isEnabled()) {
            return;
        }
        DefaultTableModel tableModel = (DefaultTableModel)this.miriamListingEditorPanel.getJTableMiriamEditor().getModel();
        int[] index = table.getSelectedRows();
        if (index == null || index.length != 1) {
            this.miriamListingEditorPanel.showPleaseSelcetDataMsg();
            return;
        }
        int pressedRow = table.rowAtPoint(e.getPoint());
        if (e.getSource() instanceof JTable && index[0] != pressedRow) {
            return;
        }
        String datatype = (String)tableModel.getValueAt(index[0], 3);
        JPopupMenu popMenu = MiriamMainPanel.makePopupMenu(datatype, MiriamUtils.changeMiriamIdFormat(strID = (String)tableModel.getValueAt(index[0], 4), true));
        if (popMenu != null) {
            popMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

