/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.CelldCellEditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import jp.sbi.celldesigner.CelldEventProcesser.CellAnyEventProcesser;
import jp.sbi.celldesigner.CelldEventProcesser.CellDataProcesser;

public abstract class ComboCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected CellAnyEventProcesser anyEventProcesser;
    protected Vector listItems = null;
    protected int row;
    protected int col;
    protected JComboBox listbox;
    protected Object selectedValue = null;

    public Object getSelectedValue() {
        return this.selectedValue;
    }

    public ComboCellEditor(CellAnyEventProcesser processer) {
        this.anyEventProcesser = processer;
        this.initListbox();
        this.listbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboCellEditor.this.listbox.isEnabled()) {
                    String value = ComboCellEditor.this.listbox.getSelectedItem().toString();
                    ((CellDataProcesser)ComboCellEditor.this.anyEventProcesser).UpdateTableRealData(ComboCellEditor.this.row, ComboCellEditor.this.col, value);
                    ComboCellEditor.this.selectedValue = value;
                }
            }
        });
    }

    protected abstract void initListbox();

    public void editCancel() {
        this.listbox.setSelectedItem(this.selectedValue);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.row = row;
        this.col = col;
        if (this.isAnEnabledListbox()) {
            this.listbox.setEnabled(true);
        } else {
            this.listbox.setEnabled(false);
        }
        boolean changed = false;
        if (value != null) {
            if (!value.toString().equals(this.selectedValue)) {
                changed = true;
                this.selectedValue = value.toString();
            }
        } else {
            changed = true;
            this.selectedValue = this.getFirstValidDataInListbox();
        }
        if (changed) {
            this.listbox.setSelectedItem(this.selectedValue);
        }
        return this.listbox;
    }

    @Override
    public Object getCellEditorValue() {
        return this.selectedValue;
    }

    public boolean isAnEnabledListbox() {
        return true;
    }

    public String getFirstValidDataInListbox() {
        if (this.listItems == null || this.listItems.size() <= 0) {
            return "";
        }
        return this.listItems.get(0).toString();
    }
}

