/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.CelldCellEditor;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jp.sbi.celldesigner.CelldEventProcesser.CellAnyEventProcesser;

public abstract class ButtonTableCell
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor {
    protected CellAnyEventProcesser anyEventProcesser;
    protected JTable jdatatable = null;
    protected final JButton renderButton;
    protected final JButton editorButton;
    protected final JLabel jLabelSpaceCell = new JLabel("");
    protected Object eventSource = null;
    protected int iSelectedRow = -1;

    public ButtonTableCell(JTable table, String buttonname, CellAnyEventProcesser processer) {
        this.jdatatable = table;
        this.anyEventProcesser = processer;
        this.renderButton = new JButton(buttonname);
        this.editorButton = new JButton(buttonname);
        this.editorButton.setBorder(BorderFactory.createEmptyBorder());
        this.renderButton.setBorder(BorderFactory.createEmptyBorder());
        this.editorButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                ButtonTableCell.this.eventSource = null;
                ButtonTableCell.this.iSelectedRow = -1;
                ButtonTableCell.this.fireEditingStopped();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ButtonTableCell.this.eventSource = ButtonTableCell.this;
                Rectangle bounds = ButtonTableCell.this.editorButton.getBounds();
                ButtonTableCell.this.iSelectedRow = ButtonTableCell.this.jdatatable.rowAtPoint(new Point((int)bounds.getCenterX(), (int)bounds.getCenterY()));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ButtonTableCell.this.fireEditingStopped();
                int row = ButtonTableCell.this.jdatatable.getSelectedRow();
                boolean fireAction = false;
                if (row == ButtonTableCell.this.iSelectedRow && ButtonTableCell.this.eventSource instanceof ButtonTableCell) {
                    if (e.getSource().equals(((ButtonTableCell)ButtonTableCell.this.eventSource).renderButton)) {
                        fireAction = true;
                    } else if (e.getSource().equals(((ButtonTableCell)ButtonTableCell.this.eventSource).editorButton)) {
                        fireAction = true;
                    }
                }
                if (fireAction) {
                    try {
                        ButtonTableCell.this.doMouseReleasedAction(row);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ButtonTableCell.this.eventSource = null;
                ButtonTableCell.this.iSelectedRow = -1;
            }
        });
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.renderButton;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.editorButton;
    }

    @Override
    public Object getCellEditorValue() {
        return "";
    }

    public abstract void doMouseReleasedAction(int var1);
}

