/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import edu.caltech.sbw.ModuleImpl;
import edu.caltech.sbw.SBWBrokerStartException;
import edu.caltech.sbw.SBWCommunicationException;
import edu.caltech.sbw.SBWIncorrectCategorySyntaxException;
import edu.caltech.sbw.SBWModuleDefinitionException;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import jp.sbi.celldesigner.ApplicationControl;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBEventRecorder;
import jp.sbi.celldesigner.SBWAnalyzer;
import jp.sbi.celldesigner.util.UpdateChecker;
import jp.sbi.sbw.SBWUtil;
import org.COPASI.CCopasiDataModel;
import org.sbml.libsbml.libsbml;

public class Application {
    private static boolean packFrame = false;
    private static MainWindow mainwindow = null;
    private static boolean sbwconnected = false;
    public static boolean isMacOSX = false;
    public static boolean hasCopasiJava = true;
    private static SBWAnalyzer _oAnalyzer = null;

    static {
        try {
            System.loadLibrary("sbmlj");
        }
        catch (UnsatisfiedLinkError e) {
            System.exit(1);
        }
        System.err.println("libSBML version " + libsbml.getLibSBMLDottedVersion());
        String copasiErr = null;
        try {
            System.loadLibrary("CopasiJava");
        }
        catch (UnsatisfiedLinkError e) {
            hasCopasiJava = false;
            copasiErr = "[COPASI:Exception] (loadLibrary:UnsatisfiedLinkError) : " + e.getMessage();
        }
        catch (SecurityException e) {
            hasCopasiJava = false;
            copasiErr = "[COPASI:Exception] (loadLibrary:SecurityException) : " + e.getMessage();
        }
        if (hasCopasiJava) {
            String cVersion = "";
            String api = "";
            try {
                Class<?> cversion = Class.forName("org.COPASI.CVersion");
                Method method = cversion.getDeclaredMethod("getVERSION", new Class[0]);
                Object obj = method.invoke(cversion, new Object[0]);
                Method method2 = obj.getClass().getDeclaredMethod("getVersion", new Class[0]);
                Object obj2 = method2.invoke(obj, new Object[0]);
                api = "New API";
                cVersion = (String)obj2;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                api = "Old API";
                cVersion = CCopasiDataModel.getGlobal().getVersion().getVersion();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                api = "Old API";
                cVersion = CCopasiDataModel.getGlobal().getVersion().getVersion();
            }
            String copasiMsg = "CopasiJava loaded: Version " + cVersion + ": " + api;
            SBEventRecorder.addLog(copasiMsg);
            System.err.println(copasiMsg);
        } else {
            SBEventRecorder.addLog("Native library (CopasiJava) not found." + copasiErr);
        }
    }

    public static void main(String[] argv) {
        Locale.setDefault(Locale.ENGLISH);
        if (System.getProperty("mrj.version") != null) {
            isMacOSX = true;
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "CellDesigner");
        }
        try {
            String osName = System.getProperty("os.name");
            if (osName.equals("Linux") || osName.equals("FreeBSD")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            } else if (isMacOSX) {
                UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception osName) {
            // empty catch block
        }
        ToolTipManager tm = ToolTipManager.sharedInstance();
        tm.setInitialDelay(250);
        tm.setDismissDelay(20000);
        tm.setReshowDelay(750);
        sbwconnected = true;
        new ApplicationControl(argv);
        new Application(argv);
    }

    private static void initSBW(String[] argv) {
        _oAnalyzer = new SBWAnalyzer();
        ModuleImpl oModuleImpl = null;
        try {
            oModuleImpl = new ModuleImpl("celldesigner", "CellDesigner", 0);
            oModuleImpl.addService("analysis", "CellDesigner", "Analysis", (Object)_oAnalyzer, "Loads an SBML Model");
            SBWUtil.setSBWModuleObject(oModuleImpl);
            _oAnalyzer.setMainWindow(mainwindow);
            oModuleImpl.enableModuleServices();
            mainwindow.setupSBWMenu();
        }
        catch (SBWModuleDefinitionException sBWModuleDefinitionException) {
        }
        catch (SBWIncorrectCategorySyntaxException sBWIncorrectCategorySyntaxException) {
        }
        catch (SBWCommunicationException sBWCommunicationException) {
        }
        catch (SBWBrokerStartException sBWBrokerStartException) {
            // empty catch block
        }
        if (argv != null) {
            int i = 0;
            while (i < argv.length) {
                if (argv[i].equals("-sbwregister")) {
                    try {
                        if (oModuleImpl != null) {
                            oModuleImpl.registerModule();
                        }
                    }
                    catch (SBWModuleDefinitionException sBWModuleDefinitionException) {
                    }
                    catch (SBWBrokerStartException sBWBrokerStartException) {
                    }
                    catch (SBWCommunicationException sBWCommunicationException) {
                        // empty catch block
                    }
                    System.exit(0);
                }
                ++i;
            }
        }
    }

    public Application(String[] argv) {
        mainwindow = new MainWindow(argv, sbwconnected);
        Application.initSBW(argv);
        if (packFrame) {
            mainwindow.pack();
        } else {
            mainwindow.validate();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = mainwindow.getSize();
        int margin = 4;
        int winposx = -5;
        int winposy = -5;
        if (Preference.windowPosition != null) {
            winposx = Preference.windowPosition.x;
            winposy = Preference.windowPosition.y;
        }
        int winwidth = frameSize.width;
        int winheight = frameSize.height;
        if (Preference.windowSize != null) {
            winwidth = Preference.windowSize.width;
            winheight = Preference.windowSize.height;
        }
        winwidth = winwidth > screenSize.width + 8 ? screenSize.width + 8 : winwidth;
        int n = winheight = winheight > screenSize.height + 8 ? screenSize.height + 8 : winheight;
        if (winposx < -4 || winposx + winwidth > screenSize.width + 4) {
            winposx = (screenSize.width - winwidth) / 2;
        }
        if (winposy < -4 || winposy + winheight > screenSize.height + 4) {
            winposy = (screenSize.height - winheight) / 2;
        }
        mainwindow.setSize(winwidth, winheight);
        mainwindow.setLocation(winposx, winposy);
        mainwindow.setExtendedState(Preference.windowState);
        mainwindow.setDefaultSplitPanesProperties();
        mainwindow.setVisible(true);
        UpdateChecker up = new UpdateChecker();
        up.checkUpdateInfo(null, false);
    }

    public static void exit() {
        System.exit(0);
    }
}

