/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.fric.util.LogFactory;

public class WeakReferenceMonitor {
    private static final Logger logger = LogFactory.getLogger(WeakReferenceMonitor.class);
    private static final ReferenceQueue handleQueue = new ReferenceQueue();
    private static final Map trackedEntries = Collections.synchronizedMap(new HashMap());
    private static Thread monitoringThread = null;
    private static int number = 1;

    public static void monitor(Object handle) {
        if (handle != null) {
            WeakReference<Object> weakRef = new WeakReference<Object>(handle, handleQueue);
            final String str = String.valueOf(handle.getClass().getName()) + " " + handle.toString();
            final int num = number++;
            logger.info("[monitor start " + num + "] " + str);
            WeakReferenceMonitor.addEntry(weakRef, new ReleaseListener(){

                @Override
                public void released() {
                    logger.info("[GC " + num + "] " + str);
                }
            });
        }
    }

    private static void addEntry(Reference ref, ReleaseListener entry) {
        trackedEntries.put(ref, entry);
        if (!WeakReferenceMonitor.isMonitoringThreadRunning()) {
            monitoringThread = new Thread((Runnable)new MonitoringProcess(), WeakReferenceMonitor.class.getName());
            monitoringThread.start();
        }
    }

    private static ReleaseListener removeEntry(Reference reference) {
        return (ReleaseListener)trackedEntries.remove(reference);
    }

    private static boolean isMonitoringThreadRunning() {
        return monitoringThread != null;
    }

    private static class MonitoringProcess
    implements Runnable {
        private MonitoringProcess() {
        }

        @Override
        public void run() {
            block6: {
                logger.finest("Starting reference monitor thread");
                while (true) {
                    if (trackedEntries.isEmpty()) break block6;
                    try {
                        Reference reference = handleQueue.remove();
                        ReleaseListener entry = WeakReferenceMonitor.removeEntry(reference);
                        if (entry == null) continue;
                        entry.released();
                    }
                    catch (InterruptedException ex) {
                        logger.log(Level.FINEST, "Reference monitor thread interrupted", ex);
                        break block6;
                    }
                }
                finally {
                    logger.finest("Stopping reference monitor thread");
                    monitoringThread = null;
                }
            }
        }
    }

    private static interface ReleaseListener {
        public void released();
    }
}

