/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class ShortFormatter
extends Formatter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    @Override
    public String format(LogRecord record) {
        Object[] objs = new Object[]{new Date(record.getMillis()), record.getLevel().getLocalizedName(), record.getSourceClassName(), record.getSourceMethodName(), record.getMessage(), LINE_SEPARATOR};
        String msg = MessageFormat.format("{0,date,yyyy-MM-dd HH:mm:ss} {1} {2} {3} - {4}{5}", objs);
        Throwable t = record.getThrown();
        if (t != null) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            StringBuffer buf = sw.getBuffer();
            buf.insert(0, msg);
            msg = buf.toString();
        }
        return msg;
    }
}

