/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import jp.fric.util.NameSpaceParseFailException;
import jp.fric.util.ProgramersException;

public class NameSpace {
    private Class classWithName = null;
    private Method getName = null;
    private Method setName = null;
    private String prefix = "";
    private int startNumber = 1;
    private ListIterator nextPointer = null;
    private LinkedList standardNameNumbers = null;
    private HashSet nonstandardNames = null;

    public NameSpace() {
    }

    public NameSpace(Class classWithName) {
        this.classWithName = classWithName;
    }

    public int getStartNumber() {
        return this.startNumber;
    }

    public void setStartNumber(int startNumber) {
        if (this.standardNameNumbers != null || this.nonstandardNames != null) {
            return;
        }
        this.startNumber = startNumber;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        if (this.standardNameNumbers != null || this.nonstandardNames != null) {
            return;
        }
        this.prefix = prefix;
    }

    public Class getClassWithName() {
        return this.classWithName;
    }

    public void setClassWithName(Class classWithName) {
        if (this.standardNameNumbers != null || this.nonstandardNames != null) {
            return;
        }
        this.classWithName = classWithName;
    }

    public void setGetName(String getNameName) throws SecurityException, NoSuchMethodException {
        if (this.classWithName == null) {
            return;
        }
        this.getName = this.classWithName.getMethod(getNameName, new Class[0]);
    }

    public void setSetName(String setNameName) throws SecurityException, NoSuchMethodException {
        this.setName = this.classWithName.getMethod(setNameName, String.class);
    }

    public void setSetName(String setNameName, Class type) throws SecurityException, NoSuchMethodException {
        this.setName = this.classWithName.getMethod(setNameName, type);
    }

    public void parse(Collection c) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NameSpaceParseFailException {
        if (this.standardNameNumbers != null || this.nonstandardNames != null) {
            return;
        }
        Vector<Integer> nameNumbers = new Vector<Integer>();
        Vector<String> nonStandard = new Vector<String>();
        Iterator it = c.iterator();
        int countMax = 0;
        while (it.hasNext()) {
            boolean nonstandard = false;
            Object element = it.next();
            String name = (String)this.getName.invoke(element, null);
            if (name == null) {
                throw new NameSpaceParseFailException("Name(s) is null.", null);
            }
            try {
                String prefixStr = name.substring(0, this.prefix.length());
                String numberStr = name.substring(this.prefix.length());
                int number = Integer.parseInt(numberStr);
                if (number < this.startNumber || number != 0 && numberStr.startsWith("0") || !prefixStr.equals(this.prefix)) {
                    nonstandard = true;
                } else {
                    nameNumbers.add(new Integer(number));
                }
                if (number > countMax) {
                    countMax = number;
                }
            }
            catch (IndexOutOfBoundsException e) {
                nonstandard = true;
            }
            catch (NumberFormatException e) {
                nonstandard = true;
            }
            if (!nonstandard) continue;
            nonStandard.addElement(name);
        }
        Vector redundancy = NameSpace.redundancyCheck(nameNumbers, null);
        if (redundancy.size() > 0) {
            throw new NameSpaceParseFailException("Numbers of standard name has redunduncy.", redundancy.toArray());
        }
        this.nonstandardNames = new HashSet();
        redundancy = NameSpace.redundancyCheck(nonStandard, this.nonstandardNames);
        if (redundancy.size() > 0) {
            throw new NameSpaceParseFailException("Nonstandard names has redundancy.", redundancy.toArray());
        }
        this.standardNameNumbers = new LinkedList();
        int i = 0;
        while (i < countMax - this.startNumber + 1) {
            Integer num = new Integer(i + this.startNumber);
            if (nameNumbers.contains(num)) {
                this.standardNameNumbers.add(num);
            } else {
                this.standardNameNumbers.add(null);
            }
            ++i;
        }
        this.nextPointer = this.standardNameNumbers.listIterator();
        this.setPointerToTop();
    }

    public void assignNameTo(Object obj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Integer nextNumber = this.generateNextNumber();
        String name = String.valueOf(this.prefix) + nextNumber;
        this.setName.invoke(obj, name);
        try {
            this.registerAssignedNumber(nextNumber);
        }
        catch (ProgramersException programersException) {
            // empty catch block
        }
    }

    public String[] getStandardNames() {
        Vector<String> v = new Vector<String>();
        for (Object obj : this.standardNameNumbers) {
            if (obj == null) continue;
            v.addElement(String.valueOf(this.prefix) + obj);
        }
        String[] rtn = new String[v.size()];
        int i = 0;
        while (i < v.size()) {
            rtn[i] = (String)v.elementAt(i);
            ++i;
        }
        return rtn;
    }

    public String[] getNonstndardNames() {
        String[] rtn = new String[this.nonstandardNames.size()];
        Iterator it = this.nonstandardNames.iterator();
        int i = 0;
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj != null) {
                rtn[i] = (String)obj;
            }
            ++i;
        }
        return rtn;
    }

    private void setPointerToTop() {
        while (this.nextPointer.hasNext()) {
            if (this.nextPointer.next() != null) continue;
            this.nextPointer.previous();
            break;
        }
    }

    private Integer generateNextNumber() {
        this.setPointerToTop();
        int nextNumber = this.startNumber;
        if (this.nextPointer.hasPrevious()) {
            Integer current = (Integer)this.nextPointer.previous();
            this.nextPointer.next();
            nextNumber = current + 1;
        }
        try {
            if (nextNumber != this.nextPointer.nextIndex() + this.startNumber) {
                throw new ProgramersException("Error in " + this + ".generatNextName(). The next number is not consistent.");
            }
        }
        catch (ProgramersException programersException) {
            // empty catch block
        }
        return new Integer(nextNumber);
    }

    private void registerAssignedNumber(Integer number) throws ProgramersException {
        Integer generated = this.generateNextNumber();
        if (!number.equals(generated)) {
            throw new ProgramersException("The assigned number (" + number + ") is not valid. Should be (" + generated + ").");
        }
        if (!this.nextPointer.hasNext()) {
            this.nextPointer.add(null);
            this.nextPointer.previous();
        }
        this.nextPointer.next();
        this.nextPointer.set(number);
    }

    private static Vector redundancyCheck(Vector vec, HashSet hset) {
        if (hset == null) {
            hset = new HashSet();
        }
        Vector redundancy = new Vector();
        int i = 0;
        while (i < vec.size()) {
            Object obj = vec.elementAt(i);
            if (hset.contains(obj)) {
                redundancy.addElement(obj);
            }
            hset.add(obj);
            ++i;
        }
        return redundancy;
    }
}

