/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.util;

import java.io.FileOutputStream;
import java.io.PrintStream;

public class DebugPrinter {
    private static boolean isToConsole = false;
    private static boolean isToFile = false;
    private static boolean isToRedirectErr = false;
    private static int debugLevel = 0;
    private static PrintStream fileout = null;
    private static PrintStream err = null;
    private static String debugFile = "debug.txt";
    private static String errorFile = "error.txt";

    protected DebugPrinter() {
    }

    public static void setStreams(String flagString) {
        int i = 0;
        while (i < flagString.length()) {
            char c = flagString.charAt(i);
            if (c == 'c' & !isToConsole) {
                isToConsole = true;
            }
            if (c == 'f' & !isToFile) {
                try {
                    fileout = new PrintStream(new FileOutputStream(debugFile));
                    isToFile = true;
                }
                catch (Exception e) {
                    System.out.println("[Debug] failed to open " + debugFile);
                }
            }
            if (c == 'r' & !isToRedirectErr) {
                try {
                    err = new PrintStream(new FileOutputStream(errorFile));
                    System.setErr(err);
                    isToRedirectErr = true;
                }
                catch (Exception e) {
                    System.out.println("[Debug] failed to open " + errorFile);
                    err = System.out;
                }
            }
            ++i;
        }
    }

    public static void setLevel(int level) {
        debugLevel = level;
    }

    public static void close() {
        if (fileout != null) {
            fileout.close();
            fileout = null;
        }
        if (err != null) {
            err.close();
            err = null;
        }
    }

    public static void println(int level, String string) {
        if (level <= debugLevel) {
            if (isToConsole) {
                System.out.println(string);
            }
            if (isToFile & fileout != null) {
                fileout.println(string);
            }
        }
    }

    public static void startMessage() {
        String msg = "DebugPrinter started,";
        if (isToConsole) {
            msg = String.valueOf(msg) + " to console,";
        }
        if (isToFile & fileout != null) {
            msg = String.valueOf(msg) + " to file \"./" + debugFile + "\",";
        }
        if (isToRedirectErr) {
            msg = String.valueOf(msg) + " redirect System.err to \"./" + errorFile + "\",";
        }
        msg = String.valueOf(msg) + " debugLevel=" + debugLevel;
        DebugPrinter.println(debugLevel, msg);
    }
}

