/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import jp.fric.ui.DocumentDialog;
import jp.sbi.sbml.SId;

class ActiveDialog
extends JDialog {
    DocumentDialog dd;
    private JTextField textfieldName;
    private JTextField textfieldWidth;
    private JTextField textfieldHeight;
    private JButton okButton;
    private JButton cancelButton;

    public ActiveDialog(DocumentDialog documentdialog, String title) {
        this.setModal(true);
        this.dd = documentdialog;
        this.setTitle(title);
        this.createUI();
    }

    public ActiveDialog(DocumentDialog documentdialog, Frame frame, String string) {
        super(frame, string, true);
        this.dd = documentdialog;
        this.createUI();
        this.setLocationRelativeTo(frame);
    }

    private void createUI() {
        String name = this.dd.getDocumentName();
        Dimension dimension = this.dd.getDocumentSize();
        final JRootPane rootPane = this.getRootPane();
        JPanel panel = new JPanel();
        panel.setLayout(null);
        JLabel labelName = new JLabel("Name");
        labelName.setBounds(new Rectangle(20, 20, 40, 20));
        this.textfieldName = new JTextField();
        this.textfieldName.setBounds(new Rectangle(60, 20, 200, 20));
        this.textfieldName.setText(name);
        this.textfieldName.setEditable(true);
        this.textfieldName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusevent) {
                rootPane.setDefaultButton(ActiveDialog.this.okButton);
            }
        });
        JLabel labelWidth = new JLabel("Width");
        labelWidth.setBounds(new Rectangle(20, 45, 40, 20));
        this.textfieldWidth = new JTextField();
        this.textfieldWidth.setHorizontalAlignment(4);
        this.textfieldWidth.setDocument(new NumberDocument());
        this.textfieldWidth.setBounds(new Rectangle(60, 45, 50, 20));
        String stringWidth = "";
        if (dimension.width > 0) {
            stringWidth = Integer.toString(dimension.width);
        }
        this.textfieldWidth.setText(stringWidth);
        this.textfieldWidth.setEditable(true);
        this.textfieldWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusevent) {
                rootPane.setDefaultButton(ActiveDialog.this.okButton);
            }
        });
        JLabel labelHeight = new JLabel("Height");
        labelHeight.setBounds(new Rectangle(130, 45, 45, 20));
        labelHeight.setHorizontalAlignment(4);
        this.textfieldHeight = new JTextField();
        this.textfieldHeight.setHorizontalAlignment(4);
        this.textfieldHeight.setDocument(new NumberDocument());
        this.textfieldHeight.setBounds(new Rectangle(180, 45, 50, 20));
        String stringHeight = "";
        if (dimension.height > 0) {
            stringHeight = Integer.toString(dimension.height);
        }
        this.textfieldHeight.setText(stringHeight);
        this.textfieldHeight.setEditable(true);
        this.textfieldHeight.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusevent) {
                rootPane.setDefaultButton(ActiveDialog.this.okButton);
            }
        });
        this.okButton = new JButton("OK");
        this.okButton.setMnemonic(79);
        this.okButton.setBounds(new Rectangle(50, 80, 70, 25));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                ActiveDialog.this.okButton_selected();
            }
        });
        this.okButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusevent) {
                rootPane.setDefaultButton(ActiveDialog.this.okButton);
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic(67);
        this.cancelButton.setBounds(new Rectangle(130, 80, 120, 25));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                ActiveDialog.this.cancelButton_selected();
            }
        });
        this.cancelButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusevent) {
                rootPane.setDefaultButton(ActiveDialog.this.cancelButton);
            }
        });
        this.getContentPane().add(panel);
        panel.add((Component)labelName, null);
        panel.add((Component)labelWidth, null);
        panel.add((Component)labelHeight, null);
        panel.add((Component)this.textfieldName, null);
        panel.add((Component)this.textfieldWidth, null);
        panel.add((Component)this.textfieldHeight, null);
        panel.add((Component)this.okButton, null);
        panel.add((Component)this.cancelButton, null);
        this.setSize(290, 150);
    }

    public void enableDialog(boolean isEnabled) {
        this.okButton.setEnabled(isEnabled);
        this.textfieldName.setEnabled(isEnabled);
        this.textfieldWidth.setEnabled(isEnabled);
        this.textfieldHeight.setEnabled(isEnabled);
    }

    private void cancelButton_selected() {
        this.dd.setLastOption(2);
        this.dispose();
    }

    private void okButton_selected() {
        if (this.textfieldWidth.getText().equals("") || this.textfieldHeight.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Lack of input", "Cannot accept input", 2);
        } else {
            int height;
            int width;
            String name = this.textfieldName.getText();
            try {
                width = Integer.parseInt(this.textfieldWidth.getText());
                height = Integer.parseInt(this.textfieldHeight.getText());
                this.textfieldWidth.setText(String.valueOf(width));
                this.textfieldHeight.setText(String.valueOf(height));
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Width and Height must be number", "Cannot accept input", 2);
                return;
            }
            char[] chars = name.toCharArray();
            int i = 0;
            while (i < chars.length) {
                if (Character.isWhitespace(chars[i])) {
                    chars[i] = 95;
                }
                ++i;
            }
            String tempname = new String(chars);
            try {
                if (!tempname.equals("")) {
                    SId.check(tempname);
                }
            }
            catch (Exception e) {
                String message = "Malformed [Name] input '" + name + "'\nPlease see \"Help\" menu -> \"Name Expression\".";
                JOptionPane.showMessageDialog(this, message, "Cannot accept input", 2);
                return;
            }
            if (width <= 0 || height <= 0) {
                JOptionPane.showMessageDialog(this, "Width and Height must be over zero", "Cannot accept input", 2);
            } else {
                if (!name.equals(tempname)) {
                    JOptionPane.showMessageDialog(this, "All Spaces in [Name] have been changed to underline'_' .\nNew value is '" + tempname + "' .", "Information", 1);
                }
                this.dd.setDocumentName(tempname);
                this.dd.setDocumentSize(new Dimension(width, height));
                this.dd.setLastOption(1);
                this.dispose();
            }
        }
    }

    @Override
    public void show() {
        this.getRootPane().setDefaultButton(this.okButton);
        super.show();
    }

    private class NumberDocument
    extends PlainDocument {
        private NumberDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null || str.equals("")) {
                return;
            }
            int i = 0;
            while (i < str.length()) {
                if (!Character.isDigit(str.charAt(i))) {
                    return;
                }
                ++i;
            }
            super.insertString(offs, str, a);
        }
    }
}

