/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.statistics;

import java.util.ArrayList;
import java.util.ListIterator;

public class Histogram {
    private ArrayList elements = new ArrayList();
    private ArrayList frequency = new ArrayList();
    private final int NONEXIST = -1;

    public void add(Object obj) {
        int index = this.judgeExistence(obj);
        if (index == -1) {
            this.elements.add(obj);
            this.frequency.add(new Integer(1));
        } else {
            int freq = (Integer)this.frequency.get(index);
            this.frequency.set(index, new Integer(freq + 1));
        }
    }

    public Object[] getMode() {
        ArrayList mode = new ArrayList();
        int maxfreq = Integer.MIN_VALUE;
        ListIterator lifreq = this.frequency.listIterator(0);
        ListIterator lielem = this.elements.listIterator(0);
        while (lifreq.hasNext()) {
            int freq = (Integer)lifreq.next();
            Object element = lielem.next();
            if (freq > maxfreq) {
                maxfreq = freq;
                mode.clear();
                mode.add(element);
                continue;
            }
            if (freq != maxfreq) continue;
            mode.add(element);
        }
        return mode.toArray();
    }

    protected int judgeExistence(Object obj) {
        boolean found = false;
        ListIterator li = this.elements.listIterator(0);
        while (li.hasNext()) {
            if (li.next() != obj) continue;
            found = true;
            break;
        }
        if (found) {
            return li.previousIndex();
        }
        return -1;
    }

    public Object[] getElements() {
        return this.elements.toArray();
    }

    public int[] getFrequency() {
        int[] freq = new int[this.frequency.size()];
        ListIterator li = this.frequency.listIterator(0);
        while (li.hasNext()) {
            int index = li.nextIndex();
            freq[index] = (Integer)li.next();
        }
        return freq;
    }
}

