/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.mathematics.graph;

import java.util.ArrayList;
import java.util.ListIterator;
import jp.fric.mathematics.graph.Edge;
import jp.fric.mathematics.graph.Graph;
import jp.fric.mathematics.graph.GraphInformationDisplay;
import jp.fric.mathematics.graph.Vertex;
import jp.fric.util.ProgramersException;
import jp.fric.util.Queue;

public class UndirectedGraph
extends Graph {
    private ArrayList connectedSubgraphs = new ArrayList();

    @Override
    public void addEdge(Vertex v1, Vertex v2) {
        if (!super.contains(v1) || !super.contains(v2)) {
            System.err.println("At least one vertex not in the Graph");
            return;
        }
        if (v1 == v2) {
            return;
        }
        v1.addEdge(v2);
        v2.addEdge(v1);
    }

    public void toConnectedSubgraphs() {
        Queue qu = new Queue();
        this.resetVertexTraversed();
        ListIterator itVertex = this.listIterator(0);
        while (itVertex.hasNext()) {
            Vertex v = (Vertex)itVertex.next();
            if (v.isTraversed()) continue;
            UndirectedGraph subg = new UndirectedGraph();
            qu.append(v);
            while (!qu.isEmpty()) {
                Vertex w = (Vertex)qu.serve();
                if (w.isTraversed()) continue;
                w.traversed();
                subg.addVertex(w);
                ListIterator itEdge = w.listIterator(0);
                while (itEdge.hasNext()) {
                    Edge e = (Edge)itEdge.next();
                    Vertex x = e.getEndPoint();
                    if (x.isTraversed() || !super.contains(x)) continue;
                    qu.append(x);
                }
            }
            subg.setConnected();
            try {
                subg.setGraphScales();
            }
            catch (Exception e) {
                GraphInformationDisplay.showVertexAndLinkedByID(subg);
            }
            subg.setVertexTagSequentially();
            this.connectedSubgraphs.add(subg);
        }
    }

    public void sortSubgraphsGreater() {
        if (this.connectedSubgraphs.size() < 2) {
            return;
        }
        ListIterator ili = this.connectedSubgraphs.listIterator(1);
        block0: while (ili.hasNext()) {
            int index = ili.nextIndex();
            UndirectedGraph ug = (UndirectedGraph)ili.next();
            ListIterator jli = this.connectedSubgraphs.listIterator(index);
            while (jli.hasPrevious()) {
                UndirectedGraph vg = (UndirectedGraph)jli.previous();
                if (vg.size() >= ug.size()) continue block0;
                this.connectedSubgraphs.set(index, vg);
                this.connectedSubgraphs.set(index - 1, ug);
                --index;
            }
        }
    }

    public int getNumberOfSubgraphs() {
        return this.connectedSubgraphs.size();
    }

    public Graph getConnectedSubgraph(int i) {
        return (Graph)this.connectedSubgraphs.get(i);
    }

    public UndirectedGraph[] getConnectedSubgraphs() {
        return (UndirectedGraph[])this.connectedSubgraphs.toArray();
    }

    @Override
    public void setGraphScales() throws ProgramersException {
        int count = super.countNumberOfEdges();
        if (count % 2 != 0) {
            throw new ProgramersException("The number of directed links of undirected graph is not even : " + count);
        }
        this.numberOfEdges = count / 2;
    }
}

