/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.mathematics.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import jp.fric.mathematics.graph.Edge;
import jp.fric.mathematics.graph.Vertex;
import jp.fric.util.ProgramersException;

public class Ring {
    private ArrayList vertices = null;
    private ArrayList linksList = new ArrayList();

    public Ring() {
        this.vertices = new ArrayList();
    }

    public Ring(Collection c) {
        this.vertices = new ArrayList(c);
    }

    public void setVertices(List vs) {
        ListIterator li = vs.listIterator(0);
        while (li.hasNext()) {
            this.vertices.add((Vertex)li.next());
        }
    }

    public void construct() throws ProgramersException {
        ListIterator vli = this.vertices.listIterator(0);
        int listsize = this.vertices.size();
        while (vli.hasNext()) {
            int prev = (vli.previousIndex() + listsize) % listsize;
            Vertex vminus = (Vertex)this.vertices.get(prev);
            Vertex vnote = (Vertex)vli.next();
            int next = vli.nextIndex() % listsize;
            Vertex vplus = (Vertex)this.vertices.get(next);
            ListIterator eli = vnote.listIterator(0);
            boolean prevfound = false;
            boolean nextfound = false;
            ArrayList<Vertex> links = new ArrayList<Vertex>();
            while (eli.hasNext()) {
                Vertex linked = ((Edge)eli.next()).getEndPoint();
                if (linked == vminus) {
                    prevfound = true;
                    continue;
                }
                if (linked == vplus) {
                    nextfound = true;
                    continue;
                }
                links.add(linked);
            }
            if (!prevfound || !nextfound) {
                throw new ProgramersException("Previous or next linked vertex not found.");
            }
            this.linksList.add(links);
        }
    }

    public void add(Vertex ver) {
        this.vertices.add(ver);
    }

    public Vertex get(int index) {
        return (Vertex)this.vertices.get(index);
    }

    public int size() {
        if (this.vertices == null) {
            return 0;
        }
        return this.vertices.size();
    }

    public ListIterator listIterator(int pos) {
        return this.vertices.listIterator(pos);
    }

    public void setVertexInRing() {
        ListIterator li = this.vertices.listIterator(0);
        while (li.hasNext()) {
            ((Vertex)li.next()).setInRing(true);
        }
    }

    public boolean includes(Vertex v) {
        ListIterator li = this.vertices.listIterator(0);
        while (li.hasNext()) {
            if (v != (Vertex)li.next()) continue;
            return true;
        }
        return false;
    }
}

