/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.mathematics.graph;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import jp.fric.mathematics.graph.GraphAnalyzer;
import jp.fric.mathematics.graph.GraphInformationDisplay;
import jp.fric.mathematics.graph.UndirectedGraph;
import jp.fric.mathematics.graph.Vertex;
import jp.fric.statistics.Histogram;
import jp.fric.util.DebugPrinter;

public class Graph_test {
    public static void main(String[] args) {
        int i = 0;
        while (i < args.length) {
            System.out.println(args[i]);
            ++i;
        }
        if (args.length != 1) {
            System.out.println("The Number of Argument should be 1!");
            System.exit(1);
        }
        DebugPrinter.setStreams("cfe");
        DebugPrinter.setLevel(2);
        File openFile = new File(args[0]);
        if (!openFile.exists()) {
            System.out.println("The file specified by the input does not exist");
            System.exit(1);
        }
        try {
            BufferedReader breader = new BufferedReader(new FileReader(openFile));
            try {
                breader.readLine();
                breader.readLine();
                breader.readLine();
            }
            catch (Exception e) {
                System.err.println(e);
                System.exit(1);
            }
            StringTokenizer st = new StringTokenizer("");
            int nNodes = 0;
            int nEdges = 0;
            try {
                st = new StringTokenizer(breader.readLine());
                nNodes = Integer.parseInt(st.nextToken());
                nEdges = Integer.parseInt(st.nextToken());
            }
            catch (Exception e) {
                System.err.println(e);
                System.exit(1);
            }
            System.out.println("# of nodes: " + nNodes);
            System.out.println("# of edges: " + nEdges);
            UndirectedGraph digraph = new UndirectedGraph();
            int i2 = 0;
            while (i2 < nNodes) {
                try {
                    breader.readLine();
                }
                catch (Exception e) {
                    System.err.println(e);
                    System.exit(1);
                }
                digraph.addVertex(new Vertex());
                ++i2;
            }
            Histogram hg = new Histogram();
            int i3 = 0;
            while (i3 < nEdges) {
                try {
                    st = new StringTokenizer(breader.readLine());
                }
                catch (Exception e) {
                    System.err.println(e);
                    System.exit(1);
                }
                int start = Integer.parseInt(st.nextToken()) - 1;
                int end = Integer.parseInt(st.nextToken()) - 1;
                System.out.println(String.valueOf(i3) + " : " + start + " " + end);
                Vertex v1 = digraph.getVertexByID(start);
                Vertex v2 = digraph.getVertexByID(end);
                try {
                    digraph.addEdge(v1, v2);
                }
                catch (Exception e) {
                    System.err.println(e);
                    System.exit(1);
                }
                hg.add(v1);
                ++i3;
            }
            System.out.println("Histogram test");
            Object[] obj = hg.getElements();
            int[] freq = hg.getFrequency();
            int i4 = 0;
            while (i4 < obj.length) {
                System.out.println(String.valueOf(((Vertex)obj[i4]).getID()) + " " + freq[i4]);
                ++i4;
            }
            System.out.println("mode");
            obj = hg.getMode();
            i4 = 0;
            while (i4 < obj.length) {
                System.out.print(String.valueOf(((Vertex)obj[i4]).getID()) + " ");
                ++i4;
            }
            System.out.println();
            System.out.println("# of stored vertices: " + digraph.size());
            GraphInformationDisplay.showVertexAndLinkedByID(digraph);
            digraph.toConnectedSubgraphs();
            int sub = digraph.getNumberOfSubgraphs();
            System.out.println("# of subgraphs: " + sub);
            int i5 = 0;
            while (i5 < sub) {
                System.out.println("Subgraph : " + i5);
                GraphInformationDisplay.showVertexAndLinkedByTag(digraph.getConnectedSubgraph(i5));
                ++i5;
            }
            Vertex v = digraph.get(0);
            LinkedList path = digraph.getMinimumPaths(v);
            ListIterator li = path.listIterator(0);
            while (li.hasNext()) {
                int index = li.nextIndex();
                System.out.print("Vertex : " + (index + 1) + " route ");
                LinkedList alist = (LinkedList)li.next();
                ListIterator ali = alist.listIterator(0);
                while (ali.hasNext()) {
                    Vertex w = (Vertex)ali.next();
                    System.out.print(String.valueOf(digraph.indexReferenceOf(w) + 1) + " ");
                }
                System.out.println();
            }
            System.out.println("Ring Search");
            UndirectedGraph g = (UndirectedGraph)digraph.getConnectedSubgraph(0);
            GraphAnalyzer ga = new GraphAnalyzer();
            System.out.println("Before search");
            try {
                GraphAnalyzer.ringRecognize(g);
            }
            catch (Exception e) {
                System.err.println(e);
                e.printStackTrace();
            }
            System.out.println("After search");
            GraphInformationDisplay.showRings(g);
            System.out.println("After show");
        }
        catch (Exception e) {
            System.err.println("FileNotFoundException: \"" + e + "\"");
            System.exit(1);
        }
    }
}

