/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.mathematics.graph;

import java.util.ArrayList;
import java.util.ListIterator;
import jp.fric.mathematics.graph.Edge;
import jp.fric.mathematics.graph.Graph;
import jp.fric.mathematics.graph.Ring;
import jp.fric.mathematics.graph.Vertex;

public class GraphInformationDisplay {
    public static void showVertexAndLinkedByID(Graph graph) {
        System.out.println("--- Vertex Information (ID) ---");
        ListIterator itV = graph.listIterator(0);
        while (itV.hasNext()) {
            Vertex v = (Vertex)itV.next();
            System.out.print("Node: " + v.getID() + " linked to:");
            ListIterator itE = v.listIterator(0);
            while (itE.hasNext()) {
                System.out.print(" " + ((Edge)itE.next()).getEndPoint().getID());
            }
            System.out.println();
        }
    }

    public static void showVertexAndLinkedByTag(Graph graph) {
        System.out.println("--- Vertex Information (Tag) ---");
        ListIterator itV = graph.listIterator(0);
        while (itV.hasNext()) {
            Vertex v = (Vertex)itV.next();
            System.out.print("Node: " + v.getTag() + " linked to:");
            ListIterator itE = v.listIterator(0);
            while (itE.hasNext()) {
                System.out.print(" " + ((Edge)itE.next()).getEndPoint().getTag());
            }
            System.out.println();
        }
    }

    public static void showRings(Graph graph) {
        System.out.println("--- Ring Information ---");
        ArrayList rings = graph.getRingsList();
        ListIterator li = rings.listIterator(0);
        while (li.hasNext()) {
            int index = li.nextIndex();
            Ring r = (Ring)li.next();
            System.out.println("Ring: " + index + " size= " + r.size());
            System.out.print("  members:");
            ListIterator rli = r.listIterator(0);
            while (rli.hasNext()) {
                System.out.print(" " + ((Vertex)rli.next()).getID());
            }
            System.out.println();
        }
    }
}

