/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.mathematics.graph;

import java.util.LinkedList;
import java.util.ListIterator;
import jp.fric.mathematics.graph.Edge;
import jp.fric.mathematics.graph.Graph;
import jp.fric.mathematics.graph.Ring;
import jp.fric.mathematics.graph.UndirectedGraph;
import jp.fric.mathematics.graph.Vertex;
import jp.fric.util.DebugPrinter;
import jp.fric.util.ProgramersException;

public class GraphAnalyzer {
    public static boolean ringRecognize(UndirectedGraph graph) throws ProgramersException {
        if (!graph.isConnected()) {
            throw new ProgramersException("This method is for connected diagrams");
        }
        int nEdge = graph.getNumberOfEdges();
        int nVertex = graph.getNumberOfVertices();
        int maxFace = 2 + nEdge - nVertex;
        DebugPrinter.println(2, String.valueOf(nEdge) + " edges");
        DebugPrinter.println(2, String.valueOf(nVertex) + " vertices");
        DebugPrinter.println(2, "possible maximum faces = " + maxFace);
        if (maxFace < 1) {
            throw new ProgramersException("Face index is wrong: " + maxFace);
        }
        if (maxFace == 1) {
            return true;
        }
        int[] originalTags = new int[graph.size()];
        ListIterator gli = graph.listIterator(0);
        while (gli.hasNext()) {
            int index = gli.nextIndex();
            originalTags[index] = ((Vertex)gli.next()).getTag();
        }
        int NOEXP = -1;
        graph.resetAllVertexTagsBy(-1);
        graph.resetVertexTraversed();
        LinkedList<UndirectedGraph> vsInLevel = new LinkedList<UndirectedGraph>();
        int level = 0;
        boolean nextExist = true;
        Vertex v = graph.get(0);
        v.setTag(level);
        DebugPrinter.println(2, "Vertex : " + v.getID());
        Graph vs = null;
        UndirectedGraph vsnext = new UndirectedGraph();
        vsnext.addVertex(v);
        do {
            DebugPrinter.println(2, "Loop: " + level);
            vsInLevel.add(vsnext);
            vs = (Graph)vsInLevel.get(level);
            vsnext = new UndirectedGraph();
            nextExist = false;
            ListIterator vsli = vs.listIterator(0);
            block2: while (vsli.hasNext()) {
                Vertex w = (Vertex)vsli.next();
                DebugPrinter.println(2, "In while loop, Vertex: " + w.getID());
                w.traversed();
                int wlevel = w.getTag();
                if (wlevel != level) {
                    throw new ProgramersException("Inconsistency in level set in RecognizeRing()");
                }
                ListIterator wli = w.listIterator(0);
                while (wli.hasNext()) {
                    Vertex y;
                    Vertex x = ((Edge)wli.next()).getEndPoint();
                    int xlevel = x.getTag();
                    if ((xlevel == -1 || xlevel == level || xlevel == level + 1) && !graph.contains(x)) continue block2;
                    if (xlevel == -1) {
                        x.setTag(level + 1);
                        vsnext.addVertex(x);
                        nextExist = true;
                        continue;
                    }
                    if (xlevel == level) {
                        if (x.isTraversed()) continue;
                        ListIterator li = vsInLevel.listIterator(level);
                        LinkedList path = GraphAnalyzer.findPathUpTree(w, x, li);
                        DebugPrinter.println(2, "Ring found, size=" + path.size());
                        graph.addRing(new Ring(path));
                        continue;
                    }
                    if (xlevel != level + 1) continue;
                    LinkedList minpathlist = vs.getMinimumPaths(w);
                    ListIterator xli = x.listIterator(0);
                    LinkedList minpath = new LinkedList();
                    int minpathsize = Integer.MAX_VALUE;
                    while (xli.hasNext()) {
                        y = ((Edge)xli.next()).getEndPoint();
                        if (!y.isTraversed() || !graph.contains(y)) continue;
                        ListIterator mpli = minpathlist.listIterator();
                        while (mpli.hasNext()) {
                            LinkedList path = (LinkedList)mpli.next();
                            int pathsize = path.size();
                            if (pathsize <= 1 || (Vertex)path.get(pathsize - 1) != y || pathsize >= minpathsize) continue;
                            minpathsize = pathsize;
                            minpath = path;
                        }
                    }
                    if (minpathsize == Integer.MAX_VALUE) {
                        xli = x.listIterator(0);
                        y = new Vertex();
                        while (xli.hasNext()) {
                            y = ((Edge)xli.next()).getEndPoint();
                            if (y.isTraversed() && y != w && graph.contains(y)) break;
                        }
                        ListIterator li = vsInLevel.listIterator(level);
                        minpath = GraphAnalyzer.findPathUpTree(w, y, li);
                    }
                    minpath.add(x);
                    DebugPrinter.println(2, "Ring found, size=" + minpath.size());
                    graph.addRing(new Ring(minpath));
                }
            }
            ++level;
        } while (nextExist);
        gli = graph.listIterator(0);
        while (gli.hasNext()) {
            int index = gli.nextIndex();
            ((Vertex)gli.next()).setTag(originalTags[index]);
        }
        return true;
    }

    private static LinkedList findPathUpTree(Vertex w, Vertex x, ListIterator li) throws ProgramersException {
        Vertex wup;
        if (!li.hasPrevious()) {
            throw new ProgramersException("No path found.");
        }
        int level = li.previousIndex();
        Graph graph = (Graph)li.previous();
        LinkedList minpath = new LinkedList();
        int minpathsize = Integer.MAX_VALUE;
        ListIterator wli = w.listIterator(0);
        while (wli.hasNext()) {
            wup = ((Edge)wli.next()).getEndPoint();
            if (wup.getTag() != level || !graph.contains(wup)) continue;
            LinkedList paths = graph.getMinimumPaths(wup);
            ListIterator xli = x.listIterator(0);
            while (xli.hasNext()) {
                Vertex xup = ((Edge)xli.next()).getEndPoint();
                if (xup.getTag() != level || !graph.contains(xup)) continue;
                ListIterator pathsli = paths.listIterator(0);
                while (pathsli.hasNext()) {
                    LinkedList pa = (LinkedList)pathsli.next();
                    int pasize = pa.size();
                    if (pasize <= 0 || (Vertex)pa.get(pasize - 1) != xup || pasize >= minpathsize) continue;
                    minpathsize = pasize;
                    minpath = pa;
                }
            }
        }
        if (minpath.size() == 0) {
            wli = w.listIterator(0);
            wup = new Vertex();
            while (wli.hasNext()) {
                wup = ((Edge)wli.next()).getEndPoint();
                if (wup.getTag() == level && graph.contains(wup)) break;
            }
            wli = x.listIterator(0);
            Vertex xup = new Vertex();
            while (wli.hasNext()) {
                xup = ((Edge)wli.next()).getEndPoint();
                if (xup.getTag() == level && graph.contains(xup)) break;
            }
            minpath = GraphAnalyzer.findPathUpTree(wup, xup, li);
        }
        minpath.addFirst(w);
        minpath.addLast(x);
        return minpath;
    }
}

