/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.mathematics.graph;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import jp.fric.mathematics.graph.Edge;
import jp.fric.mathematics.graph.Ring;
import jp.fric.mathematics.graph.Vertex;
import jp.fric.util.ProgramersException;

public abstract class Graph {
    private ArrayList vertices = new ArrayList();
    protected int numberOfEdges = 0;
    private boolean connected = false;
    protected ArrayList ringsList = new ArrayList();

    public abstract void addEdge(Vertex var1, Vertex var2);

    public void clear() {
        this.vertices.clear();
        this.numberOfEdges = 0;
        this.connected = false;
    }

    public void createVertex() {
        this.vertices.add(new Vertex());
    }

    public void createVertex(Object obj) {
        this.vertices.add(new Vertex(obj));
    }

    public void addVertex(Vertex v) {
        if (this.vertices.contains(v)) {
            return;
        }
        this.vertices.add(v);
    }

    public boolean add(Object obj) {
        if (obj instanceof Vertex) {
            this.addVertex((Vertex)obj);
        } else {
            this.createVertex(obj);
        }
        return true;
    }

    public Vertex get(int index) {
        return (Vertex)this.vertices.get(index);
    }

    public Vertex getVertexByID(int id) throws ProgramersException {
        ListIterator li = this.vertices.listIterator(0);
        Vertex v = null;
        while (li.hasNext()) {
            v = (Vertex)li.next();
            if (v.getID() == id) break;
        }
        if (v == null) {
            throw new ProgramersException("No Vertex with the id exists");
        }
        return v;
    }

    public void addRing(Ring r) {
        r.setVertexInRing();
        this.ringsList.add(r);
    }

    public void sortRingsListGreater() {
        if (this.ringsList.size() < 2) {
            return;
        }
        ListIterator ili = this.ringsList.listIterator(0);
        block0: while (ili.hasNext()) {
            int index = ili.nextIndex();
            Ring r = (Ring)ili.next();
            ListIterator jli = this.ringsList.listIterator(index);
            while (jli.hasPrevious()) {
                Ring s = (Ring)jli.previous();
                if (s.size() >= r.size()) continue block0;
                this.ringsList.set(index, s);
                this.ringsList.set(index - 1, r);
                --index;
            }
        }
    }

    public void setGraphScales() throws ProgramersException {
        this.numberOfEdges = this.countNumberOfEdges();
    }

    protected int countNumberOfEdges() {
        int nEdges = 0;
        ListIterator vli = this.vertices.listIterator(0);
        while (vli.hasNext()) {
            Vertex v = (Vertex)vli.next();
            ListIterator eli = v.listIterator(0);
            while (eli.hasNext()) {
                Vertex w = ((Edge)eli.next()).getEndPoint();
                if (!this.vertices.contains(w)) continue;
                ++nEdges;
            }
        }
        return nEdges;
    }

    public int size() {
        return this.vertices.size();
    }

    public boolean contains(Vertex v) {
        return this.vertices.contains(v);
    }

    public ListIterator listIterator(int pos) {
        return this.vertices.listIterator(pos);
    }

    public int getNumberOfVertices() {
        return this.size();
    }

    public int getNumberOfEdges() {
        return this.numberOfEdges;
    }

    public ArrayList getRingsList() {
        return this.ringsList;
    }

    public void setConnected() {
        this.connected = true;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setVertexTagSequentially() {
        ListIterator vli = this.vertices.listIterator(0);
        int count = 0;
        while (vli.hasNext()) {
            ((Vertex)vli.next()).setTag(count++);
        }
    }

    public void resetAllVertexTagsBy(int tag) {
        ListIterator vli = this.vertices.listIterator(0);
        while (vli.hasNext()) {
            ((Vertex)vli.next()).setTag(tag);
        }
    }

    public void resetVertexTraversed() {
        ListIterator vli = this.vertices.listIterator(0);
        while (vli.hasNext()) {
            ((Vertex)vli.next()).setTraversed(false);
        }
    }

    public void resetVertexInRing() {
        ListIterator vli = this.vertices.listIterator(0);
        while (vli.hasNext()) {
            ((Vertex)vli.next()).setInRing(false);
        }
    }

    public int indexReferenceOf(Vertex v) {
        ListIterator vli = this.vertices.listIterator(0);
        while (vli.hasNext()) {
            if ((Vertex)vli.next() != v) continue;
            return vli.previousIndex();
        }
        return -1;
    }

    public LinkedList getMinimumPaths(Vertex source) {
        int MAX_INT = Integer.MAX_VALUE;
        int NOEXP = -1;
        boolean nolinked = true;
        boolean[] found = new boolean[this.size()];
        int[] distance = new int[this.size()];
        int i = 0;
        while (i < distance.length) {
            distance[i] = Integer.MAX_VALUE;
            ++i;
        }
        LinkedList paths = new LinkedList();
        int i2 = 0;
        while (i2 < this.size()) {
            paths.add(new LinkedList());
            ++i2;
        }
        ListIterator vli = this.vertices.listIterator(0);
        while (vli.hasNext()) {
            int index = vli.nextIndex();
            Vertex v = (Vertex)vli.next();
            if (source.isLinkedTo(v)) {
                distance[index] = 1;
                ((LinkedList)paths.get(index)).add(source);
                nolinked = false;
                continue;
            }
            if (source != v) continue;
            distance[index] = 0;
            found[index] = true;
            ((LinkedList)paths.get(index)).add(source);
        }
        if (nolinked) {
            return paths;
        }
        int i3 = 0;
        while (i3 < this.size()) {
            int mindist = Integer.MAX_VALUE;
            int findex = -1;
            int j = 0;
            do {
                if (found[j] || distance[j] >= mindist) continue;
                findex = j;
                mindist = distance[j];
            } while (++j < this.size());
            if (mindist == Integer.MAX_VALUE) {
                return paths;
            }
            found[findex] = true;
            Vertex fv = (Vertex)this.vertices.get(findex);
            ((LinkedList)paths.get(findex)).add(fv);
            vli = this.vertices.listIterator(0);
            while (vli.hasNext()) {
                int index = vli.nextIndex();
                Vertex v = (Vertex)vli.next();
                if (found[index] || !fv.isLinkedTo(v) || mindist + 1 >= distance[index]) continue;
                distance[index] = mindist + 1;
                paths.set(index, new LinkedList((LinkedList)paths.get(findex)));
            }
            ++i3;
        }
        return paths;
    }
}

