/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.mathematics.geometry.plane;

import java.awt.geom.Point2D;

public class RingShape {
    protected Point2D.Double center = new Point2D.Double();
    protected double radius = 0.0;

    public RingShape() {
    }

    public RingShape(Point2D.Double c, double r) {
        this.center = (Point2D.Double)c.clone();
        this.radius = r;
    }

    public RingShape(double cx, double cy, double r) {
        this.center = new Point2D.Double(cx, cy);
        this.radius = r;
    }

    public void setCenter(Point2D.Double c) {
        this.center = (Point2D.Double)c.clone();
    }

    public void getRadius(double r) {
        this.radius = r;
    }

    public Point2D.Double getCenter() {
        return (Point2D.Double)this.center.clone();
    }

    public double getRadius() {
        return this.radius;
    }

    public double overlappingAreaWith(RingShape r) {
        Point2D.Double cR = r.getCenter();
        double rR = r.getRadius();
        double d = this.center.distance(cR);
        double area = 0.0;
        if (d < this.radius + rR) {
            if (d > Math.abs(this.radius - rR)) {
                double diff = (this.radius - rR) * (this.radius + rR);
                double cosA = (d * d + diff) / (2.0 * this.radius * d);
                double cosB = (d * d - diff) / (2.0 * rR * d);
                area = this.radius * this.radius * Math.acos(cosA) + rR * rR * Math.acos(cosB) - d * rR * Math.sqrt(1.0 - cosB * cosB);
            } else {
                double minr = this.radius;
                if (minr > rR) {
                    minr = rR;
                }
                area = minr * minr * Math.PI;
            }
        }
        return area;
    }
}

