/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.mathematics.geometry.plane;

import jp.fric.mathematics.algebra.numberTheory.NumberUtility;
import jp.fric.mathematics.algebra.series.SeriesGenerator;
import jp.fric.mathematics.geometry.plane.GridPoint;
import jp.fric.util.ProgramersException;

public class CoprimeGridPointSeriesGenerator
implements SeriesGenerator {
    private static int count = 0;
    private static GridPoint p = new GridPoint(1, 0);
    private static int series = 1;
    private static GridPoint delta = new GridPoint(-1, 1);
    private static int region = 1;
    public static final int FIRST_QUAD = 1;
    public static final int ALL_QUADS = 9;

    public CoprimeGridPointSeriesGenerator() {
    }

    public CoprimeGridPointSeriesGenerator(GridPoint pt) {
        p = pt;
        series = Math.abs(pt.x) + Math.abs(pt.y);
    }

    public void setRegion(int region_const) throws ProgramersException {
        if (region_const == 1) {
            region = region_const;
        } else if (region_const == 9) {
            region = region_const;
        } else {
            throw new ProgramersException("No such regiondesignator defined.");
        }
    }

    @Override
    public Object next() {
        GridPoint nextgrid = null;
        boolean found = false;
        do {
            if (NumberUtility.coprime(CoprimeGridPointSeriesGenerator.p.x, CoprimeGridPointSeriesGenerator.p.y)) {
                ++count;
                found = true;
                nextgrid = new GridPoint(CoprimeGridPointSeriesGenerator.p.x, CoprimeGridPointSeriesGenerator.p.y);
            }
            if (region == 1) {
                if (CoprimeGridPointSeriesGenerator.p.x == 0) {
                    CoprimeGridPointSeriesGenerator.p.x = ++series;
                    CoprimeGridPointSeriesGenerator.p.y = 0;
                }
            } else if (region == 9 && CoprimeGridPointSeriesGenerator.p.y == -1 && CoprimeGridPointSeriesGenerator.p.x >= 0) {
                ++series;
                ++CoprimeGridPointSeriesGenerator.p.x;
            }
            CoprimeGridPointSeriesGenerator.p.x += CoprimeGridPointSeriesGenerator.delta.x;
            CoprimeGridPointSeriesGenerator.p.y += CoprimeGridPointSeriesGenerator.delta.y;
            if (region != 9) continue;
            if (CoprimeGridPointSeriesGenerator.p.y == 0) {
                CoprimeGridPointSeriesGenerator.delta.x = -CoprimeGridPointSeriesGenerator.delta.x;
            }
            if (CoprimeGridPointSeriesGenerator.p.x != 0) continue;
            CoprimeGridPointSeriesGenerator.delta.y = -CoprimeGridPointSeriesGenerator.delta.y;
        } while (!found);
        return nextgrid;
    }

    @Override
    public void reset() {
        count = 0;
        CoprimeGridPointSeriesGenerator.p.x = 1;
        CoprimeGridPointSeriesGenerator.p.y = 0;
        series = 1;
        CoprimeGridPointSeriesGenerator.delta.x = -1;
        CoprimeGridPointSeriesGenerator.delta.y = 1;
    }

    @Override
    public boolean resetBy(Object pt) {
        count = 0;
        p = (GridPoint)pt;
        boolean appropriate = true;
        if (region == 1) {
            if (CoprimeGridPointSeriesGenerator.p.x < 0 || CoprimeGridPointSeriesGenerator.p.y < 0 || CoprimeGridPointSeriesGenerator.p.x == 0 && CoprimeGridPointSeriesGenerator.p.y == 0) {
                this.reset();
                appropriate = false;
            } else {
                this.setSeries();
                this.setDelta();
            }
        } else if (region == 9) {
            if (CoprimeGridPointSeriesGenerator.p.x == 0 && CoprimeGridPointSeriesGenerator.p.y == 0) {
                this.reset();
                appropriate = false;
            } else {
                this.setSeries();
                this.setDelta();
            }
        }
        return appropriate;
    }

    @Override
    public int getCount() {
        return count;
    }

    private void setSeries() {
        series = Math.abs(CoprimeGridPointSeriesGenerator.p.x) + Math.abs(CoprimeGridPointSeriesGenerator.p.y);
    }

    private void setDelta() {
        if (region == 1) {
            CoprimeGridPointSeriesGenerator.delta.x = -1;
            CoprimeGridPointSeriesGenerator.delta.y = 1;
        } else if (region == 9) {
            CoprimeGridPointSeriesGenerator.delta.x = CoprimeGridPointSeriesGenerator.p.y > 0 ? -1 : (CoprimeGridPointSeriesGenerator.p.y < 0 ? 1 : (CoprimeGridPointSeriesGenerator.p.x > 0 ? -1 : 1));
            CoprimeGridPointSeriesGenerator.delta.y = CoprimeGridPointSeriesGenerator.p.x > 0 ? 1 : (CoprimeGridPointSeriesGenerator.p.x < 0 ? -1 : (CoprimeGridPointSeriesGenerator.p.y > 0 ? -1 : 1));
        }
    }
}

