/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.mathematics.algebra;

import jp.fric.mathematics.algebra.numberTheory.NumberUtility;

public class Fraction {
    private int numerator = 1;
    private int denominator = 1;

    public Fraction() {
    }

    public Fraction(int numerator, int denominator) {
        this.set(numerator, denominator);
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public void set(int numerator, int denominator) {
        if (denominator == 0) {
            return;
        }
        if (numerator == 0) {
            this.numerator = 0;
            this.denominator = 1;
            return;
        }
        int sign = 1;
        if (numerator < 0 && denominator > 0 || numerator > 0 && denominator < 0) {
            sign = -1;
        }
        int n = Math.abs(numerator);
        int d = Math.abs(denominator);
        int gcd = NumberUtility.calculateGCDOf(n, d);
        this.numerator = sign * n / gcd;
        this.denominator = d / gcd;
    }

    public boolean equals(Object fraction) {
        if (fraction == null || !(fraction instanceof Fraction)) {
            return false;
        }
        Fraction f = (Fraction)fraction;
        return this.numerator == f.numerator && this.denominator == f.denominator;
    }

    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public static Fraction approximate(double value, int maxdenominator) {
        double e;
        if (maxdenominator < 2) {
            return null;
        }
        double f = value - (double)((int)value);
        int d = 2;
        while (!(Math.abs((e = f * (double)d) - (double)Math.round(e)) < 1.0E-6) && ++d <= maxdenominator) {
        }
        if (d == maxdenominator + 1) {
            return null;
        }
        int numerator = d * (int)value + (int)Math.round(e);
        return new Fraction(numerator, d);
    }
}

