/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.io.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class MyGTKFileChooser
extends JFileChooser
implements ItemListener {
    private final Insets insets = new Insets(4, 4, 4, 4);
    private JComboBox filterCombo = new JComboBox();

    public MyGTKFileChooser() {
        this.createUI();
    }

    private void createUI() {
        JPanel filterPanel = new JPanel();
        filterPanel.setBorder(new EmptyBorder(this.insets));
        filterPanel.setLayout(new BorderLayout());
        filterPanel.add((Component)new JLabel("File of Type:"), "North");
        JPanel comboPanel = new JPanel();
        this.filterCombo.addItemListener(this);
        this.filterCombo.setPreferredSize(new Dimension(144, 20));
        comboPanel.add((Component)this.filterCombo, null);
        filterPanel.add((Component)comboPanel, "Center");
        this.setAccessory(filterPanel);
    }

    private void rebuildFilterCombo() {
        this.filterCombo.setEnabled(false);
        this.filterCombo.removeAllItems();
        FileFilter[] filters = this.getChoosableFileFilters();
        if (filters == null || filters.length == 0) {
            return;
        }
        int i = 0;
        while (i < filters.length) {
            this.filterCombo.addItem(this.makeObj(filters[i]));
            ++i;
        }
        this.filterCombo.setEnabled(true);
    }

    private WrappedObject makeObj(final FileFilter fileFilter) {
        return new WrappedObject(){

            @Override
            public Object getObject() {
                return fileFilter;
            }

            public String toString() {
                return fileFilter.getDescription();
            }
        };
    }

    @Override
    public void setFileFilter(FileFilter fileFilter) {
        super.setFileFilter(fileFilter);
        if (this.filterCombo != null) {
            this.rebuildFilterCombo();
            this.filterCombo.setSelectedItem(fileFilter);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        FileFilter f = (FileFilter)((WrappedObject)this.filterCombo.getSelectedItem()).getObject();
        super.setFileFilter(f);
    }

    private abstract class WrappedObject {
        private WrappedObject() {
        }

        public abstract Object getObject();
    }
}

