/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.io.util;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.filechooser.FileFilter;

public class MyFileFilter
extends FileFilter {
    private HashSet filters = null;
    private String description = null;
    private String fullDescription = null;

    public MyFileFilter(String[] suffices, String description) {
        if (suffices == null) {
            this.fullDescription = this.description = "All Files";
        } else {
            this.filters = new HashSet(suffices.length);
            int i = 0;
            while (i < suffices.length) {
                if (suffices[i] != null) {
                    this.filters.add(suffices[i].toLowerCase());
                }
                ++i;
            }
            this.description = description;
        }
    }

    @Override
    public boolean accept(File file) {
        if (this.filters == null) {
            return true;
        }
        if (file.isDirectory()) {
            return true;
        }
        String suffix = this.getExtensionOf(file);
        return suffix != null && this.filters.contains(suffix);
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            this.fullDescription = this.description == null ? "" : this.description;
            this.fullDescription = String.valueOf(this.fullDescription) + " (";
            Iterator it = this.filters.iterator();
            if (it.hasNext()) {
                this.fullDescription = String.valueOf(this.fullDescription) + "." + it.next();
            }
            while (it.hasNext()) {
                this.fullDescription = String.valueOf(this.fullDescription) + ", " + it.next();
            }
            this.fullDescription = String.valueOf(this.fullDescription) + ")";
        }
        return this.fullDescription;
    }

    public String getDefaultExtention() {
        if (this.filters == null || this.filters.iterator() == null || !this.filters.iterator().hasNext()) {
            return "";
        }
        for (String extmp : this.filters) {
            if (extmp.equals("xml")) {
                return extmp;
            }
            if (!extmp.equals("jpg")) continue;
            return extmp;
        }
        return (String)this.filters.iterator().next();
    }

    private String getExtensionOf(File file) {
        String string;
        int i;
        if (file != null && (i = (string = file.getName()).lastIndexOf(46)) > 0 && i < string.length() - 1) {
            return string.substring(i + 1).toLowerCase();
        }
        return null;
    }
}

