/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.io.util;

import java.awt.Component;
import java.io.File;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import jp.fric.io.util.MyFileFilter;
import jp.fric.io.util.MyGTKFileChooser;

public class FilePather {
    public static final int OPEN = 1;
    public static final int SAVE = 2;
    private String currentOpeningDir = ".";
    private String currentSavingDir = ".";
    private JFileChooser chooser = null;
    public static final int XML_FILTER = 100;
    public static final int JPG_FILTER = 200;
    public static final int PNG_FILTER = 201;
    public static final int SVG_FILTER = 202;
    public static final int PDF_FILTER = 203;
    public static final int EPS_FILTER = 204;
    public static final int ALL_FILES_FILTER = 999;
    private MyFileFilter xmlFilter = new MyFileFilter(new String[]{"xml"}, "XML Files");
    private MyFileFilter jpgFilter = new MyFileFilter(new String[]{"jpg", "jpeg"}, "JPEG Image Files");
    private MyFileFilter pngFilter = new MyFileFilter(new String[]{"png"}, "PNG Image Files");
    private MyFileFilter svgFilter = new MyFileFilter(new String[]{"svg"}, "SVG Files");
    private MyFileFilter pdfFilter = new MyFileFilter(new String[]{"pdf"}, "PDF Files");
    private MyFileFilter epsFilter = new MyFileFilter(new String[]{"eps"}, "EPS Files");
    private MyFileFilter allFilesFilter = new MyFileFilter(null, UIManager.getString((Object)"FileChooser.acceptAllFileFilterText", Locale.getDefault()));

    public FilePather() {
    }

    public FilePather(String openDirectory, String saveDirectory) {
        this();
        this.currentOpeningDir = openDirectory;
        this.currentSavingDir = saveDirectory;
    }

    public String currentOpeningDir() {
        return this.currentOpeningDir;
    }

    public String currentSavingDir() {
        return this.currentSavingDir;
    }

    private MyFileFilter getFilter(int id) {
        switch (id) {
            case 100: {
                return this.xmlFilter;
            }
            case 200: {
                return this.jpgFilter;
            }
            case 201: {
                return this.pngFilter;
            }
            case 202: {
                return this.svgFilter;
            }
            case 203: {
                return this.pdfFilter;
            }
            case 204: {
                return this.epsFilter;
            }
            case 999: {
                return this.allFilesFilter;
            }
        }
        return null;
    }

    private void removeAllFilters() {
        if (this.chooser == null) {
            this.createChooser();
        }
        FileFilter[] filters = this.chooser.getChoosableFileFilters();
        int i = 0;
        while (i < filters.length) {
            this.chooser.removeChoosableFileFilter(filters[i]);
            ++i;
        }
    }

    private void createChooser() {
        String javaVMSpecVersion = System.getProperty("java.specification.version");
        this.chooser = UIManager.getLookAndFeel().getClass().getName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel") && javaVMSpecVersion.equals("1.4") ? new MyGTKFileChooser(){

            @Override
            public void approveSelection() {
                if (FilePather.this.isReplaceFile(this)) {
                    super.approveSelection();
                }
            }
        } : new JFileChooser(){

            @Override
            public void approveSelection() {
                if (FilePather.this.isReplaceFile(this)) {
                    super.approveSelection();
                }
            }
        };
    }

    public File getUserSelection(Component owner, int flag, String suffix, String filterDesc, String defaultName) {
        return this.getUserSelection(owner, flag, new String[]{suffix}, filterDesc, defaultName);
    }

    public File getUserSelection(Component owner, int flag, String[] suffices, String filterDesc, String defaultName) {
        String directory = ".";
        directory = flag == 1 ? this.currentOpeningDir : this.currentSavingDir;
        if (this.chooser == null) {
            this.createChooser();
        }
        this.chooser.setCurrentDirectory(new File(directory));
        MyFileFilter examplefilefilter = new MyFileFilter(suffices, filterDesc);
        this.removeAllFilters();
        this.chooser.setAcceptAllFileFilterUsed(true);
        this.chooser.addChoosableFileFilter(examplefilefilter);
        this.chooser.setFileFilter(examplefilefilter);
        if (defaultName != null) {
            this.chooser.setSelectedFile(new File(defaultName));
        }
        this.chooser.setFileSelectionMode(0);
        int chooserstate = flag == 1 ? this.chooser.showOpenDialog(owner) : this.chooser.showSaveDialog(owner);
        File file = this.chooser.getSelectedFile();
        if (chooserstate != 0 || file == null || file.isDirectory()) {
            return null;
        }
        if (flag == 1) {
            this.currentOpeningDir = file.getParent();
        } else {
            this.currentSavingDir = file.getParent();
        }
        return file;
    }

    public File getUserSelection(Component owner, int flag, int[] filters, String defaultName) {
        String directory = ".";
        directory = flag == 1 ? this.currentOpeningDir : this.currentSavingDir;
        if (this.chooser == null) {
            this.createChooser();
        }
        this.chooser.setCurrentDirectory(new File(directory));
        this.removeAllFilters();
        if (filters != null) {
            MyFileFilter firstNonNull = null;
            int i = 0;
            while (i < filters.length) {
                MyFileFilter filter = this.getFilter(filters[i]);
                if (filter != null) {
                    this.chooser.addChoosableFileFilter(filter);
                    if (firstNonNull == null) {
                        firstNonNull = filter;
                    }
                }
                ++i;
            }
            if (firstNonNull != null) {
                this.chooser.setFileFilter(firstNonNull);
            }
        }
        if (defaultName != null) {
            this.chooser.setSelectedFile(new File(defaultName));
        }
        this.chooser.setFileSelectionMode(0);
        int chooserstate = flag == 1 ? this.chooser.showOpenDialog(owner) : this.chooser.showSaveDialog(owner);
        File file = this.chooser.getSelectedFile();
        this.removeAllFilters();
        if (chooserstate != 0 || file == null || file.isDirectory()) {
            return null;
        }
        if (flag == 1) {
            this.currentOpeningDir = file.getParent();
        } else {
            this.currentSavingDir = file.getParent();
        }
        return file;
    }

    private boolean isReplaceFile(JFileChooser chooser) {
        if (chooser.getDialogType() == 0) {
            return true;
        }
        File file = chooser.getSelectedFile();
        if (file != null) {
            FileFilter fileFilter = chooser.getFileFilter();
            if (!fileFilter.accept(file) && fileFilter instanceof MyFileFilter) {
                String fileName = file.getName();
                String ext = ((MyFileFilter)fileFilter).getDefaultExtention();
                fileName = fileName.endsWith(".") ? String.valueOf(fileName) + ext : String.valueOf(fileName) + "." + ext;
                file = new File(file.getParent(), fileName);
            }
            chooser.setSelectedFile(file);
            if (file.exists()) {
                String title = "Save";
                String message = "The same name already exists. Replace " + file.getName() + "\uff1f";
                int option = JOptionPane.showConfirmDialog(chooser, message, title, 0, 3);
                if (option == 0) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

