/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.multiwindow;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import jp.fric.graphics.draw.GMouseInterpreter;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.multiwindow.MultiWindowFrame;
import jp.fric.graphics.multiwindow.StatusBar;
import jp.fric.graphics.multiwindow.ZoomFrameListener;
import jp.fric.util.Debug;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.Preference;

public abstract class ZoomFrame
extends MultiWindowFrame {
    public static final int[] zoomRate = new int[]{150, 125, 110, 100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 15, 10, 5};
    public static final double zoomDefaultMinRate;
    public static final double zoomDefaultMaxRate;
    private boolean isDebug = false;
    protected JScrollBar scrollbarV = new JScrollBar(1);
    protected JScrollBar scrollbarH = new JScrollBar(0);
    private CornerPanel cornerPanel = new CornerPanel();
    private JPanel panelScrollbarH = new JPanel();
    private OffscreenPanel panel;
    double openingW = 0.0;
    double openingH = 0.0;
    private JPanel scrollPanel;
    private StatusBar statusBar;
    private boolean isStatusBarVisible = true;
    protected Transformer transformer;
    private OffscreenResizer resizer;
    private KeyInterpreter keyInterpreter;
    private MouseInterpreter mouseInterpreter;
    private ScrollbarListener scrollListener;
    private Rectangle lastRepaintRect = null;
    private boolean isHandMoveMode = false;
    private boolean isHandMoveEnabled = false;
    private boolean initmode = false;
    private Vector listeners = new Vector();
    private GStructure structure;

    static {
        int min = zoomRate[0];
        int max = zoomRate[0];
        int i = 0;
        while (i < zoomRate.length) {
            if (zoomRate[i] < min) {
                min = zoomRate[i];
            } else if (zoomRate[i] > max) {
                max = zoomRate[i];
            }
            ++i;
        }
        zoomDefaultMinRate = (double)min / 100.0;
        zoomDefaultMaxRate = (double)max / 100.0;
    }

    private static final double getNextZoomRateFromTable(double currentRate, boolean zoomIn) {
        if (zoomIn) {
            if (currentRate < zoomDefaultMinRate) {
                return zoomDefaultMinRate;
            }
            if (currentRate >= zoomDefaultMaxRate) {
                return Double.MAX_VALUE;
            }
            int i = zoomRate.length - 1;
            while (i >= 0) {
                double rate = (double)zoomRate[i] / 100.0;
                if (currentRate < rate) {
                    return rate;
                }
                --i;
            }
        } else {
            if (currentRate <= zoomDefaultMinRate) {
                return currentRate;
            }
            if (currentRate > zoomDefaultMinRate && currentRate <= zoomDefaultMaxRate) {
                int i = 0;
                while (i < zoomRate.length) {
                    double rate = (double)zoomRate[i] / 100.0;
                    if (currentRate > rate) {
                        return rate;
                    }
                    ++i;
                }
            } else {
                if (currentRate > zoomDefaultMaxRate && currentRate <= zoomDefaultMaxRate + 0.5) {
                    return zoomDefaultMaxRate;
                }
                return Double.MAX_VALUE;
            }
        }
        return Double.MIN_VALUE;
    }

    public void setStructure(GStructure structure) {
        this.structure = structure;
    }

    public BoundedRangeModel getScrollBarHModel() {
        if (this.scrollbarH.isShowing()) {
            return this.scrollbarH.getModel();
        }
        return null;
    }

    public BoundedRangeModel getScrollBarVModel() {
        if (this.scrollbarV.isShowing()) {
            return this.scrollbarV.getModel();
        }
        return null;
    }

    public void setInitMode(boolean flg) {
        this.initmode = flg;
    }

    public boolean getInitMode() {
        return this.initmode;
    }

    public ZoomFrame() {
        this.initFrame();
    }

    public void addAdjustmentListenerH(AdjustmentListener listener) {
        this.scrollbarH.addAdjustmentListener(listener);
    }

    public void addAdjustmentListenerV(AdjustmentListener listener) {
        this.scrollbarV.addAdjustmentListener(listener);
    }

    public ZoomFrame(double width, double height) {
        this.initFrame();
        this.setPreferredOpeningSize(width, height);
    }

    public synchronized void addZoomFrameListener(ZoomFrameListener zoomframelistener) {
        this.listeners.add(zoomframelistener);
    }

    @Override
    protected void finalize() throws Throwable {
        Debug.println("[ZoomFrame] finalize() <" + super.toString() + ">");
        super.finalize();
    }

    private void fireListeners(MouseEvent mouseevent) {
        Point2D.Double logicalPoint = this.transformer.toLogicalPoint(mouseevent.getX(), mouseevent.getY());
        if (logicalPoint != null) {
            int i = 0;
            while (i < this.listeners.size()) {
                ZoomFrameListener zoomframelistener = (ZoomFrameListener)this.listeners.get(i);
                zoomframelistener.mouseOperated(logicalPoint.x, logicalPoint.y, mouseevent.getID(), mouseevent.getClickCount(), mouseevent);
                ++i;
            }
        }
        if (!MainWindow.isFocusedKineticLaw()) {
            this.requestFocus();
        }
    }

    public Rectangle2D.Double getLogicalViewArea() {
        return this.transformer.getLogicalViewArea();
    }

    @Override
    public Dimension getPreferredOpeningSize() {
        return new Dimension((int)this.openingW, (int)this.openingH);
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    private void initFrame() {
        this.setLayout(new BorderLayout());
        this.transformer = new Transformer();
        this.resizer = new OffscreenResizer();
        this.keyInterpreter = new KeyInterpreter();
        this.mouseInterpreter = new MouseInterpreter(this);
        this.scrollListener = new ScrollbarListener();
        this.scrollPanel = new JPanel();
        this.scrollPanel.setLayout(new BorderLayout());
        this.panel = new OffscreenPanel();
        this.panel.addMouseMotionListener(this.mouseInterpreter);
        this.panel.addMouseListener(this.mouseInterpreter);
        this.panel.addMouseWheelListener(this.mouseInterpreter);
        this.scrollPanel.add((Component)this.panel, "Center");
        this.panelScrollbarH.setBorder(BorderFactory.createEmptyBorder());
        this.panelScrollbarH.setLayout(new BorderLayout());
        this.panelScrollbarH.add((Component)this.scrollbarH, "Center");
        this.panelScrollbarH.add((Component)this.cornerPanel, "East");
        this.scrollbarV.addAdjustmentListener(this.scrollListener);
        this.scrollbarH.addAdjustmentListener(this.scrollListener);
        this.statusBar = new StatusBar();
        this.statusBar.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.statusBar, "South");
        this.add((Component)this.scrollPanel, "Center");
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        super.addKeyListener(this.keyInterpreter);
        this.panel.addComponentListener(this.resizer);
        Debug.println("[ZoomFrame] constructed <" + super.toString() + ">");
        MouseInputAdapter adapter = new MouseInputAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ZoomFrame.this.setCursor(Cursor.getDefaultCursor());
                super.mouseEntered(e);
            }
        };
        this.scrollbarH.addMouseListener(adapter);
        this.scrollbarV.addMouseListener(adapter);
    }

    public boolean isEbleToZoomDown() {
        return this.transformer.isAbleToChangeScale(false);
    }

    public boolean isEbleToZoomUp() {
        return this.transformer.isAbleToChangeScale(true);
    }

    public boolean isStatusBarVisible() {
        return this.isStatusBarVisible;
    }

    public abstract void paintLogicalContents(Graphics2D var1);

    public void paintTransformedContents() {
        Graphics2D graphics2d = this.panel.getOffscreenGraphics();
        if (graphics2d != null) {
            this.transformer.updateViewPosition();
            AffineTransform affinetransform = this.transformer.getAffineTransform();
            graphics2d.setTransform(affinetransform);
            Rectangle2D.Double logicalView = this.transformer.getLogicalViewArea();
            graphics2d.setClip(logicalView);
            graphics2d.setColor(this.getBackground());
            graphics2d.fill(logicalView);
            this.paintLogicalContents(graphics2d);
            graphics2d.setClip(null);
        }
    }

    public void paintTransformedContents(Rectangle2D logicalArea) {
        Graphics2D graphics2d = this.panel.getOffscreenGraphics();
        if (graphics2d != null) {
            AffineTransform affinetransform = this.transformer.getAffineTransform();
            Rectangle2D clip = this.transformer.getLogicalViewArea();
            clip = ((Rectangle2D)clip).createIntersection(logicalArea);
            graphics2d.setTransform(affinetransform);
            graphics2d.setClip(clip);
            graphics2d.setColor(this.getBackground());
            graphics2d.fill(clip);
            this.paintLogicalContents(graphics2d);
            graphics2d.setClip(null);
        }
    }

    @Override
    public void releaseAll() {
        Debug.println("[ZoomFrame] releaseAll() <" + super.toString() + ">");
        super.removeKeyListener(this.keyInterpreter);
        this.scrollbarV.removeAdjustmentListener(this.scrollListener);
        this.scrollbarH.removeAdjustmentListener(this.scrollListener);
        this.panel.removeMouseListener(this.mouseInterpreter);
        this.panel.removeMouseMotionListener(this.mouseInterpreter);
        this.panel.removeMouseWheelListener(this.mouseInterpreter);
        this.panel.removeComponentListener(this.resizer);
        this.panel.release();
        this.panel = null;
        this.keyInterpreter = null;
        this.mouseInterpreter = null;
        this.scrollListener = null;
        this.resizer = null;
        this.transformer = null;
        this.structure = null;
        this.scrollbarH = null;
        this.scrollbarV = null;
        this.cornerPanel.removeAll();
        this.cornerPanel = null;
        this.panelScrollbarH.removeAll();
        this.panelScrollbarH = null;
        this.statusBar.removeAll();
        this.statusBar = null;
        this.scrollPanel.removeAll();
        this.scrollPanel = null;
        super.releaseAll();
        super.removeAll();
    }

    public synchronized void removeZoomFrameListener(ZoomFrameListener zoomframelistener) {
        this.listeners.remove(zoomframelistener);
    }

    @Override
    public void repaintFrameContents() {
        this.paintTransformedContents();
        this.panel.repaint();
    }

    @Override
    public void repaintLogicalArea(Rectangle2D logicalArea) {
        this.repaintLogicalArea(logicalArea, true);
    }

    @Override
    public void repaintLogicalArea(Rectangle2D logicalArea, boolean repaint) {
        Rectangle2D.Double clippedArea = this.transformer.getClipArea(logicalArea);
        if (clippedArea != null) {
            this.paintTransformedContents(clippedArea);
            if (this.isDebug) {
                this.lastRepaintRect = this.transformer.onWindow(clippedArea);
            }
            if (repaint) {
                this.panel.repaint();
            }
        }
    }

    public void repaintOffScreenPanel() {
        this.panel.repaint();
    }

    public void scrollView(double logicalX, double logicalY) {
        this.scrollListener.setEnabled(false);
        this.transformer.moveToLogicalPoint(logicalX, logicalY);
        this.scrollbarV.setValue((int)(-this.transformer.viewY));
        this.scrollbarH.setValue((int)(-this.transformer.viewX));
        this.repaintFrameContents();
        this.scrollListener.setEnabled(true);
    }

    @Override
    public void setActualOpeningSize(Dimension dimension) {
        this.panel.setNewSize(dimension.width, dimension.height);
    }

    public void setHandMoveEnabled(boolean handmove) {
        this.isHandMoveEnabled = handmove;
    }

    public void setHandMoveMode(boolean handmove) {
        if (this.isHandMoveEnabled) {
            this.isHandMoveMode = handmove;
            if (handmove) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public void setLogicalSize(double width, double height) {
        this.setPreferredOpeningSize(width, height);
        this.transformer.relocateScrollBars();
        this.validate();
        this.panel.remakeOffscreen();
        this.repaintFrameContents();
    }

    public void setPreferredOpeningSize(double width, double height) {
        this.openingW = width;
        this.openingH = height;
        this.transformer.setLogicalSize(width, height);
    }

    public void setStatusBarVisible(boolean statusBarVisible) {
        ZoomFrame container = this;
        boolean includeStatusBar = false;
        Component[] components = container.getComponents();
        int i = 0;
        while (i < components.length) {
            if (components[i] == this.statusBar) {
                includeStatusBar = true;
            }
            ++i;
        }
        if (statusBarVisible && !includeStatusBar) {
            container.add((Component)this.statusBar, "South");
        } else if (!statusBarVisible && includeStatusBar) {
            container.remove(this.statusBar);
        }
        this.isStatusBarVisible = statusBarVisible;
        this.validate();
    }

    public void tglDebug() {
        this.isDebug ^= true;
        this.repaintFrameContents();
        this.statusBar.setString1("");
    }

    public void zoomDown() {
        this.transformer.decrementScale();
    }

    public void zoomUp() {
        this.transformer.incrementScale();
    }

    public void zoomByInput(double selected) {
        this.transformer.updateScale(selected);
    }

    public Rectangle getCurrentLogicalViewArea() {
        Dimension dimension = this.getSize();
        Insets margin = this.getInsets();
        int w = dimension.width - margin.left - margin.right;
        int h = dimension.height - margin.top - margin.bottom - (this.isStatusBarVisible ? this.statusBar.getSize().height : 0);
        int logicalW = (int)(this.transformer.getLogicalWidth() * this.transformer.getScalingVal());
        int logicalH = (int)(this.transformer.getLogicalHeight() * this.transformer.getScalingVal());
        int x = (logicalW - w) / 2;
        int y = (logicalH - h) / 2;
        if (this.scrollbarH.isShowing()) {
            BoundedRangeModel rangeModelH = this.scrollbarH.getModel();
            x = rangeModelH.getValue();
            w = rangeModelH.getExtent();
        }
        if (this.scrollbarV.isShowing()) {
            BoundedRangeModel rangeModelV = this.scrollbarV.getModel();
            y = rangeModelV.getValue();
            h = rangeModelV.getExtent();
        }
        return new Rectangle(x, y, w, h);
    }

    public Dimension getOffScreenSize() {
        return this.panel.getOffscreenSize();
    }

    public void setToolTipTextString(String s) {
        this.panel.setToolTipText(s);
    }

    private class CornerPanel
    extends JPanel {
        boolean isExpanding = false;

        private CornerPanel() {
        }

        public void expand(boolean bool) {
            this.isExpanding = bool;
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.isExpanding) {
                return new Dimension(ZoomFrame.this.scrollbarV.getPreferredSize().width, ZoomFrame.this.scrollbarH.getPreferredSize().height);
            }
            return new Dimension(0, 0);
        }

        @Override
        public Dimension getSize() {
            if (this.isExpanding) {
                return new Dimension(ZoomFrame.this.scrollbarV.getSize().width, ZoomFrame.this.scrollbarH.getSize().height);
            }
            return new Dimension(0, 0);
        }
    }

    private class KeyInterpreter
    extends KeyAdapter {
        private KeyInterpreter() {
        }

        @Override
        public void keyPressed(KeyEvent keyevent) {
            int code = keyevent.getKeyCode();
            int modifier = keyevent.getModifiers();
            if (KeyEvent.getKeyText(code).equals("NumPad +") && modifier == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                ZoomFrame.this.transformer.incrementScale();
            } else if (code == 76 && modifier == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                ZoomFrame.this.transformer.incrementScale();
            } else if (KeyEvent.getKeyText(code).equals("NumPad -") && modifier == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                ZoomFrame.this.transformer.decrementScale();
            } else if (code == 75 && modifier == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                ZoomFrame.this.transformer.decrementScale();
            } else if (code == 32) {
                if (!ZoomFrame.this.isHandMoveMode) {
                    ZoomFrame.this.setHandMoveMode(true);
                }
            } else if (code == 112) {
                ZoomFrame.this.tglDebug();
            } else if (code == 113) {
                if (ZoomFrame.this.isStatusBarVisible) {
                    ZoomFrame.this.setStatusBarVisible(false);
                } else {
                    ZoomFrame.this.setStatusBarVisible(true);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyevent) {
            if (keyevent.getKeyCode() == 32) {
                ZoomFrame.this.setHandMoveMode(false);
            }
        }
    }

    private class MouseInterpreter
    implements MouseInputListener,
    MouseWheelListener {
        private int prevX = -1;
        private int prevY = -1;
        private ZoomFrame zoomFrame;

        MouseInterpreter(ZoomFrame zoomFrame2) {
            this.zoomFrame = zoomFrame2;
        }

        @Override
        public void mouseClicked(MouseEvent mouseevent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDragged(MouseEvent mouseevent) {
            if (!MainWindow.isFocusedKineticLaw()) {
                if (!ZoomFrame.this.isHandMoveMode) {
                    this.zoomFrame.fireListeners(mouseevent);
                    if (ZoomFrame.this.structure.isLinkMoveMode() || ZoomFrame.this.structure.isSelectMode()) {
                        ZoomFrame.this.panel.repaint();
                    }
                } else {
                    MouseInterpreter mouseInterpreter = this;
                    synchronized (mouseInterpreter) {
                        ZoomFrame.this.scrollListener.setEnabled(false);
                        ZoomFrame.this.transformer.viewSlideX(mouseevent.getX() - this.prevX);
                        ZoomFrame.this.transformer.viewSlideY(mouseevent.getY() - this.prevY);
                        ZoomFrame.this.scrollbarV.setValue((int)(-ZoomFrame.this.transformer.viewY));
                        ZoomFrame.this.scrollbarH.setValue((int)(-ZoomFrame.this.transformer.viewX));
                        ZoomFrame.this.repaintFrameContents();
                        ZoomFrame.this.scrollListener.setEnabled(true);
                    }
                }
            }
            this.prevX = mouseevent.getX();
            this.prevY = mouseevent.getY();
        }

        @Override
        public void mouseEntered(MouseEvent mouseevent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseevent) {
            GMouseInterpreter.getInstance().setCursorstate(0);
        }

        @Override
        public void mouseMoved(MouseEvent mouseevent) {
            this.prevX = mouseevent.getX();
            this.prevY = mouseevent.getY();
            if (ZoomFrame.this.isDebug) {
                Point2D.Double p = ZoomFrame.this.transformer.toLogicalPoint(this.prevX, this.prevY);
                ZoomFrame.this.statusBar.setString1("X=" + ((Point2D)p).getX() + ", Y=" + ((Point2D)p).getY());
            }
            if (!ZoomFrame.this.isHandMoveMode) {
                this.zoomFrame.fireListeners(mouseevent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseevent) {
            this.prevX = mouseevent.getX();
            this.prevY = mouseevent.getY();
            Point2D.Double p = ZoomFrame.this.transformer.toLogicalPoint(this.prevX, this.prevY);
            if (!ZoomFrame.this.isHandMoveMode) {
                this.zoomFrame.fireListeners(mouseevent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseevent) {
            if (!MainWindow.isFocusedKineticLaw() && !ZoomFrame.this.isHandMoveMode) {
                this.zoomFrame.fireListeners(mouseevent);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getScrollType() == 0) {
                if (e.isShiftDown()) {
                    int totalScrollAmount = e.getUnitsToScroll() * ZoomFrame.this.scrollbarH.getUnitIncrement();
                    ZoomFrame.this.scrollbarH.setValue(ZoomFrame.this.scrollbarH.getValue() + totalScrollAmount);
                } else {
                    int totalScrollAmount = e.getUnitsToScroll() * ZoomFrame.this.scrollbarV.getUnitIncrement();
                    ZoomFrame.this.scrollbarV.setValue(ZoomFrame.this.scrollbarV.getValue() + totalScrollAmount);
                }
            }
        }
    }

    private class OffscreenPanel
    extends JPanel {
        private Dimension offScreenSize = new Dimension(0, 0);
        private BufferedImage offScreenImage = null;
        private Graphics2D g2 = null;
        private int prevW = 0;
        private int prevH = 0;

        public OffscreenPanel() {
            this(0, 0);
        }

        public OffscreenPanel(int width, int height) {
            this.setLayout(new BorderLayout());
            this.setNewSize(width, height);
        }

        public Graphics2D getOffscreenGraphics() {
            this.setAntialias(this.g2);
            return this.g2;
        }

        protected Dimension getOffscreenSize() {
            return this.offScreenSize;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.offScreenSize;
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.offScreenImage != null) {
                Graphics2D g2 = (Graphics2D)graphics;
                g2.drawImage((Image)this.offScreenImage, 0, 0, this);
                this.setAntialias(g2);
                if (ZoomFrame.this.isDebug) {
                    g2.setColor(Color.blue);
                    g2.drawRect(0, 0, this.offScreenImage.getWidth() - 1, this.offScreenImage.getHeight() - 1);
                    g2.drawString("show repaint area", 0, 12);
                    if (ZoomFrame.this.lastRepaintRect != null) {
                        g2.setColor(Color.cyan);
                        g2.drawRect(((ZoomFrame)ZoomFrame.this).lastRepaintRect.x, ((ZoomFrame)ZoomFrame.this).lastRepaintRect.y, ((ZoomFrame)ZoomFrame.this).lastRepaintRect.width - 1, ((ZoomFrame)ZoomFrame.this).lastRepaintRect.height - 1);
                        ZoomFrame.this.lastRepaintRect = null;
                    }
                }
                g2.dispose();
            }
            ZoomFrame.this.scrollbarV.repaint();
            ZoomFrame.this.scrollbarH.repaint();
        }

        public void release() {
            this.offScreenSize = null;
            this.g2 = null;
            if (this.offScreenImage != null) {
                this.offScreenImage.flush();
                this.offScreenImage = null;
            }
        }

        public synchronized void remakeOffscreen() {
            int width = super.getSize().width;
            int height = super.getSize().height;
            if ((this.prevW != width || this.prevH != height) && width > 0 && height > 0) {
                this.release();
                this.offScreenImage = new BufferedImage(width, height, 2);
                this.offScreenSize = new Dimension(width, height);
                this.g2 = this.offScreenImage.createGraphics();
                this.setAntialias(this.g2);
                this.prevW = width;
                this.prevH = height;
            }
        }

        public void setNewSize(int width, int height) {
            super.setSize(width, height);
            this.remakeOffscreen();
        }

        private void setAntialias(Graphics2D g2) {
            if (g2 != null) {
                this.setAntialias(g2, Preference.antialias);
            }
        }

        private void setAntialias(Graphics2D g2, boolean on) {
            if (on) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        }
    }

    private class OffscreenResizer
    extends ComponentAdapter {
        private OffscreenResizer() {
        }

        @Override
        public void componentResized(ComponentEvent componentevent) {
            ZoomFrame.this.transformer.relocateScrollBars();
            ZoomFrame.this.validate();
            ZoomFrame.this.panel.remakeOffscreen();
            ZoomFrame.this.repaintFrameContents();
        }
    }

    private class ScrollbarListener
    implements AdjustmentListener {
        boolean isEnabled = true;

        private ScrollbarListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentevent) {
            ScrollbarListener scrollbarListener = this;
            synchronized (scrollbarListener) {
                if (this.isEnabled) {
                    int i = adjustmentevent.getValue();
                    boolean bool = false;
                    if (adjustmentevent.getSource() == ZoomFrame.this.scrollbarV && (int)(-ZoomFrame.this.transformer.viewY) != i) {
                        ZoomFrame.this.transformer.moveToViewY(-i);
                        bool = true;
                    } else if (adjustmentevent.getSource() == ZoomFrame.this.scrollbarH && (int)(-ZoomFrame.this.transformer.viewX) != i) {
                        ZoomFrame.this.transformer.moveToViewX(-i);
                        bool = true;
                    }
                    if (bool) {
                        ZoomFrame.this.repaintFrameContents();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setEnabled(boolean enabled) {
            ScrollbarListener scrollbarListener = this;
            synchronized (scrollbarListener) {
                this.isEnabled = enabled;
            }
        }
    }

    protected class Transformer {
        private AffineTransform at = new AffineTransform();
        private double logicalWidth = 0.0;
        private double logicalHeight = 0.0;
        private double s = 1.0;
        private double viewX = 0.0;
        private double viewY = 0.0;
        Point2D.Double lp = new Point2D.Double();
        Rectangle r1 = new Rectangle();
        Rectangle r2 = new Rectangle();
        Rectangle r3 = new Rectangle();
        private Rectangle2D.Double clipArea = new Rectangle2D.Double();
        private Rectangle2D.Double viewArea = new Rectangle2D.Double();

        protected Transformer() {
        }

        public void decrementScale() {
            this.changeScale(false);
        }

        public AffineTransform getAffineTransform() {
            this.at.setToTranslation(this.viewX, this.viewY);
            this.at.scale(this.s, this.s);
            return this.at;
        }

        public Rectangle2D.Double getClipArea(Rectangle2D area) {
            double d = Math.ceil(this.s);
            this.clipArea.x = area.getX() - d;
            this.clipArea.y = area.getY() - d;
            this.clipArea.width = area.getWidth() + d * 2.0;
            this.clipArea.height = area.getHeight() + d * 2.0;
            return this.clipArea;
        }

        public Rectangle2D.Double getLogicalViewArea() {
            Dimension dimension = ZoomFrame.this.panel.getOffscreenSize();
            double width = dimension.width;
            double height = dimension.height;
            if (this.s == 0.0) {
                return null;
            }
            this.viewArea.x = -this.viewX / this.s;
            this.viewArea.y = -this.viewY / this.s;
            this.viewArea.width = width / this.s;
            this.viewArea.height = height / this.s;
            return this.viewArea;
        }

        public void incrementScale() {
            this.changeScale(true);
        }

        public void changeScale(boolean zoomIn) {
            double rate = ZoomFrame.getNextZoomRateFromTable(this.s, zoomIn);
            if (rate != Double.MAX_VALUE && rate != Double.MIN_VALUE) {
                this.updateScale(rate);
            } else if (zoomIn) {
                this.updateScale(this.s + 0.5);
            } else {
                this.updateScale(this.s - 0.5);
            }
        }

        public void resetScale() {
            this.updateScale(1.0);
        }

        public void fitScale() {
            Rectangle rect = ZoomFrame.this.getCurrentLogicalViewArea();
            double ratiow = (double)(rect.width + (ZoomFrame.this.scrollbarV.isShowing() ? ZoomFrame.this.scrollbarV.getSize().width : 0)) / this.logicalWidth;
            double ratioh = (double)(rect.height + (ZoomFrame.this.scrollbarH.isShowing() ? ZoomFrame.this.scrollbarH.getSize().height : 0)) / this.logicalHeight;
            double ratio = ratiow > ratioh ? ratioh : ratiow;
            this.updateScale(ratio);
        }

        public boolean isAbleToChangeScale(boolean zoomIn) {
            if (this.s <= 0.0) {
                return false;
            }
            double rate = ZoomFrame.getNextZoomRateFromTable(this.s, zoomIn);
            if (rate == Double.MIN_VALUE) {
                return false;
            }
            if (rate < zoomDefaultMinRate) {
                return false;
            }
            return this.s != rate;
        }

        public void moveToLogicalPoint(double logicalX, double logicalY) {
            Dimension dimension = ZoomFrame.this.panel.getOffscreenSize();
            double panelWidth = dimension.width;
            double panelHeight = dimension.height;
            this.viewX = logicalX < 0.0 ? 0.0 : ((this.logicalWidth - logicalX) * this.s < panelWidth ? -(this.logicalWidth * this.s - panelWidth) : -logicalX * this.s);
            this.viewY = logicalY < 0.0 ? 0.0 : ((this.logicalHeight - logicalY) * this.s < panelHeight ? -(this.logicalHeight * this.s - panelHeight) : -logicalY * this.s);
        }

        public void moveToViewX(int x) {
            this.viewX = x;
        }

        public void moveToViewY(int y) {
            this.viewY = y;
        }

        public Rectangle onWindow(Rectangle2D.Double area) {
            this.r1.x = (int)(area.x * this.s) + (int)this.viewX;
            this.r1.y = (int)(area.y * this.s) + (int)this.viewY;
            this.r1.width = (int)(area.width * this.s);
            this.r1.height = (int)(area.height * this.s);
            Dimension dimension = ZoomFrame.this.panel.getOffscreenSize();
            this.r2.x = 0;
            this.r2.y = 0;
            this.r2.width = dimension.width;
            this.r2.height = dimension.height;
            Rectangle2D.intersect(this.r1, this.r2, this.r3);
            return this.r3;
        }

        public synchronized void setScalingVal(double sval) {
            this.s = sval;
        }

        public synchronized double getScalingVal() {
            return this.s;
        }

        private synchronized boolean relocateScrollBars() {
            return this.relocateScrollBars(this.s);
        }

        private synchronized boolean relocateScrollBars(double newScale) {
            ZoomFrame.this.scrollListener.setEnabled(false);
            boolean scrollVisibilityChanged = false;
            if (ZoomFrame.this.panel != null) {
                double visible;
                Dimension dimension = ZoomFrame.this.getSize();
                Insets margin = ZoomFrame.this.getInsets();
                double width = dimension.width - margin.left - margin.right;
                double height = dimension.height - margin.top - margin.bottom - (ZoomFrame.this.isStatusBarVisible ? ((ZoomFrame)ZoomFrame.this).statusBar.getSize().height : 0);
                double halfWidth = width * 0.5;
                double halfHeight = height * 0.5;
                double oldS = this.s;
                this.s = newScale;
                double factor = this.s / oldS;
                this.viewX = factor * (this.viewX - halfWidth) + halfWidth;
                this.viewY = factor * (this.viewY - halfHeight) + halfHeight;
                boolean vScrollShown = ZoomFrame.this.scrollbarV.isShowing();
                boolean hScrollShown = ZoomFrame.this.panelScrollbarH.isShowing();
                boolean vScrollShownNew = false;
                boolean hScrollShownNew = false;
                ZoomFrame.this.scrollPanel.remove(ZoomFrame.this.scrollbarV);
                ZoomFrame.this.scrollPanel.remove(ZoomFrame.this.panelScrollbarH);
                if (height < this.logicalHeight * this.s && width < this.logicalWidth * this.s) {
                    ZoomFrame.this.cornerPanel.expand(true);
                } else {
                    ZoomFrame.this.cornerPanel.expand(false);
                }
                if (height < this.logicalHeight * this.s) {
                    ZoomFrame.this.scrollbarV.setMaximum((int)(this.logicalHeight * this.s));
                    double hBarHeight = 0.0;
                    if (width < this.logicalWidth * this.s) {
                        hBarHeight = ((ZoomFrame)ZoomFrame.this).panelScrollbarH.getSize().height;
                    }
                    if (this.viewY < height - this.logicalHeight * this.s) {
                        this.viewY = height - this.logicalHeight * this.s - hBarHeight;
                    }
                    visible = height - hBarHeight;
                    ZoomFrame.this.scrollbarV.setValue(-((int)this.viewY));
                    ZoomFrame.this.scrollbarV.setVisibleAmount((int)visible);
                    ZoomFrame.this.scrollPanel.add((Component)ZoomFrame.this.scrollbarV, "East");
                    vScrollShownNew = true;
                }
                if (width < this.logicalWidth * this.s) {
                    ZoomFrame.this.scrollbarH.setMaximum((int)(this.logicalWidth * this.s));
                    double vBarWidth = 0.0;
                    if (height < this.logicalHeight * this.s) {
                        vBarWidth = ZoomFrame.this.scrollbarV.getSize().width;
                    }
                    if (this.viewX < width - this.logicalWidth * this.s) {
                        this.viewX = width - this.logicalWidth * this.s - vBarWidth;
                    }
                    visible = width - vBarWidth;
                    ZoomFrame.this.scrollbarH.setValue(-((int)this.viewX));
                    ZoomFrame.this.scrollbarH.setVisibleAmount((int)visible);
                    ZoomFrame.this.scrollPanel.add((Component)ZoomFrame.this.panelScrollbarH, "South");
                    hScrollShownNew = true;
                }
                scrollVisibilityChanged = vScrollShown != vScrollShownNew || hScrollShown != hScrollShownNew;
            }
            ZoomFrame.this.scrollPanel.repaint();
            ZoomFrame.this.scrollListener.setEnabled(true);
            return scrollVisibilityChanged;
        }

        public void setLogicalSize(double width, double height) {
            this.logicalWidth = width;
            this.logicalHeight = height;
        }

        public Point2D.Double toLogicalPoint(int x, int y) {
            if (this.s != 0.0) {
                this.lp.x = ((double)x - this.viewX) / this.s;
                this.lp.y = ((double)y - this.viewY) / this.s;
                return this.lp;
            }
            return null;
        }

        private void updateScale(double newScale) {
            if (this.relocateScrollBars(newScale)) {
                ZoomFrame.this.panel.remakeOffscreen();
            }
            ZoomFrame.this.repaintFrameContents();
            ZoomFrame.this.validate();
        }

        void updateViewPosition() {
            double widthOnScreen = this.logicalWidth * this.s;
            double heightOnScreen = this.logicalHeight * this.s;
            Rectangle offScreenSize = ZoomFrame.this.getCurrentLogicalViewArea();
            double dx = (double)offScreenSize.width - widthOnScreen;
            if (dx >= 0.0) {
                this.viewX = dx / 2.0;
            } else if (this.viewX < dx) {
                this.viewX = dx;
            } else if (this.viewX > 0.0) {
                this.viewX = 0.0;
            }
            double dy = (double)offScreenSize.height - heightOnScreen;
            if (dy >= 0.0) {
                this.viewY = dy / 2.0;
            } else if (this.viewY < dy) {
                this.viewY = dy;
            } else if (this.viewY > 0.0) {
                this.viewY = 0.0;
            }
        }

        public void viewSlideX(double slide) {
            this.viewX += slide;
        }

        public void viewSlideY(double slide) {
            this.viewY += slide;
        }

        public double getLogicalHeight() {
            return this.logicalHeight;
        }

        public double getLogicalWidth() {
            return this.logicalWidth;
        }
    }
}

