/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.multiwindow;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jp.fric.graphics.multiwindow.FileManager;
import jp.fric.graphics.multiwindow.MultiWindowFrame;

public class WindowManager
implements MenuListener,
ActionListener,
ChangeListener {
    FileManager fileManager;
    boolean isManagingWindowMenu = false;
    JMenu menuWindow = null;
    private Hashtable menutable = null;
    private boolean needToRebuildMenu = false;
    private static final Font selectedFont = new Font("MyFont", 2, new JMenuItem().getFont().getSize());
    private SingleSelectionModel selectionModel = null;

    public WindowManager(FileManager filemanager) {
        this.fileManager = filemanager;
    }

    @Override
    public void actionPerformed(ActionEvent actionevent) {
        String command = actionevent.getActionCommand();
        Vector models = this.fileManager.getModels();
        int index = 0;
        while (index < models.size()) {
            if (models.elementAt(index).toString().equals(command)) {
                this.selectionModel.setSelectedIndex(index);
                break;
            }
            ++index;
        }
    }

    private void addJMenuItem(JPanel jpanal, String title) {
        int lastindex = title.lastIndexOf(System.getProperty("file.separator"));
        String filename = title.substring(lastindex + 1, title.length());
        JMenuItem jmenuitem = new JMenuItem();
        jmenuitem.setText(filename);
        jmenuitem.addActionListener(this);
        jmenuitem.setActionCommand(jpanal.toString());
        this.menutable.put(jpanal.toString(), jmenuitem);
    }

    private void changeJMenuItemText(JPanel panel, String newMenuName) {
        JMenuItem jmenuitem = (JMenuItem)this.menutable.get(panel.toString());
        if (jmenuitem != null) {
            String filename = "";
            if (newMenuName == null || "".equals(newMenuName.trim())) {
                String path = ((MultiWindowFrame)panel).getPath().toString();
                int lastindex = path.lastIndexOf(System.getProperty("file.separator"));
                filename = path.substring(lastindex + 1, path.length());
            } else {
                filename = newMenuName;
            }
            jmenuitem.setText(filename);
        }
    }

    public void documentRenamed(JPanel panel) {
        this.documentRenamed(panel, null);
    }

    public void documentRenamed(JPanel panel, String newMenuName) {
        if (this.isManagingWindowMenu) {
            this.changeJMenuItemText(panel, newMenuName);
            this.rebuildWindowMenu();
        }
    }

    private void enableWindowMenu() {
        if (this.menuWindow.getItemCount() == 0) {
            this.menuWindow.setEnabled(false);
        } else {
            this.menuWindow.setEnabled(true);
        }
    }

    public synchronized void modelClosed(JPanel panel) {
        if (this.isManagingWindowMenu) {
            this.removeJMenuItem(panel);
            this.needToRebuildMenu = true;
            this.rebuildWindowMenu();
            this.enableWindowMenu();
        }
        this.selectionModel.clearSelection();
    }

    public synchronized void modelOpened(MultiWindowFrame panel) {
        String title = panel.frameTitle();
        if (this.isManagingWindowMenu) {
            this.addJMenuItem(panel, title);
            this.needToRebuildMenu = true;
            this.rebuildWindowMenu();
            this.enableWindowMenu();
        }
        this.fileManager.activeFrameChanged();
    }

    public void hideAll() {
    }

    @Override
    public void menuCanceled(MenuEvent menuevent) {
        this.rebuildWindowMenu();
    }

    @Override
    public void menuDeselected(MenuEvent menuevent) {
        this.rebuildWindowMenu();
    }

    @Override
    public void menuSelected(MenuEvent menuevent) {
        this.rebuildWindowMenu();
    }

    private void rebuildWindowMenu() {
        if (this.needToRebuildMenu) {
            Object[] objects = this.menutable.values().toArray();
            int i = 0;
            while (i < objects.length) {
                this.menuWindow.remove((JMenuItem)objects[i]);
                ++i;
            }
            JPanel currentModel = this.fileManager.getCurrentModel();
            Vector models = this.fileManager.getModels();
            Object current = null;
            int i2 = 0;
            while (i2 < models.size()) {
                JPanel model = (JPanel)models.elementAt(i2);
                JMenuItem jmenuitem = (JMenuItem)this.menutable.get(model.toString());
                if (jmenuitem != null) {
                    this.menuWindow.add(jmenuitem);
                    if (model.equals(currentModel)) {
                        jmenuitem.setFont(selectedFont);
                    } else {
                        jmenuitem.setFont(null);
                    }
                }
                ++i2;
            }
            this.needToRebuildMenu = false;
        }
    }

    public void registerWindowMenu(JMenu jmenu) {
        this.menuWindow = jmenu;
        this.menutable = new Hashtable();
        jmenu.addMenuListener(this);
        this.isManagingWindowMenu = true;
        this.enableWindowMenu();
    }

    public void releaseAll() {
        if (this.isManagingWindowMenu) {
            this.menuWindow.removeMenuListener(this);
            this.menutable.clear();
            this.menutable = null;
            this.menuWindow = null;
        }
        this.selectionModel = null;
    }

    private void removeJMenuItem(JPanel jpanel) {
        JMenuItem jmenuitem = (JMenuItem)this.menutable.get(jpanel.toString());
        if (jmenuitem != null) {
            jmenuitem.removeActionListener(this);
            this.menutable.remove(jpanel.toString());
            this.menuWindow.remove(jmenuitem);
        }
    }

    public void setSingleSelectionModel(SingleSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
        selectionModel.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.selectionModel.getSelectedIndex() != -1) {
            this.modelSwitched();
        }
    }

    private void modelSwitched() {
        this.needToRebuildMenu = true;
        this.rebuildWindowMenu();
        this.fileManager.activeFrameChanged();
    }
}

