/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.multiwindow;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.fric.graphics.multiwindow.MultiWindowFrame;
import jp.fric.graphics.multiwindow.OffscreenListener;
import jp.fric.util.Debug;

public abstract class OffscreenFrame
extends MultiWindowFrame {
    Dimension offscreenSize = null;
    BufferedImage offscreenImage = null;
    CenteringScrollpane scrollPane;
    DocumentPanel panel;
    Cursor stdCursor = Cursor.getDefaultCursor();
    Cursor handCursor = new Cursor(12);
    ViewportMover mover;
    SpaceKeyAdapter spaceKeyAdapter;
    int document_x = 0;
    int document_y = 0;
    private boolean isDebug = false;
    private Rectangle lastRepaintRect = null;
    Vector listeners = new Vector();

    public OffscreenFrame(Dimension dimension) {
        int width = 0;
        int height = 0;
        if (dimension != null) {
            width = dimension.width;
            height = dimension.height;
            if (width != 0 && height != 0) {
                this.offscreenSize = new Dimension(width, height);
                this.setNewOffscreen(dimension);
            }
        }
        this.panel = new DocumentPanel();
        this.panel.setSize(width, height);
        this.scrollPane = new CenteringScrollpane(this.panel);
        this.spaceKeyAdapter = new SpaceKeyAdapter();
        super.addKeyListener(this.spaceKeyAdapter);
        this.mover = new ViewportMover();
        super.addMouseMotionListener(this.mover);
        super.addMouseListener(this.mover);
        Debug.println("[OffscreenFrame] constructed <" + super.toString() + ">");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOffscreenListener(OffscreenListener offscreenlistener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(offscreenlistener);
        }
    }

    public void adjust() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension thisSize = this.getSize();
        Point point = this.getLocation();
        boolean needSetSize = false;
        if (screenSize.width < thisSize.width) {
            thisSize.width = screenSize.width;
            needSetSize = true;
        }
        if (screenSize.height < thisSize.height) {
            thisSize.height = screenSize.height;
            needSetSize = true;
        }
        if (needSetSize) {
            this.setSize(thisSize);
        }
        boolean needSetLocation = false;
        if (point.x + thisSize.width > screenSize.width) {
            point.x = screenSize.width - thisSize.width;
            needSetLocation = true;
        }
        if (point.y + thisSize.height > screenSize.height) {
            point.y = screenSize.height - thisSize.height;
            needSetLocation = true;
        }
        if (needSetLocation) {
            this.setLocation(point);
        }
    }

    private void checkDocumentPosition() {
        Dimension scrollPaneSize = this.scrollPane.getSize();
        this.document_x = this.offscreenImage.getWidth() < scrollPaneSize.width ? (scrollPaneSize.width - this.offscreenImage.getWidth()) / 2 : 0;
        this.document_y = this.offscreenImage.getHeight() < scrollPaneSize.height ? (scrollPaneSize.height - this.offscreenImage.getHeight()) / 2 : 0;
    }

    @Override
    protected void finalize() throws Throwable {
        Debug.println("[OffscreenFrame] finalize() <" + super.toString() + ">");
        super.finalize();
    }

    private void fireListeners(MouseEvent mouseevent) {
        int dx = mouseevent.getX() - this.document_x;
        int dy = mouseevent.getY() - this.document_y;
        Vector vector = (Vector)this.listeners.clone();
        int i = 0;
        while (i < vector.size()) {
            OffscreenListener offscreenlistener = (OffscreenListener)vector.elementAt(i);
            offscreenlistener.mouseOperated(dx, dy, mouseevent.getID(), mouseevent.getClickCount());
            ++i;
        }
    }

    public BufferedImage getOffscreenImage() {
        return this.offscreenImage;
    }

    public Dimension getOffscreenSize() {
        return this.offscreenSize;
    }

    @Override
    public Dimension getPreferredOpeningSize() {
        return (Dimension)this.offscreenSize.clone();
    }

    protected void notifyResize() {
        Vector listener = (Vector)this.listeners.clone();
        int i = 0;
        while (i < listener.size()) {
            OffscreenListener offscreenlistener = (OffscreenListener)listener.elementAt(i);
            offscreenlistener.resized(this.offscreenSize);
            ++i;
        }
    }

    public abstract void paintOffscreen();

    @Override
    public void releaseAll() {
        Debug.println("[OffscreenFrame] releaseAll() <" + super.toString() + ">");
        super.removeMouseListener(this.mover);
        super.removeMouseMotionListener(this.mover);
        super.removeKeyListener(this.spaceKeyAdapter);
        if (this.offscreenImage != null) {
            this.offscreenImage.flush();
            this.offscreenImage = null;
        }
        this.offscreenSize = null;
        this.stdCursor = null;
        this.handCursor = null;
        this.mover = null;
        this.spaceKeyAdapter = null;
        super.releaseAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOffscreenListener(OffscreenListener offscreenlistener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            int i = 0;
            while (i < this.listeners.size()) {
                OffscreenListener listener = (OffscreenListener)this.listeners.elementAt(i);
                if (listener.equals(offscreenlistener)) {
                    this.listeners.remove(listener);
                    break;
                }
                ++i;
            }
        }
    }

    public void repaintDocumentPanel(Rectangle rectangle) {
        rectangle.translate(this.document_x, this.document_y);
        if (!this.isDebug) {
            this.panel.repaint(rectangle);
        } else {
            this.lastRepaintRect = rectangle;
            this.panel.repaint();
        }
    }

    @Override
    public void repaintFrameContents() {
        this.paintOffscreen();
        this.panel.repaint();
    }

    public void replaceOffscreen(BufferedImage bufferedimage) {
        if (bufferedimage != null) {
            int width = bufferedimage.getWidth();
            int height = bufferedimage.getHeight();
            if (width != 0 && height != 0) {
                this.offscreenSize = new Dimension(width, height);
                if (this.offscreenImage != null) {
                    this.offscreenImage.flush();
                    this.offscreenImage = null;
                }
                this.offscreenImage = bufferedimage;
                this.panel.setSize(width, height);
                this.scrollPane.validate();
                this.notifyResize();
            }
        }
    }

    @Override
    public void setActualOpeningSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    private void setNewOffscreen(Dimension size) {
        if (this.offscreenImage != null) {
            this.offscreenImage.flush();
            this.offscreenImage = null;
        }
        this.offscreenImage = new BufferedImage(size.width, size.height, 2);
    }

    public void setOffscreenSize(Dimension size) {
        if (size != null && size.width != 0 && size.height != 0 && (this.offscreenSize == null || this.offscreenSize.width != size.width || this.offscreenSize.height != size.height)) {
            this.offscreenSize = size;
            this.setNewOffscreen(this.offscreenSize);
            this.panel.setSize(size.width, size.height);
            this.scrollPane.validate();
            this.notifyResize();
        }
    }

    public void tglDebug() {
        this.isDebug ^= true;
    }

    class CenteringScrollpane
    extends JScrollPane {
        public CenteringScrollpane(Component component) {
            super(component);
        }

        @Override
        public void validate() {
            OffscreenFrame.this.checkDocumentPosition();
            super.validate();
        }
    }

    class DocumentPanel
    extends JPanel {
        public DocumentPanel() {
            this.enableMouse(true);
        }

        public void enableMouse(boolean enable) {
            if (enable) {
                this.enableEvents(48L);
            } else {
                this.disableEvents(48L);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            if (OffscreenFrame.this.offscreenImage == null) {
                return new Dimension(0, 0);
            }
            return new Dimension(OffscreenFrame.this.offscreenImage.getWidth(), OffscreenFrame.this.offscreenImage.getHeight());
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (OffscreenFrame.this.offscreenImage != null) {
                Graphics2D graphics2d = (Graphics2D)graphics;
                OffscreenFrame.this.checkDocumentPosition();
                graphics2d.drawImage((Image)OffscreenFrame.this.offscreenImage, OffscreenFrame.this.document_x, OffscreenFrame.this.document_y, this);
                if (OffscreenFrame.this.isDebug) {
                    graphics2d.drawString("show repaint area", 0, 12);
                    if (OffscreenFrame.this.lastRepaintRect != null) {
                        graphics2d.setColor(Color.cyan);
                        graphics2d.draw(OffscreenFrame.this.lastRepaintRect);
                    }
                }
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseevent) {
            OffscreenFrame.this.fireListeners(mouseevent);
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseevent) {
            OffscreenFrame.this.fireListeners(mouseevent);
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }

    class SpaceKeyAdapter
    extends KeyAdapter {
        SpaceKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent keyevent) {
            if (keyevent.getKeyCode() == 32) {
                OffscreenFrame.this.panel.enableMouse(false);
                OffscreenFrame.this.setCursor(OffscreenFrame.this.handCursor);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyevent) {
            if (keyevent.getKeyCode() == 32) {
                OffscreenFrame.this.panel.enableMouse(true);
                OffscreenFrame.this.setCursor(OffscreenFrame.this.stdCursor);
            }
        }
    }

    private class ViewportMover
    implements MouseListener,
    MouseMotionListener {
        int px = -1;
        int py = -1;

        private ViewportMover() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseevent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseevent) {
            int x = mouseevent.getX();
            int y = mouseevent.getY();
            int dx = this.px - x;
            int dy = this.py - y;
            this.px = x;
            this.py = y;
            Point point = OffscreenFrame.this.scrollPane.getViewport().getViewPosition();
            Dimension dimension = OffscreenFrame.this.panel.getSize();
            Rectangle rectangle = OffscreenFrame.this.scrollPane.getViewport().getViewRect();
            boolean needRepaint = false;
            if (rectangle.width < dimension.width) {
                point.x += dx;
                if (point.x < 0) {
                    point.x = 0;
                } else if (point.x + rectangle.width > dimension.width) {
                    point.x = dimension.width - rectangle.width;
                }
                needRepaint = true;
            }
            if (rectangle.height < dimension.height) {
                point.y += dy;
                if (point.y < 0) {
                    point.y = 0;
                } else if (point.y + rectangle.height > dimension.height) {
                    point.y = dimension.height - rectangle.height;
                }
                needRepaint = true;
            }
            if (needRepaint) {
                OffscreenFrame.this.scrollPane.getViewport().setViewPosition(point);
                OffscreenFrame.this.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseevent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseevent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseevent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseevent) {
            this.px = mouseevent.getX();
            this.py = mouseevent.getY();
        }

        @Override
        public void mouseReleased(MouseEvent mouseevent) {
        }
    }
}

