/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.multiwindow;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.io.File;
import javax.swing.JPanel;
import jp.fric.graphics.multiwindow.FileManager;
import jp.fric.graphics.multiwindow.MainWindowAccess;
import jp.fric.util.Debug;
import jp.sbi.celldesigner.SBModelFrame;

public abstract class MultiWindowFrame
extends JPanel {
    private FileManager fileManager;
    private String myID = Long.toString(System.currentTimeMillis());
    private String name = null;
    private File filepath = null;
    private boolean hasChanged = false;
    private boolean hasAnySBaseChanged = false;
    protected MainWindowAccess mainwindowaccess;

    public MultiWindowFrame() {
        Debug.println("[MultiWindowFrame] constructed <" + this.myID + ">");
    }

    public void setMainWindowAccess(MainWindowAccess mainwindowaccess) {
        this.mainwindowaccess = mainwindowaccess;
    }

    protected void finalize() throws Throwable {
        Debug.println("[MultiWindowFrame] finalize() <" + this.myID + ">");
        super.finalize();
    }

    public String frameTitle() {
        String title = "";
        if (this.name != null) {
            title = this.name;
        }
        if (this.hasChangedInSBModelOrControlPanel()) {
            title = String.valueOf(title) + " *";
        }
        return title;
    }

    public String getFilename() {
        return this.name;
    }

    public File getPath() {
        return this.filepath;
    }

    public abstract Dimension getPreferredOpeningSize();

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void releaseAll() {
        Debug.println("[MultiWindowFrame] releaseAll() <" + this.myID + ">");
        this.fileManager = null;
        this.filepath = null;
        this.mainwindowaccess = null;
    }

    public abstract void repaintFrameContents();

    public abstract void repaintLogicalArea(Rectangle2D var1);

    public abstract void repaintLogicalArea(Rectangle2D var1, boolean var2);

    public void saveDone() {
    }

    public abstract void setActualOpeningSize(Dimension var1);

    public void setChanged(boolean changed) {
        if (this instanceof SBModelFrame && ((SBModelFrame)this).getUIType() == 2) {
            return;
        }
        this.hasChanged = changed;
        if (this.mainwindowaccess != null) {
            this.mainwindowaccess.setTitleToModel(this.frameTitle(), this);
        }
    }

    public void setChangedInControlPanel() {
        if (this.mainwindowaccess != null) {
            this.mainwindowaccess.setTitleToModel(this.frameTitle(), this);
        }
    }

    public boolean hasChangedInSBModelOrControlPanel() {
        boolean hasControlPanelChanged = false;
        try {
            hasControlPanelChanged = ((SBModelFrame)this).isControlPanelChanged();
        }
        catch (Exception ex) {
            hasControlPanelChanged = false;
        }
        return this.hasChanged || this.hasAnySBaseChanged || hasControlPanelChanged;
    }

    public void setFileManager(FileManager filemanager) {
        this.fileManager = filemanager;
    }

    public void setFilename(String filename) {
        if (!(filename == null || this.name != null && this.name.equals(filename))) {
            this.name = filename.equals("") ? "Untitled" : filename;
            if (this.filepath != null) {
                String path = this.filepath.getParent();
                String separator = System.getProperty("file.separator");
                String absolute = String.valueOf(path) + separator + this.name;
                this.filepath = null;
                this.filepath = new File(absolute);
            }
            if (this.mainwindowaccess != null) {
                this.mainwindowaccess.setTitleToModel(this.frameTitle(), this);
            }
        }
    }

    public void setFilenameIgnoreSetTitle(String filename) {
        if (!(filename == null || this.name != null && this.name.equals(filename))) {
            this.name = filename;
            if (this.filepath != null) {
                String path = this.filepath.getParent();
                String separator = System.getProperty("file.separator");
                String absolute = String.valueOf(path) + separator + this.name;
                this.filepath = null;
                this.filepath = new File(absolute);
            }
        }
    }

    public void setPath(File file) {
        if (!(file == null || this.filepath != null && this.filepath.equals(file))) {
            this.filepath = null;
            this.filepath = file;
            this.name = this.filepath.getName();
            if (this.mainwindowaccess != null) {
                this.mainwindowaccess.setTitleToModel(this.frameTitle(), this);
            }
        }
    }

    @Override
    public String toString() {
        return this.myID;
    }

    public MainWindowAccess getMainWindowAccess() {
        return this.mainwindowaccess;
    }

    public void setPath(File file, String dumyTitle) {
        String title = "newModel";
        if (dumyTitle != null && !dumyTitle.trim().equals("")) {
            title = dumyTitle;
        }
        this.filepath = file;
        this.name = title;
        if (this.mainwindowaccess != null) {
            this.mainwindowaccess.setTitleToModel(title, this);
        }
    }

    public boolean hasAnySBaseChanged() {
        return this.hasAnySBaseChanged;
    }

    public void setHasAnySBaseChangedFlg(boolean changed) {
        this.hasAnySBaseChanged = changed;
        if (this.mainwindowaccess != null) {
            this.mainwindowaccess.setTitleToModel(this.frameTitle(), this);
        }
    }
}

