/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.multiwindow;

import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import jp.fric.graphics.multiwindow.ContentsFiler;
import jp.fric.graphics.multiwindow.MultiWindowFrame;
import jp.fric.graphics.multiwindow.MultiWindowListener;
import jp.fric.graphics.multiwindow.WindowManager;
import jp.fric.io.util.FilePather;
import jp.fric.io.util.MyFileFilter;
import jp.fric.io.util.MyGTKFileChooser;
import jp.fric.util.Debug;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModelFrame;
import org.sbml.libsbml.SBase;

public abstract class FileManager {
    protected ContentsFiler filer;
    protected Image iconImage = null;
    protected FilePather filePather;
    protected WindowManager windowManager;
    private Vector listeners = new Vector();
    private boolean hasExitKeyCode = false;
    private int exitKeyCode = 0;
    protected boolean isAppendedNew = false;
    protected boolean isAppendedOpen = false;
    protected boolean isAppendedOpenInSBGNViewer = false;
    protected boolean isAppendedClose = false;
    protected boolean isAppendedCloseAll = false;
    protected boolean isAppendedSave = false;
    protected boolean isAppendedSaveAs = false;
    protected boolean isAppendedSaveAll = false;
    public static final int NEW = 1;
    public static final int OPEN = 2;
    public static final int CLOSE = 3;
    public static final int CLOSE_ALL = 4;
    public static final int SAVE = 5;
    public static final int SAVE_AS = 6;
    public static final int SAVE_ALL = 7;
    public static final int OPEN_IN_SBGNVIEWER = 8;
    protected static final int OPENED = 1;
    protected static final int CLOSED = 2;
    protected static final int CHANGED = 3;
    protected static final int LOST = 4;
    protected static final int EXIT = 5;

    public FileManager(ContentsFiler contentsfiler) {
        this.filer = contentsfiler;
        this.windowManager = new WindowManager(this);
        this.filePather = new FilePather();
    }

    public FileManager(ContentsFiler contentsfiler, String openDirectory, String saveDirectory) {
        this.filer = contentsfiler;
        this.windowManager = new WindowManager(this);
        this.filePather = new FilePather(openDirectory, saveDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMultiWindowListener(MultiWindowListener multiwindowlistener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(multiwindowlistener);
        }
    }

    public void appendMenuItem(JMenu menu, int type, String label, int mnemonic) {
        switch (type) {
            case 1: {
                this.isAppendedNew = true;
                this.appendNewItem(menu, label, mnemonic);
                break;
            }
            case 2: {
                this.isAppendedOpen = true;
                this.appendOpenItem(menu, label, mnemonic);
                break;
            }
            case 8: {
                this.isAppendedOpenInSBGNViewer = true;
                this.appendOpenInSBGNViewerItem(menu, label, mnemonic);
                break;
            }
            case 3: {
                this.isAppendedClose = true;
                this.appendCloseItem(menu, label, mnemonic);
                break;
            }
            case 4: {
                this.isAppendedCloseAll = true;
                this.appendCloseAllItem(menu, label, mnemonic);
                break;
            }
            case 5: {
                this.isAppendedSave = true;
                this.appendSaveItem(menu, label, mnemonic);
                break;
            }
            case 6: {
                this.isAppendedSaveAs = true;
                this.appendSaveAsItem(menu, label, mnemonic);
                break;
            }
            case 7: {
                this.isAppendedSaveAll = true;
                this.appendSaveAllItem(menu, label, mnemonic);
            }
        }
    }

    protected abstract void appendSaveAllItem(JMenu var1, String var2, int var3);

    protected abstract void appendSaveAsItem(JMenu var1, String var2, int var3);

    protected abstract void appendSaveItem(JMenu var1, String var2, int var3);

    protected abstract void appendCloseAllItem(JMenu var1, String var2, int var3);

    protected abstract void appendCloseItem(JMenu var1, String var2, int var3);

    protected abstract void appendOpenItem(JMenu var1, String var2, int var3);

    protected abstract void appendOpenInSBGNViewerItem(JMenu var1, String var2, int var3);

    protected abstract void appendNewItem(JMenu var1, String var2, int var3);

    public void setExitKeyCode(int i) {
        this.hasExitKeyCode = true;
        this.exitKeyCode = i;
    }

    public String currentOpeningDir() {
        return this.filePather.currentOpeningDir();
    }

    public String currentSavingDir() {
        return this.filePather.currentSavingDir();
    }

    protected abstract JPanel getCurrentModel();

    protected abstract Vector getModels();

    protected abstract void changeActiveModel(String var1);

    public void registerAppendingMenu(JMenu jmenu) {
        this.windowManager.registerWindowMenu(jmenu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMultiWindowListener(MultiWindowListener multiwindowlistener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            int i = 0;
            while (i < this.listeners.size()) {
                MultiWindowListener listener = (MultiWindowListener)this.listeners.elementAt(i);
                if (listener.equals(multiwindowlistener)) {
                    this.listeners.remove(listener);
                    break;
                }
                ++i;
            }
        }
    }

    protected abstract void getSaveCommand(MultiWindowFrame var1) throws Exception;

    protected abstract void getCloseCommand(MultiWindowFrame var1, boolean var2) throws Exception;

    protected abstract void getOpenCommand();

    protected abstract void getOpenInSBGNViewerCommand(File var1);

    protected abstract void getNewCommand();

    protected void startGC() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GcThread gcthread = new GcThread();
                gcthread.start();
            }
        });
    }

    protected void finalize() throws Throwable {
        this.windowManager.releaseAll();
        this.listeners.clear();
        this.listeners = null;
        this.windowManager = null;
        this.filePather = null;
        this.iconImage.flush();
        this.iconImage = null;
        super.finalize();
    }

    public void activeFrameChanged() {
        this.fireListeners(3, (MultiWindowFrame)this.getCurrentModel());
    }

    public void activeFrameChanged(JPanel jpanel) {
        this.fireListeners(3, (MultiWindowFrame)jpanel);
    }

    protected void activeFrameLost() {
        this.fireListeners(4, null);
    }

    protected void fireListeners(int changedflag, MultiWindowFrame multiwindowframe) {
        if (changedflag == 4 || multiwindowframe != null) {
            Vector vector = (Vector)this.listeners.clone();
            int i = 0;
            while (i < vector.size()) {
                MultiWindowListener multiwindowlistener = (MultiWindowListener)vector.elementAt(i);
                switch (changedflag) {
                    case 1: {
                        multiwindowlistener.modelOpened(multiwindowframe);
                        break;
                    }
                    case 2: {
                        if (((SBModelFrame)multiwindowframe).getSBModel() != null) {
                            MainWindow.getLastInstance().modelClosed((SBase)((SBModelFrame)multiwindowframe).getSBModel().getModel());
                        }
                        multiwindowlistener.modelClosed(multiwindowframe);
                        break;
                    }
                    case 3: {
                        multiwindowlistener.activeFrameChanged(multiwindowframe);
                        break;
                    }
                    case 4: {
                        multiwindowlistener.activeFrameLost();
                        break;
                    }
                    case 5: {
                        multiwindowlistener.exitCalled();
                    }
                }
                ++i;
            }
            if (MainWindow.getLastInstance() != null) {
                MainWindow.getLastInstance().updateLayoutMenuState();
            }
            if (MainWindow.getLastInstance().hasListOfPlugin()) {
                switch (changedflag) {
                    case 1: {
                        MainWindow.getLastInstance().modelOpened((SBase)((SBModelFrame)multiwindowframe).getSBModel().getModel());
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        MainWindow.getLastInstance().modelSelectChanged((SBase)((SBModelFrame)multiwindowframe).getSBModel().getModel());
                        break;
                    }
                    case 4: {
                        System.out.println("FileManager LOST");
                        break;
                    }
                    case 5: {
                        System.out.println("FileManager EXIT");
                    }
                }
            }
        }
    }

    public abstract void hideAll();

    public abstract void resumeAll();

    public abstract boolean closeAllDocuments();

    public void setSingleSelectionModel(SingleSelectionModel selectionModel) {
        this.windowManager.setSingleSelectionModel(selectionModel);
    }

    public static final Object openMyFile(Component parent, MyFileFilter[] fileFilters, String directory) {
        File file;
        block11: {
            block10: {
                try {
                    int i;
                    JFileChooser chooser = null;
                    String javaVMSpecVersion = System.getProperty("java.specification.version");
                    chooser = UIManager.getLookAndFeel().getClass().getName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel") && javaVMSpecVersion.equals("1.4") ? new MyGTKFileChooser() : new JFileChooser();
                    FileFilter[] filters = chooser.getChoosableFileFilters();
                    if (filters != null) {
                        i = 0;
                        while (i < filters.length) {
                            chooser.removeChoosableFileFilter(filters[i]);
                            ++i;
                        }
                    }
                    if (fileFilters == null || fileFilters.length == 0) {
                        MyFileFilter allFilter = new MyFileFilter(null, "All Files");
                        chooser.addChoosableFileFilter(allFilter);
                    } else {
                        i = 0;
                        while (i < fileFilters.length) {
                            chooser.addChoosableFileFilter(fileFilters[i]);
                            ++i;
                        }
                    }
                    chooser.setCurrentDirectory(new File(directory));
                    chooser.setFileSelectionMode(0);
                    int chooserstate = chooser.showOpenDialog(parent);
                    file = chooser.getSelectedFile();
                    if (chooserstate == 1) {
                        return new Integer(1);
                    }
                    if (chooserstate == 0 && file != null && !file.isDirectory()) break block10;
                    return null;
                }
                catch (Exception myErr) {
                    return null;
                }
            }
            if (file.exists()) break block11;
            return null;
        }
        return file;
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    public static final Object selectTargetFile(Component parent, MyFileFilter[] fileFilters, String directory) {
        try {
            int i;
            JFileChooser chooser = null;
            String javaVMSpecVersion = System.getProperty("java.specification.version");
            chooser = UIManager.getLookAndFeel().getClass().getName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel") && javaVMSpecVersion.equals("1.4") ? new MyGTKFileChooser() : new JFileChooser();
            FileFilter[] filters = chooser.getChoosableFileFilters();
            if (filters != null) {
                i = 0;
                while (i < filters.length) {
                    chooser.removeChoosableFileFilter(filters[i]);
                    ++i;
                }
            }
            if (fileFilters == null || fileFilters.length == 0) {
                MyFileFilter allFilter = new MyFileFilter(null, "All Files");
                chooser.addChoosableFileFilter(allFilter);
            } else {
                i = 0;
                while (i < fileFilters.length) {
                    chooser.addChoosableFileFilter(fileFilters[i]);
                    ++i;
                }
            }
            chooser.setCurrentDirectory(new File(directory));
            chooser.setFileSelectionMode(0);
            int chooserstate = chooser.showOpenDialog(parent);
            File file = chooser.getSelectedFile();
            if (chooserstate == 1) {
                return new Integer(1);
            }
            return file;
        }
        catch (Exception myErr) {
            return null;
        }
    }

    class GcThread
    extends Thread {
        GcThread() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setPriority(10);
            Debug.println("System.gc()");
            System.gc();
        }
    }
}

