/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw.event;

import java.util.Vector;
import jp.fric.graphics.draw.event.GEvent;

class GEventVector
extends Vector {
    private int lastIndex = -1;

    public void deleteAll() {
        super.clear();
        this.lastIndex = -1;
    }

    public void dispose() {
        int i = 0;
        while (i < super.size()) {
            GEvent gevent = (GEvent)super.elementAt(i);
            gevent.dispose();
            ++i;
        }
        super.clear();
    }

    public synchronized boolean hasNextEvent() {
        return this.lastIndex < super.size() - 1;
    }

    public synchronized boolean hasPrevEvent() {
        return this.lastIndex >= 0;
    }

    public synchronized void insertNewEvent(GEvent gevent) {
        int i = super.size() - 1;
        while (i > this.lastIndex) {
            GEvent event = (GEvent)super.remove(i);
            event.dispose();
            --i;
        }
        super.add(gevent);
        this.lastIndex = super.size() - 1;
    }

    public synchronized GEvent nextEvent() {
        if (this.lastIndex >= super.size() - 1) {
            return null;
        }
        ++this.lastIndex;
        GEvent gevent = (GEvent)super.elementAt(this.lastIndex);
        return gevent;
    }

    public synchronized GEvent prevEvent() {
        if (this.lastIndex < 0) {
            return null;
        }
        GEvent gevent = (GEvent)super.elementAt(this.lastIndex);
        --this.lastIndex;
        return gevent;
    }
}

