/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw.event;

import java.awt.geom.Point2D;
import java.util.Vector;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GResizable;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.event.GEvent;
import jp.fric.graphics.draw.event.GEventProperty;
import jp.fric.graphics.draw.event.GEventRecorderListener;
import jp.fric.graphics.draw.event.GEventVector;

public class GEventRecorder {
    private static final int UNDO = 1;
    private static final int REDO = 2;
    private GEventVector recordedEvents = new GEventVector();
    private GStructure structure;
    private GEventRecorderListener listener;
    private boolean isPerformingUndoOrRedo = false;

    public GEventRecorder(GStructure gstructure) {
        this.structure = gstructure;
        gstructure.setRecorder(this);
    }

    public void clearEvents() {
        this.recordedEvents.deleteAll();
        if (this.listener != null) {
            this.listener.eventsCleared();
        }
    }

    public void dispose() {
        this.recordedEvents.dispose();
        this.recordedEvents = null;
        this.structure = null;
        this.listener = null;
    }

    public boolean isAbleToRedo() {
        return this.recordedEvents.hasNextEvent();
    }

    public boolean isAbleToUndo() {
        return this.recordedEvents.hasPrevEvent();
    }

    private synchronized void perform(GEvent event, int action) {
        this.isPerformingUndoOrRedo = true;
        this.structure.deselectAll();
        int code = event.getCode();
        Object target1 = null;
        Object target2 = null;
        Object target3 = null;
        GEventProperty geventproperty = event.getGEventProperty();
        switch (code) {
            case 1: {
                GElement gelement = (GElement)event.getTarget1();
                gelement.setHighlighted(false);
                if (gelement instanceof GResizable) {
                    ((GResizable)((Object)gelement)).activateHandle(false);
                }
                if (action == 2) {
                    this.structure.add(gelement);
                }
                if (action != 1) break;
                this.structure.remove(gelement);
                break;
            }
            case 2: {
                Vector add1 = (Vector)event.getTarget1();
                Vector<GElement> addr1 = new Vector<GElement>();
                int i = add1.size() - 1;
                while (i >= 0) {
                    GElement gelement = (GElement)add1.elementAt(i);
                    gelement.setHighlighted(false);
                    if (gelement instanceof GResizable) {
                        ((GResizable)((Object)gelement)).activateHandle(false);
                    }
                    addr1.add(gelement);
                    --i;
                }
                if (action == 2) {
                    this.structure.add(add1);
                }
                if (action != 1) break;
                this.structure.remove(addr1);
                break;
            }
            case 9: {
                Vector paste1 = (Vector)event.getTarget1();
                Vector<GElement> paster1 = new Vector<GElement>();
                int i = paste1.size() - 1;
                while (i >= 0) {
                    GElement gelement = (GElement)paste1.elementAt(i);
                    gelement.setHighlighted(false);
                    if (gelement instanceof GResizable) {
                        ((GResizable)((Object)gelement)).activateHandle(false);
                    }
                    paster1.add(gelement);
                    --i;
                }
                if (action == 2) {
                    this.structure.paste(paste1);
                }
                if (action != 1) break;
                this.structure.remove(paster1);
                break;
            }
            case 3: {
                GElement gelement = (GElement)event.getTarget1();
                gelement.setHighlighted(false);
                if (gelement instanceof GResizable) {
                    ((GResizable)((Object)gelement)).activateHandle(false);
                }
                if (action == 2) {
                    this.structure.remove(gelement);
                }
                if (action != 1) break;
                this.structure.add(gelement);
                break;
            }
            case 4: {
                Vector remove1 = (Vector)event.getTarget1();
                Vector<GElement> remover1 = new Vector<GElement>();
                int i = remove1.size() - 1;
                while (i >= 0) {
                    GElement gelement = (GElement)remove1.elementAt(i);
                    gelement.setHighlighted(false);
                    if (gelement instanceof GResizable) {
                        ((GResizable)((Object)gelement)).activateHandle(false);
                    }
                    remover1.add(gelement);
                    --i;
                }
                if (action == 2) {
                    this.structure.remove(remove1);
                }
                if (action != 1) break;
                this.structure.add(remover1);
                break;
            }
            case 5: {
                Vector add1 = (Vector)event.getTarget1();
                Vector remove1 = (Vector)event.getTarget2();
                if (action == 2) {
                    this.structure.addAndRemove(add1, remove1);
                }
                if (action != 1) break;
                Vector<GElement> addr1 = null;
                if (add1 != null) {
                    addr1 = new Vector<GElement>();
                    int i = add1.size() - 1;
                    while (i >= 0) {
                        GElement gelement = (GElement)add1.elementAt(i);
                        gelement.setHighlighted(false);
                        if (gelement instanceof GResizable) {
                            ((GResizable)((Object)gelement)).activateHandle(false);
                        }
                        addr1.add(gelement);
                        --i;
                    }
                }
                Vector<GElement> remover1 = null;
                if (remove1 != null) {
                    remover1 = new Vector<GElement>();
                    int i = remove1.size() - 1;
                    while (i >= 0) {
                        GElement gelement = (GElement)remove1.elementAt(i);
                        gelement.setHighlighted(false);
                        if (gelement instanceof GResizable) {
                            ((GResizable)((Object)gelement)).activateHandle(false);
                        }
                        remover1.add(gelement);
                        --i;
                    }
                }
                this.structure.addAndRemove(remover1, addr1);
                break;
            }
            case 6: {
                GElement gelement = (GElement)event.getTarget1();
                gelement.setHighlighted(false);
                if (gelement instanceof GResizable) {
                    ((GResizable)((Object)gelement)).activateHandle(false);
                }
                if (action == 2) {
                    this.structure.move(gelement, geventproperty.newPoint.x, geventproperty.newPoint.y);
                }
                if (action != 1) break;
                this.structure.move(gelement, geventproperty.oldPoint.x, geventproperty.oldPoint.y);
                break;
            }
            case 7: {
                Point2D.Double position;
                GElement gelement;
                int i;
                Vector move1 = (Vector)event.getTarget1();
                int i2 = 0;
                while (i2 < move1.size()) {
                    GElement gelement2 = (GElement)move1.elementAt(i2);
                    gelement2.setHighlighted(false);
                    if (gelement2 instanceof GResizable) {
                        ((GResizable)((Object)gelement2)).activateHandle(false);
                    }
                    ++i2;
                }
                Vector newPosition1 = geventproperty.newVector;
                Vector oldPosition1 = geventproperty.oldVector;
                if (action == 2) {
                    i = 0;
                    while (i < move1.size()) {
                        gelement = (GElement)move1.elementAt(i);
                        position = (Point2D.Double)newPosition1.elementAt(i);
                        this.structure.move(gelement, position.x, position.y);
                        ++i;
                    }
                }
                if (action != 1) break;
                i = move1.size() - 1;
                while (i >= 0) {
                    gelement = (GElement)move1.elementAt(i);
                    position = (Point2D.Double)oldPosition1.elementAt(i);
                    this.structure.move(gelement, position.x, position.y);
                    --i;
                }
                break;
            }
            case 8: {
                GElement gelement = (GElement)event.getTarget1();
                gelement.setHighlighted(false);
                if (gelement instanceof GResizable) {
                    ((GResizable)((Object)gelement)).activateHandle(false);
                }
                if (action == 2) {
                    this.structure.resize(gelement, geventproperty.newBounds.x, geventproperty.newBounds.y, geventproperty.newBounds.width, geventproperty.newBounds.height);
                }
                if (action != 1) break;
                this.structure.resize(gelement, geventproperty.oldBounds.x, geventproperty.oldBounds.y, geventproperty.oldBounds.width, geventproperty.oldBounds.height);
            }
        }
        this.isPerformingUndoOrRedo = false;
        if (this.listener != null) {
            if (action == 2) {
                this.listener.redoPerformed(event);
            }
            if (action == 1) {
                this.listener.undoPerformed(event);
            }
        }
    }

    public synchronized void record(int code, Object target1, Object target2, Object target3, GEventProperty geventproperty) {
        if (!this.isPerformingUndoOrRedo) {
            GEvent gevent = new GEvent(code);
            gevent.setTarget1(target1);
            gevent.setTarget2(target2);
            gevent.setTarget3(target3);
            gevent.setGEventProperty(geventproperty);
            this.recordedEvents.insertNewEvent(gevent);
            if (this.listener != null) {
                this.listener.eventRecorded(gevent);
            }
        }
    }

    public synchronized void record(int code, Object target1, Object target2, GEventProperty geventproperty) {
        if (!this.isPerformingUndoOrRedo) {
            GEvent gevent = new GEvent(code);
            gevent.setTarget1(target1);
            gevent.setTarget2(target2);
            gevent.setGEventProperty(geventproperty);
            this.recordedEvents.insertNewEvent(gevent);
            if (this.listener != null) {
                this.listener.eventRecorded(gevent);
            }
        }
    }

    public synchronized void record(int code, Object target1, GEventProperty geventproperty) {
        if (!this.isPerformingUndoOrRedo) {
            GEvent gevent = new GEvent(code);
            gevent.setTarget1(target1);
            gevent.setGEventProperty(geventproperty);
            this.recordedEvents.insertNewEvent(gevent);
            if (this.listener != null) {
                this.listener.eventRecorded(gevent);
            }
        }
    }

    public void redo() {
        if (this.recordedEvents.hasNextEvent()) {
            GEvent gevent = this.recordedEvents.nextEvent();
            this.perform(gevent, 2);
        }
    }

    public void setGEventRecorderListener(GEventRecorderListener geventrecorderlistener) {
        this.listener = geventrecorderlistener;
    }

    public void undo() {
        if (this.recordedEvents.hasPrevEvent()) {
            GEvent gevent = this.recordedEvents.prevEvent();
            this.perform(gevent, 1);
        }
    }
}

