/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import jp.fric.graphics.draw.GLinkPositionInfo;

public class ShapeUtil {
    public static final int LINK_ANCHORS_HIDE = 0;
    public static final int LINK_ANCHORS_SHOW_ALL = 1;
    public static final int LINK_ANCHOR_SHOW_ONLY_ACTIVE = 2;

    private ShapeUtil() {
    }

    public static int translateIndexToGLinkPosition(int index) {
        int ii = -1;
        switch (index) {
            case 0: {
                ii = 14;
                break;
            }
            case 1: {
                ii = 15;
                break;
            }
            case 2: {
                ii = 0;
                break;
            }
            case 3: {
                ii = 1;
                break;
            }
            case 4: {
                ii = 2;
                break;
            }
            case 5: {
                ii = 3;
                break;
            }
            case 6: {
                ii = 4;
                break;
            }
            case 7: {
                ii = 5;
                break;
            }
            case 8: {
                ii = 6;
                break;
            }
            case 9: {
                ii = 7;
                break;
            }
            case 10: {
                ii = 8;
                break;
            }
            case 11: {
                ii = 9;
                break;
            }
            case 12: {
                ii = 10;
                break;
            }
            case 13: {
                ii = 11;
                break;
            }
            case 14: {
                ii = 12;
                break;
            }
            case 15: {
                ii = 13;
                break;
            }
            case -1: {
                ii = 16;
            }
        }
        return ii;
    }

    public static int translateGLinkPositionToIndex(int ii) {
        int index = -1;
        switch (ii) {
            case 14: {
                index = 0;
                break;
            }
            case 15: {
                index = 1;
                break;
            }
            case 0: {
                index = 2;
                break;
            }
            case 1: {
                index = 3;
                break;
            }
            case 2: {
                index = 4;
                break;
            }
            case 3: {
                index = 5;
                break;
            }
            case 4: {
                index = 6;
                break;
            }
            case 5: {
                index = 7;
                break;
            }
            case 6: {
                index = 8;
                break;
            }
            case 7: {
                index = 9;
                break;
            }
            case 8: {
                index = 10;
                break;
            }
            case 9: {
                index = 11;
                break;
            }
            case 10: {
                index = 12;
                break;
            }
            case 11: {
                index = 13;
                break;
            }
            case 12: {
                index = 14;
                break;
            }
            case 13: {
                index = 15;
                break;
            }
            case -1: {
                index = 16;
            }
        }
        return index;
    }

    public static void drawLinkAnchor1(Graphics2D g2, double x, double y) {
        g2.fillRect((int)x - 2, (int)y - 2, 5, 5);
    }

    public static void drawLinkAnchorsWithIndexStatic(Graphics2D g2, int index, Point2D.Double[] anchorCoords, boolean drawOnlyActive) {
        Color fgColor = g2.getColor();
        int i = 0;
        while (i < anchorCoords.length) {
            if (!drawOnlyActive || i == index) {
                g2.setColor(drawOnlyActive ? Color.MAGENTA : (i == index ? Color.BLUE : Color.GRAY));
                ShapeUtil.drawLinkAnchor1(g2, anchorCoords[i].x, anchorCoords[i].y);
            }
            ++i;
        }
        g2.setColor(fgColor);
    }

    public static GLinkPositionInfo getNearLinkAnchorPositionForLink(Point2D.Double[] anchorCoors, double x, double y) {
        int index = 0;
        double distsq = anchorCoors[0].distanceSq(x, y);
        int i = 1;
        while (i < anchorCoors.length) {
            double distsq1 = anchorCoors[i].distanceSq(x, y);
            if (distsq1 < distsq) {
                distsq = distsq1;
                index = i;
            }
            ++i;
        }
        return new GLinkPositionInfo(index, distsq);
    }

    public static GLinkPositionInfo getNearLinkAnchorPosition(Point2D.Double[] anchorCoors, double x, double y) {
        GLinkPositionInfo lpi = ShapeUtil.getNearLinkAnchorPositionForLink(anchorCoors, x, y);
        int ii = ShapeUtil.translateIndexToGLinkPosition(lpi.getPosition());
        lpi.setPosition(ii);
        return lpi;
    }
}

